

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wp_comments VALUES("1","1","Комментатор WordPress","wapuu@wordpress.example","https://ru.wordpress.org/","","2024-11-22 12:21:37","2024-11-22 09:21:37","Привет! Это комментарий.\nЧтобы начать модерировать, редактировать и удалять комментарии, перейдите на экран «Комментарии» в консоли.\nАватары авторов комментариев загружаются с сервиса <a href=\"https://ru.gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");



CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `wp_jet_post_types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text COLLATE utf8mb4_unicode_520_ci,
  `status` text COLLATE utf8mb4_unicode_520_ci,
  `labels` longtext COLLATE utf8mb4_unicode_520_ci,
  `args` longtext COLLATE utf8mb4_unicode_520_ci,
  `meta_fields` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `wp_jet_taxonomies` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text COLLATE utf8mb4_unicode_520_ci,
  `object_type` text COLLATE utf8mb4_unicode_520_ci,
  `status` text COLLATE utf8mb4_unicode_520_ci,
  `labels` longtext COLLATE utf8mb4_unicode_520_ci,
  `args` longtext COLLATE utf8mb4_unicode_520_ci,
  `meta_fields` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=333 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO wp_options VALUES("1","cron","a:18:{i:1732270897;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1732272697;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1732274497;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1732274654;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"686c8315be36c96dc00d0d7ed3656b43\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:6;}}}}i:1732274689;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"d63aca0b7e6237c7964320bd7fc95644\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:7;}}}}i:1732275020;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"60fda3b54003017dc64a0c492471bbfe\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:8;}}}}i:1732275490;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"b4b17768ecd6a3369b716a0ce3abb8f6\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:9;}}}}i:1732275522;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c8bde69a9f79ca24059e3807f9a3bcf8\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:10;}}}}i:1732275547;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"a33bdbdff47548655d9bd9c05ea3930a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:11;}}}}i:1732275656;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"25117f4b9fd9bb6384d0eb8ea708c8b9\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:12;}}}}i:1732310515;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1732353697;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1732353715;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1732353717;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1732354887;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1732872254;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1732873287;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on");
INSERT INTO wp_options VALUES("2","siteurl","https://cx46276-presta.tw1.ru","on");
INSERT INTO wp_options VALUES("3","home","https://cx46276-presta.tw1.ru","on");
INSERT INTO wp_options VALUES("4","blogname","Serv-trade","on");
INSERT INTO wp_options VALUES("5","blogdescription","","on");
INSERT INTO wp_options VALUES("6","users_can_register","0","on");
INSERT INTO wp_options VALUES("7","admin_email","web@newdesignlab.ru","on");
INSERT INTO wp_options VALUES("8","start_of_week","1","on");
INSERT INTO wp_options VALUES("9","use_balanceTags","0","on");
INSERT INTO wp_options VALUES("10","use_smilies","1","on");
INSERT INTO wp_options VALUES("11","require_name_email","1","on");
INSERT INTO wp_options VALUES("12","comments_notify","1","on");
INSERT INTO wp_options VALUES("13","posts_per_rss","10","on");
INSERT INTO wp_options VALUES("14","rss_use_excerpt","0","on");
INSERT INTO wp_options VALUES("15","mailserver_url","mail.example.com","on");
INSERT INTO wp_options VALUES("16","mailserver_login","login@example.com","on");
INSERT INTO wp_options VALUES("17","mailserver_pass","","on");
INSERT INTO wp_options VALUES("18","mailserver_port","110","on");
INSERT INTO wp_options VALUES("19","default_category","1","on");
INSERT INTO wp_options VALUES("20","default_comment_status","open","on");
INSERT INTO wp_options VALUES("21","default_ping_status","open","on");
INSERT INTO wp_options VALUES("22","default_pingback_flag","0","on");
INSERT INTO wp_options VALUES("23","posts_per_page","10","on");
INSERT INTO wp_options VALUES("24","date_format","d.m.Y","on");
INSERT INTO wp_options VALUES("25","time_format","H:i","on");
INSERT INTO wp_options VALUES("26","links_updated_date_format","d.m.Y H:i","on");
INSERT INTO wp_options VALUES("27","comment_moderation","0","on");
INSERT INTO wp_options VALUES("28","moderation_notify","1","on");
INSERT INTO wp_options VALUES("29","permalink_structure","/%year%/%monthnum%/%day%/%postname%/","on");
INSERT INTO wp_options VALUES("30","rewrite_rules","a:181:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio-category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio-category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:54:\"portfolio-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:49:\"portfolio-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:30:\"portfolio-tag/([^/]+)/embed/?$\";s:46:\"index.php?portfolio_tag=$matches[1]&embed=true\";s:42:\"portfolio-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?portfolio_tag=$matches[1]&paged=$matches[2]\";s:24:\"portfolio-tag/([^/]+)/?$\";s:35:\"index.php?portfolio_tag=$matches[1]\";s:42:\"jupiterx-codes/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"jupiterx-codes/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"jupiterx-codes/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-codes/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-codes/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"jupiterx-codes/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"jupiterx-codes/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-codes=$matches[1]&embed=true\";s:35:\"jupiterx-codes/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-codes=$matches[1]&tb=1\";s:43:\"jupiterx-codes/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-codes=$matches[1]&paged=$matches[2]\";s:50:\"jupiterx-codes/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-codes=$matches[1]&cpage=$matches[2]\";s:39:\"jupiterx-codes/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-codes=$matches[1]&page=$matches[2]\";s:31:\"jupiterx-codes/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"jupiterx-codes/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"jupiterx-codes/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-codes/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-codes/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"jupiterx-codes/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"jupiterx-fonts/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-fonts=$matches[1]&embed=true\";s:35:\"jupiterx-fonts/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-fonts=$matches[1]&tb=1\";s:43:\"jupiterx-fonts/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-fonts=$matches[1]&paged=$matches[2]\";s:50:\"jupiterx-fonts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-fonts=$matches[1]&cpage=$matches[2]\";s:39:\"jupiterx-fonts/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-fonts=$matches[1]&page=$matches[2]\";s:31:\"jupiterx-fonts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"jupiterx-fonts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"jupiterx-fonts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-fonts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-fonts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"jupiterx-fonts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"jupiterx-icons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"jupiterx-icons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"jupiterx-icons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-icons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-icons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"jupiterx-icons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"jupiterx-icons/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-icons=$matches[1]&embed=true\";s:35:\"jupiterx-icons/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-icons=$matches[1]&tb=1\";s:43:\"jupiterx-icons/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-icons=$matches[1]&paged=$matches[2]\";s:50:\"jupiterx-icons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-icons=$matches[1]&cpage=$matches[2]\";s:39:\"jupiterx-icons/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-icons=$matches[1]&page=$matches[2]\";s:31:\"jupiterx-icons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"jupiterx-icons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"jupiterx-icons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-icons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-icons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"jupiterx-icons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}","on");
INSERT INTO wp_options VALUES("31","hack_file","0","on");
INSERT INTO wp_options VALUES("32","blog_charset","UTF-8","on");
INSERT INTO wp_options VALUES("33","moderation_keys","","off");
INSERT INTO wp_options VALUES("34","active_plugins","a:5:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:23:\"elementor/elementor.php\";i:2;s:25:\"jet-engine/jet-engine.php\";i:3;s:31:\"jupiterx-core/jupiterx-core.php\";i:4;s:27:\"sellkit-pro/sellkit-pro.php\";}","on");
INSERT INTO wp_options VALUES("35","category_base","","on");
INSERT INTO wp_options VALUES("36","ping_sites","http://rpc.pingomatic.com/","on");
INSERT INTO wp_options VALUES("37","comment_max_links","2","on");
INSERT INTO wp_options VALUES("38","gmt_offset","3","on");
INSERT INTO wp_options VALUES("39","default_email_category","1","on");
INSERT INTO wp_options VALUES("40","recently_edited","","off");
INSERT INTO wp_options VALUES("41","template","jupiterx","on");
INSERT INTO wp_options VALUES("42","stylesheet","jupiterx","on");
INSERT INTO wp_options VALUES("43","comment_registration","0","on");
INSERT INTO wp_options VALUES("44","html_type","text/html","on");
INSERT INTO wp_options VALUES("45","use_trackback","0","on");
INSERT INTO wp_options VALUES("46","default_role","subscriber","on");
INSERT INTO wp_options VALUES("47","db_version","58975","on");
INSERT INTO wp_options VALUES("48","uploads_use_yearmonth_folders","1","on");
INSERT INTO wp_options VALUES("49","upload_path","","on");
INSERT INTO wp_options VALUES("50","blog_public","0","on");
INSERT INTO wp_options VALUES("51","default_link_category","2","on");
INSERT INTO wp_options VALUES("52","show_on_front","posts","on");
INSERT INTO wp_options VALUES("53","tag_base","","on");
INSERT INTO wp_options VALUES("54","show_avatars","1","on");
INSERT INTO wp_options VALUES("55","avatar_rating","G","on");
INSERT INTO wp_options VALUES("56","upload_url_path","","on");
INSERT INTO wp_options VALUES("57","thumbnail_size_w","150","on");
INSERT INTO wp_options VALUES("58","thumbnail_size_h","150","on");
INSERT INTO wp_options VALUES("59","thumbnail_crop","1","on");
INSERT INTO wp_options VALUES("60","medium_size_w","300","on");
INSERT INTO wp_options VALUES("61","medium_size_h","300","on");
INSERT INTO wp_options VALUES("62","avatar_default","mystery","on");
INSERT INTO wp_options VALUES("63","large_size_w","1024","on");
INSERT INTO wp_options VALUES("64","large_size_h","1024","on");
INSERT INTO wp_options VALUES("65","image_default_link_type","none","on");
INSERT INTO wp_options VALUES("66","image_default_size","","on");
INSERT INTO wp_options VALUES("67","image_default_align","","on");
INSERT INTO wp_options VALUES("68","close_comments_for_old_posts","0","on");
INSERT INTO wp_options VALUES("69","close_comments_days_old","14","on");
INSERT INTO wp_options VALUES("70","thread_comments","1","on");
INSERT INTO wp_options VALUES("71","thread_comments_depth","5","on");
INSERT INTO wp_options VALUES("72","page_comments","0","on");
INSERT INTO wp_options VALUES("73","comments_per_page","50","on");
INSERT INTO wp_options VALUES("74","default_comments_page","newest","on");
INSERT INTO wp_options VALUES("75","comment_order","asc","on");
INSERT INTO wp_options VALUES("76","sticky_posts","a:0:{}","on");
INSERT INTO wp_options VALUES("77","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("78","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("79","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("80","uninstall_plugins","a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}","off");
INSERT INTO wp_options VALUES("81","timezone_string","","on");
INSERT INTO wp_options VALUES("82","page_for_posts","0","on");
INSERT INTO wp_options VALUES("83","page_on_front","0","on");
INSERT INTO wp_options VALUES("84","default_post_format","0","on");
INSERT INTO wp_options VALUES("85","link_manager_enabled","0","on");
INSERT INTO wp_options VALUES("86","finished_splitting_shared_terms","1","on");
INSERT INTO wp_options VALUES("87","site_icon","0","on");
INSERT INTO wp_options VALUES("88","medium_large_size_w","768","on");
INSERT INTO wp_options VALUES("89","medium_large_size_h","0","on");
INSERT INTO wp_options VALUES("90","wp_page_for_privacy_policy","3","on");
INSERT INTO wp_options VALUES("91","show_comments_cookies_opt_in","1","on");
INSERT INTO wp_options VALUES("92","admin_email_lifespan","1747819297","on");
INSERT INTO wp_options VALUES("93","disallowed_keys","","off");
INSERT INTO wp_options VALUES("94","comment_previously_approved","1","on");
INSERT INTO wp_options VALUES("95","auto_plugin_theme_update_emails","a:0:{}","off");
INSERT INTO wp_options VALUES("96","auto_update_core_dev","enabled","on");
INSERT INTO wp_options VALUES("97","auto_update_core_minor","enabled","on");
INSERT INTO wp_options VALUES("98","auto_update_core_major","enabled","on");
INSERT INTO wp_options VALUES("99","wp_force_deactivated_plugins","a:0:{}","on");
INSERT INTO wp_options VALUES("100","wp_attachment_pages_enabled","0","on");
INSERT INTO wp_options VALUES("101","initial_db_version","58975","on");
INSERT INTO wp_options VALUES("102","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","on");
INSERT INTO wp_options VALUES("103","fresh_site","1","off");
INSERT INTO wp_options VALUES("104","WPLANG","ru_RU","auto");
INSERT INTO wp_options VALUES("105","user_count","1","off");
INSERT INTO wp_options VALUES("106","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:167:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Свежие записи</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:247:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Свежие комментарии</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Архивы</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Рубрики</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("107","sidebars_widgets","a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_primary\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:17:\"sidebar_secondary\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:23:\"footer_widgets_column_1\";a:0:{}s:23:\"footer_widgets_column_2\";a:0:{}s:23:\"footer_widgets_column_3\";a:0:{}s:23:\"footer_widgets_column_4\";a:0:{}s:23:\"footer_widgets_column_5\";a:0:{}s:23:\"footer_widgets_column_6\";a:0:{}s:13:\"array_version\";i:3;}","auto");
INSERT INTO wp_options VALUES("108","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("109","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("110","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("111","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("112","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("113","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("114","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("115","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("116","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("117","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("118","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("119","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("120","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("121","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("122","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.7.1\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}","on");
INSERT INTO wp_options VALUES("126","recovery_keys","a:0:{}","off");
INSERT INTO wp_options VALUES("127","theme_mods_twentytwentyfive","a:4:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1732268295;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_primary\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:17:\"sidebar_secondary\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:23:\"footer_widgets_column_1\";a:0:{}s:23:\"footer_widgets_column_2\";a:0:{}s:23:\"footer_widgets_column_3\";a:0:{}s:23:\"footer_widgets_column_4\";a:0:{}s:23:\"footer_widgets_column_5\";a:0:{}s:23:\"footer_widgets_column_6\";a:0:{}}}s:19:\"wp_classic_sidebars\";a:8:{s:15:\"sidebar_primary\";a:15:{s:4:\"name\";s:15:\"Sidebar Primary\";s:2:\"id\";s:15:\"sidebar_primary\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:34:\"<li id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</li>\n\";s:12:\"before_title\";s:24:\"<h2 class=\"widgettitle\">\";s:11:\"after_title\";s:6:\"</h2>\n\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;s:13:\"jupiterx_type\";s:5:\"stack\";s:26:\"jupiterx_show_widget_title\";b:1;s:26:\"jupiterx_show_widget_badge\";b:0;s:29:\"jupiterx_widget_badge_content\";s:5:\"Hello\";}s:17:\"sidebar_secondary\";a:15:{s:4:\"name\";s:17:\"Sidebar Secondary\";s:2:\"id\";s:17:\"sidebar_secondary\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:34:\"<li id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</li>\n\";s:12:\"before_title\";s:24:\"<h2 class=\"widgettitle\">\";s:11:\"after_title\";s:6:\"</h2>\n\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;s:13:\"jupiterx_type\";s:5:\"stack\";s:26:\"jupiterx_show_widget_title\";b:1;s:26:\"jupiterx_show_widget_badge\";b:0;s:29:\"jupiterx_widget_badge_content\";s:5:\"Hello\";}s:23:\"footer_widgets_column_1\";a:15:{s:4:\"name\";s:8:\"Footer 1\";s:2:\"id\";s:23:\"footer_widgets_column_1\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:34:\"<li id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</li>\n\";s:12:\"before_title\";s:24:\"<h2 class=\"widgettitle\">\";s:11:\"after_title\";s:6:\"</h2>\n\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;s:13:\"jupiterx_type\";s:5:\"stack\";s:26:\"jupiterx_show_widget_title\";b:1;s:26:\"jupiterx_show_widget_badge\";b:0;s:29:\"jupiterx_widget_badge_content\";s:5:\"Hello\";}s:23:\"footer_widgets_column_2\";a:15:{s:4:\"name\";s:8:\"Footer 2\";s:2:\"id\";s:23:\"footer_widgets_column_2\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:34:\"<li id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</li>\n\";s:12:\"before_title\";s:24:\"<h2 class=\"widgettitle\">\";s:11:\"after_title\";s:6:\"</h2>\n\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;s:13:\"jupiterx_type\";s:5:\"stack\";s:26:\"jupiterx_show_widget_title\";b:1;s:26:\"jupiterx_show_widget_badge\";b:0;s:29:\"jupiterx_widget_badge_content\";s:5:\"Hello\";}s:23:\"footer_widgets_column_3\";a:15:{s:4:\"name\";s:8:\"Footer 3\";s:2:\"id\";s:23:\"footer_widgets_column_3\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:34:\"<li id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</li>\n\";s:12:\"before_title\";s:24:\"<h2 class=\"widgettitle\">\";s:11:\"after_title\";s:6:\"</h2>\n\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;s:13:\"jupiterx_type\";s:5:\"stack\";s:26:\"jupiterx_show_widget_title\";b:1;s:26:\"jupiterx_show_widget_badge\";b:0;s:29:\"jupiterx_widget_badge_content\";s:5:\"Hello\";}s:23:\"footer_widgets_column_4\";a:15:{s:4:\"name\";s:8:\"Footer 4\";s:2:\"id\";s:23:\"footer_widgets_column_4\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:34:\"<li id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</li>\n\";s:12:\"before_title\";s:24:\"<h2 class=\"widgettitle\">\";s:11:\"after_title\";s:6:\"</h2>\n\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;s:13:\"jupiterx_type\";s:5:\"stack\";s:26:\"jupiterx_show_widget_title\";b:1;s:26:\"jupiterx_show_widget_badge\";b:0;s:29:\"jupiterx_widget_badge_content\";s:5:\"Hello\";}s:23:\"footer_widgets_column_5\";a:15:{s:4:\"name\";s:8:\"Footer 5\";s:2:\"id\";s:23:\"footer_widgets_column_5\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:34:\"<li id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</li>\n\";s:12:\"before_title\";s:24:\"<h2 class=\"widgettitle\">\";s:11:\"after_title\";s:6:\"</h2>\n\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;s:13:\"jupiterx_type\";s:5:\"stack\";s:26:\"jupiterx_show_widget_title\";b:1;s:26:\"jupiterx_show_widget_badge\";b:0;s:29:\"jupiterx_widget_badge_content\";s:5:\"Hello\";}s:23:\"footer_widgets_column_6\";a:15:{s:4:\"name\";s:8:\"Footer 6\";s:2:\"id\";s:23:\"footer_widgets_column_6\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:34:\"<li id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</li>\n\";s:12:\"before_title\";s:24:\"<h2 class=\"widgettitle\">\";s:11:\"after_title\";s:6:\"</h2>\n\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;s:13:\"jupiterx_type\";s:5:\"stack\";s:26:\"jupiterx_show_widget_title\";b:1;s:26:\"jupiterx_show_widget_badge\";b:0;s:29:\"jupiterx_widget_badge_content\";s:5:\"Hello\";}}s:18:\"nav_menu_locations\";a:0:{}}","off");
INSERT INTO wp_options VALUES("128","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"876d6a15de1f6639de6574a66475c0b5\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on");
INSERT INTO wp_options VALUES("129","_site_transient_timeout_available_translations","1732278101","off");
INSERT INTO wp_options VALUES("130","_site_transient_available_translations","a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.9/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-01 09:05:28\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.5/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.26/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-10-28 18:43:11\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-11 11:12:13\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-15 23:05:23\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-07-23 09:49:04\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-02 10:05:37\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-09-27 09:32:19\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-05 18:11:40\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-07 15:43:21\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 21:24:01\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 21:22:42\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.7.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-05 18:08:14\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.7.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 01:55:00\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-04 22:51:08\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-08 19:43:34\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 00:03:39\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-09 02:33:22\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-14 20:17:10\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-19 14:30:41\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 04:23:19\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 19:39:57\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 17:51:13\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-20 15:25:26\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.16/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.21/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-01 13:40:20\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 03:48:07\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-10-10 00:15:35\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-06-20 17:15:28\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 00:15:08\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 05:44:18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-20 17:18:27\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-09-30 11:36:50\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.6/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-01 14:43:10\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 11:31:44\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.33\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.33/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-25 08:05:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-11 08:43:38\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-14 09:49:05\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-14 03:56:14\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 17:43:13\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-01 13:18:01\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-08 06:38:31\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.21/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 23:54:38\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 02:38:23\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-13 21:41:57\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.7.1/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-03 07:07:47\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.7.1/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-13 13:11:03\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-05 21:35:49\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.9/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-10-05 15:57:37\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-01 08:11:24\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.15\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.15/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 22:03:40\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-08-30 11:32:23\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 07:28:50\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 15:25:34\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 11:12:32\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 07:35:19\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.34\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.34/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-08 08:50:31\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 13:50:09\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-04 09:20:12\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-20 16:59:47\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-20 15:32:31\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.16/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-18 04:48:42\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-09-21 09:44:08\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.6.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-08-30 07:14:35\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-03 08:29:01\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-09-20 22:15:56\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 05:08:10\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-06 16:56:18\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.10/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.25/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-14 07:22:59\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-18 17:37:18\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-03-06 18:52:07\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.16/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-20 13:04:32\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-20 16:45:59\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 08:38:08\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}","off");
INSERT INTO wp_options VALUES("133","_site_transient_timeout_theme_roots","1732270090","off");
INSERT INTO wp_options VALUES("134","_site_transient_theme_roots","a:2:{s:8:\"jupiterx\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";}","off");
INSERT INTO wp_options VALUES("136","_site_transient_timeout_browser_0de35a7b2b753ddf7e2a4074e305b103","1732872116","off");
INSERT INTO wp_options VALUES("137","_site_transient_browser_0de35a7b2b753ddf7e2a4074e305b103","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"128.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","off");
INSERT INTO wp_options VALUES("138","_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447","1732872117","off");
INSERT INTO wp_options VALUES("139","_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","off");
INSERT INTO wp_options VALUES("141","can_compress_scripts","0","on");
INSERT INTO wp_options VALUES("142","_site_transient_timeout_community-events-4662e8f2c014e08e253d56f2683c9d6b","1732310519","off");
INSERT INTO wp_options VALUES("143","_site_transient_community-events-4662e8f2c014e08e253d56f2683c9d6b","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"85.198.105.0\";}s:6:\"events\";a:0:{}}","off");
INSERT INTO wp_options VALUES("144","_transient_timeout_feed_92227bfe1354c9fe21266d111aae5ed4","1732310519","off");
INSERT INTO wp_options VALUES("145","_transient_feed_92227bfe1354c9fe21266d111aae5ed4","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Блог — WordPress.org Русский\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://ru.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Русский\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Dec 2023 14:39:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"ru-RU\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.8-alpha-59448\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Блог — WordPress.org Русский\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://ru.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Предупреждение о мошенниках\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://ru.wordpress.org/news/2023/12/scam-alert-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Dec 2023 14:27:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:14:\"Новости\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:25:\"Общие вопросы\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ru.wordpress.org/?p=2647\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:802:\"В последнее время администраторы сайтов WordPress стали заметно чаще получать письма якобы от WordPress.org или WordPress.com. Примерный текст такого письма: Уважаемый владелец сайтаМы хотим обратить ваше внимание на некоторые важные&#160;изменения в наших правилах&#160;и предписаниях, которые влияют на работу вашего&#160;веб-сайта WordPress.Для обеспечения безопасности и качества обслуживания необходимо принять новые правила. Если вы с ними не согласны [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Yui\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4851:\"\n<p>В последнее время администраторы сайтов WordPress стали заметно чаще получать письма якобы от WordPress.org или WordPress.com.  Примерный текст такого письма:</p>\n\n\n\n<div class=\"wp-block-group is-layout-constrained wp-block-group-is-layout-constrained\">\n<figure class=\"wp-block-pullquote has-text-align-left has-small-font-size\"><blockquote><p>Уважаемый владелец сайта<br>Мы хотим обратить ваше внимание на некоторые важные&nbsp;<strong>изменения в наших правилах</strong>&nbsp;и предписаниях, которые влияют на работу вашего&nbsp;веб-сайта WordPress.<br>Для обеспечения безопасности и качества обслуживания необходимо принять новые правила. Если вы с ними не согласны и не предпримете необходимых действий,&nbsp;<strong>ваш веб-сайт будет отключен</strong>.<br><br>КНОПКА ДЛЯ ПЕРЕХОДА<br>Пожалуйста, ознакомьтесь с изменениями и примите решение до&nbsp;<strong>12.05.2023</strong>. Мы ценим ваше сотрудничество и готовы помочь вам с любыми вопросами или озабоченностями.<br>Спасибо вам за ваше понимание и оперативные действия!<br><br>Automattic, Inc. — 60 29th St. #343, Сан-Франциско, Калифорния 94110</p></blockquote></figure>\n\n\n\n<p>Обращаем ваше внимание, WordPress Foundation, Automattic Inc, Команда безопасности WordPress <strong>не рассылают писем</strong> владельцам сайтов, не просят переходить по ссылкам для принятия каких-либо условий, не просят установить никаких плагинов или совершать иные действия не связанные со штатным обновлением вашего сайта (Консоль-Обновления).</p>\n\n\n\n<p>Если вы подписаны на какие-либо рассылки WordPress, убедитесь что исходящий адрес не был подделан:</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://ru.wordpress.org/files/2023/12/email-details-signed-by-wordpressdotorg.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"450\" src=\"https://ru.wordpress.org/files/2023/12/email-details-signed-by-wordpressdotorg.png\" alt=\"\" class=\"wp-image-2650\" srcset=\"https://ru.wordpress.org/files/2023/12/email-details-signed-by-wordpressdotorg.png 1024w, https://ru.wordpress.org/files/2023/12/email-details-signed-by-wordpressdotorg-300x132.png 300w, https://ru.wordpress.org/files/2023/12/email-details-signed-by-wordpressdotorg-768x338.png 768w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n</div>\n\n\n\n<p>вы можете сделать это просмотрев служебные заголовки сообщения email.</p>\n\n\n\n<p>Официальными доменами являются .wordpress.org и .wordpress.net , а также домены третьего уровня, например ru.wordpress.org (обратите внимание что .wordpress.org является концом доменной части адреса (перед слешем <strong>/</strong>) и перед wordpress.org имеется точка, а не какой-то иной символ, например тире).</p>\n\n\n\n<p>Также обращайте внимания на письма исходящие якобы от вашего хостинга, вашего регистратора домена и прочее, в случае сомнений обращайтесь в службу поддержки хостинга, регистратора и.т.д. зайдя в личный кабинет в соответствующем месте. Не переходите по ссылкам из писем и не совершайте сомнительных действий о которых вас просят возможные мошенники.</p>\n\n\n\n<p>Официальное сообщение от команды безопасности WordPress (на английском): <a href=\"https://wordpress.org/news/2023/12/alert-wordpress-security-team-impersonation-scams/\" target=\"_blank\" rel=\"noreferrer noopener\">https://wordpress.org/news/2023/12/alert-wordpress-security-team-impersonation-scams/</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2647\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"Ежегодный опрос пользователей и участников разработки WordPress 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://ru.wordpress.org/news/2023/09/2023-wordpress-survey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Sep 2023 15:38:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:14:\"Новости\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:25:\"Общие вопросы\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ru.wordpress.org/?p=2631\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:827:\"Пользователи, создатели сайтов, создатели расширений и участники разработки предоставляют ценные отзывы посредством ежегодного опроса. В прошлом, 2022 году, исследование получило комплексное обновление, впервые за шесть лет. Общее количество вопросов было сокращено до 29 ( ранее около 100), большинство социально-экономических вопросов были удалены, а также введена шкала Лайкерта. Эти обновления были призваны повысить процент заполнения опроса, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Yui\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:12466:\"\n<div class=\"wp-block-media-text is-stacked-on-mobile\"><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" width=\"768\" height=\"342\" src=\"https://ru.wordpress.org/files/2019/11/image-12-1.png\" alt=\"\" class=\"wp-image-2145 size-full\" srcset=\"https://ru.wordpress.org/files/2019/11/image-12-1.png 768w, https://ru.wordpress.org/files/2019/11/image-12-1-300x134.png 300w\" sizes=\"(max-width: 768px) 100vw, 768px\" /></figure><div class=\"wp-block-media-text__content\">\n<p>Каждый год сообщество WordPress проводит ежегодный опрос для пользователей и участников сообщества.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-width wp-block-button__width-100\"><a class=\"wp-block-button__link has-background has-text-align-center wp-element-button\" href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey\" style=\"background-color:#0072b9\" target=\"_blank\" rel=\"noreferrer noopener\">Пройти опрос за этот год</a></div>\n</div>\n</div></div>\n\n\n\n<p>Пользователи, создатели сайтов, создатели расширений и участники разработки предоставляют ценные отзывы посредством ежегодного опроса. В прошлом, 2022 году, исследование получило комплексное обновление, впервые за шесть лет. Общее количество вопросов было сокращено до 29 ( ранее около 100), большинство социально-экономических вопросов были удалены, а также введена шкала Лайкерта. Эти обновления были призваны повысить процент заполнения опроса, обеспечить более эффективный и структурированный анализ этих данных и позволить опросу лучше всего оценить темы, которые наиболее важны для сообщества WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Итоги предыдущего опроса за 2022 год</h2>\n\n\n\n<p>В опросе 2022 года процент завершения увеличился на 26%, однако количество заполнений сократилось на 56% до примерно 3400, включая около 800 участников разработки. В этом году опрос стартует ранее чем в прошлом, что, надеемся, позволит увеличить его количество участников.</p>\n\n\n\n<p>Ключевые моменты:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Опрос показывает более широкое использование блоков и нового редактора сайта (по сравнению с классическим редактором), что не должно вызывать удивления, поскольку тема по умолчанию теперь является темой на блоках</li>\n\n\n\n<li>22% респондентов использовали WordPress всего год или меньше. Те, кто участвует в опросе, также становятся немного старше: меньше ответов от тех, кто моложе 40 лет, чем в предыдущие годы.</li>\n\n\n\n<li>Каждый пятый респондент узнал о WordPress от коллеги и примерно такой же процент благодаря поисковой системе.</li>\n\n\n\n<li>В 2022 году пользователи WordPress продолжали изучать WordPress (68%), обучали других WP (48%) и создавали сайты для других (55%).</li>\n\n\n\n<li>Пользователи WordPress выбирают платформу, потому что она с открытым исходным кодом (62%), гибкая (47%), с низким уровнем риска (45%), экономичная (45%) и имеет положительную репутацию (41%).</li>\n\n\n\n<li>57% участников опроса получали новости и обучение непосредственно на WordPress.org. Хотя это основной источник, другие сайты остаются очень важными: поисковые системы (46%), YouTube (40%), другие сообщества WordPress (35%) и социальные сети (30%).</li>\n\n\n\n<li>Подавляющее большинство респондентов не используют регулярно другие платформы CMS, а 21% респондентов не используют ни один из 20 наиболее популярных плагинов WordPress.</li>\n\n\n\n<li>Респонденты продолжают утверждать, что «WordPress не хуже других платформ CMS или даже лучше», с этим согласны 68%. Элементы, которые респонденты считают лучшими аспектами WordPress, включают «простоту использования», «гибкость» и/или «варианты плагинов» — примерно по 30% каждый. Говоря о наиболее разочаровывающих элементах WordPress, каждый пятый ответил: «Ничего», а примерно 30% упомянули трудности с редактированием сайта / Гутенберг.</li>\n\n\n\n<li>Общий опыт участников остается положительным. 64% поделились положительным опытом, а 24% оценили свой опыт как «нейтральный». Авторы также чувствуют себя желанными гостями с таким же процентом (64% согласны и 24% нейтральны).</li>\n</ul>\n\n\n\n<p>Более подробно ознакомиться с результатами можно скачав <a href=\"https://wordpress.org/news/files/2023/05/2022-Annual-Survey-Final.pdf\" data-type=\"link\" data-id=\"https://wordpress.org/news/files/2023/05/2022-Annual-Survey-Final.pdf\" target=\"_blank\" rel=\"noreferrer noopener\">этот файл PDF</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Опрос этого года</strong></h2>\n\n\n\n<p>Чтобы ваш опыт работы с WordPress был представлен в результатах опроса 2023 года, примите участие в опросе прямо сейчас</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-2 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-background has-text-align-center wp-element-button\" href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey\" style=\"background-color:#0072b9\" target=\"_blank\" rel=\"noreferrer noopener\">Пройти опрос</a></div>\n</div>\n\n\n\n<p>Вы также можете пройти опрос на других языках, воспользовавшись ссылкой выше и переключившись на другой язык, благодаря усилиям полиглотов WordPress. Опрос будет открыт в течение пяти недель. Результаты будут опубликованы в блоге WordPress News в начале декабря.  </p>\n\n\n\n<p>В этом году, как и в прошлом, в опрос были внесены некоторые улучшения в структуру и набор вопросов. Также тестируется новая платформа, предлагающая обновленный интерфейс, расширенную многоязычную поддержку, расширенные инструменты анализа и визуализации результатов и многое другое. Новая платформа также имеет встроенные средства контроля доступа и конфиденциальности, что гарантирует, что опрос будет отвечать разнообразным потребностям сообщества WordPress.</p>\n\n\n\n<p>Пожалуйста, <strong>помогите распространить информацию об опросе</strong>, поделившись им в своей сети, через Slack или через записи в социальных сетях. Чем больше людей заполнят опрос и поделятся своим опытом работы с WordPress, тем большую пользу принесет проект.</p>\n\n\n\n<p><em>Безопасность и конфиденциальность данных имеют первостепенное значение для проекта WordPress и сообщества. Учитывая это, все данные будут анонимизированы: никакие адреса электронной почты или IP-адреса не будут связаны с опубликованными результатами. Чтобы узнать больше о политике конфиденциальности WordPress.org, ознакомьтесь с <a href=\"https://ru.wordpress.org/about/privacy/\" target=\"_blank\" rel=\"noreferrer noopener\">политикой конфиденциальности.</a></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Благодарности</h2>\n\n\n\n<p>Спасибо <a href=\"https://www.hostinger.com/\">Hostinger</a>, <a href=\"https://cloud.jetpack.com/\">Jetpack</a>, и <a href=\"http://wordpress.com\">WordPress.com</a> за помощь в продвижении опроса среди своих клиентов.</p>\n\n\n\n<p>Благодарим следующих участников сообщества WordPress за помощь в проекте ежегодного опроса, включая создание вопросов, стратегию, составление опроса и перевод:<br><a href=\"https://profiles.wordpress.org/adamsilverstein/\">adamsilverstein</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">adurasjb</a>, <a href=\"https://profiles.wordpress.org/alvarogois/\">alvarogóis</a>, <a href=\"https://profiles.wordpress.org/atachibana/\">atachibana</a>, <a href=\"https://profiles.wordpress.org/bjmcsherry/\">bjmcsherry</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">chanthaboune</a>, <a href=\"https://profiles.wordpress.org/dansoschin/\">dansoschin</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\">eidolonnight</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">fierevere</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbénard</a>, <a href=\"https://profiles.wordpress.org/hassantafreshi/\">hassantafreshi</a>, <a href=\"https://profiles.wordpress.org/juliagasparyan/\">juliagasparyan</a>, <a href=\"https://profiles.wordpress.org/kittmedia/\">kittmedia</a>, <a href=\"https://profiles.wordpress.org/manudavidos/\">manudavidos</a>, <a href=\"https://profiles.wordpress.org/nao/\">nao</a>, <a href=\"https://profiles.wordpress.org/nilovelez/\">nilovelez</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\">rmartinezduque</a>, и <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner</a>.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-3 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-background has-text-align-center wp-element-button\" href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey\" style=\"background-color:#0072b9\" target=\"_blank\" rel=\"noreferrer noopener\">Пройти опрос</a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2631\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WordPress отмечает 20 лет! Результаты опроса 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://ru.wordpress.org/news/2023/05/20th-anniversary-and-2022-survey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 May 2023 15:47:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:14:\"Новости\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:25:\"Общие вопросы\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ru.wordpress.org/?p=2579\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:621:\"27 мая WordPress отмечает свое 20-летие. По всему миру проходит множество праздников и вечеринок, надеюсь, с тортом, потому что все мы знаем, что вечеринка без торта — это просто встреча. Но если вы еще не присоединились к празднованию, у вас еще есть время, чтобы получить свой сувенир на юбилей WordPress, поделиться вашим любимым воспоминанием о [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Yui\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10216:\"\n<h2 class=\"wp-block-heading\">27 мая WordPress отмечает свое 20-летие.</h2>\n\n\n\n<p>По всему миру проходит множество праздников и вечеринок, надеюсь, с тортом, потому что все мы знаем, что вечеринка без торта — это просто встреча.</p>\n\n\n\n<p>Но если вы еще не присоединились к празднованию, у вас еще есть время, чтобы получить свой сувенир на юбилей WordPress, поделиться вашим любимым воспоминанием о WordCamp, устроить целую вечеринку, если хотите, или поделиться видео для публикации на <a href=\"https://wp20.wordpress.net\">wp20.wordpress.net</a>. </p>\n\n\n\n<p>За двадцать лет WordPress прошел долгий путь от форка Cafe Log и на настоящее время обслуживает 82 миллиона веб-сайтов (43% всех сайтов сети по данным W3Techs) и имеет экономический вес экосистемы в размере 597 миллиардов долларов. Но команда WordPress не останавливается на этом и не может просто сказать &#171;хорошая работа, а теперь просто посмотрим, что будет дальше&#187;. </p>\n\n\n\n<p>У WordPress большие планы на будущее, многие из которых основаны на совершенствовании нового редактора блоков в WordPress, который направлен на снижение входных барьеров для людей на любом этапе их обучения. <br><br>Присоединиться к празднованию юбилея WordPress онлайн или найти встречу или мероприятие поблизости можно на сайте <a href=\"https://wp20.wordpress.net\">wp20.wordpress.net</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Результаты ежегодного сообщества WordPress за 2022 год</h2>\n\n\n\n<p>Каждый год члены сообщества WordPress предоставляют ценные отзывы в рамках ежегодного опроса. На 2022 год опрос получил комплексное обновление, первое за шесть лет. Общее количество вопросов было сокращено с почти 100 до 29, в основном удалены социально-экономические вопросы и введена шкала Лайкерта. Эти обновления были предназначены для увеличения скорости заполнения опроса, обеспечения более эффективного и структурированного анализа этих данных и позиционирования опроса для наилучшего определения тем, которые наиболее важны для сообщества WordPress.</p>\n\n\n\n<p>Цель состоит в том, чтобы информация, полученная в ходе опроса, помогла информировать об инициативах и направлениях работы WordPress в ближайшем будущем, наряду с другими сигналами, такими как обсуждения в сообществе, блоги <a href=\"https://make.wordpress.org\">Making WordPress</a> и мероприятия.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Основные моменты</h3>\n\n\n\n<p>В выпуске опроса 2022 года процент завершения увеличился на 26%, однако количество представленных материалов уменьшилось на 56% до примерно 3400, включая около 800 участников. Для опроса 2023 года реклама будет увеличена, что, мы надеемся, компенсирует снижение числа заявок. Доля анкет заполненных на русском языке составила 7% (237 участников). Мы очень надеемся увидеть больше в опросе за 2023 год!</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Опрос показывает более широкое использование блоков и нового редактора сайта (по сравнению с классическим редактором), что не должно вызывать удивления, поскольку тема по умолчанию теперь основана на блоках.</li>\n\n\n\n<li>22% респондентов используют WordPress только год или меньше. Те, кто отвечает на опрос, также становятся немного старше: меньше ответов от лиц моложе 40 лет, чем в предыдущие годы.</li>\n\n\n\n<li>1 из 5 респондентов узнал о WordPress от коллеги и примерно такой же процент от использования поисковой системы.</li>\n\n\n\n<li>В 2022 году пользователи WordPress продолжали изучать WordPress (68%), обучали других работе с WP (48%) и создавали сайты для других (55%).</li>\n\n\n\n<li>Пользователи выбирают платформу CMS, потому что она с открытым исходным кодом (62%), гибкая (47%), с низким уровнем риска (45%), рентабельна (45%) и имеет положительную репутацию (41%).</li>\n</ul>\n\n\n\n<ul class=\"wp-block-list\">\n<li>57% участников опроса получали новости и обучающие материалы непосредственно с WordPress.org. Хотя это основной источник, другие сайты остаются очень важными: поисковые системы (46%), YouTube (40%), другие сообщества WordPress (35%) и социальные сети (30%).</li>\n\n\n\n<li>Подавляющее большинство респондентов не используют другие платформы CMS, а 21% респондентов не используют ни один из 20 лучших плагинов WordPress.</li>\n\n\n\n<li>Респонденты продолжают заявлять, что «WordPress не хуже или даже лучше других платформ CMS», с чем согласны 68%. Элементы, которые респонденты считают лучшими аспектами WordPress, включают «простоту использования», «гибкость» и/или «варианты плагинов», всего около 30% каждого. На вопрос о наиболее разочаровывающих элементах WordPress 1 из 5 ответил «ничего», а примерно 30% сослались на трудности с редактированием сайта или редактором блоков.</li>\n\n\n\n<li>Общий опыт участников остается положительным, 64% поделились своим положительным опытом, а 24% оценили свой опыт как «нейтральный». </li>\n</ul>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Участники сообщества также чувствуют себя желанными как и ранее (64% согласны и 24% нейтральны).</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Планы на 2023</h3>\n\n\n\n<p>В следующей итерации опроса планируется улучшить языковые возможности, а также продолжить уточнение вопросов вариантов ответов. Важно помнить, что заполнение опроса требует времени, поэтому мы хотим убедиться, что членам сообщества задаются вопросы, которые больше всего помогают WordPress.</p>\n\n\n\n<p>Предварительный план состоит в том, чтобы запустить опрос 2023 года уже в августе. Это создаст возможность собрать больше результатов и, что наиболее важно, их учета в планировании ключевых инициатив и направлений деятельности на 2024 год. Отзывы сообщества жизненно важны для успеха и направления проекта. </p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-4 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-width wp-block-button__width-50\"><a class=\"wp-block-button__link has-charcoal-0-color has-pale-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://wordpress.org/news/files/2023/05/2022-Annual-Survey-Final.pdf\">Скачать PDF-файл с результатами опроса</a></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<p><em>Для подготовки публикации использованы материалы:</em></p>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/05/episode-55-happy-anniversary-wordpress/\">Episode 55: Happy Anniversary, WordPress!</a><br><a href=\"https://wordpress.org/news/2023/05/2022-annual-survey-results-next-steps/\">2022 Annual Survey Results &amp; Next Steps</a><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2579\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Люди WordPress: Хаува Абашия\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://ru.wordpress.org/news/2023/03/people-of-wordpress-hauwa-abashiya/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 04 Mar 2023 12:56:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Люди WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:19:\"people-of-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ru.wordpress.org/?p=2569\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:650:\"В этой статье мы рассказываем о Хауве Абашия, менеджере проектов в Нигерии и Великобритании, чье стремление помогать людям и ее профессиональные навыки нашли применение и признание в глобальном сообществе WordPress. Иногда нам везет найти в жизни дело, к которому мы не только готовы присоединиться, но и отстаивать. Чтобы бы это ни было, оно может помочь [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olga Gleckler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:29644:\"\n<p>В этой статье мы рассказываем о Хауве Абашия, менеджере проектов в Нигерии и Великобритании, чье стремление помогать людям и ее профессиональные навыки нашли применение и признание в глобальном сообществе WordPress.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/02/feature-img-for-hauwa-powp.jpg\" alt=\"Портретная фотография Хаувы \" width=\"680\" height=\"420\" title=\"Портретная фотография Хаувы \" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Иногда нам везет найти в жизни дело, к которому мы не только готовы присоединиться, но и отстаивать. Чтобы бы это ни было, оно может помочь нам выйти за рамки повседневной рутины и переосмыслить то, что мы знаем. Именно это случилось с Хаувой, она почувствовала, что нашла свое место и смогла по новому посмотреть на свою жизнь и планы. </p>\n\n\n\n<p>Для нее поворотной точкой стало открытие WordPress, проекта с открытым исходным кодом.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Обучение разработке и WordPress</h2>\n\n\n\n<p>В 2017 году Хаува, уже опытный и успешный менеджер проектов, осознала, что не испытывает от работы того же восторга, как раньше, и ей откровенно скучно. «Я знала, что мне по-прежнему нравится работать с проектами и заниматься их управлением, но мне нужно было что-то менять», — вспоминает она.</p>\n\n\n\n<p>Тогда Хаува записалась на курсы веб-разработки, где освоила HTML, CSS и немного JavaScript. Одной из возможностей курса было изучение WordPress, и она выбрала его. Преподаватель курса посоветовал ей посетить конференцию WordCamp.</p>\n\n\n\n<p>Хаува посчитала, что необходимо иметь базовые знания о CMS (системе управления контентом сайта) до того, как приедет на мероприятие, и углубилась в самостоятельное изучение WordPress. Первый WordCamp, который она посетила, проходил в приморском городе Брайтон на южном побережье Англии. Там она встретила людей, которые стали ее друзьями и наставниками на долгие годы.</p>\n\n\n\n<p>«Меня вдохновили встречи с людьми из сообщества WordPress. Моя жизнь и мое желание поддерживать сообщества изменились к лучшему благодаря людям, которых я встретила, и я продолжаю благодарна судьбе за знакомство с ними».</p>\n\n\n\n<h2 class=\"wp-block-heading\">Глобальное сообщество WordPress: от Германии до Нигерии</h2>\n\n\n\n<p>Открыв для себя сообщество WordPress в Великобритании, Хаува заинтересовалась его реальными масштабами, и услышав, что WordCamp Europe — флагманское мероприятие, собирающее тысячи людей со всего мира, захотела принять участие в его организации и использовать свои навыки управления проектами. Она подала заявку и стала волонтером в трехдневной конференции, которая в 2019 году проходила в столице Германии, Берлине. На этом мероприятии Хаува познакомилась не только с участниками со всего мира, но и открыла для себя активное сообщество WordPress в своей родной Нигерии. После она обнаружила как легко поддерживать связь с друзьями со всего мира через мессенджеры.&nbsp;</p>\n\n\n\n<p>Вдохновившись людьми, которые использовали WordPress для улучшения жизни людей в Нигерии и других частях Африки, Хаува начала изучать, как WordPress и его глобальное сообщество могут помочь улучшить взаимопонимание между культурами и континентами.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/02/hauwa-and-her-mom.jpg\" alt=\"Хаува и ее мать Розалинд на одном из мероприятий в Нигерии.\" title=\"Хаува и ее мать Розалинд на одном из мероприятий в Нигерии\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Отец Хаувы, доктор Ауду Квасау Абашия, и ее мать Розалинд Зулай Абашия — известны своей благотворительной деятельностью, в частности оказанием поддержки людям в Кадуне, на севере Нигерии, и Абудже в центре страны. Хаува поясняет: «Моя мама происходит из семьи, которая делится своими навыками для оказания практической помощи. От друзей, с которыми я познакомилась в WordPress, я узнала, что есть части общества, которые придерживаются такой же этики. Я могла бы стать частью этого, внести свою лепту в развитие Нигерии в будущем».</p>\n\n\n\n<p>Ее родители основали благотворительный фонд, цель которого — помощь вдовам, сиротам и детям получить доступ к образованию, от финансов до музыки. Он связывает тех, кто нуждается в помощи, и тех, кто может оказать поддержку.</p>\n\n\n\n<p>Хаува говорит: «Обучение людей практическим навыкам, которые можно использовать для получения дохода или которыми можно поделиться с семьей и другими людьми в своем районе, очень важно. Подобные проекты помогают развивать и поддерживать общину. Такие навыки, как шитье и кулинария — это не просто возможность одеться и поставить еду на стол, но и обретение независимости и гордости. Они являются примером того, как микроэкономика может развиваться и вдохновлять людей на мечты, воплощающиеся в жизнь. В ходе своей работы и учебы я убедилась, что технологии, используемые сознательно и с пониманием решаемых задач, способны изменить жизнь общин к лучшему. Такие проекты, как WordPress, могут стать частью этой движущей силы благодаря переводу на родной язык и самому программному обеспечению, позволяющему делиться идеями».</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/02/hauwa-in-2022.jpg\" alt=\"Хаува в Нигерии\" title=\"Хаува в Нигерии\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Имея опыт управления проектами и работы в сфере информационных технологий, Хаува все больше интересуется тем, как можно использовать свои навыки не только для сплочения сообщества, но и для практического долгосрочного вклада в местную инфраструктуру и внедрения быстро меняющихся технологий.</p>\n\n\n\n<p>Она говорит: «Я бы хотела, чтобы некоторые люди, которым помог фонд, основанный моими родителями, могли поделиться своими идеями и достижениями и вдохновлять других. Одним из путей может стать программное обеспечение с открытым исходным кодом, доступное для использования и которое может работать на мобильных телефонах».</p>\n\n\n\n<p>«Побыв представителем <a href=\"https://make.wordpress.org/training/\">Training Team</a> (команды обучения), я на собственном опыте убедилась, насколько важно, чтобы пользователи не являющиеся технарями могли использовать программное обеспечение для обмена своими идеями без необходимости становиться разработчиками. Мы все можем помочь людям быть услышанными, и если мы работаем в сфере технологий, мы играем определенную роль в создании и продвижении доступности инструментов для этого».</p>\n\n\n\n<p>В списке желаний Хаувы помочь африканским странам получить доступ к программному обеспечению и технологиям на их местных языках. Она говорит: «Это часть самобытности, уважения и признания различных культур, а не ожидание того, что все будет переведено с английского дословно. Это дает возможность пожилым людям пользоваться программным обеспечением или опубликованным контентом».</p>\n\n\n\n<p>Хаува выучила хауса (язык, на котором говорят в нескольких африканских странах) и английский одновременно у себя дома в Нигерии. Она, как и ее родители, получила образование в разных местах, училась и работала в разных странах. В 16 лет Хаува занялась информатикой как развлечением, не догадываясь, что в будущем это станет важной частью ее трудовой жизни. </p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/02/hauwa-in-2015.jpg\" alt=\"Хаува в кафе в 2015 году\" title=\"Хаува в кафе в 2015 году\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Она собиралась поступить в университет, чтобы изучать финансы и социологию. Когда она пошла прощаться с классом по информатике, учитель спросил, что она собирается делать. Услышав о ее планах, учитель сказал: «Ты не хочешь заниматься этим, ты хочешь заниматься чем-то в области IT». Этот разговор стал поворотным моментом для Хаувы. Она продолжила изучать вычислительные и информационные системы и объектно-ориентированные информационные системы для получения степени магистра в Великобритании.</p>\n\n\n\n<p>На втором курсе университета она также работала с технологиями вводом данных и в смежных областях, поскольку была полна решимости узнать как можно больше о различных направлениях. После окончания магистратуры она выбрала работу, которая позволяла ей работать с системами, их поддержкой, управлением проектами, цепочками поставок и закупками. Она является сторонником изучения как можно большего количества смежных дисциплин, чтобы получить широкий набор инструментов для реального понимания того, что нужно клиентам и как помочь им достичь подходящих и своевременных решений. Эти навыки оказались полезными и в последующие годы, что позволило ей найти время для поддержки конференций WordCamp, митапов и Training Team. Она говорит: «Участники проектов с открытым исходным кодом являются представителями самых разных профессиональных и культурных слоев. Участие в проекте — это отличный способ делиться своими навыками и сохранять их актуальным и быть открытым для новых возможностей обучения».</p>\n\n\n\n<p>Хаува сохранила любовь к управлению проектами и образованию, она получила квалификации в этой области, включая Prince 2 и PMP. Она остается верна идее непрерывного обучения в своей сегодняшней работе с Agile и другими методологиями и находит взаимосвязь между работой и своим стремлением к просвещению.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/02/hauwa-at-wc-london-2019-2.jpg\" alt=\"Хаува у стойки регистрации на WordCamp London 2019\" title=\"Хаува у стойки регистрации на WordCamp London 2019\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Стремясь поддержать и местное сообщество в Великобритании, Хаува присоединилась к London WordPress Meetup, а в 2019 году стала организатором WordCamp London, где она использовала свой опыт в области управления проектами. Во время этих мероприятий она провела множество бесед, призывая других развивать свои навыки в области ИТ и делясь собственным опытом.</p>\n\n\n\n<p>Этот интерес к повышению уровня квалификации других людей естественным образом привел ее к дальнейшему участию в работе команд <a href=\"https://make.wordpress.org/\">Make WordPress</a>. Вдохновленная идеей поделиться своими навыками другим участником проекта, она присоединилась к <a href=\"https://make.wordpress.org/training/\">Training Team</a> на Contributor Day во время WordCamp. Эта команда трудится над созданием онлайн платформы — <a href=\"https://learn.wordpress.org/\">Learn</a>, позволяющей людям осваивать программное обеспечение и поддерживать свои знания актуальными, а также научиться развивать сообщество в своем регионе. Хаува считает, что доступность — ключевой фактор, поэтому она посвятила много времени проработке документации для лучшего понимания. Она считает, что это необходимо для того, чтобы действительно предоставить людям доступную информацию и определить, где требуется дополнительная работа. Ее вера в это только укрепилась, когда она присоединилась к <a href=\"https://make.wordpress.org/accessibility/\">Accessibility Team</a> (команде по обеспечению доступности) релиза WordPress 5.6, и она внесла свой вклад в документацию и образовательные материалы.</p>\n\n\n\n<p>Хаува посвятила много часов поддержке Training Team в течение нескольких лет, будучи убежденной в том, что правильные ресурсы могут действительно помочь сообществам во всем мире использовать программное обеспечение с открытым исходным кодом. Она также подчеркивает важность того, чтобы материалы должны быть удобными для пользователей и легко переводиться, поскольку проект WordPress имеет глобальный масштаб.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Вклад в программное обеспечение с открытым исходным кодом заряжает энергией</h2>\n\n\n\n<p>Благодаря сочетанию волонтерской деятельности в Великобритании и Нигерии, а также поддержке участников по всему миру, Хаува заново открыла в себе стремление помогать людям — планировать и достигать своих целей. Она смогла поделиться своим 15-летним опытом управления проектами в своей волонтерской деятельности и призывает других рассмотреть эту профессию в качестве карьеры.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/02/Hauwa-WC-Europe-2019.jpg\" alt=\"Хаува на WordCamp Europe 2019\" title=\"Хаува на WordCamp Europe 2019\" /></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>«Занимаясь волонтерством, вы работаете рядом с людьми. Управление проектами связано с людьми. Это помощь людям в достижении целей. То же самое можно сделать и через волонтерство, и вы можете многому научиться, встречаясь с людьми из разных мест». </p>\n\n\n\n<p>«Одним из моих стимулов является использование технологий для решения проблем. Для меня, как руководителя проектов, большая честь помогать людям и организациям определять и достигать цели. Это позволяет им обрести ценность. Это одна из причин, по которой меня потянуло к поиску технологических сообществ и участию в них. Если это то, что движет вами, читающими о моем опыте, то у вас есть широкие возможности поделиться своими навыками. Найдите то, что подходит именно вам, там, где вы сейчас находитесь». </p>\n\n\n\n<p>Хаува призывает всех, кто работает в сфере технологий, углубить свое понимание управления проектами и работы с различными командами. «Навыки управления проектами очень важны, в каком бы проекте вы ни работали. Из-за долгих рабочих часов на протяжении многих лет я чувствовала, что потеряла связь с людьми. Я застряла в, казалось, повторяющемся цикле. Благодаря людям, которых я встретила в сообществе WordPress, и использованию моих профессиональных навыков, я вспомнила о своих собственных ценностях и о том, как в качестве менеджера проектов я могу помочь другим достичь новых высот или сделать что-то ценное и существенное, чем другие могут использовать».  </p>\n\n\n\n<p>В 2022 году Хаува вернулась к работе на полную ставку в национальных и международных проектах впечатляющих своими масштабами и время ее волонтерской работы в рамках глобальных инициатив по развитию сообществ сократилось, но она продолжает вносить свой вклад в WordPress, сосредоточившись на продвижении образовательных проектов и культурной стороне сообщества.</p>\n\n\n\n<p>«Я буду продолжать интересоваться тем, как проекты с открытым исходом, такие как WordPress, работая вместе с другими решениями, может помочь некоммерческим организациям в их развитии. По мне, если существуют технологические решения, то мы все можем сыграть определенную роль в их развитии и изменении ситуации».</p>\n\n\n\n<p>«То, как мы помогаем сообществам, не обязательно должно оставаться неизменным на протяжении всего времени. Важно постоянно смотреть на то, что необходимо, и на то, какую пользу это может принести».</p>\n\n\n\n<p>«Найдите то, что хотела ли бы воплотить для своего родного соообщества, и, возможно, существуют технологии, которые могут воплотить его. Я рада, что начала свое путешествие».</p>\n\n\n\n<h2 class=\"wp-block-heading\">Поделитесь историями</h2>\n\n\n\n<p>Познакомьтесь с другими историями в серии «Люди WordPress», помогите поделиться или с другими и присоединяйтесь к нам, чтобы найти новое применение собственным знаниям и талантам, найти друзей и внести вклад в развитие проекта в глобальном масштабе. Тут находят единомышленников и филологи, и самые отъявленные технари. Make WordPress сейчас насчитывает 21 команду, и вы всегда можете присоединиться к русскоязычному комьюнити в Telegram.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Авторы и редакторы</h2>\n\n\n\n<p>Спасибо Хауве Абашия (<a href=\"https://profiles.wordpress.org/azhiyadev/\">@azhiyadev</a>) за ее #ContributorStory.</p>\n\n\n\n<p>Спасибо Абе Такор (<a href=\"https://profiles.wordpress.org/webcommsat/\">@webcommsat</a>) за интервью и запись, а также Мехер Бала (<a href=\"https://profiles.wordpress.org/meher/\">@meher</a>), Хлое Брингманн <a href=\"https://profiles.wordpress.org/cbringmann/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/cbringmann/\">@cbringmann</a>), Мари Баум (<a href=\"https://profiles.wordpress.org/marybaum/\">@marybaum</a>), Налини Такор (<a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">@nalininonstopnewsuk</a>) and Майе Лончар (<a href=\"https://profiles.wordpress.org/majaloncar/\">@majaloncar</a>) за редактуру и работу с фотографиями.</p>\n\n\n\n<p>Серия Люди WordPress благодарит Джозефу Хейден (<a href=\"https://profiles.wordpress.org/chanthaboune/\">@chanthaboune</a>) и Тофера ДеРозиа (<a href=\"https://profiles.wordpress.org/topher1kenobe/\">@topher1kenobe</a>) за поддержку проекта.</p>\n\n\n\n<p>Перевод на русский: Ольга Глеклер (<a href=\"https://profiles.wordpress.org/oglekler/\">@oglekler</a>)</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image\"><img loading=\"lazy\" decoding=\"async\" width=\"180\" height=\"135\" src=\"https://ru.wordpress.org/files/2021/03/heropress-logo.png\" alt=\"\" class=\"wp-image-2268\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p>Эта статья основана на первоначальной публикации HeroPress.com, инициативе, ориентированной на людей в сообществе WordPress, созданной Тофером ДеРозиа&nbsp;<a href=\"https://profiles.wordpress.org/topher1kenobe/\">@topher1kenobe</a>.</p>\n</div>\n</div>\n\n\n\n<p>Читайте эту и другие истории серии «<a href=\"https://wordpress.org/news/category/interviews/\">People of WordPress</a>» (на английском) или «<a href=\"https://ru.wordpress.org/news/category/people-of-wordpress/\">Люди WordPress</a>» (на русском).</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2569\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Сообщество WordPress Russia в Telegram\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"https://ru.wordpress.org/news/2023/02/%d1%81%d0%be%d0%be%d0%b1%d1%89%d0%b5%d1%81%d1%82%d0%b2%d0%be-wordpress-russia-%d0%b2-telegram/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Feb 2023 12:57:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:14:\"Новости\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:25:\"Общие вопросы\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ru.wordpress.org/?p=2558\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:667:\"В связи с закрытием пространства WordPress Russia в Slack с 21 марта 2023 года, были открыты каналы сообщества в Telegram.Добро пожаловать: https://t.me/ru_wp_org На каналах можно как общаться по поводу WordPress и сообщества, по развитию проекта WordPress (внесению своего вклада в проект), так и просто пообщаться (#random). Обратите внимание!Все темы, связанные с поддержкой WordPress следует по-прежнему [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Yui\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2535:\"\n<div class=\"wp-block-group is-layout-constrained wp-block-group-is-layout-constrained\">\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://ru.wordpress.org/files/2023/02/wapuushkin-wapuu.png\" alt=\"\" class=\"wp-image-2563 size-full\" srcset=\"https://ru.wordpress.org/files/2023/02/wapuushkin-wapuu.png 300w, https://ru.wordpress.org/files/2023/02/wapuushkin-wapuu-150x150.png 150w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></figure><div class=\"wp-block-media-text__content\">\n<p>В связи с <a rel=\"noreferrer noopener\" href=\"https://slack.com/blog/news/access-restricted-russia-embargoed-regions-ukraine\" target=\"_blank\">закрытием пространства</a> WordPress Russia в Slack с 21 марта 2023 года, были открыты каналы сообщества в Telegram.<br>Добро пожаловать: <a rel=\"noreferrer noopener\" href=\"https://t.me/ru_wp_org\" target=\"_blank\">https://t.me/ru_wp_org</a></p>\n</div></div>\n</div>\n\n\n\n<p>На каналах можно как общаться по поводу WordPress и сообщества, по развитию проекта WordPress (<a href=\"https://make.wordpress.org/\">внесению своего вклада в проект</a>), так и просто пообщаться (#random).</p>\n\n\n\n<p>Обратите внимание!<br>Все темы, связанные с поддержкой WordPress следует по-прежнему создавать на форуме, сообщество в Telegram (как и ранее в Slack) существует<br>прежде всего для общения на темы, связанные с внесением своего вклада в развитие WordPress любым из доступных способов: разработка ядра, дизайн, переводы, ответы на форумах, документация, публикация плагинов и тем в каталоге, организация мероприятий, улучшение самого портала <a href=\"http://WordPress.org\">WordPress.org</a>, тестирование, маркетинг, CLI и т.д.</p>\n\n\n\n<p>Для переводов WordPress, плагинов, тем и прочих связаных проектов существует канал <a href=\"https://t.me/wp_translate\">https://t.me/wp_translate</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2558\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"Ежегодный опрос пользователей и участников разработки WordPress 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://ru.wordpress.org/news/2022/12/2022-wordpress-survey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Dec 2022 16:13:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:14:\"Новости\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:25:\"Общие вопросы\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ru.wordpress.org/?p=2547\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:715:\"Каждый год сообщество WordPress проводит ежегодный опрос для пользователей и участников сообщества. Ключевые выводы и тенденции, выявляемые в результате этого опроса, часто отражаются в ежегодном обращении State of the Word, публикуются в общедоступных блогах проекта и могут влиять на направление и стратегию проекта WordPress. Проще говоря: этот опрос помогает тем, кто создает WordPress, больше узнать [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Yui\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6195:\"\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\"><div class=\"wp-block-media-text__content\">\n<p style=\"font-size:18px\">Каждый год сообщество WordPress проводит ежегодный опрос для пользователей и участников сообщества. </p>\n</div><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"768\" height=\"342\" src=\"https://ru.wordpress.org/files/2019/11/image-12-1.png\" alt=\"\" class=\"wp-image-2145 size-full\" srcset=\"https://ru.wordpress.org/files/2019/11/image-12-1.png 768w, https://ru.wordpress.org/files/2019/11/image-12-1-300x134.png 300w\" sizes=\"auto, (max-width: 768px) 100vw, 768px\" /></figure></div>\n\n\n\n<p>Ключевые выводы и тенденции, выявляемые в результате этого опроса, часто отражаются в ежегодном обращении <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\" target=\"_blank\" rel=\"noreferrer noopener\">State of the Word</a>, публикуются в общедоступных блогах проекта и могут влиять на направление и стратегию проекта WordPress.</p>\n\n\n\n<p>Проще говоря: этот опрос помогает тем, кто создает WordPress, больше узнать о том, как и кем используется программное обеспечение. Опрос также помогает руководителям проектов с открытым исходным кодом WordPress больше узнать об опыте наших участников.</p>\n\n\n\n<p>В этом году опрос был переработан и стал заметно короче, поэтому ответы на него займут у вас не так много времени.</p>\n\n\n\n<p>В этом году мы предлагаем пройти вам этот опрос:</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-5 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-outline is-style-outline--1\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpressdotorg.survey.fm/ru-2022\" target=\"_blank\" rel=\"noreferrer noopener\">На русском</a></div>\n\n\n\n<div class=\"wp-block-button is-style-outline is-style-outline--2\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpressdotorg.survey.fm/en-2022\" target=\"_blank\" rel=\"noreferrer noopener\">In English</a></div>\n</div>\n\n\n\n<p>Как и в прошлом году, предлагаются и другие языки: <a href=\"https://wordpressdotorg.survey.fm/fr-2022\">французский</a>, <a href=\"https://wordpressdotorg.survey.fm/de-2022\">немецкий</a>, <a href=\"https://wordpressdotorg.survey.fm/it-2022\">итальянский</a>, <a href=\"https://wordpressdotorg.survey.fm/jp-2022\">японский</a>, и <a href=\"https://wordpressdotorg.survey.fm/es-2022\">испанский</a>. Это шесть наиболее часто используемых языков, помимо английского, основываясь на количестве загрузок программного обеспечения WordPress. Возможно, в 2023 году будут добавлены и другие.</p>\n\n\n\n<p>Сбор данных осуществляется в полном соответствии с <a rel=\"noreferrer noopener\" href=\"https://ru.wordpress.org/about/privacy/\" target=\"_blank\">политикой конфиденциальности WordPress.org</a>: все данные будут анонимизированы и не будут ассоциироваться с IP-адресами и адресами e-mail.</p>\n\n\n\n<p>Опрос открыт до конца 2022 года, его результаты будут опубликованы позже в блоге WordPress.org. </p>\n\n\n\n<p>Помогите распространить информацию об опросе, поделившись им в социальных сетях или иным способом. Чем больше людей пройдут опрос и поделятся своим опытом работы с WordPress, тем больше пользы получит проект в будущем.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Благодарность</h2>\n\n\n\n<p>За помощь в создании, оформлении и переводе на национальные языки опроса, спасибо следующим участникам: <a href=\"https://profiles.wordpress.org/dansoschin/\">dansoschin</a>, <a href=\"https://profiles.wordpress.org/_dorsvenabili/\">_dorsvenabili</a>, <a href=\"https://profiles.wordpress.org/angelasjin/\">angelasjin</a>, <a href=\"https://profiles.wordpress.org/arkangel/\">arkangel</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">audrasjb</a>, <a href=\"https://profiles.wordpress.org/atachibana/\">atachibana</a>, <a href=\"https://profiles.wordpress.org/bjmcsherry/\">bjmcsherry</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">chanthaboune</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\">eidolonnight</a>, <a href=\"https://profiles.wordpress.org/fernandot/\">fernandot</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">fierevere</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">jdy68</a>, <a href=\"https://profiles.wordpress.org/jpantani/\">jpantani</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">laurlittle</a>, <a href=\"https://profiles.wordpress.org/nao/\">nao</a>, <a href=\"https://profiles.wordpress.org/nielslange/\">nielslange</a>, <a href=\"https://profiles.wordpress.org/peiraisotta/\">peiraisotta</a>, <a href=\"https://profiles.wordpress.org/piermario/\">piermario</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\">rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/santanainniss/\">santanainniss</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2547\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Прекращение поддержки старых версий WordPress 3.7-4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://ru.wordpress.org/news/2022/11/dropping-security-updates-for-wordpress-versions-3-7-through-4-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Nov 2022 09:17:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:25:\"Общие вопросы\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:12:\"Релизы\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ru.wordpress.org/?p=2544\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:826:\"Команда безопасности WordPress прекратит предоставлять обновления для версий WordPress 3.7–4.0, начиная с 1 декабря 2022 года. Официально WordPress предоставляет поддержку только последней версии программного обеспечения. Команда безопасности исторически практикует предоставление исправлений безопасности в качестве любезности для сайтов с более старыми версиями в ожидании, что сайты будут автоматически обновлены. До сих пор эти исправления включали все [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Yui\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2294:\"\n<p><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/security/\" target=\"_blank\">Команда безопасности</a> WordPress прекратит предоставлять обновления для версий WordPress 3.7–4.0, начиная с 1 декабря 2022 года.</p>\n\n\n\n<p>Официально WordPress предоставляет поддержку только последней версии программного обеспечения. Команда безопасности исторически практикует предоставление исправлений безопасности в качестве любезности для сайтов с более старыми версиями в ожидании, что сайты будут автоматически обновлены.</p>\n\n\n\n<p>До сих пор эти исправления включали все версии WordPress, поддерживающие автоматические обновления. Версии WordPress 3.7 – 4.0 достигли <a rel=\"noreferrer noopener\" href=\"https://ru.wordpress.org/about/stats/\" target=\"_blank\">уровней использования менее 1%</a> от общего числа установок, где польза от предоставления этих обновлений перевешивается затраченными усилиями.</p>\n\n\n\n<p>Сегодня, 30 ноября 2022, выйдут последние обновления для веток 3.7, 3.8, 3.9 и 4.0, в них единственным изменением станет анонсирование прекращения поддержки безопасности и предложение перейти на более свежую версию WordPress.</p>\n\n\n\n<p>Если у вас возникнут проблемы при переходе к новой версии WordPress, вы можете обратиться на <a rel=\"noreferrer noopener\" href=\"https://ru.wordpress.org/support/\" target=\"_blank\">форумы поддержки</a>. Не забывайте о резервном копировании перед внесением изменений на свой сайт.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2544\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Люди WordPress: Михаил Кобзарёв\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://ru.wordpress.org/news/2022/08/people-of-wordpress-mikhail-kobzarev/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Aug 2022 09:05:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Люди WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:19:\"people-of-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ru.wordpress.org/?p=2526\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:742:\"Мы продолжаем серию интервью с участниками русского сообщества WordPress, объединяющем русскоговорящих разработчиков, переводчиков, пользователей и владельцев сайтов по всему миру.&#160; Сегодня мы беседуем с Михаилом Кобзарёвым, автором плагинов и техноблогером, чье имя и никнейм на слуху у всех, кто интересуется новостями WordPress. — Более 13 лет ты совмещаешь веб-разработку с личным блогом, а последние 5 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olga Gleckler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:34548:\"\n<p>Мы продолжаем серию интервью с участниками русского сообщества WordPress, объединяющем русскоговорящих разработчиков, переводчиков, пользователей и владельцев сайтов по всему миру.&nbsp;</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-2.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-2-1024x683.jpg\" alt=\"\" class=\"wp-image-2531\" srcset=\"https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-2-1024x683.jpg 1024w, https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-2-300x200.jpg 300w, https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-2-768x512.jpg 768w, https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-2-1536x1024.jpg 1536w, https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-2-2048x1365.jpg 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Сегодня мы беседуем с <a href=\"https://profiles.wordpress.org/mihdan/\">Михаилом Кобзарёвым</a>, автором плагинов и техноблогером, чье имя и никнейм на слуху у всех, кто интересуется новостями WordPress.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Более 13 лет ты совмещаешь веб-разработку с личным блогом, а последние 5 лет еще и </em></strong><a href=\"https://wp-digest.com/\"><strong><em>WordPress Digest</em></strong></a><strong><em> ведешь. Как удается все совмещать и не разбрасываться, что тебя вдохновляет и чему научился за это время?&nbsp;</em></strong></p>\n\n\n\n<p>Начнем с того, что мой общий стаж в разработке почти 19 лет, за которые я перепробовал все методики управления своим временем и проектами. Плюс после переезда из мегаполиса в деревню я стал работать удаленно задолго до того, как это стало мейнстримом. По этим причинам я выработал для себя определенный график труда и отдыха.</p>\n\n\n\n<p>Во-первых, никакой работы по выходным, праздникам и в отпуске — мозги нужно постоянно разгружать, иначе очень просто выгореть, когда ведешь несколько проектов одновременно и держишь огромные массивы данных в голове, постоянно что-то просчитываешь, прикидываешь, прорабатываешь разные варианты.</p>\n\n\n\n<p>Во-вторых, на протяжении дня обязательны перерывы, во время которых никаких гаджетов и телевизоров быть не должно — глазам тоже нужен отдых. В это время лучше выйти на улицу, пройтись, поглядеть вдаль и помечтать о будущем ) Тут может помочь любой pomodoro таймер.</p>\n\n\n\n<p>В третьих, необходимо соблюдать режим дня (который у меня последнее время немного сбился). Исторически сложилось, что мой рабочий день вот уже много лет начинается в 11 и заканчивается в 19 часов по московскому времени. В Москве это самые удобные часы, чтобы добраться до работы и безболезненно уехать домой, а утром всегда есть время на семью: походы по магазинам или поездка в поликлинику с ребенком.</p>\n\n\n\n<p>Свой блог я начал вести еще когда учился в университете на радиотехника в Туле, он задумывался именно как дневник/записная книжка для себя и одногруппников, где я делился своими открытиями в чудесном мире разработки на РНР, верстки под IE6, Netscape 4 и Opera 6.</p>\n\n\n\n<p>Я очень много поглощаю информации из интернета за день (в основном через RSS как старый добрый олдфаг), особо интересные заметки кладу в закладки для чтения позже. И есть огромное желание делиться этими знаниями с людьми (я помню то время, когда не было интернета и всю информацию мы получали из книг, журналов и энциклопедий), поэтому с появлением Твиттера я стал постить много контента туда, так как&nbsp;под содержимое моего блога.</p>\n\n\n\n<p>Со временем русскоязычный Твиттер стал превращаться в помойку и одновременно с этим появился Телеграм, в котором я был одним из первых бета-тестеров. Мы стали переводить рабочие чаты туда, создавать каналы для своих, так появились сначала закрытые, а потом уже и открытые публично чаты и каналы: WordPress Digest (сюда мы постим новости по WordPress), WordPress Jobs (работа вокруг WordPress), Elementor (чат по конструктору страниц Elementor) и многие другие. Основные можно поглядеть у меня <a href=\"https://www.kobzarev.com/wordpress/wordpress-resources/\">в блоге</a>.</p>\n\n\n\n<p>Вдохновляет меня на все эти подвиги моя семья и мои родители, я им искренне благодарен за знания, которые они в меня вложили в детстве и научили самостоятельности, благодаря которой я много лет занимаюсь самообразованием и стараюсь помогать другим. А вот опыт больших компаний (Apple, Microsoft, Tesla) меня не вдохновляет, так как они всего лишь попали в нужное место в нужное время. Каждый должен наступить на свои грабли, ведь человек не учится на чужих ошибках.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Почему WordPress? Всегда ли сложный проект значит «интересный» для тебя как разработчика?</em></strong></p>\n\n\n\n<p>За эти 19 лет я набрался огромного опыта почти во всех сферах необъятного веба: фронтенд, бэкенд, seo и даже дизайн, перепробовал кучу языков программирования, прошел десятки курсов и прочитал сотни книг, поработал в нескольких крупных компаниях и мелких веб-студий и могу сказать однозначно: WordPress — сила.</p>\n\n\n\n<p>К WordPress я пришел не сразу. Это был долгий тернистый путь. Все начиналось с написания своей CMS в компании Ingate (которая была блочная как текущий Gutenberg и использовала ныне непопулярный XML/XSLT).</p>\n\n\n\n<p>Потом была своя CMS в студии Imagos на чистом РНР4 без фреймворков, которую можно до сих пор встретить на некоторых сайтах.</p>\n\n\n\n<p>А после переезда из Тулы в Москву я попал в информационное агентство, где мы делали сайты для МИД, дипломатов, РАН, поднимали свои информационные, новостные порталы, здесь мне пригодился опыт написания своих CMS под нужды заказчиков и мы с коллегами запилили не просто новую CMS, а целую платформу, на которой сейчас крутится около 12к сайтов для сельских газет, они им достались совершенно бесплатно.</p>\n\n\n\n<p>И тут случился кризис в стране и нам пришлось всем временно уйти на удаленку, так как ЗП платить нам перестали, а на дорогу и покушать в Москве нужно было много денег, плюс съемная квартира и маленький ребенок.</p>\n\n\n\n<p>В это время, чтобы прокормить семью, пришлось работать с разными CMS (Joomla, Drupal, ModX) и фреймворками (Zend, Symfony, Laravel, Yii).</p>\n\n\n\n<p>Компания не смогла быстро выйти из этого кризиса и мы с бывшими коллегами покинули занимаемые должности и запустили несколько стартапов разной направленности, которые мы сделали на популярном тогда Битрикс.</p>\n\n\n\n<p>Работая с Битрикс, я испытал много боли и унижения. В итоге мы уперлись в потолок его кастомизации и решили попробовать WordPress, у меня был небольшой опыт работы с ним в то время. Максимум, что я тогда сделал — развернул свой блог на нем и перенес туда все свои заметки за много лет. Так начался мой путь в WordPress.</p>\n\n\n\n<p>Следующие несколько лет с каждым днем проектов на WordPress мне попадалось все больше и больше, как простых так и сложных, копился опыт и я начал писать свои <a href=\"https://profiles.wordpress.org/mihdan/#content-plugins\">бесплатные плагины под WordPress</a>, которые я по сей день дополняю и поддерживаю, новый функционал добавляется за счет донов и отдается бесплатно.</p>\n\n\n\n<p>И вот уже 10 лет я делаю сайты на WordPress, разрабатываю бэкенд для мобильных приложений на WordPress REST API или использую «безголовый» (headless) WordPress для сайтов на React/Vue.</p>\n\n\n\n<p>Это не всегда интересные проекты, но всегда достаточно сложные, высоконагруженные и объемные с большим количеством кастомного кода на бэкенде. Я стараюсь не брать (но в качестве исключения иногда беру) совсем простые проекты и не заниматься доработками чужих, предпочитаю стартапы — там всегда можно найти для себя что-то интересное и ограничивает тебя лишь полет фантазии ))</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Ты родом из маленького села в Магаданской области и сейчас предпочитаешь сельскую местность мегаполисам. Давно ли ты работаешь удаленно, легко ли это и почему выбрал жизнь вне города?</em></strong></p>\n\n\n\n<p>Родился я в поселке Сеймчан («Солнечная долина» по-эвенски) Магаданской области, после окончания школы поступил в ТулГУ в городе Тула на радиотехника и мечтал ремонтировать телевизоры и видеомагнитофоны, но судьба распорядилась иначе и я открыл для себя бесплатный кабинет интернета в Политехе, который меня заворожил, а после того как я случайно нажал CTRL+U на странице <a href=\"http://ya.ru\">ya.ru</a> и увидел разноцветные строки кода — «поплыл» и не могу остановиться до сих пор.</p>\n\n\n\n<p>Несколько лет работал в Туле, потом в Москве, потом по стечению обстоятельств попал в деревню под Тулой и мне тут так стало просто и кайфово, что я больше не стал возвращаться в мегаполис. Тут чистый воздух, свое хозяйство, красота, спокойствие и нет городской суеты и пробок, в которых я проводил по 2-4 часа в сутки, живя в большом городе. И так уже 7 лет я удаленщик, не путайте с фрилансом (работаю официально, фултайм).</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-1.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-1-1024x683.jpg\" alt=\"Фотографии Михаила Кобзарева на отдыхе с сыном\" class=\"wp-image-2529\" srcset=\"https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-1-1024x683.jpg 1024w, https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-1-300x200.jpg 300w, https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-1-768x512.jpg 768w, https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-1-1536x1024.jpg 1536w, https://ru.wordpress.org/files/2022/08/Mikhail-Kobzarev-1-2048x1365.jpg 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a><figcaption class=\"wp-element-caption\">Михаил на отдыхе с сыном</figcaption></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Но есть и свои минусы: за продуктами, в больницу, стоматологию, кинотеатр приходится ездить в город, но это не является проблемой, когда у тебя есть автомобиль и четкий распорядок дня, когда ты можешь час-два в день отлучиться по личным вопросам.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Сейчас в профессиональных чатах активно обсуждается тема трудоустройства и возникает ощущение, что работодатели и кандидаты не могут друг друга найти. Ты размещаешь в Дайджесте вакансии и общаешься и с теми, и с другими. Действительно ли существует проблема и что нужно делать, чтобы найти работу или нанять подходящего специалиста?</em></strong></p>\n\n\n\n<p>К сожалению, эта проблема сейчас как снежный ком. Образовалась она не так давно по понятным причинам, в основном из-за оттока специалистов за границу во всех сферах жизни и не только в IT.</p>\n\n\n\n<p>Мы с ребятами-волонтерами на нашем проекте <a href=\"https://wp-digest.com/vacancies/\">WordPress Jobs</a> стараемся помогать обеим сторонам, чтобы компании находили достойных специалистов, а соискатели — работу мечты.</p>\n\n\n\n<p>Сейчас не достаточно просто разместить резюме на сайте HH.ru. Многие компании ушли с рынка и сейчас практически некому заниматься обучением джунов (за исключением таких компаний как Сбер, Яндекс, Тинькофф), все хотят минимум мидлов, которых осталось тоже не так много, поэтому необходимо помимо резюме иметь открытый живой GitHub аккаунт, где рекрутеры смогут увидеть ваши скилы. Желательно крутиться в тематических чатах, куда HR-ы тоже часто заглядывают дабы схантить новых кандидатов. Не стоит забывать про личные блоги (с моего блога на меня приходит 30% заказов) и LinkedIn (правда придется заморочиться с VPN).</p>\n\n\n\n<p>А для компаний один совет — пишите про себя больше и исключительно правду, сейчас всю информацию очень легко проверить, а если работодателя уличат во лжи — доверия от соискателей ждать не стоит. У нас были случаи, когда мы отказывали в размещении вакансий, так как я стараюсь сам лично проверять каждое объявление, «пробивать» компании по открытым базам, общаться с ними лично. Это долго, но снижает процент мошенничества с обеих сторон.</p>\n\n\n\n<p>Мы как раз хотим вынести WordPress Jobs на отдельный домен, доработать его, сделать удобный поиск, интеграцию с биржами типа HH.ru и попытаться давать гарантии как это делают фриланс-биржи, добавить возможность менторинга, обучения, но нужно найти заинтересованных спонсоров и участников проекта, а с этим пока не густо.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Порталы по поиску работы рекомендуют делать отдельные резюме точно подходящие под названия вакансий и писать сопроводительное письмо индивидуально каждому работодателю, это весьма трудоемко и поиск работы может растянуться на месяца. Существует другой подход, аналогичный «воронке продаж»&nbsp; — откликнуться на 1000 вакансий и рассчитывать, что после прохождения 30 собеседований получишь 2-3 предложения о работе. Из-за этого HR специалисты тонут под грудами резюме и подходящие кандидаты, не указавшие в своем резюме все нужные ключевые слова теряются в этом потоке. Есть ли выход из сложившийся практики?</em></strong></p>\n\n\n\n<p>Оба подхода имеют место быть, в каждом из них есть свои плюсы и минусы.</p>\n\n\n\n<p>Первый подход со стороны соискателя позволяет более точечно подстраиваться под вакансии с определенным набором ключевых слов, но на создание такого количества резюме нужно очень много времени и велик шанс ошибиться лишь в одном месте, наплодив ошибку повсеместно, что может негативно сказаться на вас в дальнейшем. Рекрутерам и компаниям здесь проще в поиске соискателя, но не всем нравится копаться в груде одинаковых резюме, где отличается пара абзацев или список скиллов. С их точки зрения это похоже на переспам и плюсов вам особо не добавит. Это больше моё личное мнение и доверять ему на 100% не нужно.</p>\n\n\n\n<p>Второй подход я считаю более надежным и проверенным годами, сам им часто пользуюсь. Соискателю достаточно создать резюме на любой площадке или в своём блоге или на GitHub и откликнуться хоть на 100500 вакансий и вы с уверенностью в 99% получите пару-тройку офферов. HR, конечно, закопаются в огромном количестве откликов, но такая у них работа.</p>\n\n\n\n<p>Тут самое главное найти золотую середину в обоих подходах и составить детализированное резюме. Постараться указать развернуто должность, на которую вы претендуете, все свои hard и soft skills, опыт работы в хронологическом порядке, занимаемую должность, выполняемые обязанности и ваши достижения в каждой из компаний, где вы когда-либо работали.</p>\n\n\n\n<p>Высшее образование в текущих реалиях не является обязательным условием приема на работу, но указать его желательно. Многие компании до сих пор требуют наличие диплома о высшем образовании для отчетности, не более того.&nbsp;</p>\n\n\n\n<p>Обязательно укажите контакты, по которым с вами можно связаться в реальном времени. Если есть какие-то рекомендательные или сопроводительные письма &#8212; тоже добавьте их к вашему резюме.</p>\n\n\n\n<p>Не стоит указывать ничего лишнего.</p>\n\n\n\n<p>Если вы устраиваетесь не в русскоязычную компанию, то сделайте копию вашего резюме на английском языке.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Для WordPress существует огромное количество плагинов и тем, создать сайт можно в считанные минуты, и многие разработчики специализируются на «сборке» сайтов и у них даже не возникает необходимости «заглядывать под капот». В результате работодатели не знают с каким стеком технологий разработчик им нужен, а кандидаты претендуют на работу, которая им не подходит. Можно ли кардинально изменить ситуацию?</em></strong></p>\n\n\n\n<p>Работодатель по факту и не должен это знать, это больше задача HR или тех людей с техническими навыками, кто у вас будет проводить в итоге собеседования. К сожалению, уровень знаний HR сейчас тоже оставляет желать лучшего, и очень часто годные специалисты не проходят их отсев, но тут только самим проводить интервью.</p>\n\n\n\n<p>Ну и стоит справедливо заметить, что существует огромное количество проектов, где технические навыки для соискателя вообще не нужны. Нет необходимости знать PHP, JavaScript, HTML, SQL, чтобы поставить пачку плагинов, потыкать пару кнопок в админке и запустить сайт для проверки какой-то гипотезы или прощупывания ниши. Мы таких специалистов в своём сообществе называем «Модератор админки».</p>\n\n\n\n<p>А есть очень сложные, запутанные проекты с кучей логики, микросервисов и высокой нагрузкой, где без технических знаний ты и дня не продержишься.</p>\n\n\n\n<p>Поэтому вакансии должен создавать не руководитель и не менеджер проекта, а технически подкованный специалист, ваш будущий коллега, который на пальцах может расписать в резюме, что же вас ждет на будущей работе.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Опытные разработчики часто находятся в латентном поиске, то есть сидят и ждут, когда работодатель придет и предложит. Это работает? Что делать работодателю, которому нужен специалист на сложный высоконагруженный проект? Есть ли они вообще такие?</em></strong></p>\n\n\n\n<p>Я сам постоянно нахожусь в латентном поиске и жду «работу мечты», где мне будет интересно и за это будут соответствующе платить. Это работает, работало и будет работать. И таких специалистов в режиме ожидания достаточно много, обычно они собираются в сообществах в социальных сетях и прекрасно знают друг друга.</p>\n\n\n\n<p>Поэтому, если вам нужно найти реально хорошего профессионала на высоконагруженный проект, то нет ничего лучше, чем «сарафанное радио». Гуру обычно уже где-то работают, но если знакомый коллега предложит что-то более интересное, то, скорее всего, у работодателя появится шанс схантить к себе этого человека. Тут главное внимательно посмотреть соцсети, блоги и GitHub аккаунт, чтобы не попасть на простого «разговорника», которые встречаются в любом сообществе. На словах они гуру, а по факту не далеки от джунов.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Что ты посоветуешь тем, кто хочет начать свою карьеру как WordPress-разработчик? Многие курсы предлагают трудоустройство после обучения. Насколько это реально?</em></strong></p>\n\n\n\n<p>Посоветую только одно — не бояться. WordPress не страшный и не монструозный как его обычно описывают поклонники классического ООП и любители фреймворков типа Symfony и Laravel. У него есть EAV (Entity Attribute Value) вместо ORM и EDA (Event Driven Architecture) вместо MVC. Именно из-за этих отличий у многих разработчиков возникает нелюбовь к WordPress — они не понимают архитектуру и не допускают мысли, что почерпнутые в книгах по ООП подходы не являются единственно правильными. Никто не запрещает использовать ООП, PSR.</p>\n\n\n\n<p>WordPress уже давно не простенькая CMS для создания бложиков. У нее под капотом более <a href=\"https://codex.wordpress.org/WordPress_APIs\">десятка различных API для разработчика</a>, весь код покрыт юнит-тестами, соответствует стандартам WPCS (WordPress Coding Standards для PHP_CodeSniffer), простой интерфейс для создания CRUD постепенно внедряется так любимое многими разработчиками ООП. На этом движке можно построить проект любой сложности, главное делать это с головой (MVC, headless, CMF).</p>\n\n\n\n<p>Не просто так же WordPress <a href=\"https://w3techs.com/technologies/overview/content_management\">уже занял 43%</a> всемирного рынка сайтов в вебе.</p>\n\n\n\n<p>Единственное чего пока лично мне не хватает — это удобного интерфейса для работы с кастомными таблицами и поддержки composer для пакетов. Но мы справляемся при помощи WP_List_Table (базовый класс для создания таблиц со списком чего угодно в WordPress. Таблицы поддерживают технологию AJAX. На базе этого класса выводится все виды таблиц в админ-панели WordPress).</p>\n\n\n\n<p>Трудоустройство после курсов вполне реально и многие компании именно так и поступают — сами себе выращивают специалистов и пытаются их как-то заинтересовать и замотивировать, чтобы готовые к употреблению разработчики не разбежались (подбирают интересные проекты, благодарят финансово).</p>\n\n\n\n<p>Если вы думаете, что на WordPress нельзя заработать более 60.000 рублей в месяц, то вы ошибаетесь, рынок труда просто огромен, количество проектов еще больше и ценником в 300.000 рублей в месяц уже никого не удивишь.</p>\n\n\n\n<p>Читайте книги, гуглите Яндексом и почаще посещайте <a href=\"https://wp-kama.ru/\">ВП-Каму</a>. Подписывайтесь на <a href=\"https://t.me/+RArNVwv2tJi2CNFk\">WordPress Digest</a>.</p>\n\n\n\n<p>Дерзайте! Всё будет WordPress!</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Вопросы и работа с изображениями:&nbsp;<a rel=\"noreferrer noopener\" href=\"https://profiles.wordpress.org/oglekler/\" target=\"_blank\">Глеклер Ольга</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2526\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:54:\"\n		\n		\n		\n		\n		\n				\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Большой московский митап #20 — онлайн-трансляция 25 августа 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://ru.wordpress.org/news/2022/08/moscow-meetup-20-online-broadcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Aug 2022 07:48:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ru.wordpress.org/?p=2508\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:752:\"25 августа 2022 в 19:00 стартует онлайн-трансляция Большого московского митапа # 20 и всех, кто не сможет присутствовать лично, приглашаем присоединиться к просмотру на YouTube. Программа митапа Денис Янчевский расскажет про разработку нативных Gutenberg-блоков,&#160; Николай Миронов — про то, как легко и просто создавать Gutenberg-блоки практически без программирования,&#160; Анатолий Куликов — как разработать чат-бота. Это [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olga Gleckler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6592:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://ru.wordpress.org/files/2022/08/moscow-meetup-20.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://ru.wordpress.org/files/2022/08/moscow-meetup-20-1024x576.jpg\" alt=\"\" class=\"wp-image-2515\" srcset=\"https://ru.wordpress.org/files/2022/08/moscow-meetup-20-1024x576.jpg 1024w, https://ru.wordpress.org/files/2022/08/moscow-meetup-20-300x169.jpg 300w, https://ru.wordpress.org/files/2022/08/moscow-meetup-20-768x432.jpg 768w, https://ru.wordpress.org/files/2022/08/moscow-meetup-20.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong>25 августа 2022 в 19:00</strong> стартует онлайн-трансляция Большого московского митапа # 20 и всех, кто не сможет присутствовать лично, приглашаем присоединиться к просмотру на <a href=\"https://www.youtube.com/watch?v=zwOXG6f4ego\">YouTube</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Программа митапа</h2>\n\n\n\n<ul class=\"wp-block-list\"><li><a href=\"https://profiles.wordpress.org/denisco/\">Денис Янчевский</a> расскажет про разработку нативных Gutenberg-блоков,&nbsp;</li><li><a href=\"https://profiles.wordpress.org/solidcreature/\">Николай Миронов</a> — про то, как легко и просто создавать Gutenberg-блоки практически без программирования,&nbsp;</li><li><a href=\"https://profiles.wordpress.org/anatolykulikov/\">Анатолий Куликов</a> — как разработать чат-бота.</li></ul>\n\n\n\n<p>Это далеко не все актуальные WordPress темы, и если вы хотите предложить свою тему или выступить на следующем митапе в Москве, смело обращайтесь к <a href=\"https://t.me/solidcreature\">Николаю Миронову</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Почему стоит присоединиться к онлайн-трансляции</h2>\n\n\n\n<p><em>Вы сможете:</em></p>\n\n\n\n<ul class=\"wp-block-list\"><li>Задать свои вопросы в чат на YouTube по теме выступлений, а также на любые другие связанные с WordPress темы, </li><li>Помочь другим участникам своими ответами,</li><li>Пообщаться с единомышленниками и хорошо провести время.</li></ul>\n\n\n\n<p>Запасайтесь едой и напитками <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<h2 class=\"wp-block-heading\">Почему стоит прийти лично</h2>\n\n\n\n<p>WordPress митап — это дружественная атмосфера, открытое общение и обмен опытом между разработчиками, дизайнерами, интернет-маркетологами, копирайтерами, тестировщиками, SEO-специалистами, владельцами сайтов, блоггерами и многими другими. Самое интересное начинается с момента появления на горизонте пиццы — не стесняйтесь общаться, задавать вопросы, есть и слушать чужие беседы.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://ru.wordpress.org/files/2022/08/WordPress-Meetup-Moscow.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://ru.wordpress.org/files/2022/08/WordPress-Meetup-Moscow-1024x683.jpg\" alt=\"Коллаж из фотографий с московских митапов, на которых участники беседуют\" class=\"wp-image-2510\" srcset=\"https://ru.wordpress.org/files/2022/08/WordPress-Meetup-Moscow-1024x683.jpg 1024w, https://ru.wordpress.org/files/2022/08/WordPress-Meetup-Moscow-300x200.jpg 300w, https://ru.wordpress.org/files/2022/08/WordPress-Meetup-Moscow-768x512.jpg 768w, https://ru.wordpress.org/files/2022/08/WordPress-Meetup-Moscow-1536x1024.jpg 1536w, https://ru.wordpress.org/files/2022/08/WordPress-Meetup-Moscow-2048x1366.jpg 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>А еще митап — это отличная возможность внести свой вклад в развитие сообщества и попробовать себя в новом качестве.</p>\n\n\n\n<p>На мероприятие <strong>требуется фотограф-волонтер</strong> — хорошая возможность получить удовольствие от процесса, потренироваться и поэкспериментировать.</p>\n\n\n\n<p>А также мы <strong>ищем модератора онлайн-трансляции</strong> — следить за сигналом и задавать вопросы спикерам из YouTube-чата. </p>\n\n\n\n<p>Если вы готовы помочь — обращайтесь к <a href=\"https://t.me/solidcreature\">Николаю Миронову</a>, а для всех остальных участников — <a href=\"https://www.meetup.com/ru-RU/wordpress-moscow/events/287181506/\">регистрация все еще открыта</a>.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Отложите свои планы на вечер четверга, приходите или присоединяйтесь к трансляции — держите руку на пульсе WordPress новостей и оставайтесь на связи с сообществом в какой бы точке мира вы не находились!</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Ссылка на онлайн-трансляцию: <a href=\"https://www.youtube.com/watch?v=zwOXG6f4ego\">https://www.youtube.com/watch?v=zwOXG6f4ego</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2508\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Люди WordPress: Николай Миронов\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://ru.wordpress.org/news/2022/08/people-of-wordpress-nikolay-mironov/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 22 Aug 2022 19:41:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Люди WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:19:\"people-of-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ru.wordpress.org/?p=2500\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:792:\"Мы продолжаем серию интервью с участниками русского сообщества WordPress, объединяющем русскоговорящих разработчиков, переводчиков, пользователей и владельцев сайтов по всему миру. В преддверии Большого московского митапа #20 мы беседуем с его организатором Николаем Мироновым — разработчиком, спикером, стримером, автором курсов и обучающих видео. — Ты постоянно пробуешь что-то новое и совмещаешь разработку на WordPress с другими [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olga Gleckler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:18093:\"\n<p>Мы продолжаем серию интервью с участниками русского сообщества WordPress, объединяющем русскоговорящих разработчиков, переводчиков, пользователей и владельцев сайтов по всему миру.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://ru.wordpress.org/files/2022/08/people-of-wordpress-Nikolay-Mironov-2.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://ru.wordpress.org/files/2022/08/people-of-wordpress-Nikolay-Mironov-2-1024x683.jpg\" alt=\"\" class=\"wp-image-2505\" srcset=\"https://ru.wordpress.org/files/2022/08/people-of-wordpress-Nikolay-Mironov-2-1024x683.jpg 1024w, https://ru.wordpress.org/files/2022/08/people-of-wordpress-Nikolay-Mironov-2-300x200.jpg 300w, https://ru.wordpress.org/files/2022/08/people-of-wordpress-Nikolay-Mironov-2-768x512.jpg 768w, https://ru.wordpress.org/files/2022/08/people-of-wordpress-Nikolay-Mironov-2-1536x1024.jpg 1536w, https://ru.wordpress.org/files/2022/08/people-of-wordpress-Nikolay-Mironov-2-2048x1365.jpg 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>В преддверии Большого московского митапа #20 мы беседуем с его организатором <a href=\"https://profiles.wordpress.org/solidcreature/\">Николаем Мироновым</a> — разработчиком, спикером, стримером, автором курсов и обучающих видео.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Ты постоянно пробуешь что-то новое и совмещаешь разработку на WordPress с другими личными проектами и активным участием в жизни сообщества уже более десяти лет. Как это все сочетается, откуда идеи, энергия? Над чем сейчас работаешь и что в планах?</em></strong></p>\n\n\n\n<p>Тут две принципиальных составляющих. Первое, я кайфую от процесса, неважно записываю ли ролики, организую ли митап или программирую — все это топливо, которое позволяет мне двигаться дальше. Второе — те вещи, которые приносят деньги, позволяют и содержать семью и поддерживать баланс между работой и творчеством.</p>\n\n\n\n<p>Основное направление деятельности за последние полгода — это развитие видеостудии. Несмотря на то, что youtube-каналу WordPrеss Moscow уже несколько лет, профессиональная запись видео — совершенно новая для меня область. Пока прокачиваю техническую составляющую. Надеюсь это заметно по качеству роликов, которые выходят на канале.</p>\n\n\n\n<p>Из планов до конца года — развивать youtube-канал, социальные сети, искать спонсоров, предлагать новые форматы встреч: картинг, боулинг, пейнтбол, игра в мафию, чередуя их с классическими митапами.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Пока глобальное сообщество только планирует возобновление физических митапов, мы же их уже во всю проводим. В чем идея предстоящего митапа и есть ли планы на следующие?</em></strong></p>\n\n\n\n<p>Да, пандемия сильно подкосила живые встречи, к концу 19-го года мы вышли на стабильные 50+ участников. А первые живые встречи в этом году собирали по 10-15 человек, желающих выступить было мало и приходилось экспериментировать с форматами. Например, были игры в настолки, или в одну из встреч мы сели небольшим кружочком и проговорили о WordPress 2,5 часа. Просто накидывая темы, задавая вопросы, рассказывая кейсах и делясь опытом. Глобальной идеи у предстоящего митапа нет, но есть амбиции. Надеюсь, 20-й митап станет серьезным шагом в развитии WordPress-сообщества в Москве.<br><br></p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"Приглашение на большой московский митап WordPress-разработчиков  №20\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/4LICB-mES3k?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div><figcaption class=\"wp-element-caption\">Приглашение на большой московский митап WordPress-разработчиков №20</figcaption></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Ты стоял у истоков организации WordPress митапов в Москве и этот митап должен иметь номер #65. Почему нумерация сбилась и что еще изменилось за это время?</em></strong></p>\n\n\n\n<p>Ну не совсем так, в 13-м году я впервые попал на митап, который устраивал Константин Ковшенин. Это был взрыв мозга: интересные люди, классные темы, возможность задать вопросы или рассказать что-нибудь самому. Костя заряжал своей энергетикой и мотивировал. Я посещал каждый митап, и где-то на 4 встрече выступил с докладом про сайты-портфолио. Доклад получился классным и Костя пригласил выступить на WordCamp Russia 2013, первом WordCamp’е в России. Так прошло 6 лет, выступал с докладами на митапах и был спикером на каждом WordCamp’е в Москве. Так сказать, активный участник сообщества, но в организации почти не участвовал. Летом 2017 года прошел последний митап и наступило затишье.</p>\n\n\n\n<p>Эстафету продолжил <a href=\"https://ru.wordpress.org/news/2022/07/people-of-wordpress-denis-yanchevskiy/\">Денис Янчевский</a>, он организовал официальную группу WordPress Krasnogorsk, а через несколько встреч, митапы перебрались в Москву и на meetup.com появился <a href=\"https://www.meetup.com/ru-RU/wordpress-moscow/\">WordPress Moscow</a>. Так как WordPress Moscow получилось производной от WordPress Krasnogorsk, а не предыдущих 45 митапов, то и нумерацию мы начали с 1. Где-то на третьей встрече я предложил свою помощь и стал участвовать в организации митапов. На тот момент у меня не было глобальных целей, мне нравилось тусовка и хотелось внести свой вклад в подготовку мероприятий. До начала пандемии мы делили организаторские обязанности 50/50. Во время пандемии было вынужденное затишье с редкими онлайн-встречами, ну и в «новом сезоне» я уже организую митапы самостоятельно.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Что дает участие в митапах для слушателей, спикеров и волонтеров? Как получить максимум пользы от посещения</em></strong>?</p>\n\n\n\n<p>Каждый может найти в митапах полезное для себя. Для новичков это возможность задать вопросы, получить помощь, на живых примерах увидеть направления и пути развития. Для опытных разработчиков — найти единомышленников, партнеров, подрядчиков или новые заказы. Для спикеров — возможность «материализовать» свои знания и умения, проверить их актуальность, получить статус эксперта, заработать «социальные очки», плюс митап — хорошая площадка для тренировки ораторских навыков, здесь лояльная аудитория и нет завышенных требований как на больших конференциях.</p>\n\n\n\n<p>Организация большого мероприятия затратный процесс, требующий много сил, внимания, времени. Это ответственность. Но когда все получается, когда участники уходят заряженные, когда каждый получил пользу — приходит умиротворение, чувство наполненности, понимание, что ты на своем месте и делаешь свое дело. Для волонтеров это возможность разделить эти чувства, быть причастными к большому событию.</p>\n\n\n\n<p>Чтобы получит пользу от митапа для начала нужно решить а для чего ты туда идешь. Хочешь найти подрядчиков или новый проект — распечатай визитки, чтобы проще налаживать коммуникацию. Заинтересовала конкретная тема доклада — узнай побольше о спикере, подготовь вопросы, конспектируй во время выступления. Есть затык в проекте, нужна помощь или совет, перерывы между докладами — лучшее время. Обычно участники делятся на небольшие группы и что-то обсуждают, ищи схожую тему, задавай вопросы, будь коммуникабелен. В идеале, приди с ноутбуком, сделай так, чтобы суть проблемы можно было быстро увидеть, получить доступ к коду и настройкам сайта. Так шанс получить помощь оперативно намного выше.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Что делать тем, кто хочет выступить и какие темы актуальны для митапов?</em></strong></p>\n\n\n\n<p>Двери для спикеров всегда открыты. Для начала разговора напишите мне в <a href=\"https://t.me/solidcreature\">телеграм</a>. У меня ровно один критерий к докладам — тема должна быть интересна аудитории сообщества.</p>\n\n\n\n<p>Если человек выступает в первый раз, то предварительно проводим тестовый онлайн-прогон доклада. Это помогает исправить мелкие ошибки, правильно расставить акценты, потренировать подачу материала.</p>\n\n\n\n<p>Очень часто люди недооценивают свои знания и опыт. Тысячу раз я слышал «ну что я буду рассказывать, это и так все знают». Зачастую достаточно 2-3 интересных кейса или нестандартная предметная область, чтобы подготовить хороший доклад.</p>\n\n\n\n<p>Иногда люди активно сопротивляются и не хотят выступать на публике. Так для 19-го митапа мне пришлось включить всю свою харизму, и силу убеждения, чтобы у митапа появились докладчики. <br><br></p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordPress, немного о SEO, Как превратить сайт в приложение под iOS и Android — WP Mocow #19\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/8zgPyP2Zwzc?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Интересна ли спонсорам поддержка митапов и что сообщество WordPress может им предложить?</em></strong></p>\n\n\n\n<p>У нас вполне понятная и состоявшаяся аудитория, это молодые люди 25-35 лет, с опытом разработки от 3-х лет и более. Наиболее интересными мы можем оказаться хостинг-компаниям, онлайн-школам, компаниям, которым нужны опытные wordpress-разработчики. Помимо живых мероприятий, где количество участников ограничено, у меня в планах активная прокачка youtube-канала и социальных сетей.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Можем ли мы рассчитывать на проведение WordCamp в ближайшем будущем? И чем принципиально отличается конференция он митапа?</em></strong></p>\n\n\n\n<p>У меня уже была попытка стать организатором WordCamp’а в 2020-м году, но выбранная дата 30-го мая оказалась неудачной — мы попали на самый пик ковидных ограничений в Москве.</p>\n\n\n\n<p>Конференция это намного больший масштаб, больший уровень ответственности и совсем другие временные затраты. Да, планы на WordCamp 2020 были грандиозными, но сейчас юношеский задор пропал и в ближайшие полгода–год ничего подобного не планирую.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong><em>— Что делать тем, кто не может посещать митапы, как оставаться в курсе новостей и поддерживать связь с сообществом?</em></strong></p>\n\n\n\n<p>В этот раз попробуем организовать онлайн-трансляцию, посмотрим на сколько это получится технически. А чтобы не пропустить ссылку на трансляцию — советую вступить в <a href=\"https://vk.com/wordpressmoscow\">нашу группу VK</a> и <a href=\"https://t.me/wpmeetup\">ламповый телеграм-чат</a>. Ну и подписаться на <a href=\"https://www.youtube.com/c/WordPressMoscow\">youtube-канал</a>, конечно же.</p>\n\n\n\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Вопросы и работа с изображениями: <a rel=\"noreferrer noopener\" href=\"https://profiles.wordpress.org/oglekler/\" target=\"_blank\">Глеклер Ольга</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2500\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://ru.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096041\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 22 Nov 2024 09:21:59 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 13 Nov 2024 19:41:25 GMT\";s:4:\"link\";s:61:\"<https://ru.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1732310519;s:23:\"__cache_expiration_time\";i:1732310519;}","off");
INSERT INTO wp_options VALUES("146","_transient_timeout_feed_mod_92227bfe1354c9fe21266d111aae5ed4","1732310519","off");
INSERT INTO wp_options VALUES("147","_transient_feed_mod_92227bfe1354c9fe21266d111aae5ed4","1732267319","off");
INSERT INTO wp_options VALUES("148","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1732310520","off");
INSERT INTO wp_options VALUES("149","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: Welcoming Harper\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=130466\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://ma.tt/2024/11/welcoming-harper/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1155:\"<p>As <a href=\"https://automattic.com/2024/11/21/automattic-welcomes-harper-and-elijah-potter/\">announced by Automattic</a> and <a href=\"https://techcrunch.com/2024/11/21/wordpress-com-owner-automattic-snaps-up-grammar-checker-harper/\">covered by TechCrunch</a>, I want to take a moment to welcome <a href=\"https://elijahpotter.dev/\">Elijah Potter</a> and <a href=\"https://writewithharper.com/\">Harper</a> to join Automattic. Harper is a super-fast (way faster than LanguageTool and Grammarly), local English grammar checker. The technology is nascent, but I&#8217;m very excited to embed this throughout all of Automattic&#8217;s products, and then expanding it to other languages, all in an open source way that can be embedded everywhere. I&#8217;m a huge fan of Grammarly and use it every day, but I think we&#8217;re doing too much in the cloud right now and there is so much compute and potential at the edge, and I&#8217;m excited to drive that forward with projects like <a href=\"https://writewithharper.com/\">Harper</a>, <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, and <a href=\"https://wordpress.org/playground/\">Playground</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Nov 2024 21:27:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: PeepSo Leaves WordPress Plugin Repository\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=180255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wptavern.com/peepso-leaves-wordpress-plugin-repository\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3825:\"<p>Matt Jaworski, Co-Founder of PeepSo.com, has <a href=\"https://www.peepso.com/peepso-is-leaving-the-wordpress-org-repository/\">announced</a> that  PeepSo is leaving the WordPress plugin repository. Moving forward, all updates for the plugin will be served directly from PeepSo’s servers. Explaining the decision, Jaworski expressed dissatisfaction with the repository, stating, “We have never been very happy with the WordPress repository, as we found their rules to be convoluted, poorly defined and too open for interpretation – that includes both the Plugin Guidelines and the way the support and review forums are moderated by them.”</p>\n\n\n\n<h3 class=\"wp-block-heading\">Key Reasons Behind the Decision</h3>\n\n\n\n<p>He shared that several factors contributed to this move like learning recently that WordPress.org is not owned by the WordPress Foundation, as many assume, but is instead a private website managed by Matt Mullenweg. This, combined with unsettling actions by WordPress.org, such as banning developers, disabling plugin updates for client sites, and even taking over an entire plugin, led to a loss of trust. He noted, <em>“</em>We have thus lost our trust in the WordPress.org platform, the WordPress Foundation itself, and most importantly the man who seems to wield the ultimate power in the entire ecosystem.”</p>\n\n\n\n<p>PeepSo was also suspended without a warning for issues that were already fixed. He explained,“There were a few cases where security researchers pentested our demo site, and found some minor issues. WP.org jumped on these and suspended our plugin, even though the issues were in our paid addons, or even third party software &#8211; NOT in the plugin hosted on WP.org. They have since apologized, but the issue of having our plugin suspended without warning stands &#8211; it affects our release cycle and our customers.”</p>\n\n\n\n<a href=\"https://www.peepso.com/community/?status/156601-156601-1727260854\"><img width=\"1756\" height=\"1800\" src=\"https://wptavern.com/wp-content/uploads/2024/11/image-2.png\" alt=\"\" class=\"wp-image-180266\" /></a>\n\n\n\n<p>“All that combined with the WPEngine drama led us to the decision to finally pull out of WordPress.org &#8211; WP.org hijacking a plugin from under the original devs was the final straw. That was the day we decided too pull the trigger and focused on removing the WP.org dependency from our business.”, he continued.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Moving Forward</h3>\n\n\n\n<p>Existing users of PeepSo will need to manually update the base plugin to version 7.0.0.0, after which all updates will be delivered directly from PeepSo’s servers. </p>\n\n\n\n<p>Jaworski also hinted at potential changes to improve code organization and performance. “The Plugin Guidelines prevented us from putting premium code in the base plugin (paywalled) so we were forced to encapsulate paid features into separate plugins. There is an idea bouncing around of merging some premium code into the base plugin, and only enabling it based on the license type (free vs paid). This should lead to better code organization and performance improvements, but it&#8217;s just a general idea, likely not to be touched any time soon.”, he said.</p>\n\n\n\n<p>After the ACF controversy, several plugin authors <a href=\"https://wptavern.com/developers-remove-plugins-from-wordpress-org-repository-after-acf-controversy\">removed their plugins</a> from the WordPress.org repository. Luc Princen, an eCommerce developer at Wooping,&nbsp; also <a href=\"https://x.com/LucP/status/1858476808481456368\">shared</a> on X that they weren&#8217;t going to put WPWooping&#8217;s new Shop Health plugin on the Repository and also published a <a href=\"https://wooping.io/blog/2024/11/why-were-not-releasing-on-wp-org-yet/\">blog post </a>detailing the reasons.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Nov 2024 18:33:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: AI, DevOps, and Accessibility in WooCommerce with Anick Akbar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87009\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://dothewoo.io/ai-devops-and-accessibility-in-woocommerce-with-anick-akbar/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:218:\"In this episode of Do the Woo, Anick from Pixable chats about his agency\'s journey with WordPress and WooCommerce, innovative client solutions, AI trends, compliance challenges, accessibility, and community engagement.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Nov 2024 17:40:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WordPress.org blog: WordPress 6.7.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18096\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2024/11/wordpress-6-7-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8607:\"<h2 class=\"wp-block-heading\">WordPress 6.7.1 is now available!</h2>\n\n\n\n<p>This minor release features 16 bug fixes <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&milestone=6.7.1&group=component&col=id&col=summary&col=milestone&col=owner&col=type&col=status&col=priority&order=priority\">throughout Core</a> and <a href=\"https://github.com/WordPress/wordpress-develop/pull/7851\">the Block Editor</a>.</p>\n\n\n\n<p>WordPress 6.7.1 is a fast-follow release with a strict focus on bugs introduced in WordPress 6.7. The next major release will be <a href=\"https://make.wordpress.org/core/6-8/\">version 6.8</a>, <a href=\"https://make.wordpress.org/core/2024/11/19/proposal-major-releases-for-2025/\">planned for April 2025</a>.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.7.1.zip\">download WordPress 6.7.1 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-7-1\">visit the HelpHub site</a>. You can find a summary of the maintenance updates in this release in the <a href=\"https://make.wordpress.org/core/?p=116365\">Release Candidate announcement</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p class=\"is-style-default\">This release was led by <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> and <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>.</p>\n\n\n\n<p class=\"is-style-default\">WordPress 6.7.1 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/abcsun/\">abcsun</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a>, <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a>, <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a>, <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a>, <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a>, <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/dhewercorus/\">dhewercorus</a>, <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a>, <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a>, <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a>, <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/glynnquelch/\">glynnquelch</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a>, <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a>, <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a>, <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/leecollings/\">Lee Collings</a>, <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a>, <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a>, <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a>, <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a>, <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a>, <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/369work/\">miroku</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/ramonopoly/\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a>, <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a>, <a href=\"https://profiles.wordpress.org/room34/\">room34</a>, <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a>, <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a>, <a href=\"https://profiles.wordpress.org/sailpete/\">sailpete</a>, <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a>, <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a>, <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a>, <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a>, <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a>, <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a>, <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a>, <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a>, <a href=\"https://profiles.wordpress.org/yowangdu/\">YoWangdu</a>, <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a>, and <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\">#6-8-release-leads</a> channels. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thanks to <a href=\"https://profiles.wordpress.org/marybaum/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>marybaum</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aaroncampbell</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>jeffpaul</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>audrasjb</a>, <a href=\"https://profiles.wordpress.org/cbravobernal/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbravobernal</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ankit-k-gupta</a> for proofreading.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Nov 2024 14:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Jonathan Desrosiers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: #146 – Fränk Klein on Redesigning WordPress: The Shift to Block-Based Systems\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=180076\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/podcast/146-frank-klein-on-redesigning-wordpress-the-shift-to-block-based-systems\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58605:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast, which is dedicated to all things, WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, the shift to block by systems in all parts of WordPress.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast, player of choice. Or by going to wptavern.com/feed/podcast. And you can copy that URL into most podcasts players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Fränk Klein. Fränk is a principal engineer at Human Made and brings a wealth of experience from his extensive history with WordPress, having started with the platform in 2011. He previously worked at Automattic, and now directs his expertise towards WP Development Courses, where he teaches block theme and custom block development.</p>\n\n\n\n<p>Fränk talks about the modernization of PHP within WordPress, a topic that often gets overshadowed by the hype around Javascript. We get into Human Made&#8217;s work and enterprise focused WordPress agency renowned for serving high profile clients, such as the Harvard Gazette and TechCrunch. Fränk explains the intricate custom backend development needed to meet the complex requirements of enterprise clients, like sophisticated editorial workflows for clients like banks.</p>\n\n\n\n<p>Fränk provides a comprehensive breakdown of the Gutenberg projects four phases, content editing, site customization, collaborative editing, and multi-lingual capabilities. We explore how FSE is transforming WordPress by integrating new editing tools, and modernizing the admin interface. Moving the platform from its classic roots to a more dynamic block-based editing environment.</p>\n\n\n\n<p>Fränk shares his unique perspectives on the challenges and rewards of engineering and teaching within the WordPress ecosystem. He stresses the importance of understanding client needs and the necessity for developers to engage in continuous learning.</p>\n\n\n\n<p>We also talk about using traditional WordPress solutions and third party page builders, like Bricks, Beaver Builder and Elementor. Fränk argues for the streamlined, block-based systems, offered by WordPress core, citing both financial and technical benefits.</p>\n\n\n\n<p>Our conversation continues into the broader implications of WordPress&#8217;s ongoing evolution, the significant admin interface redesigns, and its impact on users and agencies. Fränk discusses, the challenges users face with these changes, and the importance of improving communications within the WordPress community to facilitate smoother transitions.</p>\n\n\n\n<p>Towards the end, Fränk talks about his experiences with course creation and content maintenance, particularly given the fast paced changes in WordPress features. He emphasizes the need for a solid grasp of foundational web development concepts to fully leverage the platforms evolving tools.</p>\n\n\n\n<p>If you&#8217;re keen on understanding how full site editing and other WordPress innovations can enhance your projects, and wish to gain insights into the evolving WordPress landscape, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes, many added by Fränk, by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Fränk Klein.</p>\n\n\n\n<p>I am joined on the podcast today by Fränk Klein. How are you doing Fränk?</p>\n\n\n\n<p>[00:04:10] <strong>Fränk Klein:</strong> I&#8217;m doing great. Thank you for having me.</p>\n\n\n\n<p>[00:04:12] <strong>Nathan Wrigley:</strong> Really nice to have you on the podcast today. We&#8217;re going to talk a lot about full site editing. I&#8217;m not entirely sure where the conversation is going to go. But before we do that, Fränk, just over to you really for a brief moment on your bio. Just tell us about your history with WordPress, perhaps where you work, maybe some interesting projects that you&#8217;ve worked on. Anything you like really, but just tell us a little bit about you and WordPress.</p>\n\n\n\n<p>[00:04:35] <strong>Fränk Klein:</strong> Yeah, so I started in WordPress in 2011, software engineer. I worked at a small agency in Luxembourg, and then from then I went to Automattic, wordpress.com, then VIP. And now I&#8217;m at Human Made, where I&#8217;m now principal engineer, which is great. I get to work on a lot of interesting projects.</p>\n\n\n\n<p>And kind of out of that activity comes my WP Development Courses business. So where I do sell courses to WordPress developers. So obviously block theme development is one of the focuses of that.</p>\n\n\n\n<p>The thing is, because I am self-taught, it kind of simplifies with the people that don&#8217;t have any formal background in programming, and I try to help this out as much as possible.</p>\n\n\n\n<p>[00:05:11] <strong>Nathan Wrigley:</strong> For your courses, do you focus entirely on blocks, and full site editing, and the new, in air quotes, way of doing WordPress? Is that your thing, Gutenberg a hundred percent?</p>\n\n\n\n<p>[00:05:22] <strong>Fränk Klein:</strong> It used to be that, but now, so there is one on block theme development, there&#8217;s one on custom block development. But now I&#8217;m also going back to a course that I previously, which is about WordPress unit testing, so PHP unit testing.</p>\n\n\n\n<p>So the title I like to use right now is more modern PHP, so what&#8217;s happening in the PHP world. Because I think that we have been moving a lot, we have been talking a lot about JavaScript and everything like that, but that has kind of slowed down.</p>\n\n\n\n<p>But the PHP has picked up quite a lot, because PHP is modernising quite rapidly in terms of how the language works. And PHP is still a big part of WordPress, even though it doesn&#8217;t get maybe the love that we need to give it to. But yeah, there&#8217;s lots of interesting things happening there.</p>\n\n\n\n<p>[00:05:59] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s certainly not getting the attention that it once did. In fact, almost to the point where it never gets mentioned really. But like you said, quite a lot of exciting developments.</p>\n\n\n\n<p>Again, just very, very briefly, the Human Made side of things, if you haven&#8217;t come across Human Made, Human Made are a, I&#8217;m going to call it enterprise agency. Do you just want to give us some insight into the kind of work that you and the team do over there? What kind of projects you&#8217;re involved in.</p>\n\n\n\n<p>You may or may not be able to elucidate on that, but just interested to know at that kind of level, what kind of projects you might be involved in.</p>\n\n\n\n<p>[00:06:29] <strong>Fränk Klein:</strong> Yes, Human Made, we call it an enterprise WordPress agency. Now, enterprise can be a very wide word, what fits in there? But Human Made works with everything from publishing companies, to banks, to universities. One of the more recent projects that my colleagues in the US did was the Harvard Gazette, a really great project also block based.</p>\n\n\n\n<p>Then we have worked in the past with TechCrunch, the million dollar website as Jamie called it. So that was the previous iteration.</p>\n\n\n\n<p>And so generally, when it comes to enterprise, what distinguishes it from the rest of WordPress is maybe not, so the budget definitely is, because the budgets tend to be higher, but enterprises, they have very specific needs. So there&#8217;s a lot of custom development, and they have a lot of demand, especially for backend customisations.</p>\n\n\n\n<p>So when you build a website, there&#8217;s always going to be the front end, the design, everything like that. But that&#8217;s the same across every project. But when you go to the enterprise, depending on the type of business that you run, for example, a bank, what we have developed is a system where instead of just when you hit publish, the blog post goes live, or the content. There is a system where it goes to approval, and then they can say that the change isn&#8217;t approved. So all of those publishing customisations there&#8217;s a little part of it. It&#8217;s the workflow and also the interface. So that&#8217;s a big part of what we do is actually customising the editing experience in WordPress.</p>\n\n\n\n<p>[00:07:52] <strong>Nathan Wrigley:</strong> Really interesting. You can go and check those websites out. Just by the way, anything that we mention in the podcast today, you can get the show notes over at wptavern.com/podcast. Go and search over there, and anything that we mention, if we don&#8217;t read out the URL, you&#8217;ll be able to find it, including links to Human Made, and Fränk&#8217;s courses as well.</p>\n\n\n\n<p>But turning to the main focus of the podcast today, we&#8217;re going to try and get into the weeds of FSE, full site editing.</p>\n\n\n\n<p>Now, if you are fairly new to WordPress, you may be unfamiliar that there was ever any change. But if you&#8217;ve been in WordPress for anything longer than a couple of years, you&#8217;ll know that what has changed over the last several years has been pretty profound.</p>\n\n\n\n<p>It&#8217;s kind of all wrapped up inside the Gutenberg project, if you like, which has come in four phases. We&#8217;re currently on the third of those four phases, collaborative editing. I have to say, the collaborative editing piece seems to have stopped becoming the center of all attention at the moment. I haven&#8217;t seen a great deal of coverage of that, but hopefully that will pick up and we&#8217;ll get something akin to Google Docs, or something like that inside our WordPress installs.</p>\n\n\n\n<p>But the first of those phases, content editing, was followed by site customisation and then, like I said, we&#8217;re in collaborative editing at the moment. And then finally ending up with multilingual, so the ability to natively turn your site into a multilingual website.</p>\n\n\n\n<p>Where does full site editing fit into all of this jigsaw puzzle, Fränk? And also what promise does it bring? How will it change a WordPress install from a couple of years ago to something in the more, air quotes, modern WordPress?</p>\n\n\n\n<p>[00:09:25] <strong>Fränk Klein:</strong> That&#8217;s a big question, but it goes back to when we talk about full site editing. So what we now say is full site editing, essentially site editor. That is what we call the tool that is in the admin.</p>\n\n\n\n<p>And then the other part of it is the block theme. And those together then form what we now call full site editing. And that is the second phase actually of the Gutenberg roadmap.</p>\n\n\n\n<p>And the thing is, at this moment, if you go to WordPress install at this time, and you click on the admin, it looks like it has always looked, right? The admin hasn&#8217;t changed, but when you go to the post editor, you get the block editor. When you go to the appearance, so let&#8217;s go to the theme editor, what comes up is the site editor.</p>\n\n\n\n<p>And so right now we having these weird experiences where you click on the post edit and it becomes full screen, and the admin UI is gone, inside it is kind of the same. And so we need to understand those four phases, not as being four different things that are going to be delivered, but really it&#8217;s just pieces of one big admin redesign.</p>\n\n\n\n<p>So there&#8217;s, I think, what was in the beginning. And so Matt, Matt Mullenweg published a blog post, I think it was in 2017. I think we called it Gutenberg For a Reason, that was the title. And it really laid out everything that they want to change, all of the people that this concerns, which is everybody that uses WordPress.</p>\n\n\n\n<p>And once that kind of groundwork was laid, they didn&#8217;t go into it much afterwards. So that is why, when we talk about full site editing, we have these two pieces. What it changes right now, and just the specific concerns that we have with it. But also the groundwork that is laid for the phase three, which is right now is called still collaboration, but I think it&#8217;s more content editing reimagined.</p>\n\n\n\n<p>Because right now, if you&#8217;re on the site editor, sure, you have functionalities like, I can change my templates, I can change the header, the footer, or the patterns, all that is built in. But you also now have, for example, pages available in the site editor, and you can go into content editing mode, you can go into template editing mode. So already we are mixing everything together.</p>\n\n\n\n<p>And so that is the part where, when we go to phase two, the original name was customisation. So it wasn&#8217;t theme building, it wasn&#8217;t theme adaptation, it was really customisation because the idea was that, with a site editor, we&#8217;re going to reimagine the way that you interact with your WordPress website. And so the phases two and three are just going extend on that admin concept.</p>\n\n\n\n<p>And so WordPress under the hood, as part of this, is building out all of the pieces that are going to be put in place to complete admin redesign. Then actually, if you look at WooCommerce, which is of course one of the biggest, if not, I think the biggest plugin out there in WordPress, they&#8217;re are doing the same thing while they are modernising their admin experience. They&#8217;re both aligning to give that new interface feel to WordPress.</p>\n\n\n\n<p>And I think that&#8217;s something which is not a lot talked about in the wider community, that for sure we have the theme building, we have that very practical aspects, but it&#8217;s also the bigger perspective in that we are going to need to get rid of that admin that we know right now, which has been by now as old as WordPress, close to being as old as WordPress. So it&#8217;s a complete redoing of the experience.</p>\n\n\n\n<p>[00:12:27] <strong>Nathan Wrigley:</strong> Coming from an agency which is dealing with big ticket items, you know, websites that presumably have some sort of fairly large user base, and certainly I would imagine fairly deep pockets for their development, bespoke development at that. But also having a set of courses which are trying to teach aspects of all this, how do you think the whole phases approach has been handled, but particularly the redesign?</p>\n\n\n\n<p>And rather than calling it full site editing, let&#8217;s call it what I think you called it, something along the lines of the admin redesign, or something like that. How do you think that&#8217;s gone?</p>\n\n\n\n<p>And what my question really is asking is, if you could rewind the clock, let&#8217;s say four years, to a period in which the admin had not been redesigned in any way, shape, or form, you could create content with the block editor inside posts, and pages, and so on, but outside of that, everything was as it was.</p>\n\n\n\n<p>How do you feel that it&#8217;s been managed, the transition slowly over time into this reimagined admin area, full site editing and what have you?</p>\n\n\n\n<p>My impression, because I&#8217;m in it all the time, and I see the tiny little changes, and I notice it happening, it doesn&#8217;t really jar with me all that much, but I have the intuition that people who are, I don&#8217;t know, casual users of WordPress, perhaps they&#8217;re just logging into achieve a thing on their Monday morning that they need to do on the website, and then they want to log out and never look at the website again for the rest of the week.</p>\n\n\n\n<p>I feel it must have been quite a difficult thing to keep track of. New things this week, which are removed next week, and then another thing replaces it, and then, oh, if I click here, oh look, now it looks nothing like it did five minutes ago and for the last 20 years. So how well do you think it&#8217;s been handled? How easy has it been for people to cope with? I know that&#8217;s a lot.</p>\n\n\n\n<p>[00:14:09] <strong>Fränk Klein:</strong> Yeah, I think that we can always look back and say, I would&#8217;ve done this and that in the other, knowing in hindsight. That&#8217;s always the luxury that we have. But, it kind of depends on how you want to develop your product. And I think that WordPress, what we shouldn&#8217;t forget is that a lot of people now look at WordPress and say, well, a lot is changing and some things are unstable.</p>\n\n\n\n<p>But actually if we go back in time, it kind of always has been like that. It&#8217;s just that most people do not see the changes that were done because they are just dealing with the admin, they&#8217;re doing content editing stuff which was very stable.</p>\n\n\n\n<p>But I remember when the customiser was introduced. I mean, it wasn&#8217;t like this was the smoothest launch ever. And so I still remember because then I was, I think I was already at Automattic, or maybe not. But the situation was that every theme had their custom admin pages with a bunch of fields, they had their own frameworks. Everybody was sad, everybody was happy. And so then WordPress comes and says, oh, we are now going to do customiser. Huge drama, nobody wants to change it.</p>\n\n\n\n<p>And then years later everybody uses a customiser, and now the next thing comes along, it&#8217;s like, oh, now we&#8217;re going to use the site editor. Huge drama. So it&#8217;s just a repeating cycle. But where it is difficult is, yeah, just these changes being introduced. The patterns, for example, it started out with having reusable blocks. I think that was the first feature that there was. So saving a block into the database, you can add it to other pages. And then if you change one instance, everything updates, great.</p>\n\n\n\n<p>And then comes a pattern, which is more a theme developer thing back then, because you could only do it in themes previously. So you have these two concepts, and then suddenly they say, well, this is kind of the same thing because what we want to do now is you should be able to change the patterns also in the editor. So why don&#8217;t we just merge the two because they are similar.</p>\n\n\n\n<p>So those get merged in and then that&#8217;s, I think it was at 6.2, or 6.3. Then it&#8217;s me standing there, hey, in 6.2 we used reusable blocks, but now it&#8217;s called a pattern, now it works this way. So obviously there&#8217;ve been a lot of changes and I don&#8217;t think that&#8217;s going to stop because they&#8217;re just trying things and getting feedback.</p>\n\n\n\n<p>But generally it&#8217;s also the case that if you look at your clients in the agency world, they&#8217;re using very few features actually of the whole thing. So what we see as developers, all of the changes, for them it doesn&#8217;t really matter to be honest, in most cases, doesn&#8217;t matter. If you tell them, hey, what used to be a reusable block now is a pattern, they&#8217;re going to say, okay, yeah, I get it.</p>\n\n\n\n<p>Yeah, it&#8217;s kind of hard how this thing has been rolled out. But definitely what I do criticise is that we all remember the famous learn JavaScript deeply speech, and it was good advice, but also bad advice. The advice was good because the direction was, everybody&#8217;s using JavaScript, so we as WordPress are also going to go more into JavaScript because they need it to build those interactive experiences. But learn JavaScript deeply is not a great path to follow.</p>\n\n\n\n<p>And so if you talk to me and tell me I&#8217;m in this situation, I will need to learn this, I&#8217;m going to say, you do this, you that, you do the other, right? It&#8217;s a roadmap, and you can just follow it and it&#8217;ll work out fine.</p>\n\n\n\n<p>So in the beginning there wasn&#8217;t really a lot of direction, what you should learn, how you should learn it. And also all of the things that we have now, where we have a dedicated developer blog, where we have people like Jamie, there is Justin, there is Nick Diego, there&#8217;s Rich. So all these people that we know like, in quotes. There are two community outreach, developer outreach, things like that, wasn&#8217;t there.</p>\n\n\n\n<p>So I think if you would have that right from the beginning, all these people, it would&#8217;ve been a lot smoother because you still need somebody to, it&#8217;s one thing to have a change log that says, WordPress is now adding this feature, but that is not of the what.</p>\n\n\n\n<p>And so then they also show the how, but you are not understanding the why. And so the why is the big piece where we need somebody that comes in and says, okay, we have this feature, it works this way. But you can use it in this fashion, in that fashion. And so that kind of basic layer of just the big why things are there, I think that is missing just in the free content that is out there.</p>\n\n\n\n<p>[00:18:05] <strong>Nathan Wrigley:</strong> I&#8217;ve got a couple of things to add to that. So the first thing is I think the customiser bit that you said, was similar in magnitude, you know, and confusion. I guess the thing about the customiser is at least there was just one single purpose for being there. If you went into the customiser, it was basically to change the way things looked. Colors, or padding, or the number of posts in an archive, or whatever it may be.</p>\n\n\n\n<p>You were looking at the way the front end looked in the customiser, and you could understand that. I guess the difference here with the admin overhaul, again, there&#8217;s no perfect word for it, but that&#8217;ll do, is that it encapsulates so many things, and that it&#8217;s a completely rolling program. So, it&#8217;ll be this one week, and then a few weeks later it&#8217;ll be something slightly different.</p>\n\n\n\n<p>And like you said, the naming of things gets changed. And then you get things like synced patterns and all of that, that we just have to rename things over time. But in the end, it&#8217;ll settle.</p>\n\n\n\n<p>And I also think that there is definitely more boots on the ground. The appointment of Jamie Marsland, you&#8217;ve said Jamie&#8217;s name a couple of times, I&#8217;m assuming that you mean Jamie Marsland, being put out as a, not really the developer advocate, but when things have been developed, his task now is to corral people himself and other people in the community to put out content to show how that works.</p>\n\n\n\n<p>I think that was a real missing piece. And then you&#8217;ve obviously got learn.wordpress.org, developer.wordpress.org, and all of these different resources. And I think more work is going in right now than ever has before on the education piece afterwards. Whether or not people are seeing them, I don&#8217;t know. But it definitely seems like there is more effort going into explain how things are done, almost at the same time that they&#8217;re getting released, if you know what I mean. So content on YouTube within weeks of a new feature dropping, that&#8217;s new to me, and it&#8217;s really helpful when I see those.</p>\n\n\n\n<p>[00:19:53] <strong>Fränk Klein:</strong> Right. I think the problem that WordPress has is that you have so many different profiles, and it&#8217;s hard to do content which fits everybody because there is the user aspect. So that is more on the WordPress Learn side. So that&#8217;s more end user, I would call it.</p>\n\n\n\n<p>Jamie is also, I guess, in that space, and then you have the developer blog is very much more developer stuff. But one of the challenges is when we look at what I teach, so I do teach the features for sure, but it&#8217;s all down to a specific angle. And so the challenge that we have, I think in WordPress, and that we need to recognise is that when I learned WordPress, I didn&#8217;t just open WordPress and then started typing stuff. I knew that it used PHP. So I first learned PHP, I was actually quite decent in PHP before I got to the WordPress, which is lucky for me.</p>\n\n\n\n<p>But the thing is that, yes, there is a lot of content that is being released, but it&#8217;s all very piecemeal. And so the challenge is that you need to take a step back, that&#8217;s how I organise my learning materials, that we need to understand the big picture, the concepts that are there, and then once you understand those, then you&#8217;re going to be able to understand all of the rest.</p>\n\n\n\n<p>Because it&#8217;s the same thing when you go from, for example, so I knew PHP, that is the language that I definitely learned from books and everything like that. And then JavaScript, I knew somewhat, I mean, jQuery really, let&#8217;s be honest. But then when I had to learn it for real, my knowledge of PHP helped me a lot because I understood all of the concepts.</p>\n\n\n\n<p>For me, it&#8217;s not just code. I know what a variable is, what the function is, how it works, what scope is. All of these more foundational stuff that you learn when you have a computer sciences background, or something like that, formal education, you&#8217;ll learn it. But when you&#8217;re self-taught you&#8217;ll not necessarily learn that.</p>\n\n\n\n<p>And so that is something missing because, for example, Jamie has those speed builds, right? And I find them cool, they&#8217;re a cool demo. And we kind of had this little disagreement of where I said, the speed build is cool, but it&#8217;s that, it&#8217;s cool. You don&#8217;t really build websites for clients this way, where you go in and choose just will nilly change stuff.</p>\n\n\n\n<p>You need to really go into the design and say, okay, what are the font, the sizes, the colors, the spacings. So really create that design system, then you enter that. And once you have that foundation, where all of those design system values are created, then you start building out the designs. And then we&#8217;ll see that most of the stuff that you drop in, it already looks like it should look. It has the right font, it has the right size.</p>\n\n\n\n<p>And so it&#8217;s more, because when you write CSS it&#8217;s the same thing. You don&#8217;t just look at the red button and make a red button class. No, you have a certain color system, you have a certain foundational values for the HTML tag. So everything that way that you would build out your CSS in layers, that go from the least specific to the most specific, with full site editing is quite the same.</p>\n\n\n\n<p>And so the challenge that we have as a developer community is to realise that with the tooling is changing, and we are now building things visually, but all of the, let&#8217;s say the tech part underneath it, it&#8217;s still the same. It&#8217;s HTML, it&#8217;s CSS, it&#8217;s PHP, right? So that&#8217;s what the front end runs on. And we just need to take those concepts and apply them in the site editor. And then the transition is going to be a lot easier.</p>\n\n\n\n<p>But definitely some developers have a problem with, instead of just saying, I want to write code, I&#8217;ve decided that you&#8217;re not really writing a lot of code, and that is unfortunately or fortunately where the direction is going. That depends on how you&#8217;re looking at it.</p>\n\n\n\n<p>But I think with the whole perspective that we need to have on this is that you may look at the site editor and say, it&#8217;s weird that it tries to do this page builder like approach with content editing built in. Because a lot of developers say, I want it to distinguish from each other.</p>\n\n\n\n<p>But it&#8217;s more that the people that now start building websites with any of the tools that are out there, that is the experience that they get, it&#8217;s a visual builder. And so in the same way as, my daughter is six years old, she doesn&#8217;t know what the landline phone is. She saw one at my grandparents and she says, what&#8217;s that? Well, that&#8217;s a phone.</p>\n\n\n\n<p>And so, yeah, for them, the children that grow up now, obviously everything is a smartphone, everything has a touch interface. They don&#8217;t know what we knew with actual buttons, and blackberries, and all that stuff. And so that&#8217;s the perspective that we need to take. There was a very interesting podcast with Josh Hall, who has a podcast, and Mark Szymanski I think, I hope I&#8217;m not butchering his name. I think the title was even, is WordPress for old people?</p>\n\n\n\n<p>And so, yeah, I mean, I&#8217;m 40. I&#8217;m not really old, but I&#8217;m not spring chicken. And that&#8217;s a perspective that we need to have. We are in the middle of this transition and we know the old, and the new, and for us, while we&#8217;re in the middle of that transition, it&#8217;s going to be hard.</p>\n\n\n\n<p>But every day there are new people coming onto the web, and WordPress needs to be the thing that they expect, needs to be a visual builder. And they don&#8217;t know about the customiser/ they for sure don&#8217;t know about settings, pages that we used in the past. For them it&#8217;s all, it&#8217;s as much history as a landline phone. And so that&#8217;s a perspective which we need to have when we look at this project.</p>\n\n\n\n<p>[00:24:39] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting, when you play with SaaS products, when they want to radically change their UI UX, they&#8217;ll typically be some sort of upgrade path. There&#8217;ll be a button in the UI saying, do you want to try out the new interface? And you click the button, and there you go, and you have a period of time.</p>\n\n\n\n<p>But typically, the companies presumably dog fooded at that UI UX and figured out, okay, this is the end result, this is basically what we want to offer, and we&#8217;re at the point now where we just want a little bit of guidance, where we&#8217;ve gone wrong on a few minor points. And then some people opt into it, and stay with it, other people say, actually, do you know what? I&#8217;m just going to stay with the old interface for a little while.</p>\n\n\n\n<p>We&#8217;ve got that kind of in WordPress, you know, if you use a block-based theme then those options become available, but if you use a, in air quotes, classic theme, you&#8217;re still with how it always was. But I do think that we&#8217;re presented with a different problem in that it&#8217;s so very different, and so in a state of flux. And there&#8217;s so much that has changed, and so much that will change. I feel it&#8217;s quite, I&#8217;m going to use the word discombobulating. It&#8217;s just tricky to make the decision to flip over.</p>\n\n\n\n<p>And when I frequent, I don&#8217;t know, things like social networks, X, or Facebook groups and what have you, there&#8217;s also this whole other thing of third party page builders, where people have just opted and sort of said, look, I don&#8217;t want anything to do with any of that, I want to just go with Bricks, or Beaver Builder, or Elementor, and I&#8217;m just going to handle it all that way, which makes it even more difficult to coalesce on what&#8217;s the correct path.</p>\n\n\n\n<p>So we&#8217;re definitely living in interesting times. Like you said, we&#8217;re in the middle of it at the moment. I&#8217;m kind of hoping that at some point it settles down, and we get some sort of muscle memory on where everything is, and how everything works, and that it stabilises and nothing much changes. And I feel we&#8217;re getting there at the moment.</p>\n\n\n\n<p>But it sounds from everything that you&#8217;ve said that you are putting all of your bets on full site editing, block-based everything, as opposed to, well, any other way of doing it. Classic themes, or third party page builders, or what have you.</p>\n\n\n\n<p>Why are you so bullish? Why do you think that this is the correct path? Why will WordPress and it&#8217;s core offerings succeed, do you think?</p>\n\n\n\n<p>[00:26:45] <strong>Fränk Klein:</strong> I think we already had that lined last time we saw each other, I&#8217;m fully in on that. So I built a production website at Human Made with the block editor that was still in Gutenberg. So we launched a couple of months, I think two or three before it officially was merging WordPress 5.0. And that was just because block-based editors were a thing before WordPress introduced it.</p>\n\n\n\n<p>Notion, for example, which is very popular, it&#8217;s a block editor. And I was very aware of the limitations of the classic editor. Yeah, so for me it made total sense, just from the content editing perspective. And this is where it&#8217;s kind of hard to distinguish when you don&#8217;t know what to choose, and you see two people posting on X, or on Facebook, and one says, oh yeah, this is great, editors love it. Another person says, no, they hate it.</p>\n\n\n\n<p>So I can say that very comfortably that editors love it, because I work with a lot of big publishing brands. They have a lot of people that write content, and they all love the block editor.</p>\n\n\n\n<p>So the other person maybe has talked to one person once that didn&#8217;t like it, and now that&#8217;s opinion. So that&#8217;s the hard part, is that when you listen to somebody&#8217;s opinion, you should look at, okay, what are they doing? What is their background? Why do they have that opinion? And that goes in both ways.</p>\n\n\n\n<p>When you are a user of a specific page builder, you need to look at, okay, what is this person doing? Why do they like this? But the problem that we have in WordPress is that if you Google on YouTube how to build a website, or how to build the WordPress website, there&#8217;s going to be a gazillion videos that use some kind of third party solution. And that is just influencers that want to make money through affiliates.</p>\n\n\n\n<p>And so that is, I think, changing because when we look at the economic incentives for you to build using Core WordPress, it&#8217;s zero, it&#8217;s free. I can just take it, it&#8217;s all there for me, versus having a product that I recommend, and again, 30% of whatever the price is. That skews the debate a little bit unfortunately.</p>\n\n\n\n<p>Because when you, for example, let&#8217;s say you don&#8217;t know how to build a website at all. You Google it, you find a video that explains to you, oh, we use this product here, this product like that. You think that this is what WordPress is.</p>\n\n\n\n<p>And so when we talk about page builders, for me it&#8217;s always, you do what you do, and if it works for you, then I&#8217;m fine with it, right? I have my position on it, but if you have a different position, that&#8217;s great. But it&#8217;s different than, if you built your website using this page builder and it&#8217;s your own website, then you took the decision and you own it fully. When you are an agency and you build a website for a client using a specific product, and then this client wants to move off of the page builder, and they come to a different agency. Then you say, oh, I have this website, I have this man, this content, how do I get it off whatever thing?</p>\n\n\n\n<p>And then you&#8217;re saying, yeah, we can do some automated migration, but really you have to rebuild a lot, and then you are totally falling out of the sky. It&#8217;s like, why, it&#8217;s WordPress? Why can&#8217;t you just take WordPress and put a new theme on it, and then it&#8217;s going to be great?</p>\n\n\n\n<p>And then we get into, well, you need to understand that, yada yada. So it&#8217;s going to be a lot of technical mumbo jumbo, they have zero interest in it. And unfortunately it&#8217;s also going to be very pricey. If you have a lot of content to take from some kind of solution, which doesn&#8217;t store the content in the format that is native that WordPress can understand, it&#8217;s going to be a lot of hard work to get it right.</p>\n\n\n\n<p>So there is the data liberation project, which is going to help with that hopefully. But it&#8217;s also the case that certain page builders, just due to the way that they are built, it&#8217;s very hard to make sense of it. You have page builders that give you a total freedom that you build, so it&#8217;s essentially just blobs of HTML and so, how do you make sense of blobs of HTML? It&#8217;s very hard.</p>\n\n\n\n<p>So the whole deal with blocks is, what is not understood is, that theme building in WordPress was fine, it was a solved problem. But the problem was that WordPress has zero clue what you have in your templates. Some PHP, some HTML, some JavaScript, and you cannot go through that in a programmatic way and say, this is the title, this is the content.</p>\n\n\n\n<p>So what blocks give you is that every block is self-contained, and you know exactly what it is. This is a title, this is a paragraph, this is a header block. And so to have that freedom of customising your designs, you need to give structure to it. And so blocks solve that problem that we now can break up a design to different pieces, and customise them individually.</p>\n\n\n\n<p>But also it solves the long standing problem of who wins out. Because it&#8217;s like this, you build a website, you take a theme, you take a plugin. Put your stuff on the page using a short code back in the day, and it looks like nothing, right? And then the plugin says, oh, it&#8217;s the theme&#8217;s fault, and the theme says, no, it&#8217;s the plugin&#8217;s fault. And you&#8217;re just, okay, let&#8217;s just forget about it.</p>\n\n\n\n<p>And then when you are a developer, you can fix it. But when you&#8217;re not a developer, it&#8217;s terribly frustrating because maybe you bought the theme, and maybe you bought a plugin, and everybody&#8217;s just saying it&#8217;s the other person&#8217;s fault. And that&#8217;s just not the great situation.</p>\n\n\n\n<p>And so if it is a block, it can integrate into this existing design system. Hopefully it gives you a few options to customize stuff. But generally, if you drop a block into Twenty Twenty Two, and then Twenty Twenty Five, and the block is quite unopinionated, it&#8217;s going to look somewhat like the theme. It&#8217;s never going to be close, especially if you have very complicated blocks like the obvious slider, you know, people love sliders, so that&#8217;s more difficult to handle.</p>\n\n\n\n<p>But there are a lot of very basic blocks, like in an LMS, a course list, course title, that kind of stuff, where we can have a lot of compatibility with themes just out of the box. And you always need to understand the problems of the past to understand the solutions to take right now. And WordPress still is, even with block themes, can be very hard to use, right?</p>\n\n\n\n<p>Because this doesn&#8217;t work with this, this doesn&#8217;t work with that. So we need to really simplify and agree on the common set of interfaces, a common set of programming interfaces, a common set of just ways that we build things, and blocks help with that.</p>\n\n\n\n<p>But the difficulty in that is that WordPress, for a long time, the philosophy was more, there&#8217;s zero in it, right? So if you install WordPress 4.9, there&#8217;s nothing in it. And WordPress was just, hey, I&#8217;m going to give you these programming interfaces, and then you do whatever you want.</p>\n\n\n\n<p>So the customiser was like that. So you take the customiser and then you build your controls that you want. But then you have the problem that different themes have different controls. When you switch themes, it breaks.</p>\n\n\n\n<p>And so now WordPress is taking the exact opposite way, where it&#8217;s saying, no, we are going to agree on this set of tools. It&#8217;s going to be handled this way. It&#8217;s very opinionated. And more than the technical issues, it&#8217;s just this opinionated version of how the WordPress admin should look that is causing problems.</p>\n\n\n\n<p>And the thing is with the SaaS, when you subscribe to some platform and you do change the interface, well, you like it or you don&#8217;t like it, it&#8217;s not our problem. If you don&#8217;t like it, then leave. That&#8217;s essentially their solution to solving that problem, because when they change interfaces, their bet is that more people going to like it than people are going to dislike it, so they&#8217;re going to be fine. But still the opinion is that, hey, if you don&#8217;t like it then leave, we don&#8217;t care.</p>\n\n\n\n<p>And so we in WordPress have the problem that we do want people to stay around for a long time. We need to give people those tools where they don&#8217;t need third party tools to do very basic things. And it&#8217;s the same for WordPress, also same for WooCommerce, right? It&#8217;s both having a lot of other platforms competing with them. And we need to give people the tools that they need to really have a site that stays around for a very long time.</p>\n\n\n\n<p>[00:33:55] <strong>Nathan Wrigley:</strong> I guess there&#8217;s a few problems, isn&#8217;t there? Firstly that the SaaS platforms have complete control over the architecture of all the things. So they know everything that&#8217;s going on with every one of their clients. Whereas WordPress, who knows what&#8217;s going on with any one of the millions of websites? What the dependencies are, what hosting it&#8217;s on, what range of plugins it&#8217;s got going on in there. So it has to be much more slowly, slowly, gently. Just try to make sure that everything is backwards compatible.</p>\n\n\n\n<p>But also when you kind of muddle up the way a site looks with the content, so the design and the content is put into the same interface, there&#8217;s potential for everything to go wrong there as well.</p>\n\n\n\n<p>Certainly at the moment, I really do like the endeavors of locking things within blocks, so that the designers, if they&#8217;ve got the technical capacity to get in there and figure out how to lock different aspects, they can hand over, kind of like boilerplate templates for pages if you like, drop things in. You can change the text here, but you can&#8217;t change the background. The colors are fixed, but the font, that&#8217;s okay, you can change that. All of that seems to be adding to a much more complete solution as well.</p>\n\n\n\n<p>Whereas in the more recent past, if you hand over something to a client, they&#8217;ve basically been able to destroy everything just by clicking around in the interface. Whereas now, hopefully in the near future, more of those locking things will be possible so that, like I said, you can make it so that they can&#8217;t change this thing, or the other thing as well.</p>\n\n\n\n<p>[00:35:14] <strong>Fränk Klein:</strong> Right. I think we can talk a lot about the tech, and the tech is important, but the tech is just that. And the technology never comes first. It&#8217;s always the demand for the technology that precedes it.</p>\n\n\n\n<p>And when we look at the agency world, you kind of have the two extremes. On the one hand, you have agencies that say, I&#8217;m going to build your website, if you need to change anything, call me, send me an email, and we&#8217;re going to change it for you.</p>\n\n\n\n<p>And that&#8217;s certainly a model that works up to a certain point, because if you do request a lot of changes on the website, then it becomes pricey from a certain point. But what we now see in the larger companies is that from a certain point on, the marketing&#8217;s not going to be done by an agency, the market is going to be done in house. And those people in the marketing world, they are used to things like HubSpot Pages, all these tools that are out there to ClickFunnels for example, and they take that for granted.</p>\n\n\n\n<p>And they might even not know WordPress depending on where they&#8217;ve been, or what the age is even. And so they come into WordPress and then they say, I want to build this landing page for this campaign, and then their boss says, yeah, I&#8217;m going to call up our agency and then say, yeah, give me a design. Then we&#8217;re going to hand code it, it&#8217;s going to take us a week. Then I say, okay, no, it&#8217;s not going to take a week for me there to build a campaign because I need to build a lot of landing pages.</p>\n\n\n\n<p>And so that is the thing that&#8217;s changed that with marketers taking a liking to WordPress, and also being more involved with that, we need to give them the tools that they need. So the challenge that WordPress has is that it needs to correspond to that really use case where you have people that know how to use this tool, that want to build landing pages, want nearly complete control over the website, and that don&#8217;t want to pay an agency to do it, and they want to be fast and quick.</p>\n\n\n\n<p>And then the, I guess, path in the middle where you have maybe end users, or people that are updating the website like a restaurant, classic scenario, do you need to update their menu of the week? Where we need to offer them an interface that is easy to understand, but locked down so that they can go in and, on Monday this is the menu of the day, so that they can change those few things quite easily while keeping the design intact.</p>\n\n\n\n<p>But it&#8217;s also more, you have the tools and WordPress can give you that content locking, that design locking, all of those tools are built in. But the other part is also that every agency needs to kind of customise WordPress a bit. For example, what you can do is, when you log into WP admin, you have the possibility to register a custom widget there. So you register a widget and then you say, hey, change the menu, and it leads you directly to that page where you can edit that.</p>\n\n\n\n<p>So it&#8217;s little things like that end user experience where you can make it a lot simpler. And the challenge is that if you&#8217;re used to WordPress makes total sense because use it every day. But we really need to take a step back and think about the people that don&#8217;t use it every day, and say, okay, what can I customise in here to make this a lot smoother?</p>\n\n\n\n<p>So the challenges right now is, for sure the tech is a challenge, but tech is very solvable, right? I can teach anybody to do anything technically. But that user experience aspect, that&#8217;s really hard to do. Teaching somebody to design effective user interfaces, that&#8217;s a totally different skill to just being technical, and we need to have both at this time.</p>\n\n\n\n<p>[00:38:11] <strong>Nathan Wrigley:</strong> We know that you are very technical, you&#8217;re working for an enterprise agency, and you are teaching this content. So we could have the conversation about what we would hope the project, WordPress itself, would do differently. But remove that, we are where we are.</p>\n\n\n\n<p>But personally, looking back over the last five, six years of what you have done, have you gone down any blind alleys? Have you made any missteps that you think with hindsight, oh, I would&#8217;ve done that differently?</p>\n\n\n\n<p>I don&#8217;t know, with your courses, just released content which then got completely upended by something that Core did. Or perhaps, I don&#8217;t know, advocate for something that was a blind alley and never got taken on. So it&#8217;s more a question of not what Core did, but what you did, and how that worked out.</p>\n\n\n\n<p>[00:38:53] <strong>Fränk Klein:</strong> Yeah, so there&#8217;s two angles to it. So for the course it&#8217;s definitely. So I thought, well, this is a feature I like it. Full Site Editing is really great, because I published it in 2021. That was when they started work in just the plugin for a while. That wasn&#8217;t the plugin, so obviously it changed a lot. Then it landed in Core, and then we had a theme.</p>\n\n\n\n<p>So I did a release for 5.8, which was just the underlying APIs without the site editor. That was on theme json version one, okay. So great. 5.9 hits, a V2 comes out, which as somebody who&#8217;s using it, the difference is zero. But as somebody who shows it, I cannot have a video where it says at the top, oh, this is V1, right? So I need to re record that.</p>\n\n\n\n<p>And then now we are on V3. So yeah, I had to redo the course. I mean there have been three complete redos, and then every time that the new release comes out, pretty much have replaced between 20 to 40% of the lessons. And it&#8217;s not interface updates, but it&#8217;s more, now it&#8217;s not reusable blocks, now it&#8217;s patterns, sync patterns, partially synced patterns. Block bindings, now there&#8217;s a UI.</p>\n\n\n\n<p>So that&#8217;s just the technical part, but the other part is more that you can use it for this, you can use it for that. It&#8217;s all of those tricks that I find out, I put in there. So really it&#8217;s more like a recipe. For example, when the content only editing comes in, then it&#8217;s when I go, this is what it does, and this is what I would recommend that to use.</p>\n\n\n\n<p>So yeah, courses are not passive income by any means. But it has given me a lot in terms of just interacting with the people, seeing what they&#8217;re doing. I&#8217;ve learned a lot just from the people that I talk to. Because it&#8217;s not that I come up with this stuff all on my own. For sure, certain things I do my own research, and I know that from all projects, but a lot of stuff just comes from the people that are in the course.</p>\n\n\n\n<p>It&#8217;s more the other part, did I do anything wrong where I would say afterwards, would&#8217;ve done it this way? Sure, but there wasn&#8217;t anything terribly off. But it&#8217;s also my personality is that if you do teach things, obviously you like learning things, because you need to learn something to teach it. Yeah, I just have a high barrier for frustration. But that&#8217;s just me because as a principal engineer, those are the highest paid engineers in the organisation. And so if you want that kind of money, you need to bring something to the table.</p>\n\n\n\n<p>And so stuff is always difficult, whether it&#8217;s Full Site Editing, some kind of architecture stuff. So the whole thing is always just hard. So if that&#8217;s your day to day, it&#8217;s different than to somebody who, for a long time has just been building with the same stuff, and there weren&#8217;t many challenges. And now this is all changing and they&#8217;re like, oh wow, what&#8217;s going on? You know, this is all very difficult.</p>\n\n\n\n<p>But that&#8217;s why there are stuff like course and tutorials, right? Somebody does the hard work for you and just follow along. So that&#8217;s a thing.</p>\n\n\n\n<p>But what would actually, the biggest growth that I&#8217;ve seen is that when we talk about just what we do every day, you have to understand your clients in order to build a solution for them that is great. Because you have two types of developers. One developer just sits there and the client says, do this, and they do it, and that&#8217;s it.</p>\n\n\n\n<p>The other develop is more, the client says, do this, and then they&#8217;re saying like, why do you want this? Should it be this way? Should it be that way? Because a client cannot know as much about workers as you do. So obviously your opinion usually is better than theirs because they don&#8217;t have the technical background.</p>\n\n\n\n<p>But you also need to understand their needs. You need to understand their need without accepting their solution of it. And that&#8217;s really where I&#8217;ve done a lot of learning just also because of my course. You know, I have to do email marketing. How does email marketing work? I have zero clue. Just the tech of it. What do you write? What do people want to read? I have to look at analytics. I have to build sales pages. What goes on the sales page? And so all of that, now I have a lot more respect for marketing people because it&#8217;s a very, very hard job.</p>\n\n\n\n<p>And so that has been the biggest growth for me. Also writers, you know I write a lot. Previously when I did projects back in 2015, I used WordPress, but I didn&#8217;t write. So anything that they say to me was, I use it this way, and I didn&#8217;t have an idea of what they meant, because I wasn&#8217;t creating a lot of content in WordPress. I was just writing code.</p>\n\n\n\n<p>Now that I do create content I understand, okay. This is hard, that is hard. This is difficult. So it&#8217;s more that being closer to your clients and their needs that has allowed me to have that bigger growth. And also the challenge when it comes to building custom blocks, people get hung up, oh, it&#8217;s JavaScript. Yes, but so what? I mean, JavaScript is very learnable. It&#8217;s the most popular language out there. React is super popular. There are literally hundreds of thousands of people that are doing React.</p>\n\n\n\n<p>But the hard part is that, how do I build that block? What should it look like? What is the dialogue? What is the state when I put it in? Should it be in the sidebar? Should it be here? Just a slider. A slider on the front end, everybody knows what it looks like. But how do you represent six slides in the backend? You put them one below the other. Should there be a toggle? Should you be able to drag things? Is it all just one editing mask? Should you be able to move things around?</p>\n\n\n\n<p>So those are really the hard challenges right now, and that you only get when you actually talk to people of how they use WordPress. And I think that&#8217;s perspective is missing unfortunately, a lot in the community.</p>\n\n\n\n<p>[00:43:26] <strong>Nathan Wrigley:</strong> I&#8217;m glad that there are people like you who are giving that plenty of thought so that you can presumably contribute back, and give your opinions on how things should go from the admin side of things.</p>\n\n\n\n<p>Fränk, just before we say thank you and adieu, do you want to just drop a couple of links? Maybe a website where you can be found, or a, I don&#8217;t know, social media handle where people can get in touch with you if they wish to.</p>\n\n\n\n<p>[00:43:48] <strong>Fränk Klein:</strong> Yes. My website is wpdevelopment.courses, quite easy. Then I&#8217;m on X at fklux. So yeah, the rest we&#8217;re going to put into the show notes.</p>\n\n\n\n<p>[00:43:58] <strong>Nathan Wrigley:</strong> Okay, well, I will do that. Go to wptavern.com/podcast and search for the episode with Fränk Klein, and all of the links will be in the show notes there. So Fränk, once more, thank you so much for chatting to me today. I really appreciate it.</p>\n\n\n\n<p>[00:44:13] <strong>Fränk Klein:</strong> Thank you very much.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://x.com/fklux\">Fränk Klein</a>.</p>\n\n\n\n<p>Fränk is a principal engineer at Human Made and brings a wealth of experience from his extensive history with WordPress, having started with the platform in 2011. He previously worked at Automattic and now directs his expertise towards WP Development Courses, where he teaches block theme and custom block development.</p>\n\n\n\n<p>Fränk talks about the modernization of PHP within WordPress, a topic that often gets overshadowed by the hype around JavaScript. We get into Human Made&#8217;s work, an enterprise-focused WordPress agency renowned for serving high-profile clients such as the Harvard Gazette and TechCrunch. Fränk explains the intricate custom backend development needed to meet the complex requirements of enterprise clients, like sophisticated editorial workflows for clients like banks.</p>\n\n\n\n<p>Fränk provides a comprehensive breakdown of the Gutenberg project&#8217;s four phases: content editing, site customization, collaborative editing, and multilingual capabilities. We explore how FSE is transforming WordPress by integrating new editing tools and modernising the admin interface, moving the platform from its classic roots to a more dynamic, block-based editing environment.</p>\n\n\n\n<p>Fränk shares his unique perspective on the challenges and rewards of engineering and teaching within the WordPress ecosystem. He stresses the importance of understanding client needs and the necessity for developers to engage in continuous learning.</p>\n\n\n\n<p>We also talk about using traditional WordPress solutions and third-party page builders like Bricks, Beaver Builder, and Elementor. Fränk argues for the streamlined, block-based systems offered by WordPress Core, citing both financial and technical benefits.</p>\n\n\n\n<p>Our conversation continues into the broader implications of WordPress&#8217;s ongoing evolution; the significant admin interface redesign and its impact on users and agencies. Fränk discusses the challenges users face with these changes and the importance of improving communication within the WordPress community to facilitate smoother transitions.</p>\n\n\n\n<p>Towards the end, Fränk talks about his experiences with course creation and content maintenance, particularly given the fast-paced changes in WordPress features. He emphasises the need for a solid grasp of foundational web development concepts to fully leverage the platform&#8217;s evolving tools.</p>\n\n\n\n<p>If you&#8217;re keen on understanding how full site editing and other WordPress innovations can enhance your projects, and wish to gain insights into the evolving WordPress landscape, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://humanmade.com/\">Human Made</a></p>\n\n\n\n<p><a href=\"https://wpdevelopment.courses/\">WP Development Courses</a></p>\n\n\n\n<p><a href=\"https://news.harvard.edu/gazette/\">Harvard Gazette</a></p>\n\n\n\n<p><a href=\"https://techcrunch.com/\">TechCrunch</a></p>\n\n\n\n<p><a href=\"https://ma.tt/2017/08/we-called-it-gutenberg-for-a-reason/\">We Called it Gutenberg for a Reason</a></p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a></p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/\">Developer Blog</a></p>\n\n\n\n<p><a href=\"https://joshhall.co/349-is-wordpress-for-old-people-with-mark-szymanski/\">Is WordPress for Old People?</a> Podcast with Josh Hall and Mark Szymanski</p>\n\n\n\n<p><a href=\"https://bricksbuilder.io/\">Bricks</a></p>\n\n\n\n<p><a href=\"https://www.wpbeaverbuilder.com/\">Beaver Builder</a></p>\n\n\n\n<p><a href=\"https://elementor.com/\">Elementor</a></p>\n\n\n\n<p><a href=\"https://www.notion.so/\">Notion</a></p>\n\n\n\n<p><a href=\"https://www.hubspot.com/products/marketing/landing-pages\">HubSpot Pages</a></p>\n\n\n\n<p><a href=\"https://www.clickfunnels.com/\">ClickFunnels</a></p>\n\n\n\n<p><a href=\"https://x.com/fklux\">Fränk on X</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Nov 2024 09:45:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: WP Engine Updates Its Original Legal Complaint Against Automattic and Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=180085\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/wp-engine-updates-its-original-legal-complaint-against-automattic-and-matt-mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5395:\"<p>After Automattic launched the <a href=\"https://wordpressenginetracker.com/\">WP Engine Tracker</a> website to monitor the number of websites departing WP Engine hosting, WP Engine updated its ongoing lawsuit against Automattic and its founder, Matt Mullenweg.</p>\n\n\n\n<p>The <a href=\"https://storage.courtlistener.com/recap/gov.uscourts.cand.437474/gov.uscourts.cand.437474.51.0.pdf\">revised document</a> with 144 pages, opens with strong accusations: “This is a case about abuse of power, extortion, and greed. The misconduct at issue is especially troubling because it took place within the WordPress open-source software community, which was built on promises of freedom to build, run, change, and redistribute without barriers or restrictions. Those promises were betrayed by the wrongful actions of a few defendants, to the detriment of the broader community—including WPE.”</p>\n\n\n\n<p>The filing continues: “WPE brings this suit to stop the defendants from further harming WPE, its customer relationships, and the entire WordPress ecosystem, and to hold them accountable for their broken promises and misconduct.”</p>\n\n\n\n<p>The document also raises concerns about trademark misuse, alleging that the defendants Automattic &amp; Matt have used their claimed trademark to violate antitrust laws. WP Engine claims to have used the terms &#8220;WordPress&#8221; and &#8220;WooCommerce&#8221; without issue since 2010 and 2018, respectively, even with Automattic&#8217;s knowledge. In fact, Automattic had invested in WP Engine in 2011 and remained an investor until 2018, and the companies maintained regular communications during that period.</p>\n\n\n\n<p>The filing highlights an acknowledgment from Mullenweg years back when he publicly stated that WP Engine’s use of “WP” in its company name is entirely proper and serves as an example for other companies: “We ask you to not use WordPress in your domain name, which we’ve done for four years now. So, use like WP, like there’s WPEngine, call it WPEngine instead of WordPressEngine.com or something like that.”</p>\n\n\n\n<p>Further, WP Engine argues that Mullenweg&#8217;s statements indicate Automattic’s knowledge of their legitimate use of the WordPress name and suggest that the recent trademark infringement claims are a strategy to harm competitors. The suit suggests that Automattic&#8217;s actions appear to be a deliberate attempt to undermine WP Engine through anticompetitive tactics.</p>\n\n\n\n<p>WP Engine claims these actions are causing severe damage to its business and reputation, including:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Loss of access to WordPress.org functionality.</li>\n\n\n\n<li>Customer attrition due to Automattic&#8217;s actions.</li>\n\n\n\n<li>Costly workarounds as WPE expends significant resources to update plugins and serve customers.</li>\n\n\n\n<li>Loss of key products, including the ACF plugin and its millions of users.</li>\n\n\n\n<li>Reputational harm and loss of goodwill in the WordPress community.</li>\n</ul>\n\n\n\n<p>WP Engine argues that Automattic’s conduct has harmed four key markets relevant to the dispute &#8211; Web content management systems, WordPress web hosting services, WordPress custom field plugins and Distribution of WordPress plugins. </p>\n\n\n\n<p>The lawsuit asserts that Automattic is attempting to raise costs for competitors by forcing WP Engine and others to pay licensing fees for trademarks Automattic claims to control. This, WP Engine argues, constitutes a violation of antitrust laws by attempting to monopolize key sectors of the WordPress ecosystem.</p>\n\n\n\n<p>WP Engine also shared that even their CEO was threatened, and &#8220;Automattic has recently escalated its tactics by actively recruiting hundreds of WPE employees, in an apparent effort to weaken WPE by sowing doubts about the company’s future and enticing WPE’s employees to join Automattic.&#8221;</p>\n\n\n\n<p>The filing invokes multiple legal frameworks, including the <a href=\"https://www.archives.gov/milestone-documents/sherman-anti-trust-act\">Sherman Act</a>, the <a href=\"https://www.law.cornell.edu/wex/lanham_act\">Lanham Act</a>, <a href=\"https://www.classlawgroup.com/antitrust/state-laws/california-cartwright-act\">California Cartwright Act</a>, and the <a href=\"https://en.wikipedia.org/wiki/Computer_Fraud_and_Abuse_Act\">Computer Fraud and Abuse Act</a>.</p>\n\n\n\n<p>Automattic <a href=\"https://x.com/automattic/status/1857080476776767975\">tweeted</a>, &#8220;WordPress isn’t just a software–it’s a movement. This movement, and the community that powers it, are why WordPress now powers over 40% of the web. That’s why Automattic and <a href=\"https://x.com/photomatt\">@photomatt</a> are taking action to protect it from misuse by those who profit without giving back.&#8221; They also published <a href=\"https://automattic.com/2024/protecting-wordpress/\">Defending Open Source: Protecting the Future of&nbsp;WordPress</a>. </p>\n\n\n\n<p>Meanwhile, the Observer <a href=\"https://observer.com/2024/11/wordpress-founder-matt-mullenweg-energized-amid-wp-engine-battle/\">reported</a> that Mullenweg claims the whole saga is a blip within WordPress’s wider mission to defend the democratization of publishing, commerce and messaging. “I’ve been doing this for 21 years and I hope to do it the rest of my life,” he said. “This is a small chapter of a very long journey.”</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 20 Nov 2024 17:21:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: Host James Kemp Takes the Role of Core Product Manager at Woo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=86965\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://dothewoo.io/blog/host-james-kemp-takes-the-role-of-core-product-manager-at-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"The team here at Do the Woo are excited to hear the news that James has been moved up to Core Product Manager for WooCommerce.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 20 Nov 2024 10:12:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"HeroPress: From Attendee to Contributor: My WordPress Journey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=7651\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:172:\"https://heropress.com/essays/from-attendee-to-contributor-my-wordpress-journey/#utm_source=rss&utm_medium=rss&utm_campaign=from-attendee-to-contributor-my-wordpress-journey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5659:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/3024/11/111924.webp\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: After nearly two decades, the WordPress community remains its greatest strength.\" />\nHere is Akshaya reading her own story aloud.\n\n\n\n\n\n<p>Howdy, friends!</p>\n\n\n\n<p>I’m Akshaya Rane, a fellow WordPress enthusiast from the vibrant suburbs of Mumbai, India. You’ll often find me at WordPress meetups, WordCamps, and Do Actions, eagerly soaking in the energy of this incredible community.</p>\n\n\n\n<p>It all began at my first WordCamp Mumbai. The enthusiasm in the air, the insightful sessions, and the shared passion for WordPress left me inspired. At the time, I couldn’t imagine myself on that stage, yet here I am today, sharing my journey with you.</p>\n\n\n\n<h2 class=\"kt-adv-heading7651_9919d8-02 wp-block-kadence-advancedheading\"><strong>Discovering the Joy of Contribution</strong></h2>\n\n\n\n<p>A few years later, WordCamp Mumbai hosted a Contribution Day, and my world opened up. I learned about the many ways to give back—Core, Meta, Photos, Themes, Translations, and more. My first contribution was a ticket in Core, and from there, I never looked back.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Earning a few contribution badges along the way has been an honor, but the real reward has been the learning and the connections made with like-minded people worldwide.</p>\n</blockquote>\n\n\n\n<p>Recently, I had the privilege of serving as a release coordinator for WordPress 6.4 and 6.5. Working alongside such talented individuals from around the globe has been humbling and inspiring. If this sounds daunting, trust me—it wasn’t something I planned for. I simply embraced the opportunities that came my way and poured my time and effort into them.</p>\n\n\n\n<h2 class=\"kt-adv-heading7651_c36762-8e wp-block-kadence-advancedheading\"><strong>Embracing the Speaker’s Stage</strong></h2>\n\n\n\n<p>My speaker journey began with a #WPDiversity workshop led by Jill Binder. She simplified the process of becoming a speaker, guiding us from topic selection to proposal submission. While it took me a few months to act on it, the group’s encouragement kept me going.</p>\n\n\n\n<p>Finally, I submitted my first application to WordCamp Kerala 2023, and to my surprise, I was selected! </p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>It was both exciting and nerve-wracking, but delivering that talk and hearing how others related to my experiences made it all worthwhile.</p>\n</blockquote>\n\n\n\n<p>Since then, I’ve delivered six to seven talks at various WordCamps, including panel discussions. These events have allowed me to explore new places, experience diverse cultures, savor local cuisines, and, most importantly, connect with fellow enthusiasts.</p>\n\n\n\n<a href=\"https://heropress.com/wp-content/uploads/3024/11/akshaya_at_wordcamp.webp\"><img width=\"1024\" height=\"1024\" src=\"https://heropress.com/wp-content/uploads/3024/11/akshaya_at_wordcamp-1024x1024.webp\" alt=\"Akshaya speaking at WordCamp Kerala.\" class=\"wp-image-7654\" /></a>\n\n\n\n<p>If you’re considering stepping onto the WordCamp stage, I’ve documented my speaker journey<a href=\"https://akshayar.online/from-novice-to-wordcamp-speaker-navigating-the-journey/\"> here</a>. I hope it helps you get started!</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-sharing-and-growing-together\"><strong>Sharing and Growing Together</strong></h2>\n\n\n\n<p>As I delved deeper into contributions, I wanted to share the experience with my team. With support from my company, we organized a WordPress Contribution Day, which was a great success. Seeing my teammates engage and grow was incredibly rewarding.</p>\n\n\n\n<p>Being part of the 6.4 and 6.5 release teams taught me the value of empathy, time management, and collaboration. Every small change in WordPress reflects the dedication of contributors ensuring the platform remains reliable for countless businesses worldwide.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-problem-solving-through-wordpress\"><strong>Problem-Solving Through WordPress</strong></h2>\n\n\n\n<p>In my day-to-day role as a Project Manager, I specialize in solving business challenges. One project that stands out involved migrating subscriptions to WooCommerce. With careful planning and execution, we ensured seamless integration, minimizing disruption and protecting the client’s business.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>These experiences remind me why WordPress is a cornerstone for so many businesses—it’s not just a tool; it’s a community-powered solution.</p>\n</blockquote>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-the-heart-of-wordpress-community\"><strong>The Heart of WordPress: Community</strong></h2>\n\n\n\n<p>After nearly two decades, the WordPress community remains its greatest strength. It’s a place where we help each other grow and learn, and I am deeply grateful to be part of it.</p>\n\n\n\n<p>I want to thank Topher for this opportunity to share my story on HeroPress, a platform filled with inspiring journeys. If my story resonates with you, feel free to reach out through my site. Whether it’s learning, connecting, or collaborating, I’d love to hear from you.</p>\n\n\n\n<p>Let’s continue building and thriving together!</p>\n\n\n\n<p></p>\n<p>The post <a href=\"https://heropress.com/essays/from-attendee-to-contributor-my-wordpress-journey/\">From Attendee to Contributor: My WordPress Journey</a> appeared first on <a href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 20 Nov 2024 02:30:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Akshaya Rane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: WordPress 6.7.1 Scheduled for November 21, 2024, to Fix Bugs in WordPress 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=180043\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/wordpress-6-7-1-scheduled-for-november-21-2024-to-fix-bugs-in-wordpress-6-7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2120:\"<p>WordPress 6.7, “<a href=\"https://wptavern.com/wordpress-6-7-rollins-released-with-new-default-theme-wordpress-org-experiences-outage\">Rollins</a>,” was released on November 12, 2024, but WordPress.org experienced increased error rates after the release. Several users reported getting 502 “Bad Gateway” errors and the release <a href=\"https://www.reddit.com/r/Wordpress/comments/1gr0ftk/wordpress_67_update_messed_up_my_websiteam_i_the/?rdt=56607\">messing up their websites</a>. </p>\n\n\n\n<p>WordPress contributors kept a close eye on the complaints and have decided to release<a href=\"https://make.wordpress.org/core/2024/11/19/wordpress-6-7-1-release-schedule/\"> WordPress 6.7.1</a> on November 21, 2024, to address bugs introduced in version 6.7.</p>\n\n\n\n<p>WordPress Core Committer Jonathan Desrosiers emphasized the release&#8217;s targeted approach, “The goal is to deliver a small handful of high-impact bug fixes for added stability prior to the busy online commerce holiday week consisting of Black Friday, Cyber Monday, and Giving Tuesday.”</p>\n\n\n\n<p>Key fixes planned for WordPress 6.7.1 include:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Resolving issues with sizes=auto causing small images.</li>\n\n\n\n<li>Fixing translation errors.</li>\n\n\n\n<li>Addressing problems with uncategorized patterns breaking the editor.</li>\n\n\n\n<li>Correcting zoom-in misalignment issues</li>\n\n\n\n<li>Fixing the missing zoom-out button when plugins add toolbar items.</li>\n</ul>\n\n\n\n<p>Several other bugs are being reviewed and may be included if fixes are ready, including images being unexpectedly converted to HEIC files with temporary names when using the Upload button in Safari, broken category management in the Classic Editor, and changes to CSS targets on the login screen affecting custom logos.</p>\n\n\n\n<p>The fast-follow release will be led by Jonathan Desrosiers and Carlos Bravo. Contributors interested in volunteering are encouraged to comment on the announcement post or join the conversation in the &nbsp;<a href=\"https://wordpress.slack.com/archives/C07BTF54N68\">#6-7-release-squad channel</a> on Slack.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 19 Nov 2024 16:49:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Do The Woo Community: Cutting Credit Card Costs with Konrad Holtkamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=86946\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://dothewoo.io/cutting-credit-card-costs-with-konrad-holtkamp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:181:\"In this episode, Adam and Bob chat with Konrad from FLIZpay about reducing credit card fees in WooCommerce. The conversation covers payment options, costs, and innovative solutions.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 19 Nov 2024 10:49:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Akismet: Version 5.3.5 of the Akismet WordPress plugin is available now\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://akismet.com/?p=284243\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://akismet.com/blog/version-5-3-5-of-the-akismet-wordpress-plugin-is-available-now/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1083:\"<p>Version 5.3.5 of <a href=\"http://wordpress.org/plugins/akismet/\">the Akismet plugin for WordPress</a> is now available for&nbsp;download.</p>\n\n<p>There are a number of bug fixes and improvements and we recommend upgrading if you&#8217;re using an earlier version of the&nbsp;plugin.</p>\n\n<p><strong>This new version of the plugin replaces v5.3.4</strong>, which was briefly available from wordpress.org earlier today. This version contained code that had compatibility issues with versions of PHP earlier than 7.3. If you were affected by errors on installing this version, we&#8217;re very sorry for any difficulties this may have caused. We are adding extra automated testing to prevent this from happening again in the future. These issues are addressed in the current version,&nbsp;v5.3.5.</p>\n\n<p>To upgrade, visit the Updates page of your WordPress dashboard and follow the instructions. If you need to download the plugin zip file directly, links to all versions are available in <a href=\"http://wordpress.org/plugins/akismet/\">the WordPress plugins&nbsp;directory</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 19 Nov 2024 03:07:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Chris Rosser 🏔\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Gravatar: Stand Out in the Digital Crowd: Tips For a Winning Online Profile\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2405\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://blog.gravatar.com/2024/11/18/create-online-profile/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16947:\"<p>Nowadays, first impressions happen online as often (or even <em>more often</em>) than they do in person. That&#8217;s why having a professional digital profile is a must-have. Some people think that being professional equals a nice photo and listing your work experiences neatly on LinkedIn. But there’s so much more to it.</p>\n\n\n\n<p>A good online profile lets you strategically present yourself to align with your career goals and catch the eye of potential employers or clients.</p>\n\n\n\n<p>Thankfully, with the right tools, you can create a consistent, professional presence across thousands of platforms without breaking a sweat. Ready to learn how? Let&#8217;s discover the secrets to crafting an online profile that truly shines.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 1: Implement essential strategies for a winning online profile</strong></h2>\n\n\n\n<p>Creating an online profile that turns heads starts with defining your <a href=\"https://blog.gravatar.com/2024/04/10/personal-branding-tools/\">personal brand</a>. Think about what makes you unique. What skills, experiences, and values set you apart from the crowd? It’s not an easy thing to define, but once you do, everything else becomes much easier.&nbsp;</p>\n\n\n\n<p>Every element of your profile, from your bio to your achievements, should consistently reflect this brand. Here are some strategies to keep in mind:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Be authentic.</strong> Genuinely displaying your experiences and aspirations builds trust. People can spot insincerity from a mile away, so keep it real.</li>\n\n\n\n<li><strong>Use keywords strategically. </strong>Sprinkle industry-specific terms throughout your profile to boost your searchability. But don&#8217;t go overboard – it should still read naturally.</li>\n\n\n\n<li><strong>Craft a compelling narrative.</strong> Instead of a dry list of jobs, tell the story of your career. What challenges have you overcome? What unique value do you bring?</li>\n\n\n\n<li><strong>Optimize for AI-driven recruitment tools.</strong> Many companies use automated systems to screen candidates. Use relevant keywords to increase your chances of making it past these digital gatekeepers.</li>\n\n\n\n<li><strong>Showcase tangible results.</strong> Don&#8217;t just say you&#8217;re great – <em>prove it</em>. Use specific metrics and outcomes to demonstrate your impact.</li>\n\n\n\n<li><strong>Leverage multimedia.</strong> A picture is worth a thousand words, and a video might be worth even more. Consider incorporating presentations or infographics to make your profile more engaging.</li>\n</ul>\n\n\n\n<p>And remember, your profile isn&#8217;t set in stone. Keep it current by regularly updating your information to reflect your latest achievements and skills.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 2: Choose the right platforms for your professional goals</strong></h2>\n\n\n\n<p>While <a href=\"https://www.linkedin.com/\">LinkedIn</a> is often the go-to for professionals, it&#8217;s not the only game in town. The trick here is to find platforms where your industry peers hang out. For developers, <a href=\"https://github.com/\">GitHub</a> is a must. Designers? Check out <a href=\"https://www.behance.net/search/projects\">Behance</a> or <a href=\"https://dribbble.com/\">Dribbble</a>.</p>\n\n\n\n<p>And here&#8217;s a pro tip: it&#8217;s better to have a strong presence on a few platforms than a weak one on many. Quality trumps quantity every time. Focus your efforts on platforms that align with your career objectives.</p>\n\n\n\n<p>Don&#8217;t just set it and forget it, though. Use data-driven tools to track engagement and fine-tune your presence on each platform.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Leverage Gravatar for universal profile syncing</strong></h3>\n\n\n\n<p>Now, let&#8217;s talk about a tool that can make the whole process a lot easier: <a href=\"https://gravatar.com/\">Gravatar</a>.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"343\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-new-homepage-2.png?w=660\" alt=\"Gravatar homepage\" class=\"wp-image-2406\" />\n\n\n\n<p>Gravatar makes profile management easy by acting as a central point for your online identity. The platform connects your profile picture, biography, and professional information – it can be used as a main profile, an online resume, a digital business card, or a <a href=\"https://blog.gravatar.com/2024/07/31/better-links-simple-messaging-developer-tools-and-more/\">link-in-bio tool</a>.&nbsp;</p>\n\n\n\n<p>It has one big advantage – when you update your information once in Gravatar, it syncs with each connected platform, including <a href=\"https://slack.com/\">Slack</a>, <a href=\"https://github.com/\">GitHub</a>, <a href=\"https://wordpress.com/\">WordPress</a>, <a href=\"https://openai.com/\">OpenAI</a>, and more. On top of that, the platform&#8217;s <a href=\"https://blog.gravatar.com/2024/06/05/user-profile-page-examples/\">structured layout and simple design</a> present your skills, experiences, verified profiles, and portfolio in a professional format, making it an effective tool for establishing a unified personal brand.</p>\n\n\n\n<img width=\"660\" height=\"333\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-profile-links-new.png?w=660\" alt=\"Verified links feature of Gravatar profile\" class=\"wp-image-2408\" />\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 3: Select the perfect profile picture and craft an engaging bio</strong></h2>\n\n\n\n<p>Your <a href=\"https://blog.gravatar.com/2024/07/19/wordpress-profile-picture/\">profile picture</a> is often the first thing people see, so make it count. Here&#8217;s how:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Invest in a high-quality, professional headshot. </strong>You don&#8217;t need to break the bank, but a blurry selfie won&#8217;t cut it.</li>\n\n\n\n<li><strong>Dress the part. </strong>Wear something that matches your industry&#8217;s standards. A suit might be perfect for finance, while a more casual look could work for tech.</li>\n\n\n\n<li><strong>Aim for friendly and approachable</strong>. A warm smile can go a long way in making a positive first impression.</li>\n\n\n\n<li><strong>Keep the background simple.</strong> You&#8217;re the star of this show, not your bookshelf or your cat (as adorable as they might be).</li>\n</ul>\n\n\n\n<p>Now, let&#8217;s talk about your bio. It&#8217;s your elevator pitch in written form, and it needs to pack a punch:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Begin with a strong statement that encapsulates your professional value.</strong> Example: &#8220;<em>Enterprise software architect specializing in scalable cloud solutions with 15 years of experience leading distributed teams.</em>&#8220;</li>\n\n\n\n<li><strong>Identify your unique strengths and expertise.</strong> Focus on specific technical abilities, industry knowledge, or specialized experience that differentiates you from others in your field.</li>\n\n\n\n<li><strong>Write in clear, direct language. </strong>Instead of &#8220;<em>Results-driven professional,</em>&#8221; try &#8220;<em>Increased client retention by 40% through implementing automated customer service systems.</em>&#8220;</li>\n\n\n\n<li><strong>Adapt your writing style to your industry&#8217;s expectations.</strong> Software developers might focus on technical achievements, while marketing professionals might highlight creative campaigns and measurable outcomes.</li>\n\n\n\n<li><strong>Structure your bio to address your target audience&#8217;s needs</strong>. For recruiters, emphasize career progression and achievements. For potential clients, focus on problems you&#8217;ve solved and value delivered. For industry peers, highlight your contributions to the field and areas of expertise.</li>\n</ul>\n\n\n\n<p><strong>Pro tip: </strong>Try A/B testing different versions of your bio and profile picture. See which ones get more engagement and refine accordingly.</p>\n\n\n\n<p>And here&#8217;s where Gravatar comes in handy again. Use it as your central hub, then create platform-specific &#8220;satellite&#8221; bios that link back to your comprehensive Gravatar profile. This way, you can tailor your message for each platform while maintaining a consistent core identity.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 4: Showcase skills and achievements effectively</strong></h2>\n\n\n\n<p>Demonstrating your skills and achievements is like showing your professional superpowers. Here&#8217;s how to do it right:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Prioritize relevant skills. </strong>Focus on abilities that align with your current career goals. Not every skill needs to be listed – quality beats quantity.</li>\n\n\n\n<li><strong>Use quantifiable achievements. </strong>Numbers speak louder than words. Did you increase sales by 30%? Mention it.</li>\n\n\n\n<li><strong>Highlight certifications and awards. </strong>These serve as third-party validation of your expertise.</li>\n\n\n\n<li><strong>Share testimonials. </strong>Let others sing your praises. A glowing recommendation from a colleague or client can be incredibly powerful.</li>\n\n\n\n<li><strong>Consider using a skills matrix or visual representation. </strong>This can make it easy to scan your abilities at a glance.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 5: Optimize your profile for recruiters and job searches</strong></h2>\n\n\n\n<p>Optimizing your profile for both human recruiters and applicant tracking systems (ATS) requires strategic planning and precise execution:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Start with targeted industry terminology. </strong>Research job descriptions in your desired roles and incorporate relevant terms naturally throughout your profile. For example, a UX designer might include specific methodologies like &#8220;user research,&#8221; &#8220;wireframing,&#8221; and &#8220;usability testing.&#8221;</li>\n\n\n\n<li><strong>Focus on detailed, measurable accomplishments in each role.</strong> Instead of &#8220;Led marketing campaigns,&#8221; write &#8220;Led 12 marketing campaigns generating $2M in revenue through targeted email and social media strategies.&#8221;</li>\n\n\n\n<li><strong>Boost visibility through strategic content sharing. </strong>Post or share industry analysis, project case studies, or professional insights weekly. This activity signals to recruiters that you&#8217;re actively engaged in your field.</li>\n\n\n\n<li><strong>Review your privacy settings carefully. </strong>Enable profile visibility for recruiters and ensure your contact information is current. LinkedIn&#8217;s &#8220;Open to Work&#8221; feature can be particularly effective when used selectively.</li>\n\n\n\n<li><strong>Track your profile&#8217;s performance using built-in analytics tools.</strong> Monitor profile views and search appearances, then adjust your content strategy based on these metrics.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 6: Build and engage with your network</strong></h2>\n\n\n\n<p>Building a strong professional network requires strategic outreach and meaningful engagement. Here&#8217;s how to maximize your networking effectiveness:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Craft personalized connection requests that demonstrate genuine interest.</strong> Example: &#8220;<em>Your presentation on AI ethics at the Tech Summit was fascinating. I&#8217;d appreciate connecting to discuss your insights on responsible AI development.</em>&#8220;</li>\n\n\n\n<li><strong>Participate actively in professional groups related to your expertise. </strong>Share practical insights, answer technical questions, and initiate discussions about industry trends. Quality contributions establish you as a knowledgeable peer.</li>\n\n\n\n<li><strong>Implement a structured engagement strategy.</strong> Dedicate 15 minutes daily to interact with industry content, focusing on thoughtful comments that add value to the discussion.</li>\n\n\n\n<li><strong>Leverage virtual professional events strategically.</strong> Research speakers and attendees beforehand, prepare relevant questions, and follow up with meaningful connection requests afterward.</li>\n</ul>\n\n\n\n<p>Focus on building mutually beneficial relationships by offering assistance <em>before </em>asking for favors. Your network&#8217;s strength lies in the value exchange between members.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 7: Continuous improvement and profile maintenance</strong></h2>\n\n\n\n<p>Maintaining an effective online presence requires systematic monitoring and regular updates to reflect your professional growth.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Implement a structured review schedule.</strong> Set quarterly calendar reminders to assess your profile&#8217;s relevance and completeness. This means your online presence accurately reflects your current capabilities and achievements.</li>\n\n\n\n<li><strong>Document professional accomplishments as they occur.</strong> Create a dedicated spreadsheet or note system to track new certifications, project outcomes, and quantifiable achievements. This makes profile updates more efficient and comprehensive.</li>\n\n\n\n<li><strong>Use platform analytics effectively. </strong>Monitor key metrics such as profile views, search appearances, and engagement rates. Use this data to identify patterns and optimize your content strategy accordingly.</li>\n\n\n\n<li><strong>Establish a peer review system. </strong>Develop relationships with respected colleagues who can provide specific, actionable feedback on your profile&#8217;s effectiveness and areas for improvement.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Common mistakes to avoid when creating an online profile</strong></h2>\n\n\n\n<p>Certain profile missteps can significantly diminish your professional impact. Here&#8217;s how to avoid these common pitfalls:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Incomplete sections signal a lack of attention to detail.</strong> Fill out each section thoroughly, but purposefully. A partial employment history or missing education details can raise red flags for recruiters.</li>\n\n\n\n<li><strong>Outdated information undermines credibility. </strong>Remove obsolete skills, update employment status promptly, and refresh contact details immediately when they change.</li>\n\n\n\n<li><strong>Unprofessional imagery damages first impressions.</strong> Replace casual photos, low-resolution images, or group pictures with a clear, professional headshot.</li>\n\n\n\n<li><strong>Generic descriptions waste valuable profile space.</strong> Replace overused phrases like &#8220;<em>team player</em>&#8221; or &#8220;<em>results-driven</em>&#8221; with specific examples: &#8220;<em>Led cross-functional team of 8 to deliver $1M project under budget.</em>&#8220;</li>\n\n\n\n<li><strong>Inconsistent information across platforms creates confusion.</strong> Ensure your job titles, dates, and accomplishments align across all professional profiles.</li>\n\n\n\n<li><strong>Neglecting privacy settings can expose sensitive information. </strong>Review and adjust visibility settings regularly, particularly when sharing personal updates or career changes.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Take charge of your online identity with Gravatar today</strong></h2>\n\n\n\n<p>A polished online presence makes a measurable difference in professional advancement and networking opportunities. Each profile update, every connection, and all interactions contribute to your professional story.</p>\n\n\n\n<p>Gravatar offers a sophisticated solution to streamline this process:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Sync your profile across thousands of platforms automatically, from GitHub to Slack and <a href=\"https://stackoverflow.com/\">Stack Overflow</a>.</li>\n\n\n\n<li>Create a customizable profile that functions as your professional hub.</li>\n\n\n\n<li>Integrate social media profiles, portfolios, and website links.</li>\n\n\n\n<li>Control your data sharing with a privacy-first design.</li>\n\n\n\n<li>Personalize your presence with custom domain support – available through WordPress.com domain registration.</li>\n</ul>\n\n\n\n<p>Think of Gravatar as your professional command center. It eliminates the hassle of managing multiple profiles while ensuring your professional identity remains consistent and compelling.</p>\n\n\n\n<p>Ready to make your mark? <a href=\"https://wordpress.com/log-in/link?client_id=1854&redirect_to=https%3A%2F%2Fpublic-api.wordpress.com%2Foauth2%2Fauthorize%3Fclient_id%3D1854%26response_type%3Dcode%26blog_id%3D0%26state%3De703ba11e8d0b0894bbbc4731bddd3a0fd4e1d8aa36b3519f01cf7305f56c738%26redirect_uri%3Dhttps%253A%252F%252Fgravatar.com%252Fconnect%252F%253Faction%253Drequest_access_token%26gravatar_from%3Dsignup%26from-calypso%3D1&gravatar_from=signup\">Create your Gravatar profile now</a> and transform the way you manage your professional presence. Your next opportunity might be just one profile update away.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 18 Nov 2024 22:31:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: Observer Article\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=130235\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://ma.tt/2024/11/observer-article/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:259:\"<p>Alexandra Tremayne-Pengelly writes for the Observer, <a href=\"https://observer.com/2024/11/wordpress-founder-matt-mullenweg-energized-amid-wp-engine-battle/\">WordPress Founder Matt Mullenweg Is ‘More Energized’ Than Ever Amid WP Engine Battle</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 18 Nov 2024 18:56:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Do The Woo Community: A Look at the State of the Woo 2025, Driving the Future\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=86685\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://dothewoo.io/blog/a-look-at-the-state-of-the-woo-2025-driving-the-future/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:180:\"The State of the Woo this year included major innovations, a commitment to open-source, community involvement, and future enhancements aimed at simplifying ecommerce for merchants.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 18 Nov 2024 10:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: Friday Shares: This Week’s Must-Reads and Community Highlights, v4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=86927\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/blog/friday-shares-this-weeks-must-reads-and-community-highlights-v4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Do the Woo\'s curated post of featured content for the week.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 15 Nov 2024 15:17:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"WPTavern: WordPress 6.7 “Rollins” Released With New Default Theme, WordPress.org Experiences Outage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=179550\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://wptavern.com/wordpress-6-7-rollins-released-with-new-default-theme-wordpress-org-experiences-outage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6659:\"<p>WordPress 6.7, code-named “Rollins,” was released on November 12, introducing a new default theme, Twenty Twenty-Five, zoom out view, and new powerful APIs. The <a href=\"https://wordpress.org/news/2024/11/rollins/\">announcement post</a> stated, “Rollins’ bold and exploratory style resonates with WordPress’ own commitment to empowering creators to push boundaries and explore new possibilities in digital expression.”</p>\n\n\n\n<p>The new default theme, <a href=\"https://make.wordpress.org/core/2024/08/15/introducing-twenty-twenty-five/\">Twenty Twenty-Five</a>, “embodies ultimate flexibility and adaptability.” Fully compatible with the Site Editor, it offers multilingual font support, diverse color palettes, and an extensive set of patterns to make site customization easier.</p>\n\n\n\n<p>The new zoom out mode enhances the editing experience, focusing on broader content patterns rather than individual blocks, enabling users to work with content from a higher, less granular perspective.</p>\n\n\n\n<p>WordPress 6.7 also improves media handling, adding HEIC image support, auto-sizing for lazy-loaded images, and more background image support at individual and global levels. The release also has tons of site editor improvements and improved font management with deep styling capabilities.</p>\n\n\n\n<p>Now, the Query Loop block automatically inherits queries from the default template. WordPress 6.7 also stabilized <a href=\"https://developer.wordpress.org/news/2024/11/05/how-to-add-content-only-editing-support-to-a-block/\">content-only editing</a> for blocks.&nbsp;</p>\n\n\n\n<p>Performance has also been boosted with faster pattern loading, optimized previews in the data views component, enhanced PHP 8+ compatibility, removal of deprecated code, auto-sizing for lazy-loaded images, and more efficient tag processing within the HTML API.</p>\n\n\n\n<p>This release has given importance to accessibility, too. “65+ accessibility fixes and enhancements focus on foundational aspects of the WordPress experience, from improving user interface components and keyboard navigation in the Editor, to an accessible heading on WordPress login screens and clearer labeling throughout.”</p>\n\n\n\n<p>Two new APIs—Template Registration API and Preview Options API—debut with this release, alongside enhancements to the Interactivity, Block Bindings, and HTML APIs.</p>\n\n\n\n<p>As the final major release of 2024, WordPress 6.7 reflects the work of more than 780 contributors and includes over 340 updates and fixes. For further insights, check out the <a href=\"https://make.wordpress.org/core/2024/10/23/wordpress-6-7-field-guide/\">Field Guide</a>, <a href=\"https://wordpress.org/documentation/wordpress-version/version-6.7/\">WordPress 6.7 documentation</a>, <a href=\"https://make.wordpress.org/core/tag/dev-notes+6-7/\">Developer Notes</a> or Jamie Marsland’s <a href=\"https://www.youtube.com/watch?v=MSTwyNVcO6g\">250-second video</a> on the highlights. You can also watch the <a href=\"https://www.youtube.com/watch?v=Ok6JKHMAkH8\">Official WordPress 6.7 release video</a> for an overview.</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress.org Experienced Increased Error Rates After the WordPress 6.7 Release</h2>\n\n\n\n<p>Several people reported getting 502 “Bad Gateway” errors and Systems Wrangler at Automattic, Barry, has <a href=\"https://status.wordpress.org/2024/11/14/on-nov-12th-2024-beginning/\">confirmed</a> that WordPress.org experienced intermittent elevated latency and increased error rates on November 12, which affected both the WordPress.org website and API.&nbsp;</p>\n\n\n\n<p>He has shared more details, “This initial incident was quickly resolved by the team, but reoccurred briefly on Nov 13 at 0110 UTC, 0900 UTC, and 1400 UTC. The underlying cause was network saturation of the hosting provider’s network that hosts some of the WordPress.org infrastructure. Although all of the servers and switch interfaces that our team has visibility into were within normal levels of utilization, there were some upstream network bottlenecks that created increased latency and packet loss that affected the WordPress.org environment.”&nbsp;</p>\n\n\n\n<p>They are still working to resolve the underlying issues.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Future of WordPress and Russian Contributions</h2>\n\n\n\n<p>Robert DeVore <a href=\"https://x.com/deviorobert/status/1849264002632704350\">drew the attention</a> of the WordPress community to Biden&#8217;s Executive Order 14071. He wondered what happens to WordPress when it can no longer accept contributors from Russia.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Here\'s a question for the WordPress Community <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f914.png\" alt=\"🤔\" class=\"wp-smiley\" /><br /><br />What happens to WordPress when it can no longer accept contributors from Russia? <br /><br />What happens when Automattic can no longer employ Russian employees to work on WordPress?<br /><br />Crazy talk? IDK about that <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f937-200d-2642-fe0f.png\" alt=\"🤷‍♂️\" class=\"wp-smiley\" /><br /><br />\"Biden\'s Executive Order… <a href=\"https://t.co/wlGBIusDRm\">pic.twitter.com/wlGBIusDRm</a></p>&mdash; Robert DeVore (@deviorobert) <a href=\"https://twitter.com/deviorobert/status/1849264002632704350?ref_src=twsrc%5Etfw\">October 24, 2024</a></blockquote>\n</div>\n\n\n\n<p>A WordPress.org spokesperson shared this with WPTavern on the issue: “The claim that Russians can&#8217;t contribute to GPL-licensed software is not entirely accurate. Executive Order 14071 was issued on April 6, 2022, and it prohibits new investments in the Russian Federation by U.S. citizens and restricts the exportation, reexportation, sale, or supply of certain services to individuals located in Russia.</p>\n\n\n\n<p>Additionally, it does not specifically address or ban the use of GPL-licensed (General Public License) software by Russian individuals or entities. The U.S. Department of the Treasury&#8217;s Office of Foreign Assets Control (OFAC) has provided guidance on the scope of services restricted under this order. While certain information technology and software services are prohibited, these restrictions do not extend to the mere use of GPL-licensed software by individuals in Russia.</p>\n\n\n\n<p><a href=\"http://wordpress.org/\">WordPress.org</a> is committed to increasing security expectations, adopting secure development practices, continuing to lead the project with transparency, and being a willing and helpful partner regarding any government requirements.”</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Nov 2024 18:00:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Do The Woo Community: Behind the Code, Brian Jackson on WordPress and WooCommerce Optimization\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=86880\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://dothewoo.io/behind-the-code-brian-jackson-on-wordpress-and-woocommerce-optimization/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"In this episode of Woo DevChat we chat with Brian about optimizing WooCommerce sites, the Perfmatters plugin, and the importance of customer support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Nov 2024 11:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: #145 – Calvin Alkan on Enhancing WordPress Productivity With CommandUI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=179273\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/podcast/145-calvin-alkan-on-enhancing-wordpress-productivity-with-commandui\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48356:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, enhancing WordPress productivity with a new WordPress plugin.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast, player of choice. Or by going to wptavern.com/feed/podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you, and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Calvin Alkan.</p>\n\n\n\n<p>Calvin has been in the WordPress space for the past four or five years, with a focus on security research. His company&#8217;s security product, called Fortress, has become a widely used tool for many hosting companies.</p>\n\n\n\n<p>Recently, Calvin and his team ventured into developing a new product CommandUI, and it&#8217;s this plugin which is the topic on the discussion today.</p>\n\n\n\n<p>Calvin shares his journey, starting from his experiences redesigning the Fortress website, and his frustrations with the traditional WordPress workflows. This led him to create CommandUI, aimed at providing a more efficient, keyboard driven workflow, akin to features available in his IDE, PhpStorm.</p>\n\n\n\n<p>Over the past two months, Calvin has been working on the plugin, and receiving positive feedback from the developer community, indicating a strong demand for such a tool.</p>\n\n\n\n<p>We talk about CommandUI&#8217;s functionalities, including its ability to help quickly navigate around the WordPress admin UI. It executes WordPress tasks using keyboard shortcuts, and Calvin explains how the tool helps manage your website efficiently, and how it supports dynamic integration with menus and can enhance accessibility.</p>\n\n\n\n<p>We also touch on the product&#8217;s reception into the market, and the serendipitous strategies that drove its vitality. Calvin talks about his efforts to ensure the tool resonates with power users, and the potential for future collaborations with plugin developers to expand its core offering.</p>\n\n\n\n<p>We explore why CommandUI, despite its success, may not be a fit for WordPress Core, but remains a novel solution for users looking to save time moving around the WordPress backend.</p>\n\n\n\n<p>If you&#8217;re curious about how a new tool changes the way you work with WordPress, and how a new product can become popular quickly, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Calvin Alkan.</p>\n\n\n\n<p>I am joined on the podcast by Calvin Alkan. How are you doing, Calvin?</p>\n\n\n\n<p>[00:03:34] <strong>Calvin Alkan:</strong> Hi Nathan, I&#8217;m doing fine. How are you?</p>\n\n\n\n<p>[00:03:35] <strong>Nathan Wrigley:</strong> Yeah, good, really good. This is unexpected. This episode probably would not have occurred just, I&#8217;m going to say, one month ago. Rewind the clock 30 days, and this episode probably would not have occurred. And you&#8217;ll find out why in a little while.</p>\n\n\n\n<p>But before we do that, Calvin has been on podcasts with me in the past talking about WordPress in terms of security. This is going to be very much focused on a brand new product, and the journey, and the happenstance, and serendipity of releasing that product into the wild over the last few weeks.</p>\n\n\n\n<p>But before we begin that Calvin, can I just give you a minute just to give us your bio, probably focusing on the WordPress space, maybe dropping some security bits and pieces in there as well. So just tell us who you are.</p>\n\n\n\n<p>[00:04:20] <strong>Calvin Alkan:</strong> Sure. I am probably in the WordPress space since four or five years ago, I don&#8217;t know exactly. But until very recently, or maybe like two months ago, I was mainly in the security space. I did a lot of security research. Our main product of my company, Snicco is Fortress, which is like a very advanced security tool that we mostly sell to WordPress hosting companies.</p>\n\n\n\n<p>That has mostly been my focus so far in WordPress, very focused on security. And we kind of stumbled into like a new product two months ago, which is CommandUI, which we&#8217;ll hopefully discuss in more depth right now.</p>\n\n\n\n<p>[00:04:53] <strong>Nathan Wrigley:</strong> Yeah, indeed we will. And it may be a good idea if you are listening to this podcast, to give yourself a bit of a flavor of what the product is. Head to commandui.com. Exactly as you might expect.</p>\n\n\n\n<p>Anything that we discuss today, if there&#8217;s a link for it, I will track it down and put it into the show notes. So you can find that on wptavern.com. Search for this episode, and all of the links will be in there. So that should be easy for you to get to.</p>\n\n\n\n<p>So this is a new product, brand new. It&#8217;s familiar, I would imagine, to most people, in the sense that they&#8217;ve probably used something like this before. That might be in their OS, or something. Do you want to just quickly tell us what it is, and then we&#8217;ll get into the fun story surrounding it.</p>\n\n\n\n<p>[00:05:35] <strong>Calvin Alkan:</strong> The really quick explanation is if you ever used something like Spotlight on Mac, or Raycast, even like commercial products for Mac. I think even Windows has something right now with this Windows search bar key, I don&#8217;t know, I&#8217;m not like a Windows power user.</p>\n\n\n\n<p>We&#8217;ve built the same thing, but specifically for WordPress. So it runs in your WordPress site, and basically allows you to build and manage your WordPress sites. The speed that was never possible before.</p>\n\n\n\n<p>[00:06:00] <strong>Nathan Wrigley:</strong> So when you say that, I&#8217;m imagining that a lot of people will be thinking, okay, there&#8217;s an interface, and I need to click around with a mouse. But maybe that&#8217;s what we should draw the distinction on straightaway. This is minimal mouse, I think you could describe as.</p>\n\n\n\n<p>[00:06:13] <strong>Calvin Alkan:</strong> Ideally you can unplug the mouse completely. That would be like the goal, because it&#8217;s just way faster. Like working with just the keyword is a lot faster than using the mouse.</p>\n\n\n\n<p>[00:06:22] <strong>Nathan Wrigley:</strong> So it invokes what you might describe as a modal front and center. So it&#8217;s a plugin, we should say that to begin with. It&#8217;s a plugin that you install in different WordPress websites. And then what do you do? How, do you invoke it? How do you interact with it? Let&#8217;s begin there.</p>\n\n\n\n<p>[00:06:37] <strong>Calvin Alkan:</strong> You have two options. You can either press the shift key twice, consecutively, with like a little, half a second time in between, or you can use the very classic command, or control K, combination that is used by other tools to invoke like similar models, or like command bars. So it&#8217;s one key combination. You can customise it if you want, but the default is, on Mac OS it&#8217;s command K, and on Windows it&#8217;s control K.</p>\n\n\n\n<p>[00:07:03] <strong>Nathan Wrigley:</strong> Okay. And if you do that, you then invoke, like I said, a modal, front and center in the middle. And it&#8217;s basically a text search box. And you can begin typing, and then the more input that you put in, it&#8217;s like faceted search in a way, it will then give you options for what you could do.</p>\n\n\n\n<p>So I don&#8217;t know, you might type in the letters p and o, which might map to, for example, post, things like that. And then it will give you the different options that it ships with at the moment. I imagine that functionality over time will increase.</p>\n\n\n\n<p>Let&#8217;s go into the kind of things that you can do with it. So would you be able to just outline a few typical things that you can do with it, that everybody will understand. Then maybe we could get into some of the more unusual edge cases. But let&#8217;s start with the really basics that it can do.</p>\n\n\n\n<p>[00:07:48] <strong>Calvin Alkan:</strong> Let&#8217;s start with the really basic of, you set up a new WordPress site, and you create like a post, and you view that post in the front end. And then you realise that you didn&#8217;t set up your pretty permalinks. So it&#8217;s still like p= whatever the number is, right, you know what I mean?</p>\n\n\n\n<p>So normally in WordPress, you would then need to go to like the little icon in the top left, and go to the admin dashboard. From there you need to find the, I don&#8217;t even know the exact name, but settings, I think permalinks, and then you need to change it. And all of that takes you like four clicks I think, more or less.</p>\n\n\n\n<p>And each of those clicks requires a full round trip to the server. So you need to wait to get a response back, and the server needs to render your WordPress page. So it probably takes you like, whatever, five seconds, let&#8217;s say, depending on your server speed.</p>\n\n\n\n<p>With CommandUI, you would just open it and type perm, for permalinks, and then it would instantly bring you up the result for settings permalinks, and then you hit enter, and you immediately jump to that page. So you just skip through all of the intermediary work to get to exactly what you want without taking all of these like unnecessary detours, if that makes sense. That would be like a very, very basic example.</p>\n\n\n\n<p>[00:08:52] <strong>Nathan Wrigley:</strong> Okay, so you have got all of the default settings in there. So if I install a vanilla version of WordPress, you&#8217;ve mapped, I&#8217;m going to say, every single setting that you could possibly get to.</p>\n\n\n\n<p>[00:09:03] <strong>Calvin Alkan:</strong> The default core ones, yeah.</p>\n\n\n\n<p>[00:09:04] <strong>Nathan Wrigley:</strong> Yeah. right, okay. And although it might seem trivial, you know, if you&#8217;re listening to this podcast and you&#8217;ve just got one WordPress website, you may be thinking to yourself, well, it&#8217;s not that difficult, is it? I can click four times and it&#8217;s not much of a burden.</p>\n\n\n\n<p>But honestly, when you&#8217;ve done that 15 times in a day. Map that over a week, and a year, this genuinely starts to add up. You only get a real understanding for it once you&#8217;ve done it. The sudden realisation that, okay, if I type three letters and hit return, that saves me from clicking this, waiting. Clicking this one now, and waiting. And then finally interacting. I know it seems like not a lot, but it is fairly profound.</p>\n\n\n\n<p>[00:09:39] <strong>Calvin Alkan:</strong> It looks nice on demos, but it&#8217;s amazing when you like kind of experience it the first time. It&#8217;s like something that looks great, but you need to really try. And most people, if you use it for like five minutes, then you can immediately see it, there&#8217;s no way that I&#8217;ll ever be able to go back to not using a tool like this.</p>\n\n\n\n<p>[00:09:55] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s kind of interesting because my muscle memory at the moment, navigating around a WordPress website is very much bound to the mouse. If I&#8217;m in a post, for example, and I know that I want to go to that permalink setting, I actually know exactly where it is. So I know that I would do precisely what you said.</p>\n\n\n\n<p>But of course, for a bunch of people who are not really that familiar with WordPress, they may have seen a YouTube video and discovered, okay, I need to change the permalinks. Discovering where that is could be quite infuriating. So if you could just type in p e r, or whatever it might be, and you get there immediately, that kind of also helps the novice journey, if you like, inside of WordPress and managing all of that as well.</p>\n\n\n\n<p>[00:10:31] <strong>Calvin Alkan:</strong> And also, for example, one that might also resonate is if you have a site and you start to rack up the plugin numbers, like 20 plugins or, I don&#8217;t know. Let&#8217;s say 20 plugins, and each of those plugins adds like three menu items to the admin menu, and the icons look all familiar. It&#8217;s not uncommon to open it, and then you go like up and down looking for what it is that you&#8217;re trying to find. And it takes a lot of time.</p>\n\n\n\n<p>Basically the more plugins you add, the more valuable something like this becomes. Because, let&#8217;s say you want to find some WooCommerce subsetting. You don&#8217;t need to scan the sidebar for the exact WooCommerce icon that you need to just go into the command bar type Woo settings, or even shorter, Woo S, and then it&#8217;ll immediately find where you want to go to. Basically the nastier the site, the more valuable something like this becomes.</p>\n\n\n\n<p>[00:11:16] <strong>Nathan Wrigley:</strong> Oh, interesting. Okay, so that&#8217;s curious. So let&#8217;s say that I have 20 plugins installed, and each of them got menus, within menus, within menus. Dozens and dozens of options. How does your plugin know of their existence, and how is it, I don&#8217;t know, understanding that this plugin over here has this selection of settings. And obviously if that plugin gets an update and a new setting arrives, perhaps, how does it know all of that? Basically, what&#8217;s the underlying technology? How are you building this menu that must be in there in the background?</p>\n\n\n\n<p>[00:11:45] <strong>Calvin Alkan:</strong> So 99% of the product of CommandUI is like JavaScript that runs in your browser that has really nothing to do with WordPress, for it WordPress is just like a data source. And then you have like a tiny part that is like the PHP, the plugin part if you want. And that basically just informs the JavaScript of what kind of data is available.</p>\n\n\n\n<p>So when you load a page in WordPress, then the PHP part can see which admin menus are registered in like the WordPress menu bar, in the sidebar. It kind of reads those, and passes that information down to the JavaScript part, which then transforms that into the UI.</p>\n\n\n\n<p>So if you install a new plugin, it&#8217;ll immediately pull that in. You don&#8217;t need to need update anything, configure anything, it&#8217;s just all automatic.</p>\n\n\n\n<p>If you deactivate one, it will not show it anymore, or even if you use like, there&#8217;s like popular menu editor plugins and whatever. If you use one of those to rename a plugin, then it will show that with the renamed name, for example.</p>\n\n\n\n<p>So it&#8217;s all dynamic. It gathers all the data, basically, the plugin, and then passes the data down to the JavaScript libraries that we built, and that is responsible for presenting the data to you.</p>\n\n\n\n<p>[00:12:53] <strong>Nathan Wrigley:</strong> So it&#8217;s not like I install a new plugin, and then I need to go around examining the settings, and CommandUI has to learn it as I&#8217;m seeing it.</p>\n\n\n\n<p>[00:13:02] <strong>Calvin Alkan:</strong> It&#8217;s immediately available. And also in the front end. You can also do all of these actions from anywhere on your site. So on the front end, or even if you&#8217;re in a page builder, or inside Gutenberg, it always knows what you have available.</p>\n\n\n\n<p>[00:13:13] <strong>Nathan Wrigley:</strong> Okay, so let me just parse that so I&#8217;m sure that we&#8217;ve got it correct. So the first thing is, if I was to install CommandUI on an existing site, which has, let&#8217;s say, oh gosh, let&#8217;s go nuts, 50 plugins. The settings within those plugins would be available immediately. I wouldn&#8217;t have to wait for anything to be crawled.</p>\n\n\n\n<p>[00:13:30] <strong>Calvin Alkan:</strong> So navigation is really just one part of what it does. But everything you see in the sidebar, so like the top level menu items, the little sub settings, these are all immediately available. And then it also picks up on any, for example, custom post types that a plugin might create. So you can create post types from within it, you can search across post types. So it&#8217;s all dynamic. There isn&#8217;t even like a configuration page for CommandUI. And that&#8217;s like kind of how I want to be, like just install it, and then it just kind of works, right?</p>\n\n\n\n<p>[00:13:57] <strong>Nathan Wrigley:</strong> Yeah, I think we&#8217;ve grasped that. And we&#8217;ll get onto those other use cases in a moment. But also you mentioned page builders. But the example that you gave was in the WP admin area, so you want to change a setting, for example. Are you saying that this can be invoked wherever you may be in your WordPress website? So you could be editing a post, you could be in a page builder. Elementor, Beaver Builder, what have you. You can do the same command K, it will come right up no matter where you are.</p>\n\n\n\n<p>[00:14:22] <strong>Calvin Alkan:</strong> Correct. You could, for example, let&#8217;s say you are editing a page with Gutenberg, and then you realise that you missed your favorite block plugin that adds like custom blocks, or collections. You could install a plugin from the repository without ever leaving the Gutenberg editor. And then you would see these blocks available because you can also activate the plugin from within the post that you&#8217;re currently editing.</p>\n\n\n\n<p>And Gutenberg is dynamic. So I think Gutenberg fetches new blocks dynamically once they&#8217;re available, and then you could immediately use them without first leaving, going back, then going back into Gutenberg. So it&#8217;s like everywhere, and like I said, it saves a huge amount of time.</p>\n\n\n\n<p>[00:15:00] <strong>Nathan Wrigley:</strong> Fascinating. Okay, so we understand that it&#8217;s everywhere. We understand that it can get into settings, and you mentioned that you could modify the settings.</p>\n\n\n\n<p>Let&#8217;s talk about some of the other slightly less normal use cases. So as an example, if I wanted to, I don&#8217;t know, create a new post of a custom post type of my design. It would allow me to do that I&#8217;m guessing as well? There&#8217;s a keyboard shortcut for add, I don&#8217;t know, custom post, or add taxonomy, or whatever it may be.</p>\n\n\n\n<p>[00:15:26] <strong>Calvin Alkan:</strong> You can actually press the C key, the letter C, anywhere on your site, and then it will bring up a subsection of CommandUI where you can just choose the post type that you want to create. So let&#8217;s say if you type C, it opens up the model, and then you just type P for post, or P O to narrow it down if you have a lot. And then you hit enter, and then it immediately brings you to the page where you can create a new post type.</p>\n\n\n\n<p>And that not only works for the core post types, it also works dynamically for every single plugin that you install. So if you install ACF, for example, then you can press the C key, type ACF, and then you immediately get the option to create either ACF field group, or an ACF taxonomy, or you can even create ACF post type with it.</p>\n\n\n\n<p>You can&#8217;t do it inside the model because every post type, if it&#8217;s a custom plugin, might require different fields that we might not know about, but we immediately send you to the page where you can start creating the post type.</p>\n\n\n\n<p>[00:16:22] <strong>Nathan Wrigley:</strong> Is it possible to, with CommandUI, is it possible to open up things in a different tab or window? So as an example, I&#8217;m in the middle of a post, I&#8217;m in the flow, but I know that I need to modify some setting briefly, quickly over in a new thing. And typically I&#8217;d have to, I don&#8217;t know, right click, open new tab, navigate blah, blah, blah. So it can do all of that?</p>\n\n\n\n<p>[00:16:39] <strong>Calvin Alkan:</strong> By default, if you select an action with enter, then it opens it in the same window. If you select it with command, or control on Windows, and enter, then it opens the same action in a new tab. That is very useful. Like a lot of people have given me the feedback of like, this basically allows them to use their laptop without having 20 different chrome tabs open, because you don&#8217;t need to like save all those spots where you might want to go to later. You can just open it in a new tab, do your work, close the tab, and you&#8217;re back to where you were.</p>\n\n\n\n<p>[00:17:08] <strong>Nathan Wrigley:</strong> Yeah, I mean, that&#8217;s a very typical frustration for me, is that I will halfway through something, and I don&#8217;t want to close it in case I, I don&#8217;t know, just forget where I was or something. I want to be able to open immediately the setting.</p>\n\n\n\n<p>[00:17:20] <strong>Calvin Alkan:</strong> But why don&#8217;t you want to close it?</p>\n\n\n\n<p>[00:17:22] <strong>Nathan Wrigley:</strong> I don&#8217;t know.</p>\n\n\n\n<p>[00:17:23] <strong>Calvin Alkan:</strong> Probably because you know it would take you like a lot of time to get back to that page. That&#8217;s why you don&#8217;t want to close it.</p>\n\n\n\n<p>[00:17:28] <strong>Nathan Wrigley:</strong> It&#8217;s lots of little quality of life things basically it sort of sounds like.</p>\n\n\n\n<p>Okay, so we know it can do settings. We know it can interact with posts. We know that you can open things in new tabs so that you don&#8217;t have to navigate from what you&#8217;re doing.</p>\n\n\n\n<p>Does it do anything kind of quirky? I&#8217;m going to use the word quirky there. Does it do things that one might not expect? Have you built into it functionality that you thought, ooh, this is curious, maybe nobody will use this, but let&#8217;s see.</p>\n\n\n\n<p>[00:17:52] <strong>Calvin Alkan:</strong> Probably. You can do a lot of little things that don&#8217;t really matter in the grand scheme of things. For example, toggle the admin sidebar or, I don&#8217;t know, if you&#8217;re on the dashboard page, you can toggle, or collapse all of these widgets on the dashboard in WP admin. Or use it to log out of your site.</p>\n\n\n\n<p>So there&#8217;s a lot of these little things in there that, on its own, they wouldn&#8217;t blow you away, right? But it kind of all adds up. And if you can do, eventually, everything in there, I want to have as much in there as possible.</p>\n\n\n\n<p>And an important part that allows it to do this is because we built the entire search behind it from scratch. So we&#8217;ve tested this with like 100k items to be searched in the command bar. It doesn&#8217;t even break a sweat. It&#8217;s still in the sub 100 milliseconds for hundred thousands of items.</p>\n\n\n\n<p>So there&#8217;s really no limit to how many things and actions you can put in there. And it doesn&#8217;t overwhelm you either because you only get shown what kind of matches your search query. I want to have as much things possible in there.</p>\n\n\n\n<p>[00:18:47] <strong>Nathan Wrigley:</strong> So are you imagining a scenario where it can search, for example, the content of posts? So for example, I want to track down a post with the word Calvin in it.</p>\n\n\n\n<p>[00:18:56] <strong>Calvin Alkan:</strong> Right now it can already search all your users and every single post type. So posts, pages, every custom post type you create. For example, WooCommerce products, there&#8217;s a post type, so it can search those. But it only searches right now the titles. So you kind of need to at least roughly have an idea of where you want to go, that&#8217;s the search. That&#8217;s basically how it operates.</p>\n\n\n\n<p>You roughly need to have an idea what you&#8217;re looking for. Maybe a couple of letters, or an initial if you want to find the user Nathan, but you don&#8217;t know the last name maybe, or the email, you could just type N A and you&#8217;d probably find it. But it&#8217;s not really like the best UI for like exploratory searches. That&#8217;s not the best model with the search bar, and result is not the best use case for exploring what&#8217;s there if you don&#8217;t really know what you&#8217;re looking for yet.</p>\n\n\n\n<p>[00:19:38] <strong>Nathan Wrigley:</strong> Yeah. What I was describing is more the kind of search that you would have on the front end, isn&#8217;t it? Where you want to, I don&#8217;t know, search for a particular episode of a podcast, for example, with the word Calvin. And you would typically do that on the front end, and that&#8217;s an entirely different enterprise.</p>\n\n\n\n<p>As we&#8217;ve been talking, it suddenly occurred to me that, and I don&#8217;t know what your posture is on this, I don&#8217;t know how much work you&#8217;ve put into it, but it feels like you&#8217;ve thrown the doors open to perhaps a more accessible website because obviously we&#8217;re using the keyboard suddenly to navigate all the things. And I don&#8217;t know if the UI that you&#8217;ve built, you&#8217;ve had that in mind in the background, or coincidentally it happens to satisfy that. What&#8217;s gone on from the accessibility side to make this product usable?</p>\n\n\n\n<p>[00:20:18] <strong>Calvin Alkan:</strong> A lot of work into accessibility. I&#8217;ve worked with Gen Herres, I don&#8217;t know if you&#8217;re familiar with her. She does lot of work in the accessibility space in WordPress. The website I think is Easy Accessibility Guide. I&#8217;ve worked a lot with her because she told me like about the potential this has for users with assistive technology. And we&#8217;ve worked really, really hard to improve the admin experience for users with assistive technology.</p>\n\n\n\n<p>Building something like this, like that is so interactive in a way that doesn&#8217;t compromise power users, and users with assistive technology is really, really difficult. It&#8217;s not like a form where you go with the basics and then you&#8217;re good. Like this really, really needs a lot of custom work. But it turned out amazing. Every single item, every single search result is read out by the screen reader. Every single announcement, for example, if you install a plugin, then the screen reader will read out the progress information, like installing plugin, installed plugin.</p>\n\n\n\n<p>Everything is keyboard accessible. Everything has the proper aria labels. We did a lot of work there basically. Even things where if you close the model, it restores the focus back to where you&#8217;ve been to before on the page. I really think it has a lot of potential in the accessibility space to help people use WordPress.</p>\n\n\n\n<p>[00:21:26] <strong>Nathan Wrigley:</strong> Yeah, it just occurred to me that it was, in a sense, it was a really great interface for doing just that, because once you&#8217;re in the modal, you&#8217;re in the search bar, then you are basically using text. And if you can navigate through that with the tab key, or whatever it may be, with all the different assistive technologies out there, then that would be really useful. And it would circumvent that long journey of trying to find the menu, then finding the sub menu, then going through all the options, and toggling it on, or toggling it off.</p>\n\n\n\n<p>[00:21:50] <strong>Calvin Alkan:</strong> I think Gen did a video the other day about it, where she goes through the plugin with a screen reader and basically shows you how a user with a screen reader would experience that. So maybe you can link to it in a show notes later.</p>\n\n\n\n<p>[00:22:01] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s perfect. I will make sure that that goes into the show notes so that people can examine that.</p>\n\n\n\n<p>The other thing I was going to ask is, do you have intuitions that in the future you&#8217;ll be working with other developers? So for example, I don&#8217;t know, you mentioned popular plugins, a couple that you just mentioned. Is there any scope for them speaking to you to expose things that your plugin at the moment might not be able to get its teeth into, so that you can open up the functionality with CommandUI for the whole host of plugins that are out there in the wild?</p>\n\n\n\n<p>[00:22:31] <strong>Calvin Alkan:</strong> Definitely, one of the big projects will be having a proper extension system and developer APIs, so that either we can build first party extensions that we maintain, or that developers build their own extensions for it. For example, right now I like Bricks Builder a lot. And I use that. So we have a really good integration with Bricks Builder where, for example, if you are on the homepage, and then CommandUI recognises that you built this page with Bricks, then you can just press the B key, on the keyboard without even opening it, and it immediately brings you to edit that page in Bricks Builder.</p>\n\n\n\n<p>So that is something that obviously doesn&#8217;t work out of the box. So there&#8217;s like a little integration for handling Bricks specific things. You can also, if you search for a post, or let&#8217;s say a page, you wouldn&#8217;t edit posts with the page builder. But let&#8217;s say you have a landing page, or whatever, and then you search for it, and then instead of just a normal view page and edit page, it would also show you edit page in Bricks as an option, right? I think there&#8217;s a huge potential in having as many things as possible in there.</p>\n\n\n\n<p>One big thing is I want to also make it as easy as possible for also developers that maintain a site, but also plugin developers to integrate it without complicated setups, without needing to install like React and pre-compiling their JavaScript. I think it needs to be really, really simple for it to work. And that will definitely be one big project in the future.</p>\n\n\n\n<p>[00:23:47] <strong>Nathan Wrigley:</strong> Fascinating what the future will hold. I mean that speaks to the next topic that I want to get into. Which is the fact that this is still really, really new. Really, this whole story has found its way into my consciousness because of, I guess maybe being on social networks. Up it popped a few weeks ago, maybe less, 10 days or something like that. And it feels like I had never heard of this until then, and then suddenly I couldn&#8217;t stop hearing about it. Let&#8217;s just get into that for a moment. First of all, why did you build this, and when did you start building it?</p>\n\n\n\n<p>[00:24:21] <strong>Calvin Alkan:</strong> So let me walk you through the timeline. I don&#8217;t remember the exact date, but I&#8217;d say like maybe two months ago I started working on the redesign of our website for Fortress, or other product, because that has still like a design from like two years ago that was never updated. You know how that goes, right?</p>\n\n\n\n<p>So I started working on it and we were using WordPress for it as well, and I really, really disliked the experience of working all day in WordPress. So my role is primarily a developer. I use WordPress, but I&#8217;m not like a WordPress power user in the sense that I spend all my day inside WordPress. I spend most of my time in my IDE and PhpStorm.</p>\n\n\n\n<p>And there I&#8217;m really, really spoiled by this keyboard driven workflow where you can do like thousands of things inside PhpStorm with just a couple keyboard combinations. And I really missed that in WordPress.</p>\n\n\n\n<p>So once I started building a site, I was getting really annoyed and I was like, I don&#8217;t know, I can quickly hack together something that works for me right now. And it took me like a couple hours to build something that allowed me to navigate between different pages. That was all I could do, navigate between the admin, homepage, and the settings. The really basic stuff. Nothing to really brag about.</p>\n\n\n\n<p>But then I recorded like a really crappy YouTube video, I think it&#8217;s still up somewhere, of just me showing that. And I posted it in groups where I frequently go to, in Facebook it was. People went absolutely crazy over it. The reaction was insane. People almost, how do you say, they bit my hand off to build this.</p>\n\n\n\n<p>The initial reaction definitely showed that there might be something there. Sometimes that just happens, right? And that also then the timing was the same, where all the WP drama started. And once that started, I basically knew that, okay, like my primary customer base is hosting companies, and there&#8217;s probably not a lot of enterprise sales going on in the next months in the hosting space. I immediately knew that. Understandable.</p>\n\n\n\n<p>But I knew that and then I was like, well, let me just try and build this thing properly, not the four hour versions, but like maybe the six week version. So the initial reaction was like very promising. And then I kept posting like videos about it, cool new things. And the reaction was always the same. People were messaging me in private, hey, I know this is not even like a finish, but can I please already pay you so that you can give me this, what you already have?</p>\n\n\n\n<p>It was like very promising all along the way, very good signals. And that&#8217;s why I ultimately ended up building it. So it took like maybe two months, right now seven weeks, two months, I don&#8217;t know, to get where we&#8217;re at right now. And it completely blew my mind, the feedback and the attention that it got. I never really expected that, to be honest. I don&#8217;t know, maybe this helps a couple of people, and it&#8217;s useful for me, and maybe it pays for a couple months of rent, that was kind like my expectation of it.</p>\n\n\n\n<p>[00:26:53] <strong>Nathan Wrigley:</strong> Well, I think most people who launch a product in the WordPress space, and if, dear listener, you are one of those people, I&#8217;m sure you can identify with the struggle. It&#8217;s not an easy place to be. There are countless different versions of more or less everything. So if you&#8217;re releasing a plugin, unless you come up with something truly different, then it&#8217;s likely that you are going to spend a lot of time bashing your head against the wall with the marketing, figuring out what the website&#8217;s going to look like.</p>\n\n\n\n<p>You have just had, I don&#8217;t want to call it luck, but if you forgive me for using that word, you&#8217;ve just had this perfect storm of building something, creating a video, putting it into some social networks, getting really amazing feedback which encouraged you to build it. And again, not really marketing in the traditional sense of the word, just social media, hanging out in groups and what have you, and explaining what you&#8217;re doing. And I think it&#8217;s fair to say that it&#8217;s been a barnstormer.</p>\n\n\n\n<p>Since you&#8217;ve started two months ago, we don&#8217;t need to get into the numbers, that&#8217;s not important, but is it fair to say that it has gone way beyond, in terms of the people that have interacted with you, and purchased it, and played with it, and given you feedback. I&#8217;m guessing it&#8217;s fair to say that it&#8217;s gone way beyond what you imagined.</p>\n\n\n\n<p>[00:28:00] <strong>Calvin Alkan:</strong> For sure. The way I launched it basically was, so once the product was ready, or maybe a week or two before it was fully ready, I threw up a landing page, and recorded like a proper demo walkthrough, my first ever edited video. It turned out okay. It turned out good with Descript, and a lot of these tools make it, I guess a videographer would cringe at that, but it&#8217;s like passable, it did its job.</p>\n\n\n\n<p>I threw up a wait list and had a little gamified approach to this waitlist thing, where I didn&#8217;t even like promise some crazy deal, or discount, or whatever. I just said, look, there will be a launch offer that will be better than the public offer, and it will be limited in quantity, not a gimmick or whatever, like when the quantity is sold out, it&#8217;s sold out.</p>\n\n\n\n<p>And then I think that the verbiage was something like, if you&#8217;re on the wait list, you&#8217;ll get 48 hours exclusive access before public launch to secure wait list deals. And if you&#8217;re in the first 50 spots, I think it was, then you get an additional 48 hours.</p>\n\n\n\n<p>I don&#8217;t know, it&#8217;s fun but I never expected it to go that crazy, like people were sharing it all over the place, and then once the first 50 people got access, a day before the entire wait list, they started using the product, loved it, posted about it.</p>\n\n\n\n<p>It was well done, I put a lot of thought into it, but it&#8217;s also, something about the timing must have been right with maybe like all the negativity that was happening in WordPress, Twitter and Facebook groups, and whatever. No, definitely there&#8217;s some part to it where people like were excited to see something positive, or some positive news coming out I think.</p>\n\n\n\n<p>[00:29:30] <strong>Nathan Wrigley:</strong> Yeah, I think also you happen to have a product which, if you frequent those Facebook groups, which I know you do, they&#8217;re full of people who are jobbing WordPressers. They&#8217;re either building websites, or they&#8217;re building plugins, or they&#8217;re building client websites as part of an agency or something like that.</p>\n\n\n\n<p>So they&#8217;re fully into WordPress, but they also realise the limitations. And in some cases they may have not have realised the frustration, but then when they saw something like this and thought, actually, you know what, that&#8217;ll save me a minute here, and a minute there, which all adds up to greater productivity.</p>\n\n\n\n<p>I think you just had that perfect storm of the right product, and you were already connecting to the perfect audience. And honestly, if we were to revisit this topic in a year and do some sort of marketing analysis, I think every domino was kind of set up perfectly. And again, I don&#8217;t mean this to sound bad, but kind of by accident in a sense. You&#8217;d already found your audience because you were in there talking to these communities. You built the product, which perfectly aligned, to scratch your own itch. What a lovely story, basically.</p>\n\n\n\n<p>[00:30:36] <strong>Calvin Alkan:</strong> I think maybe I stumbled upon the idea based on luck maybe, yeah, to some degree. I certainly didn&#8217;t expect that so many people will find it useful, or be interested in it. I do actually plan to, like once it all settles down a bit, do some sort of post mortem write up, or analysis of, this is how I launched it. This is why I did it this way, and why I didn&#8217;t do this, the decision making behind it. I also had a lot of trust, let&#8217;s say, not advisors, but like friends in the ecosystem that gave me a lot of feedback or, no, don&#8217;t do it this way, rather try this. And so I think like a proper writeup of that be cool to see, the behind the scenes.</p>\n\n\n\n<p>[00:31:10] <strong>Nathan Wrigley:</strong> Yeah, it would be interesting to match the people that you were already speaking to, prior to even conceiving the product, with the product that you then built, and the way that you were able to market it in a kind of gorilla fashion. Just producing some videos, and not, I don&#8217;t know, building an email list over many years and what have you.</p>\n\n\n\n<p>And I think it will be interesting because I think we all know that the WordPress space can be saturated. And just because you build it doesn&#8217;t mean that they will come. There&#8217;s so many serendipitous bits in there. It&#8217;s fabulous.</p>\n\n\n\n<p>One thing that I was going to ask you, and I don&#8217;t know if you have any intuitions about this, is that one of the comments that I kept seeing was something along the lines of, why isn&#8217;t this in Core WordPress? There were variants of that. You use it for a bit and you can&#8217;t not carry on using it. It&#8217;s got that stickiness to it. You get the muscle memory over a few short minutes and then suddenly it&#8217;s, oh, put the mouse away, I don&#8217;t want that anymore.</p>\n\n\n\n<p>And I did wonder if you have any thoughts about letting something like this go into Core, or working with Core on it, or whether or not you&#8217;re going to stay with the product that you&#8217;ve got. Not sure what you think about that.</p>\n\n\n\n<p>[00:32:11] <strong>Calvin Alkan:</strong> Well, it is kind of in Core, a lot of people don&#8217;t know that. In Gutenberg, in the block editor, and inside the site editor there is, I wouldn&#8217;t say similar, but they have a Command Palette, but it just, it never really stuck for people, getting into the habit of using it.</p>\n\n\n\n<p>Let&#8217;s say like this, a command bar is, I don&#8217;t know, maybe the best analogy is a keyboard. All keyboards, more or less, they look the same if you just glance at them from a distance. But once you start pressing like the first key, you really feel like the difference between like a $500 mechanical keyboard and a default keyboard, right? It&#8217;s hard to describe, but that&#8217;s like the best analogy I can give for it.</p>\n\n\n\n<p>And if a command bar is not like really, a really, really polished product, technically zero friction, people don&#8217;t get into the habit of using it. And I think that&#8217;s maybe why previous attempts of building something like this in WordPress didn&#8217;t really stick around, or didn&#8217;t take off. It&#8217;s just my theory.</p>\n\n\n\n<p>[00:33:00] <strong>Nathan Wrigley:</strong> Wasn&#8217;t it also limited just to the Gutenberg UI?</p>\n\n\n\n<p>[00:33:03] <strong>Calvin Alkan:</strong> That&#8217;s also a big part of it. If you can just use it inside the block editor, then it obviously won&#8217;t stick around. It&#8217;s like the default workflow for people. But also, of course, WordPress Core is just one tiny part of it, and there&#8217;s probably not resources to dedicate a full command bar team to it basically.</p>\n\n\n\n<p>In my opinion, maybe this shouldn&#8217;t be a Core thing to its fullest degree. There&#8217;s always the saying of 80 20 rule that they have, right? I don&#8217;t think 80% of WordPress users will use this. In the same way that not 80% of MacOS users use Spotlight or Raycast. There&#8217;s probably a big segment of users that will use it, but it&#8217;s nowhere near 80, probably not even near 50% of people that will use it. So I think the resources could be spent other ways. I don&#8217;t know, it&#8217;s just my theory.</p>\n\n\n\n<p>[00:33:43] <strong>Nathan Wrigley:</strong> That seems like a sensible way of doing it. I think the promise of WordPress is to be, if 80% of the people use it, then it can be considered. And I think you&#8217;re right. I think for people who are really in WordPress all the time, like you, like me, like the people that you&#8217;ve pitched the product to and who have bought it, then that makes perfect sense. But perhaps for the more casual user who&#8217;s just got a brochure site that they don&#8217;t really modify all that much, then maybe not.</p>\n\n\n\n<p>[00:34:05] <strong>Calvin Alkan:</strong> It&#8217;s also, I very much built this for the power user audience. And if you built with that in mind, the outcome is very different to if built like a, you can also build like a command bar that is more geared towards, let&#8217;s say beginners that need maybe more exploratory features. So if you open it, it&#8217;s more like, hey, you can do this, and from here you can go there. And ours is very much, you type a couple letters in some random order, and it more or less brings you to already where you know you want to go. So it&#8217;s I guess built for a different segment also.</p>\n\n\n\n<p>[00:34:36] <strong>Nathan Wrigley:</strong> Yeah, definitely worth checking out. So I think probably we&#8217;ve reached the number of minutes, which would be suitable for this episode. So we&#8217;ll knock it on the head there. But just before we go, one last mention of the URL, it&#8217;s commandui.com, no hyphens, just all as one word, commandui.com. Go and check it out.</p>\n\n\n\n<p>Where can we find you if we want to communicate about this? Obviously the website probably, but are there other places where you hang out? Sounds like you do hang out on socials quite a bit.</p>\n\n\n\n<p>[00:35:02] <strong>Calvin Alkan:</strong> Yeah, I&#8217;m in like all the popular WordPress Facebook Groups, mostly agency groups I think. And also since half a year, a year or so, very active on X, I think my handle is @CalvinAlkan. So if you want to hit me up, just hit me up there.</p>\n\n\n\n<p>[00:35:17] <strong>Nathan Wrigley:</strong> Okay, so that&#8217;s perfect. I will link to that in the show notes. Well, well done for, firstly, bringing a product to market in a record amount of time, but also for the barnstorming success that you&#8217;ve had. I hope that it carries on in that same way, and maybe, you never know, in a year or two, we&#8217;ll come back and see where you&#8217;re at. But Calvin Alkan, thank you so much for chatting to me today.</p>\n\n\n\n<p>[00:35:35] <strong>Calvin Alkan:</strong> Thank you Nathan, thanks for having me.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://x.com/CalvinAlkan\">Calvin Alkan</a>.</p>\n\n\n\n<p>Calvin has been in the WordPress space for the past four to five years, with a focus on security research. His company’s security product, called <a href=\"https://fortress.snicco.io/\">Fortress</a>, has become a widely used tool for many hosting companies. Recently, Calvin and his team ventured into developing a new product, <a href=\"https://commandui.com/\">CommandUI</a>, and it’s this plugin which is the topic under discussion today.</p>\n\n\n\n<p>Calvin shares his journey, starting from his experiences redesigning the Fortress website, and his frustrations with the traditional WordPress workflows. This led him to create CommandUI, aimed at providing a more efficient, keyboard-driven workflow, akin to features available in his IDE, PhpStorm. Over the past two months, Calvin has been working on the plugin and received positive feedback from the developer community, indicating a strong demand for such a tool.</p>\n\n\n\n<p>We talk about CommandUI&#8217;s functionalities, including its ability to help quickly navigate around the WordPress admin UI. It executes WordPress tasks using keyboard shortcuts, and Calvin explains how the tool helps manage your website efficiently, and how it supports dynamic integration with menus, and can enhance accessibility.</p>\n\n\n\n<p>We also touch on the product&#8217;s reception into the market, and the serendipitous strategies that drove its virality. Calvin talks about his efforts to ensure the tool resonates with power users, and the potential for future collaborations with plugin developers to expand its core offering.</p>\n\n\n\n<p>We explore why CommandUI, despite its success, may not be a fit for WordPress Core, but remains a novel solution for users looking to save time moving around the WordPress backend.</p>\n\n\n\n<p>If you’re curious about how a new tool changes the way that you work with WordPress, and how a new product can become popular quickly, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://snicco.io/\">Snicco</a></p>\n\n\n\n<p><a href=\"https://fortress.snicco.io/\">Fortress</a></p>\n\n\n\n<p><a href=\"https://commandui.com/\">CommandUI</a></p>\n\n\n\n<p><a href=\"https://www.raycast.com/\">Raycast</a></p>\n\n\n\n<p><a href=\"https://easya11yguide.com/\">EasyA11yGuide website</a></p>\n\n\n\n<p><a href=\"https://www.youtube.com/watch?v=4eU59Hk4m70&feature=youtu.be\">A11Y battle: CommandUI vs WP Core vs Turbo Admin</a> &#8211; video with Gen Herres on YouTube</p>\n\n\n\n<p><a href=\"https://bricksbuilder.io/\">Bricks Builder</a></p>\n\n\n\n<p><a href=\"https://www.jetbrains.com/phpstorm/\">PhpStorm</a></p>\n\n\n\n<p><a href=\"https://www.descript.com\">Descript</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/article/site-editor-command-palette/\">WordPress Command Palette</a></p>\n\n\n\n<p><a href=\"https://x.com/CalvinAlkan\">Calvin on X / Twitter</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 13 Nov 2024 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Akismet: What is Email Obfuscation? Why is it Essential for Preventing Spam?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://akismet.com/?p=284217\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://akismet.com/blog/email-obfuscation/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19558:\"<p>No one wants an inbox full of spam, especially when they’re running a business website. And when customer queries are overshadowed by spam and phishing attempts, you’re left inconvenienced — and that’s putting it mildly. Not to mention, sorting through it all takes a lot of time that could be spent on other&nbsp;tasks.</p>\n\n<p>While sharing your email address online is necessary to direct visitors towards your support and sales channels, it’s an open invitation for spambots, too. These automated programs crawl the web, collect public email addresses, and send a barrage of spam in the hopes that you or someone on your team takes the&nbsp;bait.</p>\n\n<p>Thankfully, this can be prevented with a tactic known as email obfuscation. This technique disguises your email addresses, keeping them safe from <a href=\"https://akismet.com/blog/what-is-a-spambot/\">spambots</a> and protecting your business from unwanted&nbsp;messages.</p>\n\n<p>So today, let’s explore email obfuscation in depth and explain how you can use it (alongside other methods) to improve your online&nbsp;security.</p>\n\n\n<span id=\"more-284217\"></span>\n\n\n<h2 id=\"what-is-email obfuscation\" class=\"wp-block-heading\">What is email&nbsp;obfuscation?</h2>\n\n<p>Email obfuscation is a technique used to mask email addresses so that they’re not as easily detected by spambots. When an email address is obfuscated, it’s still completely readable by humans, but is difficult for bots to&nbsp;recognize.</p>\n\n<p>Malicious bots are constantly crawling the internet looking for emails to scrape and add to their spam lists, and email obfuscation is absolutely necessary to prevent spam. While this won’t help against targeted spam and phishing attempts, it will at least stop the bulk of automated spam&nbsp;attacks.</p>\n\n<p>There are several ways to obfuscate an email on your site. Some methods include replacing parts of the email with HTML characters, or using JavaScript to dynamically display the email when the page is loaded. These make it a lot harder for simple bots to scrape your email. We’ll go into the details on how it works&nbsp;below.</p>\n\n\n<img width=\"1066\" height=\"1600\" src=\"https://akismet.com/wp-content/uploads/2024/10/image.jpeg\" alt=\"someone writing an email on their laptop, with a tablet and color swatches next to them\" class=\"wp-image-284219\" />\n\n\n<h2 id=\"why-is-email-obfuscation-crucial-for-cybersecurity-and-spam prevention\" class=\"wp-block-heading\">Why is email obfuscation crucial for cybersecurity and spam&nbsp;prevention?</h2>\n\n<p>Email obfuscation might not seem all that important. It’s hard to understand how disruptive spam can be until you have an inbox full of it. And by then, it’s too late to do anything about it except change your email address&nbsp;entirely.</p>\n\n<p>Here are some of the risks of leaving your email&nbsp;unobfuscated:</p>\n\n<h3 id=\"email-harvesting-bots-scraping-your email\" class=\"wp-block-heading\">Email harvesting bots scraping your&nbsp;email</h3>\n\n<p>You don’t want your email on a scammer’s list. These are sold to spammers looking for active emails to send their junk mail to. If your email is out there long enough, it’s nearly inevitable, but you can use email obfuscation to delay it as long as&nbsp;possible.</p>\n\n<h3 id=\"brute-force-attacks-on-your-email account\" class=\"wp-block-heading\">Brute force attacks on your email&nbsp;account</h3>\n\n<p>Once attackers know your email, they can attempt to launch brute force attacks to access your account. When this happens, they’ll try as many passwords as possible, and break in. It’s best to hide your email from the automated programs that run these brute force&nbsp;attacks.</p>\n\n<h3 class=\"wp-block-heading\">A spam&#8209;filled&nbsp;inbox</h3>\n\n<p>Spam may seem like just an annoyance, but it can be devastating when it’s in full force. Genuine customers get drowned out and your inbox becomes impossible to sort&nbsp;through.</p>\n\n<h3 id=\"being-targeted-by-phishing attacks\" class=\"wp-block-heading\">Being targeted by phishing&nbsp;attacks</h3>\n\n\n<p>Phishing occurs when an attacker tries to trick you into revealing sensitive info, like your email or website login info. Or, you might receive an email asking you to click a link or download an attachment that installs malware on your device and steals your info. Basic phishing attacks can be automated.&nbsp;</p>\n\n\n\n<p>While <em>you </em>may know all about how to identify a scam, not everyone on your team might be so experienced. The more team members that have access to your business email, the more likely they’ll fall prey to phishing attempts.&nbsp;</p>\n\n\n\n<p>And since over <a href=\"https://siliconangle.com/2023/10/02/report-half-phishing-emails-now-use-obfuscation-tactics-avoid-detection/\" target=\"_blank\" rel=\"noreferrer noopener\">55% of phishing emails</a> now employ some form of obfuscation to evade detection — which marks a significant 24.4% increase from the previous year — it’s more important than ever to implement some level of prevention.&nbsp;</p>\n\n\n<h2 id=\"common-methods-of-email obfuscation\" class=\"wp-block-heading\">Common methods of email&nbsp;obfuscation</h2>\n\n<p>There are several ways to hide the email address on your website from bots while still allowing real customers and prospects to contact you. And the good news is you can employ one or all of&nbsp;them.</p>\n\n\n<h3 id=\"use-a-contact-form-with-spam-protection \" class=\"wp-block-heading\">Use a contact form with spam protection&nbsp;</h3>\n\n\n<p>One of the most effective email obfuscation techniques is to avoid displaying your email online altogether. Instead, you can just use a contact form. Of course, contact forms have their own issues with spam, which is why you’ll need to use this alongside an anti&#8209;spam solution like&nbsp;<a href=\"https://akismet.com/\">Akismet</a>.</p>\n\n\n<img width=\"1000\" height=\"518\" src=\"https://akismet.com/wp-content/uploads/2024/10/image-1.jpeg\" alt=\"Akismet homepage with the text \" />\n\n\n\n<p>Akismet uses AI to scan all incoming form submissions and filter out unwanted, spammy messages with 99.99% effectiveness. <a href=\"https://akismet.com/blog/captcha-alternatives/\">No need for CAPTCHA</a> or other obtrusive spam protection methods. Spam will never even reach your inbox when you use Akismet. And if you have a WordPress website, it comes pre-installed, which is pretty convenient.&nbsp;</p>\n\n\n\n<h3 id=\"character-replacement\" class=\"wp-block-heading\">Character replacement</h3>\n\n\n\n<p>This can be as simple as replacing the “@” in an email with “at”, or replacing the symbols with their HTML entities. So an email address like “test@example.com” becomes “test@example.com”.&nbsp;</p>\n\n\n<p>This renders correctly for people who visit your website but parses as gibberish for bots. The downside is that it only works for very simple bots, so you should use it in conjunction with other&nbsp;methods.</p>\n\n\n<h3 id=\"image-based-obfuscation\" class=\"wp-block-heading\">Image-based obfuscation</h3>\n\n\n<p>Another simple solution is displaying your email as an image. Most bots can’t read images, so this can work pretty well. But it’s not user&#8209;friendly at all since visitors have to type in your email manually. There are also serious accessibility concerns for those who use screen readers. Because of these reasons, this isn’t the best option to&nbsp;pursue.</p>\n\n\n<h3 id=\"javascript-based-obfuscation\" class=\"wp-block-heading\">JavaScript-based obfuscation</h3>\n\n\n\n<p>This is a more involved method, where the email is hidden in the site’s code and rendered dynamically. The email address can be hidden within the site’s HTML code and is only displayed when the page is loaded by a browser. This makes it a lot more challenging for bots to scrape this data.&nbsp;</p>\n\n\n<p>There are more advanced bots out there, however, especially those running in a fully&#8209;fledged browser environment that can bypass these methods​. So that’s something to be aware&nbsp;of.</p>\n\n\n<h3 id=\"encoding-techniques\" class=\"wp-block-heading\">Encoding techniques</h3>\n\n\n<p>Encoding techniques involve converting an email address into a string of code that a browser can interpret, but that is difficult for bots to decode. A common method is <a href=\"https://developer.mozilla.org/en-US/docs/Glossary/Base64\" target=\"_blank\" rel=\"noreferrer noopener\">Base64 encoding</a>, where the email is transformed into a string of characters that can be decoded by the browser using JavaScript.&nbsp;</p>\n\n<p>So, if you have an email like &#8220;example@example.com&#8221; it might be encoded into a string like &#8220;ZXhhbXBsZUBleGFtcGxlLmNvbQ==&#8221;. When the page loads, a script decodes this string back into a readable email address that people can interact&nbsp;with.</p>\n\n<p>This method can be thwarted by more advanced bots though, so be mindful of that when putting a plan together to prevent&nbsp;spam.</p>\n\n<h2 id=\"how-email-obfuscation-fits-into-a-broader-cybersecurity framework\" class=\"wp-block-heading\">How email obfuscation fits into a broader cybersecurity&nbsp;framework</h2>\n\n<p>Where there’s a website, there’s a risk of people trying to break into it. You don’t need to be running a huge enterprise website to be targeted by bad actors. In all actuality, hackers and spammers are more than happy to take advantage of the lax security on smaller&nbsp;sites.</p>\n\n<p>That’s why cybersecurity should be a major concern of yours, whatever the size of your website. Digital threats, from spam to malware, are constantly evolving. And email obfuscation is just one piece of the puzzle that can put a stop to these&nbsp;threats.</p>\n\n<p>Email obfuscation serves as a preventative measure, reducing the likelihood that your email will be harvested and used for spam and phishing attacks. While spam is just a nuisance, phishing can lead to losing your account or major data breaches. So if you make your email harder to find, it lowers the chances of you being&nbsp;targeted.</p>\n\n<p>But email obfuscation isn’t enough on its own. It should complement other security measures. The anti&#8209;spam tools offered by Akismet can detect and block malicious messages that do manage to slip&nbsp;through.</p>\n\n<p>And you can further secure your online presence by setting up (and mandating) two&#8209;factor authentication for you and your team, <a href=\"https://jetpack.com/blog/weak-passwords/\" target=\"_blank\" rel=\"noreferrer noopener\">using strong passwords</a> (and not reusing them), and keeping website and server software up to date. Firewalls and intrusion detection systems can also work to keep your site&nbsp;safe.</p>\n\n<p>Besides that, providing cybersecurity training to your team (or thoroughly educating yourself if it’s just you) can help you recognize potential&nbsp;threats.</p>\n\n<p>So email obfuscation is a valuable tool, yes, but it works best when integrated into a comprehensive cybersecurity&nbsp;strategy.</p>\n\n<h2 id=\"the-importance-of-layered-security measures\" class=\"wp-block-heading\">The importance of layered security&nbsp;measures</h2>\n\n<p>There’s no one cybersecurity solution that will protect your entire online presence. So you’ll need to rely on multiple security measures that work together to create a more resilient&nbsp;defense.</p>\n\n<p>Redundancy is something you might have heard of in reference to web hosting servers. In a redundant hosting setup, if one server fails, a backup server is ready to take its place and prevent downtime. It’s used a lot when talking about website backups, too. If one backup fails, there’s another saved in a different location to ensure your data isn’t&nbsp;lost.</p>\n\n\n<p>This same concept of redundancy also applies to cybersecurity. If one layer of your defense fails, others are still in place to catch the threat.&nbsp;</p>\n\n\n<p>So if spambots figure out how to bypass your email obfuscation, having an <a href=\"https://akismet.com/wordpress/\">anti&#8209;spam solution</a> like Akismet will prevent that phishing email from reaching your inbox. And if it somehow does slip through that and your email spam filter, having two&#8209;factor authentication in place will prevent the phishing attempt from being successful even if you do hand over your login&nbsp;credentials.</p>\n\n\n<p>As cyberthreats are constantly becoming more sophisticated, this layered strategy is extremely important.&nbsp;</p>\n\n\n<h2 class=\"wp-block-heading\">How Akismet&#8217;s spam protection complements email&nbsp;obfuscation</h2>\n\n<p>While email obfuscation can be an effective strategy for keeping your email address hidden from spambots, it’s not&nbsp;foolproof.</p>\n\n<p>The issue with email obfuscation is that it’s static. Once you implement it, all attackers have to do is figure out how you’re hiding your email and update their bots to account for it. Then this method won’t work anymore. You can keep updating your methods, but it’s tedious to have to stay a step ahead of potential threats at all&nbsp;times.</p>\n\n<p>That’s why Akismet’s spam protection is such a preferred choice. Akismet is a spam protection platform that analyzes incoming messages for common spam patterns and then blocks spam&nbsp;immediately.</p>\n\n<p>And the big difference is that it’s dynamic, not static. Akismet is powered by machine learning that’s been trained on a dataset of billions of pieces of spam. As spammers use new methods to evade filters, Akismet learns in real&#8209;time, updating itself to respond to new&nbsp;threats.</p>\n\n<p>And that’s all done without any input needed from you, or your visitors. Unlike CAPTCHA, which can slow down and annoy your users, Akismet runs non&#8209;intrusively in the&nbsp;background.</p>\n\n<p>As we mentioned, a layered cybersecurity strategy is the best way to keep spam, phishing, and malware far away from your website. And while email obfuscation alone is not enough to protect yourself, combining it with Akismet makes for the best way to safeguard your email address&nbsp;online.</p>\n\n<h2 class=\"wp-block-heading\">Real&#8209;world examples where Akismet has effectively reduced&nbsp;spam</h2>\n\n<p>Akismet has proven to be a powerful tool in the fight against spam, helping countless businesses and individuals alike protect themselves. 100 million sites have used Akismet to block <strong>more than 500 billion pieces of&nbsp;spam</strong>.</p>\n\n<p>We’ve released a few case studies showcasing real&#8209;world examples where Akismet has made a significant&nbsp;impact.</p>\n\n<p>One is the <a href=\"https://akismet.com/blog/convertkit-customerstory/\">ConvertKit case study</a>, which explores how the marketing platform protected over 400,000 creators from spam. Lower billing fees and less email reputation damage meant happier ConvertKit customers, and the switch to Akismet was a major success. It just proves how well Akismet works for <a href=\"https://akismet.com/enterprise/\">enterprise&#8209;grade&nbsp;anti&#8209;spam</a>.</p>\n\n\n<p>Akismet also helped <a href=\"https://akismet.com/blog/saying-no-to-spam-on-smitten-kitchens-popular-food-site/\">Smitten Kitchen</a> block 2.3 million pieces of spam. Major websites like this can end up with thousands of comments per post and no easy way to filter them manually.&nbsp;</p>\n\n\n\n<img width=\"1500\" height=\"1066\" src=\"https://akismet.com/wp-content/uploads/2024/10/image-4.png\" alt=\"comment sections on the Smitten Kitchen website\" class=\"wp-image-284221\" />\n\n\n<p>Thankfully, Akismet saved Smitten Kitchen from a spam disaster by blocking spam from ever reaching their&nbsp;inbox.</p>\n\n<h2 id=\"frequently-asked questions\" class=\"wp-block-heading\">Frequently asked&nbsp;questions</h2>\n\n\n<p>This article has covered what you need to know about email obfuscation and why it plays a key part in spam prevention. But in case you have any lingering questions, here are some answers to commonly asked questions about both email obfuscation and spam.&nbsp;</p>\n\n\n<h3 id=\"what-are-the-risks-associated-with-unprotected-email addresses\" class=\"wp-block-heading\">What are the risks associated with unprotected email&nbsp;addresses?</h3>\n\n<p>Failing to protect your email address leaves it vulnerable to spambots that crawl the web and capture them. Once your email is scraped, you can become a target for spam, phishing, and even brute force&nbsp;attacks.</p>\n\n<p>Besides filling your inbox with unwanted emails, you also risk losing your account if you fall for a phishing email or hackers manage to break&nbsp;in.</p>\n\n<h3 id=\"can-email-obfuscation-completely-prevent spam\" class=\"wp-block-heading\">Can email obfuscation completely prevent&nbsp;spam?</h3>\n\n<p>Email obfuscation can reduce the risk of your email address being collected, but it’s not 100% effective. Advanced bots can easily evade obfuscation tactics. That’s why it’s important to pair obfuscation with other security measures, like spam&nbsp;filters.</p>\n\n<h3 id=\"how-does-email-obfuscation-impact-the-user-experience-on-a website\" class=\"wp-block-heading\">How does email obfuscation impact the user experience on a&nbsp;website?</h3>\n\n<p>When done correctly, email obfuscation should have minimal impact on user experience. Users should still be able to see and copy your email address. But some methods, like using image&#8209;based obfuscation makes for a negative user experience that’s terrible for&nbsp;accessibility.</p>\n\n<h3 id=\"what-are-the-best-practices-for-implementing-email obfuscation\" class=\"wp-block-heading\">What are the best practices for implementing email&nbsp;obfuscation?</h3>\n\n<p>It’s best to avoid user&#8209;unfriendly obfuscation tactics like image&#8209;based email obfuscation, and instead use tactics like character replacement, JavaScript, or encoding. But the best way of all is to forgo posting your email and instead use a contact form with spam protection like what’s offered by&nbsp;Akismet.</p>\n\n<h3 id=\"how-can-i-also-protect-my-contact-forms-from spam\" class=\"wp-block-heading\">How can I also protect my contact forms from&nbsp;spam?</h3>\n\n<p>Akismet is a highly effective way to protect your contact forms from spam. Akismet automatically filters out spam submissions, ensuring that only legitimate messages reach your inbox. And since you’re using a contact form, your email is&nbsp;hidden.</p>\n\n<h3 id=\"how-accurate-is-akismet-at-stopping spam\" class=\"wp-block-heading\">How accurate is Akismet at stopping&nbsp;spam?</h3>\n\n<p>Akismet is incredibly accurate at identifying and filtering out spam. It’s actually 99.99% effective. It uses advanced algorithms and machine learning to detect a majority of spam. While no system is perfect, Akismet’s track record speaks for itself, with millions of spam messages blocked daily across millions of&nbsp;websites.</p>\n\n<h3 id=\"how-many-sites-use akismet\" class=\"wp-block-heading\">How many sites use&nbsp;Akismet?</h3>\n\n<p>Over 100 million sites worldwide use Akismet to protect their online presence from spam. Well&#8209;known brands like Microsoft, Bluehost, WordPress.com, and ConvertKit rely on Akismet to keep their platforms&nbsp;clean.</p>\n\n<h3 id=\"where-can-i-learn-more-about akismet\" class=\"wp-block-heading\">Where can I learn more about&nbsp;Akismet?</h3>\n\n<p>You can learn more about Akismet on our <a href=\"https://akismet.com/features/\">features page</a> and the rest of the website. This will explain everything you need to know about the platform. You can also check the <a href=\"https://akismet.com/pricing/\">pricing&nbsp;page</a>.</p>\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 13 Nov 2024 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jen Swisher\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"Do The Woo Community: Innovating with AI, a Journey from CTO to Entrepreneur with Aaron Edwards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=86840\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://dothewoo.io/innovating-with-ai-a-journey-from-cto-to-entrepreneur-with-aaron-edwards/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:189:\"Aaron Edwards shares his transition from WordPress CTO to founding DocsBot.ai, highlighting the importance of adapting to new technologies and iterative experimentation in entrepreneurship.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 13 Nov 2024 09:25:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress.org blog: WordPress 6.7 “Rollins”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18066\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2024/11/rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68911:\"<img width=\"1024\" height=\"535\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/11/Release-Edition-Featured-Image.png?resize=1024%2C535&ssl=1\" alt=\"\" class=\"wp-image-18085\" />\n\n\n\n<p>Each WordPress release celebrates an artist who has made an indelible mark on the world of music. WordPress 6.7, code-named &#8220;Rollins,&#8221; pays tribute to the legendary jazz saxophonist Sonny Rollins. Known as one of the greatest improvisers and pioneers in jazz, Rollins has influenced generations of musicians with his technical brilliance, innovative spirit, and fearless approach to musical expression.</p>\n\n\n\n<p>Sonny Rollins&#8217; work is characterized by its unmatched energy and emotional depth. His compositions, such as &#8220;St. Thomas,&#8221; &#8220;Oleo,&#8221; and &#8220;Airegin,&#8221; are timeless jazz standards, celebrated for their rhythmic complexity and melodic inventiveness. Rollins&#8217; bold and exploratory style resonates with WordPress&#8217; own commitment to empowering creators to push boundaries and explore new possibilities in digital expression.</p>\n\n\n\n<p>Embrace the spirit of innovation and spontaneity that defines Rollins&#8217; sound as you dive into the new features and enhancements of WordPress 6.7.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Welcome to WordPress 6.7!</h2>\n\n\n\n<p>WordPress 6.7 debuts the modern Twenty Twenty-Five theme, offering ultimate design flexibility for any blog at any scale. Control your site typography like never before with new font management features. The new Zoom Out feature lets you design your site with a macro view, stepping back from the details to bring the big picture to life.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/wordpress-6.7.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Download WordPress 6.7 “Rollins”</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Introducing Twenty Twenty-Five</h2>\n\n\n\n<h4 class=\"wp-block-heading\">Endless possibility without complexity</h4>\n\n\n\n<p>Twenty Twenty-Five offers a flexible, design-focused theme that lets you build stunning sites with ease. Tailor your aesthetic with an array of style options, block patterns, and color palettes. Pared down to the essentials, this is a theme that can truly grow with you.</p>\n\n\n\n<img src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-tt5-2.webp?ssl=1\" alt=\"\" />\n\n\n\n<h3 class=\"wp-block-heading\">Get the big picture with Zoom Out</h3>\n\n\n\n<h4 class=\"wp-block-heading\">Explore your content from a new perspective</h4>\n\n\n\n<p>Edit and arrange entire sections of your content like never before. A broader view of your site lets you add, edit, shuffle, or remove patterns to your liking. Embrace your inner architect.</p>\n\n\n\n<img src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-zoom-2.webp?ssl=1\" alt=\"\" />\n\n\n\n<h3 class=\"wp-block-heading\">Connect blocks and custom fields with no hassle (or code)</h3>\n\n\n\n<h4 class=\"wp-block-heading\">A streamlined way to create dynamic content</h4>\n\n\n\n<p>This feature introduces a new UI for connecting blocks to custom fields, putting control of dynamic content directly in the editor. Link blocks with fields in just a few clicks, enhancing flexibility and efficiency when building. Your clients will love you—as if they didn&#8217;t already.</p>\n\n\n\n<img src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-block-bindings-2.webp?ssl=1\" alt=\"\" />\n\n\n\n<h3 class=\"wp-block-heading\">Embrace your inner font nerd</h3>\n\n\n\n<h4 class=\"wp-block-heading\">New style section, new possibilities</h4>\n\n\n\n<p>Create, edit, remove, and apply font size presets with the next addition to the Styles interface. Override theme defaults or create your own custom font size, complete with fluid typography for responsive font scaling. Get into the details!</p>\n\n\n\n<img src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-font-presets-2.png?ssl=1\" alt=\"\" />\n\n\n\n<h3 class=\"wp-block-heading\">Performance</h3>\n\n\n\n<p>WordPress 6.7 delivers important performance updates, including faster pattern loading, optimized previews in the data views component, improved PHP 8+ support and removal of deprecated code, auto sizes for lazy-loaded images, and more efficient tag processing in the HTML API.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Accessibility</h3>\n\n\n\n<p>65+ accessibility fixes and enhancements focus on foundational aspects of the WordPress experience, from improving user interface components and keyboard navigation in the Editor, to an accessible heading on WordPress login screens and clearer labeling throughout.</p>\n\n\n\n<h3 class=\"wp-block-heading\">And much more</h3>\n\n\n\n<p>For a comprehensive overview of all the new features and enhancements in WordPress 6.7, please visit the feature-showcase website.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/download/releases/6-7/\">Check out what&#8217;s new</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.7</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> is a free resource for new and experienced WordPress users. Learn is stocked with how-to videos on using various features in WordPress, <a href=\"https://learn.wordpress.org/social-learning/\">interactive workshops</a> for exploring topics in-depth, and lesson plans for diving deep into specific areas of WordPress.</p>\n\n\n\n<p>Read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6.7\">WordPress 6.7 Release Notes</a> for information on installation, enhancements, fixed issues, release contributors, learning resources, and the list of file changes.</p>\n\n\n\n<p>Explore the <a href=\"https://make.wordpress.org/core/wordpress-6-7-field-guide/\">WordPress 6.7 Field Guide</a>. Learn about the changes in this release with detailed developer notes to help you build with WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.7 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly. The team that has led 6.7 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordinator: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a></li>\n\n\n\n<li>Core Tech Leads: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a></li>\n\n\n\n<li>Editor Tech Leads: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a></li>\n\n\n\n<li>Core Triage Leads: <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a></li>\n\n\n\n<li>Editor Triage Leads: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>,&nbsp;<a href=\"https://wordpress.org/support/users/colorful-tones/\">Damon Cook</a></li>\n\n\n\n<li>Documentation Leads: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a></li>\n\n\n\n<li>Test Lead: <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K. Gupta</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a></li>\n\n\n\n<li>Performance Lead: <a href=\"https://profiles.wordpress.org/adamsilverstein/\"></a><a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Default Theme Design Lead:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li>\n\n\n\n<li>Default Theme Development Leads:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>The mission of WordPress is to <a href=\"https://wordpress.org/about/\">democratize publishing</a> and embody the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.7 reflects the tireless efforts and passion of more than 780 contributors in countries all over the world. This release also welcomed over 230 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 340 enhancements and fixes, ensuring a stable release for all—a testament to the power and capability of the WordPress open source community.</p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/75thtrombone/\">75thtrombone</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aware/\">Aaron Ware</a> · <a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/ababir/\">Abir</a> · <a href=\"https://profiles.wordpress.org/acafourek/\">acafourek</a> · <a href=\"https://profiles.wordpress.org/adamkheckler/\">Adam Heckler</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adamwood/\">Adam Wood</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/adrian2k7/\">Adrian</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a> · <a href=\"https://profiles.wordpress.org/alessandrotesoro/\">Alessandro Tesoro</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">Alex Cuadra</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alex27/\">alex27</a> · <a href=\"https://profiles.wordpress.org/digitalex11/\">Alexander Frank</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/harlet7/\">Alexandru Horeanu</a> · <a href=\"https://profiles.wordpress.org/ali7ali/\">Ali Ali</a> · <a href=\"https://profiles.wordpress.org/aliaghdam/\">aliaghdam</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro G&#243;mez</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anthakkar08/\">Anand Thakkar</a> · <a href=\"https://profiles.wordpress.org/andergmartins/\">andergmartins</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andreiglingeanu/\">andreiglingeanu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankit k gupta/\">Ankit K. Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/the-ank/\">Ankur Vishwakarma</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/perezcarreno/\">Armando J. Perez Carreno</a> · <a href=\"https://profiles.wordpress.org/armandsdz/\">Armands</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/ambrosiawt/\">Art Smith</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/arypneta/\">arypneta</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/bjerke-johannessen/\">B&#229;rd Bjerke Johannessen</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/neoxx/\">Bernhard Riedl</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berubenic/\">berubenic</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai13/\">Bhavesh Desai</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">bijit027</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blindmikey/\">blindmikey</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdannikolic/\">Bogdan Nikolic</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/brentjettgmailcom/\">Brent Jett</a> · <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/bridgetwes/\">bridgetwes</a> · <a href=\"https://profiles.wordpress.org/brobken/\">brobken</a> · <a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a> · <a href=\"https://profiles.wordpress.org/cambabutonono/\">Cambabutonono</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/carstenbach/\">Carsten Bach</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/mchirag2002/\">Chirag Mathur</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/eclare/\">Chris Trynkiewicz (Sukces Strony)</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ckanitz/\">Christopher Kanitz</a> · <a href=\"https://profiles.wordpress.org/cpal/\">Christos Paloukas</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craynor/\">craynor</a> · <a href=\"https://profiles.wordpress.org/creativethemeshq/\">creativethemeshq</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/da5f656f/\">da5f656f</a> · <a href=\"https://profiles.wordpress.org/xendo/\">Dademaru</a> · <a href=\"https://profiles.wordpress.org/daleharrison/\">daleharrison</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/colorful tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/itsdanny/\">Danny</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">Dareth NHANG</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/daveagp/\">daveagp</a> · <a href=\"https://profiles.wordpress.org/fac3less/\">David</a> · <a href=\"https://profiles.wordpress.org/dballari/\">David Ballarin Prunera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/davidhbrown/\">David Brown</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/davidgodleman10up/\">David Godleman</a> · <a href=\"https://profiles.wordpress.org/dhenriet/\">David Henriet</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/ddewan/\">ddewan</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dekadinious/\">Dekadinious</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dsmart/\">Derek Smart</a> · <a href=\"https://profiles.wordpress.org/deryck/\">Deryck</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/devspace/\">devspace</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dimplemodi/\">dimplemodi</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divibanks/\">Divi Banks</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/djennez/\">djennez</a> · <a href=\"https://profiles.wordpress.org/cyberorca/\">Doni Kuntoro</a> · <a href=\"https://profiles.wordpress.org/dorzki/\">Dor Zuberi</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/eballeste/\">eballeste</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/beckej/\">Ed Beck</a> · <a href=\"https://profiles.wordpress.org/edithlb/\">Edith Milagros Loayza Barazorda</a> · <a href=\"https://profiles.wordpress.org/ejnwebmaster/\">ejnwebmaster</a> · <a href=\"https://profiles.wordpress.org/elfu98/\">elfu98</a> · <a href=\"https://profiles.wordpress.org/eliorivero/\">Elio Rivero</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/erichmond/\">Elliott Richmond</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanue ATS&#201;</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/emmanuel78/\">emmanuel78</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique S&#225;nchez</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/erikiva/\">erikiva</a> · <a href=\"https://profiles.wordpress.org/erikyo/\">erikyo</a> · <a href=\"https://profiles.wordpress.org/eroan/\">Eroan Boyer</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/fahimmurshed/\">FahimMurshed</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a> · <a href=\"https://profiles.wordpress.org/fayyazfayzi/\">Fayyaz</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fjorgemota/\">Fernando Jorge Mota (a11n)</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/fullworks/\">fullworks</a> · <a href=\"https://profiles.wordpress.org/gwallace87/\">Gale Wallace</a> · <a href=\"https://profiles.wordpress.org/gansbrest/\">gansbrest</a> · <a href=\"https://profiles.wordpress.org/garethelwell/\">Gareth Elwell</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gauravtiwari/\">Gaurav Tiwari</a> · <a href=\"https://profiles.wordpress.org/gauravsingh7/\">gauravsingh7</a> · <a href=\"https://profiles.wordpress.org/georgwordpress/\">Georg</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/germanfrelo/\">Germ&#225;n Freixin&#243;s</a> · <a href=\"https://profiles.wordpress.org/gmariani405/\">gmariani405</a> · <a href=\"https://profiles.wordpress.org/graemef/\">GraemeF</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greentreefrog/\">greentreefrog</a> · <a href=\"https://profiles.wordpress.org/greenworld/\">GreenWorld</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gyurmey/\">Gyurmey</a> · <a href=\"https://profiles.wordpress.org/priethor/\">H&#233;ctor Prieto</a> · <a href=\"https://profiles.wordpress.org/halilesen/\">Halil ESEN</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hjklemenz/\">Hans J&#246;rg Klemenz</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/plaidharper/\">Harper Holsinger</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hectorjarquin/\">hectorjarquin</a> · <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hirschferkel/\">hirschferkel</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/kardi420/\">Ibrahim</a> · <a href=\"https://profiles.wordpress.org/ibrahimriaz/\">Ibrahim Riaz</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itapress/\">itapress</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/smithjw1/\">Jacob Smith</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/jtgreyd/\">Jakob Trost</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesosborne/\">James Osborne</a> · <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a> · <a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a> · <a href=\"https://profiles.wordpress.org/janpfeil/\">Jan Pfeil</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jasonbahl/\">Jason Bahl</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javad2000/\">javad2000</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jawadwp/\">Jawad Malik</a> · <a href=\"https://profiles.wordpress.org/topdownjimmy/\">Jay</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/drjosh07/\">jbrya029</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jenilk/\">Jenil Kanani</a> · <a href=\"https://profiles.wordpress.org/jennifarhat/\">Jennifer Farhat</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a> · <a href=\"https://profiles.wordpress.org/skobe/\">Jesko Bendmann</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jetaldobariya1/\">Jetal dobariya</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jimmyh61/\">jimmyh61</a> · <a href=\"https://profiles.wordpress.org/joemoto/\">Joe Cartonia</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/elbsegler/\">Jonas</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnywatersbb/\">Jonny Waters</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/julianoe/\">julianoe</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junedsabaliya/\">Juned Sabaliya</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/jzern/\">jzern</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">Kaavya Iyer (woo-hc)</a> · <a href=\"https://profiles.wordpress.org/arkenon/\">Kadim G&#252;ltekin</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kamran8176/\">Kamran Hussen</a> · <a href=\"https://profiles.wordpress.org/karan4word/\">Karan Gupta</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/kartikmehta/\">Kartik Mehta</a> · <a href=\"https://profiles.wordpress.org/kartik-suthar/\">Kartik Suthar</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd (a11n)</a> · <a href=\"https://profiles.wordpress.org/keffr3n/\">Keffr3n</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kevinswalsh/\">kevinswalsh</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kisquian/\">kisquian</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/kracked888/\">kracked888</a> · <a href=\"https://profiles.wordpress.org/krishneup/\">Krishna Neupane</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/gohelkunjan/\">Kunjan Gohel</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a> · <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/laranz/\">Lawrence Joe</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lifelightweb/\">lifelightweb</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/crixu/\">Lucas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a> · <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/nadimcse/\">Mahmudul Haque Nadim</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/manbo/\">manbo</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/targz-1/\">Manuel Schmalstieg</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/marianguas/\">Mar&#237;a Anguas</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/mardroid/\">Marcel Tannich</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcwieland95/\">marcwieland95</a> · <a href=\"https://profiles.wordpress.org/igreenie/\">Marek Železn&#253;</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a> · <a href=\"https://profiles.wordpress.org/mat_/\">mat_</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/lonelyvegan/\">Matthew Riley MacPherson</a> · <a href=\"https://profiles.wordpress.org/kittmedia/\">Matthias Kittsteiner</a> · <a href=\"https://profiles.wordpress.org/mattraines/\">mattraines</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mcrisp1972/\">mcrisp1972</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/istiaqhossain/\">Md. Istiaq Hossain</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meteorlxy/\">meteorlxy</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a> · <a href=\"https://profiles.wordpress.org/michaelpick/\">michaelpick</a> · <a href=\"https://profiles.wordpress.org/michaelwp85/\">michaelwp85</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mielbu/\">Michelle Bulloch</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ppolo99/\">Mike Poland</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikeb8s/\">mikeb8s</a> · <a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a> · <a href=\"https://profiles.wordpress.org/milamj/\">milamj</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mklusak/\">mklusak</a> · <a href=\"https://profiles.wordpress.org/mleathem/\">mleathem</a> · <a href=\"https://profiles.wordpress.org/mlf20/\">mlf20</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mossy2100/\">mossy2100</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir a11n</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/nebojsajurcic/\">Neboj&#353;a Jurčić</a> · <a href=\"https://profiles.wordpress.org/nek285/\">nek285</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">neo2k23</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickbohle/\">Nick Bohle</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nurielmeni/\">nurielmeni</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olivierlafleur/\">Olivier Lafleur</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/oscarhugopaz/\">Oscar Hugo Paz</a> · <a href=\"https://profiles.wordpress.org/prestonwordsworth/\">p15h</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/otakupahp/\">Pablo Hern&#225;ndez</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pamprn/\">Pamela Ribeiro</a> · <a href=\"https://profiles.wordpress.org/pander/\">pander</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/obrienlabs/\">Pat O\'Brien</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a> · <a href=\"https://profiles.wordpress.org/paulcline/\">paulcline</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a> · <a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/pevogam/\">pevogam</a> · <a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pgeorgiev/\">Plamen Georgiev</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a> · <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/spanglishwebs/\">Rachel Winspear</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Gallani</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rahmatgumilar/\">Rahmat Gumilar</a> · <a href=\"https://profiles.wordpress.org/rahulharpal/\">rahulharpal</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/shashwatahalder01/\">Rajkumar Shashwata Halder</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ramswarup/\">Ramswarup Rathod</a> · <a href=\"https://profiles.wordpress.org/xyulex/\">Raul Martinez</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/rcneil/\">rcneil</a> · <a href=\"https://profiles.wordpress.org/realthemes/\">realthemes</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/reputeinfosystems/\">reputeinfosystems</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rhellewellgmailcom/\">Rick Hellewell</a> · <a href=\"https://profiles.wordpress.org/riddhipatel/\">Riddhi Patel</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rithik56/\">rithik56</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robert-biswas/\">Robert Biswas</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/rocketworks/\">rocket.works - Dominik Friedrich</a> · <a href=\"https://profiles.wordpress.org/rodelgc/\">Rodel Calasagsag a11n</a> · <a href=\"https://profiles.wordpress.org/rghedin/\">Rodrigo</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Woln&#253;</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roygbyte/\">roygbyte</a> · <a href=\"https://profiles.wordpress.org/royho/\">royho</a> · <a href=\"https://profiles.wordpress.org/rpf5573/\">rpf5573</a> · <a href=\"https://profiles.wordpress.org/rslee/\">rslee</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rleeson/\">Ryan Leeson</a> · <a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">S&#233;rgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren W&#252;nsch</a> · <a href=\"https://profiles.wordpress.org/sadmansh/\">sadmansh</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sahiladit/\">sahiladit</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samtoohey93/\">Sam Toohey</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/samuelsilvapt/\">Samuel Silva</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scottculverhouse/\">scottculverhouse</a> · <a href=\"https://profiles.wordpress.org/seanavers/\">seanavers</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/kuuuzya/\">Sergey</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/zahardoc/\">Serhiy Zakharchenko</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/severinepozzo/\">Severine Pozzo</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/sharonaustin/\">Sharon Austin</a> · <a href=\"https://profiles.wordpress.org/sheulyshila/\">SheulyShila</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/showravhasan/\">Showrav Hasan</a> · <a href=\"https://profiles.wordpress.org/shreya0204/\">Shreya Agarwal</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/silaskoehler/\">Silas K&#246;hler</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sophiegy/\">Sophie - a11n</a> · <a href=\"https://profiles.wordpress.org/souptik/\">Souptik Datta</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/thompsonsj/\">Steven Thompson</a> · <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a> · <a href=\"https://profiles.wordpress.org/styleshit/\">styleshit</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">Sunil Prajapati</a> · <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a> · <a href=\"https://profiles.wordpress.org/superchlorine/\">superchlorine</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/jannathsyeda/\">Syeda Fahima Jannath</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tdrayson/\">tdrayson</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tmanoilov/\">tmanoilov</a> · <a href=\"https://profiles.wordpress.org/toastercookie/\">toastercookie</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomasdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomllobet/\">Tomas Llobet-Arany</a> · <a href=\"https://profiles.wordpress.org/tomhine/\">tomhine</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/vertisoft/\">vertisoft</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Sz&#233;pe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/wbdv/\">wbdv</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webwurm/\">webwurm</a> · <a href=\"https://profiles.wordpress.org/wesrapyd/\">wesrapyd</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williamalexander/\">William Alexander</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/wpeople/\">WPeople</a> · <a href=\"https://profiles.wordpress.org/wpnoman0/\">wpnoman0</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wzieba/\">wzieba</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/yowangdu/\">YoWangdu</a> · <a href=\"https://profiles.wordpress.org/ytfeldrawkcab/\">ytfeLdrawkcaB</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zitaruksergij/\">zitaruksergij</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<p>More than <a href=\"https://translate.wordpress.org/stats/\">40 locales have fully translated</a> WordPress 6.7 into their language making this one of the most translated releases ever on day one. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Get involved</h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding, and learning more and getting involved is easy. Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a> and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 21:35:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"WPTavern: Automattic Launches ‘WP Engine Tracker’ to Monitor Sites Leaving WP Engine, Sparking Controversy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=179470\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://wptavern.com/automattic-launches-wp-engine-tracker-to-monitor-sites-leaving-wp-engine-sparking-controversy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5822:\"<p>The ongoing WordPress-WP Engine dispute has escalated with Automattic launching a new website &#8211; <a href=\"https://wordpressenginetracker.com/\">WP Engine Tracker</a>, to track the number of websites leaving WP Engine hosting.</p>\n\n\n\n<p>“An Automattic thingamajig,” this website tracks WP Engine hosting migrations from September 21, 2024, and also provides a downloadable CSV list of websites currently hosted on WP Engine, dubbed “sites ready for a new home.”</p>\n\n\n\n<p>Other details on this single-page website include links to <a href=\"https://wordpress.org/news/2024/10/wp-engine-promotions/\">promotions</a> offered by other hosting providers for migrating from WP Engine and the number of websites each hosting provider gained via migration. Pressable is the top gainer, followed by Bluehost and SiteGround.&nbsp;</p>\n\n\n\n<a href=\"https://x.com/WordPress/status/1854271844309684285\"><img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXfs6RSLk07o0BhMxybcYgIiAjVM6pgF0UiehAbRc1-X_Jkihc5BXOEsKLZ67X4z333Qo-2-U1wRtte4T5vxPAJD_zGs1sf9PWkxJTbS0X_O4ijVutcF6sCpAu-9mlp_lqCbDpIoDw?key=LpNsXrCc-NEhL-PqP_-S_5CU\" alt=\"\" /></a>\n\n\n\n<p>Ironically, the site&#8217;s URL is wordpressenginetracker.com as the whole WordPress-WP Engine dispute started with Matt accusing the hosting company of misusing the WordPress trademark. Also Automattic had <a href=\"https://wptavern.com/automattic-and-matt-mullenweg-push-for-dismissal-of-key-claims-in-wp-engine-lawsuit\">opposed</a> WP Engine’s lawsuit claiming their <a href=\"https://automattic.com/wp-content/uploads/2024/10/opposition-to-preliminary-injunction.pdf\">allegations regarding lost customers</a> should be viewed with skepticism.&nbsp;</p>\n\n\n\n<p><a href=\"https://www.searchenginejournal.com/cloudflare-blocks-automattics-wp-engine-tracker-for-phishing/532244/\">Search Engine Journal</a> reported that the website was blocked by Cloudflare for &#8220;suspected phishing,&#8221; but it is now up. It <a href=\"https://www.searchenginejournal.com/wpengine-tracker-domain-protest-site/532253/\">also reported</a> about someone registering the domain name <a href=\"http://wpenginetracker.com\">WPEngineTracker.com</a>.</p>\n\n\n\n<a href=\"https://wpenginetracker.com/\"><img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXeDl2uHqqXyd1eRG1-27QU1sfZQeMZpCSSwUqOCdqx6wap8FWPYcyiVjohWnPORVldwEU4ZHN5TcntIXJR18a3CocU8fLEx-nXwYk72jLrUZ7wpYxQBiQ5BagG61Mk01vIXVwE2sw?key=LpNsXrCc-NEhL-PqP_-S_5CU\" alt=\"\" /></a>\n\n\n\n<a href=\"https://github.com/wordpressenginetracker/wordpressenginetracker.github.io/issues/6#issuecomment-2463027472\"><img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXdDLhQruoamTpBlRZOaA1fc-9rl9f1Ban1pafy7hiQTUo4oxgX5RTaF2PTOZsDrIDJjEsGq1se6fqLqUjIjFYpTr_ll7RBPbIJO5S9rTUI2qbp5MhjCayOivn7CuAaVHkfOUYia_w?key=LpNsXrCc-NEhL-PqP_-S_5CU\" alt=\"\" /></a>\n\n\n\n<p><a href=\"https://x.com/WordPress/status/1854271844309684285\"></a>Eric Karkovack of The WP Minute <a href=\"https://x.com/karks88/status/1854610815330271588\">tweeted</a>, “Sort of like Ford tracking everyone who switched from Chevy. Doesn&#8217;t matter to me, I&#8217;m a Honda guy.” WordPress developer Brian Coords <a href=\"https://x.com/briancoords/status/1855286440537841792\">shared</a> this: “This has nice design/dev, but it&#8217;s sad to see talent and resources poured into increased negativity in the community, criticism without substance, tearing down instead of building up. Just sad that&#8217;s what WordPress is becoming a symbol for.”</p>\n\n\n\n<p>Security researcher Daniel Ruf dubbed it “amateurish”. He <a href=\"https://github.com/wordpressenginetracker/wordpressenginetracker.github.io/issues/3#issuecomment-2461388912\">continued</a>, “I&#8217;m not sure what the goal of this website is and what Matt tries to achieve. But the community is getting increasingly annoyed of such unprofessional behavior of Matt and in the security community some also think about dropping 0days for WordPress and related plugins/themes due to this whole situation. The feedback under the tweet from the official WordPress account and in the reddit community shows, what most of us think. The whole situation hurts everyone more than needed.”</p>\n\n\n\n<p>Another person <a href=\"https://news.ycombinator.com/item?id=42074721\">commented</a>, “So Automattic has put together a list for spammers and hackers to use to target a bunch of sites who are no longer doing business with Matt Mullenweg’s nemesis. That’s… shortsighted. This will surely result in legal action from one or more of these sites?”&nbsp;</p>\n\n\n\n<p>As of November 12, 18,280 websites have left WP Engine according to this website. </p>\n\n\n\n<p><strong>Update: </strong>An Automattic spokesperson shared this with us, &#8220;“The beauty of open source software is that everyone is able to access data on a granular level, because it’s all publicly available information. That public data has shown that ever since WP Engine filed its lawsuit – making it clear that they do not have an official association with WordPress and attracting greater attention to the company’s poor service, modifications to the WordPress core software, increasing and convoluted pricing structure, and repeated down times – their customers have left their platform for other hosting providers. WP Engine can and always has been able to access the WordPress software and plugins available on WordPress.org, as can anyone.”</p>\n\n\n\n<p>Automattic also <a href=\"https://x.com/automattic/status/1856034544115429655\">tweeted </a>this, &#8220;We got the domains list from several third-party sources, not from .org. It&#8217;s pretty easy for anyone to do with services like W3techs, Builtwith, etc, you could recreate the same with a few hours of work and a few hundred dollars. These are all public sites in DNS.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 19:25:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: Design Team Unveils New WordPress Design System Figma Library\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=179442\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wptavern.com/design-team-unveils-new-wordpress-design-system-figma-library\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2643:\"<p>Automattician James Koster has <a href=\"https://make.wordpress.org/design/2024/11/07/announcing-the-new-wordpress-design-system-figma-library/\">announced the launch</a> of a new WordPress Design System library for Figma, the popular tool the design team uses to create mockups and prototypes for WordPress. “The intention of this resource is to streamline the design process for folks working in the WordPress ecosystem,” he explained. </p>\n\n\n\n<p>The design library offers a comprehensive range of components, including buttons, forms, icons, and menus, bringing everything you need into one place. It also includes style tokens that allow you to easily manage visual details like radius, elevation, color, and typography. For added convenience, the library provides handy stickers for individual components, and more extensive UI elements like the full-screen editor and site editor.</p>\n\n\n\n<p>James also revealed that the “intention is to publish a new version of the library in line with each Gutenberg release, and from 6.8 each major WordPress release too.”</p>\n\n\n\n<p>For WordPress Design Team members, the library will be automatically enabled in all new design files within the WordPress.org community Figma organization. Designers working in other Figma organizations can access it by duplicating the file from the community page and publishing it in their own organization.</p>\n\n\n\n<p>For those new to Figma, the WordPress Design Team recommends checking out Figma&#8217;s &#8220;Learn&#8221; platform, which offers a comprehensive &#8220;<a href=\"https://help.figma.com/hc/en-us/categories/360002051613-Get-started\">Get Started</a>&#8221; section to help users become familiar with the tool.</p>\n\n\n\n<p>You can leave your feedback in the <a href=\"https://www.figma.com/design/804HN2REV2iap2ytjRQ055/WordPress-Design-System?node-id=2799-26256&node-type=canvas\">source file</a> or on the <a href=\"https://github.com/WordPress/gutenberg\">Gutenberg repository on GitHub</a>.&nbsp;</p>\n\n\n\n<p>The community has responded positively to the new library. WordPress committer Tammie Lister <a href=\"https://x.com/karmatosed/status/1854789281933308098\">shared</a>, “It also is a step towards the true design system needed. Figma is a part of the system, but an important piece when updated regularly.” </p>\n\n\n\n<p>Courtney Robertson, Open Source Developer Advocate at GoDaddy, <a href=\"https://x.com/courtneyr_dev/status/1855676450394808746\">tweeted</a>, “#WordPress just stepped up its design game with a brand-new Figma Library as part of its Design System. Designers, it’s time to explore a more seamless workflow!”. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 16:38:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"Do The Woo Community: Strategies for Selecting Effective Marketing Channels with Afshana Diya\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=86803\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://dothewoo.io/strategies-for-selecting-effective-marketing-channels-with-afshana-diya/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:231:\"In this episode of Woo BizChat, Katie Keith and Afsaneh Diya discuss effective marketing strategies for WooCommerce and WordPress businesses, emphasizing audience understanding, community engagement, and diverse marketing channels.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 09:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: RIP Quincy Jones\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=129636\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://ma.tt/2024/11/rip-quincy-jones/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3206:\"<p>Quincy Jones had such an impact on the culture that it&#8217;s impossible to summarize. <a href=\"https://en.wikipedia.org/wiki/Quincy_Jones_production_discography\">His discography is amazing</a>. I feel so lucky to have met him in 2012 when I was much earlier in my career, and he didn&#8217;t have any reason to give me time, but he treated everyone as if they were important. We talked a lot about his Count Basie and Frank Sinatra days. If you&#8217;re unfamiliar with him, <a href=\"https://www.netflix.com/title/80102952\">the Quincy documentary on Netflix is a good start</a>. His musical fingerprints are everywhere, including the super-catchy theme songs for <a href=\"https://open.spotify.com/track/5zyrFDT1xa91xTShK6etQ8?si=aab3f9fd6b114881\">Sanford and Sons</a> and <a href=\"https://open.spotify.com/track/0Jw3cPBXlGnA6DEJrZSTI0?si=8b0773b2ef16409a\">Austin Powers</a>.</p>\n\n\n\n<img width=\"604\" height=\"402\" src=\"https://i0.wp.com/ma.tt/files/2012/09/MCM_4579-1024x681.jpg?resize=604%2C402&ssl=1\" alt=\"\" class=\"wp-image-43056\" />\n\n\n\n<p>He passed away last week, on November 3<sup>rd</sup>. As a tribute, here are ten albums he was involved in from the jazz side that have been big parts of my life. I&#8217;ll link to Spotify, but find them wherever you can:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><a href=\"https://open.spotify.com/album/2m0W0n7zBYmRNs1QAgoa6Z?si=w0HA3i5yReWoOAKgAFFwBg\">Sinatra at the Sands</a>, Quincy arranges and directs the Count Basie band. This live album is great to listen to, you also get Frank doing stand-up comedy. </li>\n\n\n\n<li><a href=\"https://open.spotify.com/album/5lXF6AFeXG8UsIUfBJNsNH?si=UtcgbyAwSOOLQlml_UuJIQ\">It Might As Well Be Swing</a>, Frank Sinatra.</li>\n\n\n\n<li><a href=\"https://open.spotify.com/album/18JHKcwCBtOfCGmOB7hXx8?si=XBdTKfEcSeeZs-jv02C_Yw\">Julian &#8220;Cannonball&#8221; Adderley</a>.</li>\n\n\n\n<li><a href=\"https://open.spotify.com/album/5DDLqs1JsR7ZfnuoqLL5dB?si=N0fAf0qYSw2Hm2V2A5j0rA\">Sonny Stitt Plays Arrangements from the Pen of Quincy Jones</a>.</li>\n\n\n\n<li><a href=\"https://open.spotify.com/album/752AJr22BFy9yubj4XJauv?si=jVCG1rGERQeQhQOuOfODUw\">Ella and Basie</a>.</li>\n\n\n\n<li><a href=\"https://open.spotify.com/album/4GFWnwli2cVOBp2G1zqhV1?si=Mhk0Jo8vQ0KYOugXPPSpVw\">The Genius of Ray Charles</a>.</li>\n\n\n\n<li><a href=\"https://open.spotify.com/album/79co4mGqrQdDK93j5ZuqH2?si=Q_ZupFpfSDKnXU8jN-jg9Q\">For Those in Love, Dinah Washington</a>.</li>\n\n\n\n<li><a href=\"https://open.spotify.com/album/3J6gCSiLOWrRjSY8xqpvkV?si=qrCG7mlpTxWFI3HFWcHC_g\">Dizzy and Strings, Dizzy Gillespie</a>.</li>\n\n\n\n<li><a href=\"https://open.spotify.com/album/5ioLlvIO3CZOmxvsQmGRZ4?si=yq6JeWoASEigUQHgmMNw8w\">Quincy Here We Come, Benny Bailey</a>. (The track Meet Benny Bailey has an <a href=\"https://open.spotify.com/album/7AurSRjfOYfUD9sWSi4MV1?si=cSvdBmZGQKG4qMWSO2kEzA\">excellent tribute on Manhattan Transfer&#8217;s Vocalese</a>.)</li>\n\n\n\n<li><a href=\"https://open.spotify.com/album/7MGttcftncXXItvutjK9dM?si=VKNQsJlOTvWh39sdqmXnOg\">Social Call, Betty Carter</a>.</li>\n</ol>\n\n\n\n<p>I put all ten into <a href=\"https://open.spotify.com/playlist/4BVr7ZF2X5p2RZ433VliiT?si=c8ce164132e74aac\">one Spotify playlist if you want to check them all out</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 05:57:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Gravatar: 7 Actionable Steps to List Your Social Media Handles Effectively\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2412\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://blog.gravatar.com/2024/11/11/how-to-list-social-media-handles/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21771:\"<p>Social media handles are your digital name tags – they help people find and connect with you across every platform. When chosen and used strategically, these identifiers do more than just label your accounts; they make your brand more recognizable and help grow your following.&nbsp;</p>\n\n\n\n<p>From major corporations to personal brands, the right social media handle can be the difference between getting lost in the crowd and standing out online. These handles are like a unique fingerprint across platforms, and their presentation on business cards, websites, product packaging, and marketing materials can leave a lasting impression.</p>\n\n\n\n<p>While it may sound like a simple thing, there is a strategy to it, and we’re here to show you exactly that. This guide walks you through seven actionable steps to list your social media handles effectively.&nbsp;</p>\n\n\n\n<p>From crafting consistent handles to harnessing modern tools like QR codes and integrating your profiles into video content, you&#8217;ll discover practical strategies to boost your brand&#8217;s following and make your social profiles easily accessible.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 1: Choose consistent and memorable social media handles</strong></h2>\n\n\n\n<p>Being consistent with your social media handles builds recognition and allows your audience to find you across different platforms. Think of your handle as your digital signature – the more consistent it is, the more memorable you become.</p>\n\n\n\n<p>Inconsistent handles, on the other hand, could confuse your audience. Imagine a small business called &#8220;Green Leaf Gardens,&#8221; which has different handles on each platform:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Instagram: @greenleafgardens</li>\n\n\n\n<li>Twitter: @GLGardens2023</li>\n\n\n\n<li>Facebook: @greenleaflandscaping</li>\n\n\n\n<li>TikTok: @thegardeningexperts</li>\n\n\n\n<li>LinkedIn: @green-leaf-gardens-llc</li>\n</ul>\n\n\n\n<p>The mix of abbreviations, numbers, and different business names confuses potential customers and dilutes brand recognition. Using @greenleafgardens consistently (or a close variation if the exact handle isn&#8217;t available) would create a stronger, more memorable online presence.</p>\n\n\n\n<p>So, how can you prevent that?&nbsp;</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>Pick a handle that&#8217;s up for grabs on all the platforms that matter to you. </strong>We&#8217;re talking Instagram, <a href=\"https://twitter.com/\">Twitter (now X)</a>, <a href=\"https://www.facebook.com/\">Facebook</a>, <a href=\"https://www.linkedin.com/\">LinkedIn</a>, <a href=\"https://www.tiktok.com/\">TikTok</a>, and any niche networks where your audience hangs out.</li>\n\n\n\n<li><strong>Keep it short and sweet.</strong> The simpler your handle, the easier it is to remember and type.</li>\n\n\n\n<li><strong>Make sure it reflects your brand. </strong>Your handle should give people a taste of who you are or what you do.</li>\n</ol>\n\n\n\n<p><strong><img src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/1f4a1.png\" alt=\"💡\" class=\"wp-smiley\" />Pro tip:</strong> <em>Start with the social platforms where your audience spends most of their time. But don&#8217;t stop there – grab your handle on emerging platforms, too, even if you&#8217;re not ready to use them yet – you might need them in the future.</em></p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Use Namechk and KnowEm to ensure handle availability</strong></h3>\n\n\n\n<p>Before you commit to a handle, take it for a test drive. Free tools like <a href=\"https://namechk.com/\">Namechk</a> or <a href=\"https://chromewebstore.google.com/detail/knowem-social-media-usern/mbkgomeeoffmnhnkmngelnbfbhoggmpm\">KnowEm</a> can show you if your dream handle is available across multiple social media platforms and domains.&nbsp;</p>\n\n\n\n<p>If your first-choice handle is taken, don&#8217;t panic. Get creative with variations that still keep your <a href=\"https://blog.gravatar.com/2024/04/10/personal-branding-tools/\">brand identity</a> intact. Maybe add your location or an industry keyword. For example, @JohnDoeBakeryNYC tells people who you are, what you do, and where you&#8217;re based.</p>\n\n\n\n<p>And here&#8217;s a crucial step many folks overlook: <strong>check for potential trademark issues</strong>. The last thing you want is a legal headache down the road. A quick search of your local trademark office can save you a world of trouble.</p>\n\n\n\n<p><strong><img src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/1f4a1.png\" alt=\"💡\" class=\"wp-smiley\" />Pro tip:</strong> <em>If you&#8217;re unsure about potential trademark conflicts, it&#8217;s worth chatting with a legal pro specializing in intellectual property.</em></p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 2: Optimize handles for each platform&#8217;s format</strong></h2>\n\n\n\n<p>Each social media platform has its own handle requirements that you need to be aware of.&nbsp;</p>\n\n\n\n<p>For example, the <strong>character limitations are different</strong>. Twitter (now X) has a 15-character limit, while Instagram gives you a bit more breathing room with 30 characters. LinkedIn takes a different approach, using URLs like linkedin.com/in/username without the &#8220;@&#8221; symbol.&nbsp; Sometimes, you might need to tweak your handle slightly to fit a platform&#8217;s requirements. That&#8217;s okay, but try to keep it as close to your brand name as possible.&nbsp;</p>\n\n\n\n<p>Now, let&#8217;s talk symbols. On most platforms – Twitter, Instagram, TikTok – your handle starts with an &#8220;@&#8221; symbol. It&#8217;s like a universal &#8220;hey, this is a social media handle&#8221; sign. However, platforms like LinkedIn and Facebook often skip the &#8220;@&#8221; and use the full profile URL instead.</p>\n\n\n\n<p>Here&#8217;s a hot tip: <strong>avoid unnecessary symbols or numbers in your handle</strong> unless they&#8217;re essential to your brand identity. Sure, @JaneDoe_123_NYC might be available, but it&#8217;s a mouthful to say out loud and a pain to type. Keep it clean and simple.</p>\n\n\n\n<p>Different platforms have different purposes, and your handle should adapt accordingly. LinkedIn, for instance, is all about professional networking. So, your handle there might be more formal than your fun, casual Instagram handle.&nbsp;</p>\n\n\n\n<p>Finally, don&#8217;t forget to create a custom URL where possible. On LinkedIn or Facebook, you can often set up a custom URL (like linkedin.com/in/YourBrandName) that aligns closely with your handles on other platforms. It&#8217;s an easy way to keep your brand consistent across the board.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 3: Display social media handles on marketing materials creatively</strong></h2>\n\n\n\n<p>Your marketing materials are a great opportunity to plug your social media handles and are often the first thing people look for in business cards, brochures, and product packages. Here&#8217;s how to make the most of it:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Use clear, readable fonts: </strong>Choose fonts that are easy on the eyes, especially for smaller spaces like business cards, and make your handles stand out without overwhelming the design.</li>\n\n\n\n<li><strong>Incorporate social media icons: </strong>Place recognizable icons (Facebook, Instagram, Twitter, etc.) next to your handles and in your email signatures. They have to be high-resolution and align with your overall branding.</li>\n\n\n\n<li><strong>Showcase handles on product packaging:  </strong>If you sell physical products, use that space to encourage social engagement. For example, you can include your handles with a call-to-action like &#8220;Tag us on Instagram!&#8221;</li>\n\n\n\n<li><strong>Leverage event materials: </strong>Print your social handles on banners, posters, and promotional merchandise. You could also use items like T-shirts or tote bags to encourage attendees to follow you online.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 4: Display your social handles in one place with Gravatar</strong></h2>\n\n\n\n<p>Promoting your social media handles across platforms can complicate things for your target audience, so the best course of action is to use a centralized page where they can find everything.&nbsp;</p>\n\n\n\n<p><a href=\"https://gravatar.com/\">Gravatar</a> is a free tool that lets you create a dynamic profile and include different types of information for your audience to see, including your verified social media profiles and other important links.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"333\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-profile-links-new-2.png?w=660\" alt=\"Gravatar verified accounts section\" class=\"wp-image-2415\" />\n\n\n\n<p>The most important feature of Gravatar is its automatic synchronization – update your profile in one place, and it will reflect across all connected platforms, which includes <a href=\"https://slack.com/\">Slack</a>, <a href=\"https://openai.com/\">OpenAI</a>, <a href=\"http://wordpress.com\">WordPress.com</a>, <a href=\"https://github.com/\">GitHub</a>, and more! </p>\n\n\n\n<p>On top of that, Gravatar allows you to verify your accounts, adding a layer of trust and authority. This is especially valuable for online personalities, entrepreneurs, CEOs, artists, and other professionals.&nbsp;</p>\n\n\n\n<p>In short, this is the perfect place for you to add all your social handles and easily share them across your website, email signatures, business cards, and marketing materials. You can do this by adding your <a href=\"https://blog.gravatar.com/2024/06/26/link-your-gravatar-profile-with-a-free-custom-domain/\">personal Gravatar .link URL</a> or generating a QR code directly from the platform.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"436\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-qr-code.png?w=660\" alt=\"Gravatar QR code\" class=\"wp-image-2416\" />\n\n\n\n<p>This can be extremely useful as it provides users with instant access to all your verified social profiles with one quick scan.</p>\n\n\n\n<p>Gravatar lets you create a cohesive, professional online presence that boosts your brand&#8217;s visibility and credibility. It ensures that your audience knows they&#8217;re connecting with the real you, no matter which platform they&#8217;re on.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 5: Leverage QR codes to simplify access</strong></h2>\n\n\n\n<p>Speaking of QR codes, here&#8217;s how to utilize them effectively.&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Use reliable, free QR code generators</strong> such as <a href=\"https://www.qr-code-generator.com/\">QR Code Generator</a>, <a href=\"https://scanova.io/\">Scanova</a>, or <a href=\"http://bit.ly\">Bit.ly</a> to create scannable links for individual platforms or a single page listing all your profiles (e.g., a Gravatar profile or <a href=\"https://blog.gravatar.com/2024/10/21/linktree-alternatives/\">Linktree page</a>). As noted above, if you have a Gravatar profile, you get a QR code for free and won’t have to use external tools. </li>\n\n\n\n<li><strong>Always test your QR codes</strong> before implementation to ensure they direct users to the correct destination.</li>\n</ul>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Include QR codes in physical assets</strong> like business cards, product packaging, in-store displays, printed advertisements, and flyers.</li>\n\n\n\n<li><strong>Develop platform-specific QR codes. </strong>If your target audience favors different social networks, create separate QR codes for each platform. Alternatively, use a single QR code to direct people to a central page listing all your social handles.</li>\n\n\n\n<li><strong>Opt for dynamic QR codes when possible. </strong>Unlike static codes, dynamic versions can be updated after printing, providing flexibility if you need to change the destination link. This feature lets you modify your digital information without reprinting materials if you update your social handles.</li>\n</ul>\n\n\n\n<p>Remember, QR codes are most effective when paired with clear instructions and a compelling reason to scan. Provide context for what users will gain by scanning – whether it&#8217;s access to exclusive content, special offers, or a comprehensive view of your social profiles.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 6: List social media handles on your website and landing pages</strong></h2>\n\n\n\n<p>Your website and landing pages are prime real estate for showcasing your social media handles. By strategically integrating these handles, you can create a true connection between your web presence and social profiles.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Include social media icons in key website locations</strong></h3>\n\n\n\n<p>Social media icons are a standard and effective method to display your handles on your website. These icons typically link directly to your social profiles, allowing visitors to follow you with a single click, which is why it’s good to place them in prominent areas like the header, footer, and contact sections of your website. This ensures visitors can easily access your handles regardless of which page they&#8217;re on.</p>\n\n\n\n<p>It’s also recommended that you use branded, recognizable icons to maintain a professional appearance and keep the user experience consistent. Still, make sure that they fit your website&#8217;s <a href=\"https://blog.gravatar.com/2024/06/05/user-profile-page-examples/\">design and color scheme</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Embedding live social media feeds</strong></h3>\n\n\n\n<p>Display live content from various platforms, such as Instagram posts, Twitter/X updates, or TikTok videos on strategic pages. For example, if you’re a food blogger, you could include an instagram feed with mouth-watering content that will entice people to follow you there.&nbsp;</p>\n\n\n\n<p>What’s important here is to make it as easy as possible for readers to find you, and the best way to do this is through CTA buttons. Place them at the end of blog posts, on product pages, or in pop-ups. Direct visitors to your social platforms with clear, actionable prompts.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Optimize social media links for mobile users</strong></h3>\n\n\n\n<p>With a significant portion of web traffic coming from mobile devices, remember to make your social media links mobile-friendly. Here’s how to do that:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Make links easily tappable: </strong>Icons and links have to be large enough for easy interaction on mobile screens. Avoid clustering links too closely together to prevent accidental taps.</li>\n\n\n\n<li><strong>Ensure responsive design: </strong>Verify that linked pages are optimized for mobile browsing and test the user experience across various devices and screen sizes.</li>\n\n\n\n<li><strong>Consider load times: </strong>Slow-loading social media elements can frustrate users and decrease engagement, so don’t forget to optimize icon images and linked content for quick loading on mobile networks.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 7: Promote social media handles in video and audio content</strong></h2>\n\n\n\n<p>Incorporating your social media handles into video and audio content can significantly boost your online presence. This approach allows you to reach audiences across multiple platforms and encourages cross-platform engagement.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Display social media handles as text overlays in videos</strong></h3>\n\n\n\n<p>Text overlays are an effective way to make your handles visible without disrupting the main content of your videos.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Use lower-thirds for handle display</strong>\n<ul class=\"wp-block-list\">\n<li>Place your handles in the bottom section of the video, commonly known as lower-thirds.</li>\n\n\n\n<li>Ensure the text is clear and easy to read on both desktop and mobile devices.</li>\n</ul>\n</li>\n\n\n\n<li><strong>Match branding with font choice</strong>\n<ul class=\"wp-block-list\">\n<li>Select fonts that align with your overall brand aesthetic.</li>\n\n\n\n<li>Keep the text professional and easily legible.</li>\n</ul>\n</li>\n\n\n\n<li><strong>Balance visibility and subtlety</strong>\n<ul class=\"wp-block-list\">\n<li>Make sure your handles are noticeable without overwhelming the video&#8217;s visuals.</li>\n\n\n\n<li>Consider using semi-transparent overlays to minimize distraction.</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Add social media handles to the description box of video platforms</strong></h3>\n\n\n\n<p>Video platforms like <a href=\"https://www.youtube.com/\">YouTube</a>, TikTok, and <a href=\"https://vimeo.com/\">Vimeo</a> offer valuable space in their description boxes for promoting your handles.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Prioritize handle placement</strong>\n<ul class=\"wp-block-list\">\n<li>List your most important handles at the top of the description.</li>\n\n\n\n<li>Use clickable links to make it easy for viewers to follow you immediately after watching.</li>\n</ul>\n</li>\n\n\n\n<li><strong>Tailor approach for different platforms</strong>\n<ul class=\"wp-block-list\">\n<li>On TikTok, where space is limited, focus on your primary handle in the caption or on-screen text.</li>\n\n\n\n<li>For YouTube, utilize the expanded description space to list multiple handles and provide context.</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Mention handles verbally in video and audio content</strong></h3>\n\n\n\n<p>Verbal mentions of your social media handles can reinforce them and prompt your audience to follow you. However, you need to be strategic: Include handle mentions at the start, during transitions, or at the end of your content. For longer content like podcasts, naturally incorporate handle mentions during topic transitions.</p>\n\n\n\n<p>We also recommend briefly explaining what kind of content followers can expect on each platform and using a call-to-action approach, encouraging listeners to connect with you on social media.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Include social media handles in end screens or outro segments</strong></h3>\n\n\n\n<p>End screens and outros are prime locations for promoting your social media handles, as viewers often decide what to do next after finishing a video.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Create branded end screens</strong>\n<ul class=\"wp-block-list\">\n<li>Design clear, visually appealing end screens that prominently feature your handles.</li>\n\n\n\n<li>Include CTAs like, &#8220;Follow us on Instagram @YourHandle for behind-the-scenes content.&#8221;</li>\n</ul>\n</li>\n\n\n\n<li><strong>Utilize platform-specific features</strong>\n<ul class=\"wp-block-list\">\n<li>On YouTube, use the end screen feature to display clickable social media icons alongside your handles.</li>\n\n\n\n<li>Ensure these elements are easily clickable on both desktop and mobile devices.</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Promote social handles during live streams</strong></h3>\n\n\n\n<p>Live streams offer real-time opportunities to promote your social media handles while interacting directly with your audience. Use a persistent on-screen graphic showing your primary social media handles and rotate different handles throughout the stream if you&#8217;re active on multiple platforms.</p>\n\n\n\n<p>You can also verbally encourage follows by periodically reminding viewers to follow you on other platforms and highlighting exclusive content or benefits available on specific social media channels.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Utilize social media handle watermarks in visual content</strong></h3>\n\n\n\n<p>Watermarks ensure your handle remains visible even if your video is shared across different platforms. Place the watermark in a corner of the video where it won&#8217;t distract from the content and ensure it&#8217;s noticeable enough for viewers to remember and easily read.</p>\n\n\n\n<p>Remember to be consistent! Use the same watermark design across all your video content for brand recognition. Consider using your primary social media handle as the watermark for maximum impact.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Take control of your online presence with Gravatar today</strong></h2>\n\n\n\n<p>Effectively listing and promoting your social media handles is crucial for building a strong online presence. Consistency and visibility are key, but so is efficiency. Managing multiple social media profiles can become time-consuming, especially when updating handles or ensuring consistency across platforms.</p>\n\n\n\n<p><a href=\"https://gravatar.com/\">Gravatar</a> offers a straightforward solution for organizing your online presence, making it easier for others to find and follow your profiles without having to manage multiple platforms. With Gravatar, you can:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Create a centralized profile listing links to all your social media accounts, website, portfolio, and other online presences.</li>\n\n\n\n<li>Link to your Gravatar profile in email signatures, websites, business cards, and even physical marketing materials using a QR code.</li>\n\n\n\n<li>Verify your social media accounts and links, adding a layer of trust and authority to your online presence.</li>\n</ul>\n\n\n\n<p>Whether you&#8217;re a small business owner, entrepreneur, or social media manager, Gravatar provides a streamlined solution to keep your social media handles up-to-date and visible across your digital footprint.</p>\n\n\n\n<p>Take the first step in simplifying your online presence management. <a href=\"https://gravatar.com/\">Create your Gravatar profile now</a> and start showcasing your social media handles across all platforms with ease.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 11 Nov 2024 21:56:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Do The Woo Community: How to Follow Do The Woo on the Fediverse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=86782\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://dothewoo.io/blog/how-to-follow-do-the-woo-on-the-fediverse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:152:\"Do The Woo has joined the Fediverse, allowing users to engage with episodes and blog posts across decentralized platforms like Mastodon and Threads.net.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 11 Nov 2024 09:42:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matthias Pfefferle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Gravatar: Gravatar’s Guide: Crafting an Outstanding Digital Business Card\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2388\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://blog.gravatar.com/2024/11/08/creating-a-digital-business-card/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9797:\"<p>Imagine that you&#8217;re at a networking event, eager to make connections, but you&#8217;ve run out of business cards. Or worse, you hand someone a card only to realize it has outdated information. Situations like these highlight why professionals are turning to digital business cards. These modern alternatives offer a dynamic way to share your contact details and personal brand, complete with rich media content and real-time updates.</p>\n\n\n\n<p>Digital business cards shine in both online (as a <a href=\"https://blog.gravatar.com/2024/08/28/level-up-your-profile-3-cool-new-features-for-your-link-in-bio/\">link in bio</a> tool, in the footer of contact pages and emails) and offline (in-person networking and <a href=\"https://blog.gravatar.com/2024/08/02/organizational-benefits-of-efficient-contact-sharing/\">contact sharing</a>) settings.<strong> </strong>So, whether you&#8217;re adding them to your email signature or sharing them at in-person events, they make networking and follow-ups much easier.&nbsp;</p>\n\n\n\n<p><img src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/1f331.png\" alt=\"🌱\" class=\"wp-smiley\" /> As a bonus, they&#8217;re environmentally friendly, reducing paper waste.</p>\n\n\n\n<p>However, creating an effective digital business card comes with challenges. Many solutions can be costly, and designing one without the necessary skills can be daunting. Thankfully, <a href=\"https://gravatar.com/\">Gravatar</a> exists – a completely free and powerful platform for crafting digital business cards.</p>\n\n\n\n<p>This guide will show you how to use Gravatar to create a professional, eye-catching digital business card – no design expertise required!</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Necessary features and design elements for your digital business card</strong></h2>\n\n\n\n<p>While it’s good to be creative and unique with your digital business card, you still need some essential elements. Let’s see what they are:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Profile photo:</strong> It&#8217;s often the first thing people notice, so choose a clear, well-lit, high-quality headshot that reflects your professional persona.</li>\n\n\n\n<li><strong>Contact information:</strong> Include the essentials such as name, job title, company, email, and phone number. Remember, digital cards allow for easy updating if any details change.</li>\n\n\n\n<li><strong>Social media links: </strong>Add links to your relevant social profiles. This expands your networking reach, allowing connections to engage with you on multiple platforms.</li>\n\n\n\n<li><strong>Personal website or portfolio link:</strong> Showcase your work and drive traffic to your site by including a link to your personal website or portfolio.</li>\n\n\n\n<li><strong>Brief bio or tagline: </strong>Craft a concise personal statement that encapsulates your professional identity or unique selling point. Keep it short, sharp, and memorable.</li>\n\n\n\n<li><strong>Customization options:</strong> Your digital card should align with your personal brand, especially the visuals, such as the color scheme, fonts, and overall design. For example, you could use the same font as you would on your website but also include an effective one-liner like you would on LinkedIn.&nbsp;</li>\n\n\n\n<li><strong>Sharing methods: </strong>Ensure your digital card is easily shareable both online and offline. For example, you can create your own QR code that people can scan and access your card in seconds. Online, the most effective way is to have a <a href=\"https://blog.gravatar.com/2024/06/26/link-your-gravatar-profile-with-a-free-custom-domain/\">nice, short, custom URL</a>.&nbsp;</li>\n\n\n\n<li><strong>Easy follow-ups and contact: </strong>Your business card needs to make it easy for people to follow up and contact you when they want to. That means including your email signature in your business card, or links to contact forms.&nbsp;</li>\n\n\n\n<li><strong>Privacy controls: </strong>Make sure you can control what information is visible and to whom. This flexibility allows you to tailor your card for different professional contexts.</li>\n\n\n\n<li><strong>Integration capabilities: </strong>Consider how your digital card might connect with other tools you use regularly, such as CRM systems or other professional platforms.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Create a stunning digital business card with Gravatar – no design skills needed</strong></h2>\n\n\n\n<img width=\"2492\" height=\"1298\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-new-homepage.png\" alt=\"Gravatar homepage\" class=\"wp-image-2391\" />\n\n\n\n<p>Enter Gravatar: your free ticket to a globally recognized digital identity. This platform is a powerful tool for managing your online presence across thousands of websites and services. Think of it as your universal digital business card and <a href=\"https://blog.gravatar.com/2024/04/10/personal-branding-tools/\">personal branding hub</a> all rolled into one.</p>\n\n\n\n<img width=\"1032\" height=\"776\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/ronnie-gravatar-profile.png\" alt=\"Ronnie Burt’s Gravatar profile\" class=\"wp-image-2392\" />\n\n\n\n<p>What sets Gravatar apart? Its simplicity. You don&#8217;t need to be a design guru to create a standout profile. Just upload an avatar and fill in your details, and you&#8217;re good to go. But don&#8217;t let the ease of use fool you – there&#8217;s plenty of room for customization. You can play with background colors, tweak button hues, or add a custom-branded header and footer.&nbsp;</p>\n\n\n\n<img width=\"1613\" height=\"919\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-profile-edit-page.png\" alt=\"Demo profile in Gravatar\" class=\"wp-image-2393\" />\n\n\n\n<p>You can even rearrange the layout to suit your style. And for those who want to go the extra mile, why not embed a video introduction? It&#8217;s all about making your digital card uniquely you.</p>\n\n\n\n<p>Here&#8217;s what you can pack into your Gravatar profile:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Your chosen avatar image (make it a good one!)</li>\n\n\n\n<li>Name and a snappy biography</li>\n\n\n\n<li>Contact information (email, website)</li>\n\n\n\n<li>Links to your social media profiles</li>\n\n\n\n<li>Other relevant links (portfolio, projects, etc.)</li>\n</ul>\n\n\n\n<p>But here&#8217;s where Gravatar really shines: <a href=\"https://blog.gravatar.com/2024/02/27/gravatar-manifesto-one-profile-everywhere/\"><strong>automatic synchronization</strong></a>. Update your profile once, and those changes instantly appear across all connected platforms&nbsp; – no more scrambling to update multiple online profiles when you change jobs or contact details. This ensures your personal brand stays consistent everywhere you appear online, from professional forums to project collaborations.&nbsp;</p>\n\n\n\n<p>And for those <a href=\"https://blog.gravatar.com/2024/06/16/how-to-network-at-a-conference/\">in-person networking moments</a>, you can generate a QR code for your Gravatar profile and watch as people scan their way straight to your digital doorstep.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Android and Apple Wallet Support, Too</h2>\n\n\n\n<img width=\"2800\" height=\"1720\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/image.png\" alt=\"\" class=\"wp-image-2427\" />\n\n\n\n<p>Never fumble for a business card again. Your Gravatar profile now lives in your phone&#8217;s wallet!</p>\n\n\n\n<p><strong>Quick Setup:</strong></p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Log into your Gravatar profile</li>\n\n\n\n<li>Click the &#8216;Share profile&#8217; button</li>\n\n\n\n<li>Select &#8216;Add to Apple Wallet&#8217; or &#8216;Add to Google Wallet&#8217;</li>\n\n\n\n<li>Tap to add &#8211; you&#8217;re done!</li>\n</ol>\n\n\n\n<p><strong>Why You&#8217;ll Love It:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Always on hand &#8211; even when your phone is offline</li>\n\n\n\n<li>Share your profile with a quick tap</li>\n\n\n\n<li>Updates automatically when you change your Gravatar</li>\n\n\n\n<li>Looks sleek in your digital wallet</li>\n\n\n\n<li>Perfect for conferences and meetups</li>\n\n\n\n<li>More eco-friendly than paper cards</li>\n</ul>\n\n\n\n<p><img src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/1f31f.png\" alt=\"🌟\" class=\"wp-smiley\" /> <strong>Here&#8217;s a neat trick</strong>: Gravatar integrates with comment systems on many blogs and news sites. This means your digital business card can pop up alongside your online contributions, turning everyday interactions into potential networking gold.</p>\n\n\n\n<img width=\"1744\" height=\"952\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-comment-section.png\" alt=\"Responses to comments in Gravatar\" class=\"wp-image-2394\" />\n\n\n\n<p>So, ready to create a digital business card that works as hard as you do? Let&#8217;s dive into how you can make Gravatar work its magic for your professional brand.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Future-proof your networking: Create a digital business card with Gravatar</strong></h2>\n\n\n\n<p>Gravatar isn&#8217;t just another digital business card platform – it&#8217;s a revolution in online networking. Its unique email-based system allows you to manage multiple online identities effortlessly. And with thousands of integrated platforms, your Gravatar profile becomes a centralized hub for your digital presence.</p>\n\n\n\n<p>Worried about design skills or costs? Gravatar eliminates these common hurdles. It&#8217;s free, user-friendly, and doesn&#8217;t require a degree in graphic design to look professional.</p>\n\n\n\n<p>Head to <a href=\"http://gravatar.com\">Gravatar.com</a> and create your free profile using your email address. It&#8217;s time to build a digital business card that works as hard as you do!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 08 Nov 2024 22:13:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: Friday Shares: This Week’s Must-Reads and Community Highlights, v3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=86767\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/blog/friday-shares-this-weeks-must-reads-and-community-highlights-v3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"This week’s highlights include WordPress 6.7 updates, community events, sponsorship calls, new resources, and insights into web development and e-commerce strategies.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 08 Nov 2024 10:42:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: WooCommerce Set to Launch New Logo in 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=179174\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/woocommerce-set-to-launch-new-logo-in-2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2561:\"<p>WooCommerce is all set to roll out a <a href=\"https://x.com/WooCommerce/status/1851315035047379219\">new logo</a> in early 2025. Tamara Niesen, Chief Marketing Officer at Woo told WP Tavern, “We saw an opportunity to evolve the brand so it aligns with our new product vision and gives us a solid foundation for continuing to grow our business. The new direction helps us stand out. It’s bold, fresh, and communicates what we do and who we’re for.”</p>\n\n\n\n\n\n\n\n<p>The updated logo, featuring a lively purple and white color palette, has already sparked a buzz in the WordPress community. It showcases “WOO” in white against a deep purple background, sometimes transitioning into a shopping cart, with the “O”s doubling as wheels—perfectly representing a platform that powers millions of online stores worldwide.</p>\n\n\n\n<p>Jay Walsh, Director of Communications at WooCommerce.com, shared that they recently discussed plans around the Woo and WooCommerce brand and identity during the keynote session of this year’s WooSesh. The team teased a refreshed WooCommerce logo treatment during the keynote, which is part of the wider effort to make the Woo brand, voice, and identity bolder and more engaging for current and future merchants.&nbsp;</p>\n\n\n\n<p>“Evolving our brand and our main product is crucial to our strategy of growing new stores, reaching new merchants, and maintaining our position as the world’s most popular commerce platform”, he explained.&nbsp;</p>\n\n\n\n<p>The animated logo has been a hit, drawing comments like “one of the best logos I&#8217;ve seen in a while” to “This is so darn cool.” BobWP of Do the Woo Podcast <a href=\"https://x.com/BobWP/status/1851528372054061090\">tweeted</a>, “In case you missed this. And coming from someone who used to design logos professionally, the simplest ideas, which now seem obvious, are the hardest. Great job!”&nbsp;</p>\n\n\n\n<p>Remkus de Vries of Within WordPress newsletter, shared his excitement <a href=\"https://x.com/remkusdevries/status/1851552009662386658\">saying</a>, “It&#8217;s very rare to see a rebrand with a new logo where I immediately go &#8220;Wow, that&#8217;s a huge improvement, I love it&#8221;, but when I saw this last week, that&#8217;s exactly what I thought.”</p>\n\n\n\n<p>Despite the enthusiasm, a few critics questioned the color choice, but WooCommerce Product Lead James Kemp has <a href=\"https://x.com/jamesckemp/status/1851355951166603264\">assured</a> that “the whole rebrand is super vibrant and the purple has been enhanced.”</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 08 Nov 2024 08:35:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Gravatar: Choosing the Right Personalization Tool: Top 7 for Your Website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2252\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://blog.gravatar.com/2024/11/07/website-personalization-tools/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22795:\"<p>Are you struggling with high bounce rates and lackluster conversions on your website? You&#8217;re not alone. Many businesses find it hard to create engaging, relevant experiences for their online visitors, leading to missed opportunities and lost revenue because, as shown in a recent McKinsey report, <a href=\"https://www.mckinsey.com/capabilities/growth-marketing-and-sales/our-insights/the-value-of-getting-personalization-right-or-wrong-is-multiplying#/\">71% of consumers now expect personalized interactions from companies</a>.&nbsp;</p>\n\n\n\n<p>If you don’t provide them with one, you’re losing business, plain and simple.&nbsp;</p>\n\n\n\n<p>Thankfully, there are many website personalization tools that are transforming how businesses connect with their audience online. These tools enable companies to deliver individualized experiences that resonate with each visitor, going beyond traditional segment-based approaches.&nbsp;</p>\n\n\n\n<p>In the following sections, we&#8217;ll explore the top 7 personalization tools and their features, showing you how to unlock new levels of engagement and business success.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Introducing the top 7 website personalization tools</strong></h2>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>1.</strong> <strong>Gravatar</strong></h3>\n\n\n\n<img width=\"1473\" height=\"918\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/gravatar-profiles-as-a-service.png\" alt=\"Gravatar homepage\" class=\"wp-image-2255\" />\n\n\n\n<p><a href=\"https://gravatar.com/\">Gravatar</a> is a unique tool in the world of website personalization. It simplifies user profile management and enhances personalization based on users&#8217; email addresses, offering a distinct advantage by utilizing data already provided by users. This approach allows developers to personalize site experiences without extensive data collection.</p>\n\n\n\n<p>Gravatar offers two powerful APIs for integration:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><a href=\"https://docs.gravatar.com/api/avatars/images/\">The Avatar API</a> that is designed specifically for requesting avatars.</li>\n\n\n\n<li><a href=\"https://docs.gravatar.com/\">The Profiles-As-A-Service API</a>, which enables developers to import comprehensive profile information.</li>\n</ol>\n\n\n\n<p>These APIs create a centralized hub where users can update their information once, and it syncs across all Gravatar-integrated sites. Gravatar has also introduced <em>Interests</em>, allowing users to list specific topics they&#8217;re interested in – something that can change the game for website owners looking to understand user preferences.&nbsp;</p>\n\n\n\n<img width=\"1511\" height=\"865\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/gravatar-interests-section.png\" alt=\"Gravatar Interests section\" class=\"wp-image-2256\" />\n\n\n\n<p>For example, an e-commerce site could show personalized product recommendations based on these interests.</p>\n\n\n\n<p><strong>Best features:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Users can create a <a href=\"https://blog.gravatar.com/2024/05/09/wordpress-profile-page/\">single avatar profile page</a> associated with their email address.</li>\n</ul>\n\n\n\n<img width=\"1032\" height=\"776\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/ronnie-gravatar-profile.png\" alt=\"Example of a Gravatar profile page\" class=\"wp-image-2257\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>This profile automatically appears on any Gravatar-enabled site, providing a consistent identity across platforms.</li>\n\n\n\n<li>Users can add important information such as avatar, bio, pronouns, and job info – update once, sync everywhere.</li>\n\n\n\n<li>Gravatar is natively supported by <a href=\"https://wordpress.org/\">WordPress</a>, enabling effortless avatar management for WordPress users and developers without additional plugins or code.</li>\n</ul>\n\n\n\n<p>For developers looking to import user profiles, integration with Gravatar&#8217;s profile API is needed. To streamline the user experience, it&#8217;s recommended to explain to users that they can control their avatar and profile information directly from their Gravatar profile.</p>\n\n\n\n<p><strong>Use cases:</strong> Gravatar is particularly beneficial for developers, bloggers, and business owners. It provides a consistent brand image across platforms and maximizes engagement by offering personalized user experiences.</p>\n\n\n\n<p><strong>Used by:</strong> Gravatar integrates with popular platforms like <a href=\"http://wordpress.com\">WordPress.com</a>, <a href=\"https://slack.com/\">Slack</a>, <a href=\"https://openai.com/\">OpenAI</a>, <a href=\"https://www.figma.com/\">Figma</a>, and <a href=\"https://mailchimp.com/\">Mailchimp</a>, demonstrating its versatility and wide-reaching impact.</p>\n\n\n\n<p><strong>Price:</strong> One of Gravatar&#8217;s standout features is its pricing model – or lack of. It&#8217;s a completely free service for site owners, developers, and users, and is run and supported by <a href=\"https://automattic.com/\">Automattic</a>. There&#8217;s no paid version and no usage limits, making it an accessible option for businesses of all sizes.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>2. Dynamic Yield&nbsp;</strong></h3>\n\n\n\n<img width=\"660\" height=\"379\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/dynamic-yield-homepage.png?w=660\" alt=\"Dynamic Yield homepage\" class=\"wp-image-2258\" />\n\n\n\n<p><a href=\"https://www.dynamicyield.com/\">Dynamic Yield</a> is a powerful player in the website personalization arena, known for delivering personalized onsite experiences through AI-powered targeting and real-time analytics.</p>\n\n\n\n<p><strong>Best features:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Contextually relevant content:</strong> Delivers personalized content based on user behavior and preferences. For instance, a returning visitor interested in sports might see sports-related content prominently displayed on the homepage.</li>\n\n\n\n<li><strong>Product recommendations:</strong> Uses AI to suggest products based on browsing history and purchase patterns. An online retailer could use this to show complementary items to those in a user&#8217;s cart.</li>\n\n\n\n<li><strong>Personalized messages:</strong> Tailors messaging based on visitor behavior and characteristics. A travel website might show different promotional messages to first-time visitors versus frequent bookers.</li>\n\n\n\n<li><strong>Real-time personalization:</strong> Adapts content in real-time as users interact with the site. For example, a news site could reshuffle article placement based on what the user clicks on during their visit.</li>\n</ul>\n\n\n\n<p>Dynamic Yield integrates well with other tools to enhance personalization efforts, particularly <a href=\"https://segment.com/twilio/\">Twilio Segment</a>, a customer data platform enabling real-time data collection and action.</p>\n\n\n\n<p><strong>Use cases:</strong> Businesses can use Dynamic Yield to increase engagement and conversion rates, such as personalizing homepage experiences for returning visitors.</p>\n\n\n\n<p><strong>Used by:</strong> <a href=\"https://www.mcdonalds.com/us/en-us.html\">McDonald&#8217;s</a>, <a href=\"https://www.pacsun.com/?srsltid=AfmBOopO0JjIGm5h8VDxzygttVVXvTEK6hTqyyXzFsLeCnaxG9mugNBs\">PacSun</a>, <a href=\"https://www.cotopaxi.com/?srsltid=AfmBOorz7QhfPrt0CHN8RFdUjv_7VPTjcywAtK4ykdXSoYwhBNXT6eh8\">Cotopaxi</a>, among others.</p>\n\n\n\n<p><strong>Price:</strong> Dynamic Yield offers a customized pricing model tailored to each client&#8217;s specific needs and scale. For detailed pricing information, you&#8217;ll need to <a href=\"https://www.dynamicyield.com/request-demo/\">contact their sales team</a> directly.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>3. Optimizely</strong></h3>\n\n\n\n<img width=\"660\" height=\"406\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/optimizely-homepage.png?w=660\" alt=\"Optimizley homepage\" class=\"wp-image-2259\" />\n\n\n\n<p><a href=\"https://www.optimizely.com/\">Optimizely</a> is a leading digital experience platform that empowers businesses to create, experiment, and personalize user experiences.</p>\n\n\n\n<p><strong>Best features:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>A/B testing and multivariate testing: </strong>Allows testing of different page versions to identify the most effective elements. An e-commerce site could test different product page layouts to see which leads to more purchases.</li>\n\n\n\n<li><strong>AI-driven optimization:</strong> Uses machine learning to automatically optimize experiences. This could involve automatically adjusting the placement of call-to-action buttons based on user interaction patterns.</li>\n\n\n\n<li><strong>Personalized content delivery: </strong>Serves different content to different user segments based on their data. A software company might show different feature highlights to enterprise visitors versus small business owners.</li>\n\n\n\n<li><strong>Integrations:</strong> Make the most out of Optimizely by combining it with tools like Twilio Segment, <a href=\"https://marketingplatform.google.com/intl/en_uk/about/analytics/\">Google Analytics</a>, and <a href=\"https://business.adobe.com/\">Adobe Experience Cloud</a>.</li>\n</ul>\n\n\n\n<p><strong>Use cases:</strong> Businesses can increase engagement and conversion rates by running A/B tests on different versions of their product pages to identify the most effective elements.</p>\n\n\n\n<p><strong>Used by:</strong> <a href=\"https://www.ebay.com/\">eBay</a>, <a href=\"https://www.americanexpress.com/\">American Express</a>, <a href=\"https://www.dolby.com/\">Dolby</a>, <a href=\"https://www.fjallraven.com/eu/en-gb/\">Fjallraven</a>, among others.</p>\n\n\n\n<p><strong>Price:</strong> Optimizely offers a customized pricing model tailored to each client&#8217;s specific needs and scale. <a href=\"https://www.optimizely.com/plans/\">Contact their sales team directly</a> for detailed pricing information.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>4. HubSpot&nbsp;</strong></h3>\n\n\n\n<img width=\"660\" height=\"393\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/hubspot-homepage.png?w=660\" alt=\"Hubspot homepage\" class=\"wp-image-2260\" />\n\n\n\n<p><a href=\"https://www.hubspot.com/\">HubSpot</a> is a popular all-in-one CRM platform offering many powerful tools for marketing, sales, and customer service, with a strong emphasis on website personalization.</p>\n\n\n\n<p><strong>Best features:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Smart Content: </strong>Dynamically adjusts website content based on user attributes and behavior. For example, a B2B site could show different case studies to visitors from different industries.</li>\n\n\n\n<li><strong>Personalized CTAs:</strong> Displays different call-to-action buttons to different user segments. A SaaS company might show a &#8220;<em>Start Free Trial</em>&#8221; CTA to new visitors and an &#8220;<em>Upgrade Now</em>&#8221; CTA to existing customers.</li>\n\n\n\n<li><strong>Automated workflows:</strong> Creates personalized user journeys based on user actions and characteristics. This could involve sending a series of targeted emails based on which resources a user has downloaded.</li>\n</ul>\n\n\n\n<p><strong>Use cases:</strong> Businesses can use HubSpot to increase engagement and conversion rates by delivering targeted CTAs to specific visitor groups.</p>\n\n\n\n<p><strong>Used By:</strong> <a href=\"https://www.tripadvisor.com/\">Tripadvisor</a>, <a href=\"https://www.eventbrite.com/\">Eventbrite</a>, <a href=\"https://www.weightwatchers.com/us/\">WeightWatchers</a>, and more.</p>\n\n\n\n<p><strong>Price:</strong> HubSpot offers <a href=\"https://www.hubspot.com/pricing/marketing/enterprise?hubs_content=www.hubspot.com%2F&hubs_content-cta=nav-pricing&term=annual\">tiered pricing plans</a> for their different products, which include marketing, sales, service, content, operations, and commerce. All of them start at $15/month per seat and can go up to $3,600/month, depending on what you need. They also have many free tools, so you can get a taste of the platform before you commit to subscribing.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>5. Hyperise</strong></h3>\n\n\n\n<img width=\"660\" height=\"407\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/hyperise-homepage.png?w=660\" alt=\"Hyperise homepage\" class=\"wp-image-2261\" />\n\n\n\n<p><a href=\"https://hyperise.com/\">Hyperise</a> is a personalization platform that allows businesses to dynamically personalize images and content across various digital touchpoints.</p>\n\n\n\n<p><strong>Best features:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Dynamic image personalization: </strong>Customizes images based on user data. A real estate site could show property images with the visitor&#8217;s name on the &#8220;For Sale&#8221; sign.</li>\n\n\n\n<li><strong>Personalized text overlays: </strong>Adds personalized text to images or videos. An online course platform could add the user&#8217;s name to certificate images in promotional materials.</li>\n\n\n\n<li><strong>CRM integration:</strong> Pulls data from CRM systems to personalize content. This allows for using detailed customer information, like past purchases or support interactions, in personalizing the web experience.</li>\n</ul>\n\n\n\n<p><strong>Use cases:</strong> Businesses can use Hyperise to create personalized landing pages for different audience segments, enhancing relevance and engagement.</p>\n\n\n\n<p><strong>Used by:</strong> <a href=\"https://www.g2.com/\">G2</a>, <a href=\"http://placer.ai\">Placer.ai</a>, <a href=\"https://www.salesloft.com/\">SalesLoft</a>, and <a href=\"https://orca.security/\">Orca Security</a>.&nbsp;</p>\n\n\n\n<p><strong>Price:</strong> Hyperise offers various pricing plans, depending on what you want included. Their <em>Images </em>plan costs $69/month per seat and lets you create personalized images for your outreach. The other two tiers include adding a website and videos.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>6. Marketing Cloud Personalization by Salesforce</strong></h3>\n\n\n\n<img width=\"660\" height=\"360\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/salesforce-homepage.png?w=660\" alt=\"Salesforce marketing personalization homepage\" class=\"wp-image-2262\" />\n\n\n\n<p><a href=\"https://www.salesforce.com/eu/\">Salesforce</a>, formerly known as Evergage, is a comprehensive customer data platform that now also includes a personalization engine as part of its marketing tools. Businesses can use their tools to create individualized experiences across multiple channels, including web, mobile, and email.</p>\n\n\n\n<p><strong>Best features:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Real-time segmentation:</strong> Groups users based on their current behavior and historical data. An airline website could segment users based on their typical flight patterns and current browsing behavior.</li>\n\n\n\n<li><strong>Dynamic content personalization:</strong> Adapts content in real-time based on user segments and behavior. A media streaming service could adjust its homepage layout based on the user&#8217;s viewing history and current trends.</li>\n\n\n\n<li><strong>Journey orchestration</strong>: Creates and manages personalized customer journeys across multiple touchpoints. A bank could create different communication sequences for customers based on their life events, like buying a house or starting a business.</li>\n</ul>\n\n\n\n<p><strong>Use cases:</strong> Businesses can use Salesforce for personalized product recommendations and content tailored to individual shopping behaviors.</p>\n\n\n\n<p><strong>Used by:</strong> <a href=\"https://www.generalmills.com/\">General Mills</a>, <a href=\"https://www.formula1.com/\">Formula 1</a>, <a href=\"https://www.accenture.com/us-en\">Accenture</a>, among others.</p>\n\n\n\n<p><strong>Price:</strong> This service comes in <a href=\"https://www.salesforce.com/marketing/pricing/\">three tiers</a>: Marketing Cloud Engagement, Marketing Cloud Account Engagement, and Marketing Cloud Growth Edition. The first two tiers go for $1,250/month, while the third is $1,500/month per organization.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>7. Yieldify</strong></h3>\n\n\n\n<img width=\"660\" height=\"385\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/yieldify-homepage.png?w=660\" alt=\"Yieldify homepage\" class=\"wp-image-2263\" />\n\n\n\n<p><a href=\"https://www.yieldify.com/\">Yieldify</a> is a platform designed to optimize customer journeys through personalized experiences and conversion rate optimization, focusing on e-commerce businesses.</p>\n\n\n\n<p><strong>Best features:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Personalized overlays and pop-ups: </strong>Creates targeted messages that appear based on user behavior. An e-commerce site could show a discount pop-up to users who are about to leave the site without purchasing.</li>\n\n\n\n<li><strong>Behavioral targeting: </strong>Tailors experiences based on user actions and characteristics. A fashion retailer could show different promotional banners to users based on the categories they&#8217;ve been browsing.</li>\n\n\n\n<li><strong>Data-driven insights:</strong> Provides analytics to help understand user behavior and optimize personalization strategies. This could help identify which personalization tactics are most effective for different user segments.</li>\n</ul>\n\n\n\n<p><strong>Use cases:</strong> Businesses can use Yieldify to reduce cart abandonment through exit-intent pop-ups and promote special offers based on user behavior.</p>\n\n\n\n<p><strong>Used by:</strong> <a href=\"https://www.lacoste.com/\">Lacoste</a>, <a href=\"https://www.kiehls.com/\">Kiehls</a>, <a href=\"https://int.clarins.com/\">Clarins</a>, <a href=\"https://www.thenorthface.com/\">The North Face</a>, among others.</p>\n\n\n\n<p><strong>Price:</strong> Yieldify offers customized pricing based on specific needs. <a href=\"https://www.yieldify.com/get-started/\">Contact them directly</a> to get started and obtain pricing information.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Selecting the ideal personalization tools for your website</strong></h2>\n\n\n\n<p>Choosing the right personalization tools for your website is crucial for maximizing engagement and conversion rates. Here&#8217;s how to approach this important decision:</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Step 1: Understand your needs</strong></h3>\n\n\n\n<p>Before selecting a tool, identify your specific goals and challenges. Are you looking to improve user engagement, increase conversion rates, or streamline user profile management? Assess your current marketing stack and identify integration needs to ensure quick and easy implementation.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Step 2: Evaluate key features</strong></h3>\n\n\n\n<p>Create a list of essential features you need in a personalization tool. Consider factors such as:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Ease of use and integration</li>\n\n\n\n<li>A/B testing capabilities</li>\n\n\n\n<li>Real-time analytics</li>\n\n\n\n<li>User-friendly interfaces to reduce the learning curve for your team</li>\n</ul>\n\n\n\n<p><strong>Don&#8217;t overlook the importance of data privacy and security.</strong> Tools like Gravatar emphasize user control over personal information, allowing users to edit their public profiles and share only what they&#8217;re comfortable with. Ensure the tool complies with regulations such as <a href=\"https://gdpr-info.eu/\">GDPR</a> and <a href=\"https://oag.ca.gov/privacy/ccpa\">CCPA</a> for legal data handling practices.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Step 3: Analyze cost and ROI</strong></h3>\n\n\n\n<p>Consider both short-term costs and long-term value when evaluating tools. Low-cost and free tools like Gravatar offer high value and low risk, making them excellent starting points for personalization efforts.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Step 4: Success stories</strong></h3>\n\n\n\n<p>Look at real-world examples of companies successfully using personalization tools to drive growth. For instance, a great example of successful personalization is the plant-based cosmetics brand <a href=\"https://int.clarins.com/\">Clarins</a> which <a href=\"https://www.yieldify.com/success-stories/clarins/\">increased conversions by 20% using Yieldify</a>. Some of the strategies they implemented include:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Adding virtual consultations to help users find the best products.&nbsp;</li>\n\n\n\n<li>Guiding users to book a complimentary phone consultation with a specialist on category pages.&nbsp;</li>\n\n\n\n<li>Re-engaging shoppers who try to change tabs with special overlays that include basket reminders and introducing Clarins’ three complimentary products that they offer with each order.&nbsp;</li>\n</ul>\n\n\n\n<p>Looking at examples like this will show you the full potential of the specific platform and maybe even give you some ideas on how you can implement similar strategies in your own business.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Step 5: Make an informed decision</strong></h3>\n\n\n\n<p>Finally, whenever you can, take advantage of demos to better understand each tool&#8217;s capabilities before making a decision. Weigh the risk versus reward, keeping in mind that tools like Gravatar offer easy integration and are free to use, making them a low-risk option to start with.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Unlock the potential of your website with personalization tools&nbsp;</strong></h2>\n\n\n\n<p>Website personalization tools are powerful assets in enhancing customer engagement and boosting conversion rates. By tailoring user experiences, these tools provide a significant competitive advantage. In fact, <a href=\"https://www.mckinsey.com/capabilities/growth-marketing-and-sales/our-insights/the-value-of-getting-personalization-right-or-wrong-is-multiplying\">companies excelling at personalization generate 40% more revenue than their counterparts</a>.</p>\n\n\n\n<p>When choosing personalization tools, consider factors like powerful features, integration capabilities, and ROI measurement.&nbsp;</p>\n\n\n\n<p>Gravatar stands out with its unique advantage of utilizing existing user data for personalization without extensive on-site data collection. Its Profile API allows developers to create more detailed and personalized user experiences by integrating additional user information into their websites.</p>\n\n\n\n<p>As you explore the tools we&#8217;ve discussed, consider how they align with your business needs. Remember, <a href=\"https://gravatar.com/developers/new-application\">Gravatar is an excellent starting point</a> – it&#8217;s both highly useful and free.&nbsp;</p>\n\n\n\n<p>So what are you waiting for? Take the best out of website personalization and create experiences that your users will love!&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 07 Nov 2024 17:33:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"Do The Woo Community: Do the Woo is Trailbazing the Fediverse with Matthias Pfefferle and Derek Hanson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=86690\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://dothewoo.io/do-the-woo-is-trailbazing-the-fediverse-with-matthias-pfefferle-and-derek-hanson/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"Do the Woo is on the Fediverse with multi-authors, audio distribution and more to come.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 07 Nov 2024 10:15:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"Do The Woo Community: Press Release: Do the Woo 4.0 Official Launch, Elevating Voices in the WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=86703\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://dothewoo.io/blog/press-release-do-the-woo-4-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"Press Release: The official launch of the Do the Woo Podcast Channel 4.0 takes place during WordCamp Europe in Turino, Italy.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Nov 2024 15:00:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: #144 – Damon Cook &amp; Seth Rubenstein on the Transformational Interactivity API\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=178900\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://wptavern.com/podcast/144-damon-cook-seth-rubenstein-on-the-transformational-interactivity-api\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:41793:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley. Jukebox is a podcast, which is dedicated to all things, WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, how the Interactivity API will transform your WordPress websites.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to wptavern.com/feed/podcast. And you can copy that URL into most podcasts players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Damon Cook and Seth Rubenstein.</p>\n\n\n\n<p>Damon Cook is a developer advocate with WP Engine, and previously worked as a front end developer at several WordPress focused agencies.</p>\n\n\n\n<p>Seth Rubenstein began his WordPress journey in college, and is now the lead engineer at the Pew Research Center, where he works on interactive WordPress applications.</p>\n\n\n\n<p>This is the last of the podcast recorded at WordCamp, us 2024, and our focus today is the interactivity API. You may not be familiar with what this is and why it matters, so Damon and Seth will break it down, and explain how it might transform your WordPress websites in the future.</p>\n\n\n\n<p>Damon starts off by defining what an interactive website is, giving examples such as single page applications, and dynamic elements like tabs and accordions. Seth adds his perspective on how interactivity aids both the end user, and website editors. Making for a more compelling user experience and efficient content creation.</p>\n\n\n\n<p>We get into why WordPress needed an interactivity API, even though the platform already supports libraries, like React. The interactivity API provides a standardized way to create dynamic content, which is essential for modern web expectations.</p>\n\n\n\n<p>We also highlight real-world examples, including faceted searching and filtering, which have been successfully implemented using this API.</p>\n\n\n\n<p>The conversation also touches on performance improvements brought by the API, emphasizing how it can offload server resources by only updating necessary content.</p>\n\n\n\n<p>Towards the end we explore how the API is being used in Gutenberg blocks, and how it supports both developers and site builders.</p>\n\n\n\n<p>Damon and Seth also discussed the project&#8217;s development, encouraging more contributions and feedback from the community.</p>\n\n\n\n<p>If you&#8217;re intrigued by improving your websites&#8217; interactivity and performance, this episode is for you.</p>\n\n\n\n<p>If you&#8217;d like to find out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Damon Cook and Seth Rubenstein.</p>\n\n\n\n<p>I am joined on the podcast today by Damon Cook and Seth Rubenstein. Hello.</p>\n\n\n\n<p>[00:03:40] <strong>Damon Cook:</strong> Hey, how&#8217;s it going?</p>\n\n\n\n<p>[00:03:41] <strong>Nathan Wrigley:</strong> Yeah, really, really nice thank you. That&#8217;s Damon.</p>\n\n\n\n<p>[00:03:44] <strong>Seth Rubenstein:</strong> Hello, I&#8217;m Seth.</p>\n\n\n\n<p>[00:03:45] <strong>Nathan Wrigley:</strong> Thank you so much. We&#8217;re at WordCamp US, it&#8217;s happening in Oregon. It is the month of September 2024, and I&#8217;m being joined by Damon and Seth so that we can talk about the Interactivity API.</p>\n\n\n\n<p>Before we get into that, I think it&#8217;s probably important to paint a picture of both of you, what your background is with WordPress technology, et cetera. So we&#8217;ll just keep this very brief. Let&#8217;s go for Damon first. Damon, just tell us a little bit about you, your potted bio, if you like.</p>\n\n\n\n<p>[00:04:10] <strong>Damon Cook:</strong> Sure, yeah. Well, I started out as a WordPress front end developer at WordPress. There&#8217;s several different WordPress focused agencies, and now I&#8217;m a developer advocate with WP Engine.</p>\n\n\n\n<p>[00:04:21] <strong>Nathan Wrigley:</strong> Thank you very much. And Seth?</p>\n\n\n\n<p>[00:04:23] <strong>Seth Rubenstein:</strong> My first time using WordPress was in college. I converted all of our websites to WordPress multi-site, as like the assistant web developer. And from there I just kept going, and that was just my career track from then on, just WordPress all the time. And now I am the lead engineer at the Pew Research Center, where we have a WordPress platform that we&#8217;ve made ourselves, and we work on a lot of interactive WordPress applications.</p>\n\n\n\n<p>[00:04:43] <strong>Nathan Wrigley:</strong> Just staying on your bios just for a moment, what does the Pew Research Center do? I&#8217;ve not heard of them before.</p>\n\n\n\n<p>[00:04:49] <strong>Seth Rubenstein:</strong> We are a non-partisan, non advocacy social science research organisation. So we basically study the American public and where they are, what they think on certain issues. And we do a lot of public polling and things like that, and we report that back. So we&#8217;re kind of like a nonprofit news organisation.</p>\n\n\n\n<p>[00:05:04] <strong>Nathan Wrigley:</strong> Gosh, okay thank you. That&#8217;s really interesting.</p>\n\n\n\n<p>Okay, let&#8217;s open it up and talk about the subject at hand today. So we&#8217;ve got both of these gentlemen here to talk about the Interactivity API. I think probably we should first deal with the topic of, what is an interactive website?</p>\n\n\n\n<p>Probably, dear listener, if you&#8217;re listening to this, you might know this already, but I have an intuition that some people won&#8217;t. So, what are the benefits of having an interactive website? And whoever wants to answer that, pick up the mic and go for it.</p>\n\n\n\n<p>[00:05:30] <strong>Damon Cook:</strong> I think the classic example is that of a single page application. So the idea of being able to navigate from page to page, or section to section even, and just have things that seem seamless, so the page isn&#8217;t refreshing, that is a pretty common scenario. But there&#8217;s also lots of other interactive pieces like tabs, accordions, all that stuff gets really helpful when you reach for the Interactivity API in creating stuff like that.</p>\n\n\n\n<p>[00:05:59] <strong>Seth Rubenstein:</strong> I don&#8217;t have anything to add to that. I guess what I would say is, on the other side of it besides the front end user, the kind of, your visitor, I think the interactivity part of a website kind of also can help out your editors, and how they&#8217;re building content, and making more engaging content.</p>\n\n\n\n<p>I think this will be interesting because I think, you know, Damon might have a kind of perspective of the front end user, and I&#8217;m definitely coming from a perspective of, how can I scale up my editorial team&#8217;s ability to create interactive content? And not so much like what it looks like on the front end.</p>\n\n\n\n<p>[00:06:27] <strong>Nathan Wrigley:</strong> So there&#8217;s an interesting distinction there. So, does the work that you are doing touch on both the front end and the back end? So it&#8217;s not just for the forward facing, user facing part of a WordPress website. This is things that you can do in the back end, the admin side of things too.</p>\n\n\n\n<p>[00:06:40] <strong>Seth Rubenstein:</strong> Yeah, it&#8217;s how editors create interactive bits of content, and how those interactive bits of content might interact with each other. Because I think right now, without the Interactivity API, that kind of content is static and siloed on the page.</p>\n\n\n\n<p>[00:06:52] <strong>Nathan Wrigley:</strong> We will link in the show notes to all of the different places, and no doubt one of the first links will be to the project itself, the Interactivity, API. But I guess I have to ask the question, why is this even a project in WordPress? Is it that WordPress historically wasn&#8217;t particularly adapted towards interactive content?</p>\n\n\n\n<p>I mean, we know how to publish posts and pages, and once you&#8217;ve done that, that&#8217;s kind of it. You&#8217;ve done it, and there&#8217;s no interactivity there. Is this something that has been, I don&#8217;t know, more recently thought was necessary? Is this something that you think should be in Core? Let&#8217;s just take that. Has WordPress been bad at interactivity historically?</p>\n\n\n\n<p>[00:07:28] <strong>Damon Cook:</strong> I don&#8217;t think that it&#8217;s been bad historically, I think that it&#8217;s more of kind of a, I guess a technology trend of leaning into libraries like React or Preact, which Interactivity is built upon. So I think it&#8217;s more of a trend, but also, yeah, a necessity in Core, because folks are trying to build these types of experiences, and we want to have a standardised way for them to be able to do that, and not have to pull in a bunch of different libraries. And although they still can, you know, there&#8217;s a standardised and backwards compatible way for them to do it. So that&#8217;s the idea.</p>\n\n\n\n<p class=\"ticss-13c01dd4\">[00:08:05] <strong>Nathan Wrigley:</strong> Thank you. Seth, anything to add?</p>\n\n\n\n<p>[00:08:06] <strong>Seth Rubenstein:</strong> Yeah. I don&#8217;t think WordPress has done a bad job on interactivity in the past, you know, ships with jQuery, ships with React, that&#8217;s all available to you. I think the Interactivity API is kind of looking at how developers have been creating front end experience with React, and narrowing that down to be like the right tool set for blocks and for block developers specifically.</p>\n\n\n\n<p>[00:08:26] <strong>Nathan Wrigley:</strong> So it&#8217;s about having the right tooling. Something standardised that everybody can get their teeth into, that every developer understands.</p>\n\n\n\n<p>[00:08:32] <strong>Seth Rubenstein:</strong> Yeah, and something that fits the blocks kind of model I think, a little bit better than some of these other frameworks.</p>\n\n\n\n<p>[00:08:38] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s great. So give us some examples of good interactivity on the internet. So we could limit ourselves to WordPress, but let&#8217;s not do that. Let&#8217;s just go out there and try to pick good examples.</p>\n\n\n\n<p>Really, I guess we could be talking about Google Docs, we could be talking about websites, we could be talking about anything. Do you want to just rattle off a few things where you&#8217;ve seen and you&#8217;ve been impressed, and thought, ah okay, there&#8217;s a good example. The only reason I&#8217;m asking this really is so that the listener can just get an idea of what interactivity means.</p>\n\n\n\n<p>[00:09:05] <strong>Damon Cook:</strong> Sure. And I&#8217;m actually going to set up Seth, because I think a lot of the things that his organisation is creating are representative of what folks kind of need. So I&#8217;ll set him up for that.</p>\n\n\n\n<p>[00:09:17] <strong>Seth Rubenstein:</strong> And I&#8217;ll say the word that he&#8217;s probably thinking of, facets. Amazon, you&#8217;re browsing Amazon, you want to narrow down the content that you&#8217;re looking at. Those facets on the left hand side, filters, aggregations, whatever you want to call them. I think this has probably been our biggest success with the Interactivity API, is developing out facet blocks.</p>\n\n\n\n<p>And with the Interactivity API what that would let you do is just server side hydrate data before it gets back to the client. And you can browse through all this content, and do it in a performant way that you just couldn&#8217;t do before. Or you could, but it would take a lot of work on your part to build out the framework and the technology to handle all that.</p>\n\n\n\n<p>And so now that&#8217;s just in the box in WordPress free to use. So we can probably touch on facets a little bit more later, but I think that&#8217;s probably the best use case for the Interactivity API thus far.</p>\n\n\n\n<p>[00:10:00] <strong>Nathan Wrigley:</strong> Let&#8217;s dig into that a little bit. So when you say facets, my head is immediately going to things like, I don&#8217;t know, the posts and pages, table layout, or something like that. And the fact that, if I want to get to post number 11, I might have to click a button, wait for a moment whilst the page refreshes, there&#8217;s obviously something going on there, page refresh, I&#8217;m contacting the server and what have you. Is the idea here that, a bit like, I don&#8217;t know, if I scroll on Google, I would be able to automatically upload more pages, more posts, that kind of thing? And then be able to, I don&#8217;t know, say filter them, show me only the ones that are authored by me, or ones with featured images, and that would all happen on the fly.</p>\n\n\n\n<p>[00:10:35] <strong>Seth Rubenstein:</strong> Yeah. So, you know, you can filter by author, by taxonomies, category, custom taxonomies, whatever, date, et cetera. And those results just update in real time, without you having to refresh the page.</p>\n\n\n\n<p>You can paginate through those results without having to refresh the page. That, of course, is great for the end user, but it&#8217;s also great on the backend because you&#8217;re saving server resources without having to re-render that entire page every single time. So you&#8217;re only rendering out what&#8217;s changed.</p>\n\n\n\n<p>So in that way, great for the end user and great for you as a website operator, because the Interactivity API kind of offloads some of that performance overhead that way.</p>\n\n\n\n<p>[00:11:07] <strong>Nathan Wrigley:</strong> Yeah, okay. I have children, and they have been born in a world where the mobile phone is completely ubiquitous. And the idea of anything refreshing to them just seems like an anathema, just a pointless thing. You know, you want to open an app, and from that moment just everything happens. You scroll, there&#8217;s more to see, you press back, it just immediately loads and what have you.</p>\n\n\n\n<p>Is that kind of where we&#8217;re going with the internet? And what I mean by that is, sites where you&#8217;ve got to click a button to see another further piece of content, or for your shopping cart to be updated, or whatever it may be, that just seems like the 1990s almost.</p>\n\n\n\n<p>Is it a bit of that? Is it just we&#8217;re kind of keeping up with the times? And the expectation from the next generation of users is going to be, well, if it isn&#8217;t interactive, I&#8217;m not sticking around. So if I&#8217;ve got a, I don&#8217;t know, a WooCommerce store or something like that, it&#8217;s going to be painful for a user to have to refresh, click a button to go to a cart, wait for it to load and all that. It&#8217;s just, like I said, the 1990s.</p>\n\n\n\n<p>[00:12:05] <strong>Damon Cook:</strong> Yeah, I think a lot of it does touch on that and, yeah, just reaching out to that kind of experience. But, yeah, I think Seth touched on this, but the performance impact is pretty great about the Interactivity API because you&#8217;re only updating the sections, or components on the page that are really relevant to what the user is doing. So that has a performance impact. It makes things feel seamless, faster, and I think that&#8217;s a lot of probably what we&#8217;re all looking for at the end of the day.</p>\n\n\n\n<p>[00:12:30] <strong>Nathan Wrigley:</strong> It feels like something more native to the device that you are on. So it feels like a Mac app, or a Windows app, or an Android, or an iPhone app. Does that kind of make sense? It just feels like we&#8217;re in the modern world, not in the old world where any kind of refresh just seems bizarre, frankly. Anything to add, Seth?</p>\n\n\n\n<p>[00:12:46] <strong>Seth Rubenstein:</strong> You know, I think the coolest part about this is it basically lets you take a PHP application and turn it into a single page JavaScript app. I mean, that&#8217;s really what the Interactivity API as a whole is doing. And I think that&#8217;s what developers are looking for these days. Look at, you know, Next.js, and frameworks like that that are really grown and are really popular. And I think that this kind of API just is an answer to those for WordPress developers.</p>\n\n\n\n<p>[00:13:06] <strong>Nathan Wrigley:</strong> So if I were a developer and I was, I don&#8217;t know, creating plugins, themes, blocks, whatever it may be, where do I go and find out about this? How do I get my teeth into the project? So you might want to drop a URL at this point, wherever you want to point us.</p>\n\n\n\n<p>[00:13:20] <strong>Damon Cook:</strong> Sure. Well, I can tell you how I find it because I Google it. I Google it myself. Interactivity API Handbook, I&#8217;m pretty sure that&#8217;s where you&#8217;ll find it, and developer.wordpress.org. The documentation is very thorough, and up to date, and complete. And I think that&#8217;s what&#8217;s excites me about this API because it&#8217;s a very discreet project that kind of got pulled together and, yeah, the documentation is really up to date and great, so that&#8217;s where I&#8217;d go.</p>\n\n\n\n<p>[00:13:47] <strong>Nathan Wrigley:</strong> Okay, I will link to that in the show notes. And probably a good idea, dear listener, to pause at this point, go and check that out and then come back and hit play.</p>\n\n\n\n<p>So from the developer sort of point of view, how baked is it? How complete is it? Is there a lot that you have achieved already? Is there a big roadmap for things that you want to achieve?</p>\n\n\n\n<p>I know that&#8217;s going to be difficult to encapsulate in a few sentences, but just tell us the state of the project now for developers listening to this, they might have some intuitions as, okay, that sounds like something I could use right now, as opposed to the roadmap features that are still going to come.</p>\n\n\n\n<p>[00:14:17] <strong>Damon Cook:</strong> Sure. No, it is quite complete and ready to use, and the documentation can even step you through how to integrate it into an existing block. You can even spin up a new block with the Interactivity API already baked in.</p>\n\n\n\n<p>Some of the future roadmap areas is, I know that we&#8217;re still working on like client side navigation, and then pulling in kind of different modules. Like I know one experiment that&#8217;s being explored is, there&#8217;s a package for accessibility. So just the general idea of speaking, screen reader, passing along. So these APIs have been in WordPress for a while, like some of the accessibility packages. So there&#8217;s explorations in kind of porting that over, and pulling it in, because the Interactivity APIs uses JavaScript modules for a lot of this. So it&#8217;s kind of re jigging, I guess, some of the code and pulling in some of these packages so that developers can use kind of those old, not old, but accessibility features, and have all that compatibility baked in.</p>\n\n\n\n<p>So that&#8217;s some of the areas that are still getting integrated, and I&#8217;m excited for them. And I think that&#8217;s on the roadmap right now, and there&#8217;s folks contributing towards it.</p>\n\n\n\n<p>[00:15:24] <strong>Seth Rubenstein:</strong> The modules area is probably, I think probably the area that it needs the most work, and hopefully the most amount of work is going into. I would say that&#8217;s probably one of the roughest parts of the Interactivity API right now is, if you need to use an external script, or kind of library, or framework, it&#8217;s a little difficult to get that in. So I think that&#8217;s probably where the most amount of work&#8217;s going to be going.</p>\n\n\n\n<p>And I think there&#8217;s some work going on WordPress URL, bringing that in as well. And there&#8217;s a few more directives too, to the API, that are being added like wp-show which should be interesting, that should let you dynamically hydrate elements on the page in a different way. I won&#8217;t go to like all the technical details on that, but there are some additional features that are coming to the Interactivity API, beyond just the module stuff. So there are, in the Interactivity API parlance, there are new directives coming soon.</p>\n\n\n\n<p>[00:16:05] <strong>Nathan Wrigley:</strong> I think for anybody who is a developer, you&#8217;re going to be fine looking at the documentation. But if I say any acronym on this podcast, I always get some pushback from people who are not developers, WordPress end users. So let&#8217;s address that.</p>\n\n\n\n<p>Is there going to be functionality within the Interactivity API, although it&#8217;s there, and it is part of the Interactivity API, will be available to just builders of websites? People who have their own blog, or their own property, they&#8217;re not interested in WordPress from a technical point of view. Is there anything that they can do with it so that they can have this sort of dynamic content? Or is it mainly going to be through the work that developers do, through plugins, and blocks, and what have you?</p>\n\n\n\n<p>[00:16:44] <strong>Seth Rubenstein:</strong> Right now. It&#8217;s live, already on your site if you&#8217;re running kind of the latest version of WordPress. The light box in the image block is using the Interactivity API. So site builders are already gaining that Core query, already has interactivity built in. So does the pagination block. So your publication pages can already be kind of a single page JavaScript app. So Core is adding that stuff in and, yeah, obviously plugin developers will also hopefully add interactivity to their plugins, but it&#8217;s already there for site builders.</p>\n\n\n\n<p>[00:17:11] <strong>Nathan Wrigley:</strong> It feels like we&#8217;ve gone down the road in WordPress where everybody&#8217;s done their own thing with interactivity. The page builders have done, well, not just the page builders as one block, but each page builder has done a different thing. You&#8217;ve got these multitude of plugins that do the sort of facet searching and all of that kind of thing.</p>\n\n\n\n<p>The idea that there&#8217;s just going to be this one thing, I suppose in a sense you kind of want the Interactivity API to not really be that well known about. The idea is for it to sort of fade into the background and nobody even realise that there&#8217;s a thing. Is that sort of doing down the project a little bit, or is that kind of the point? If nobody knows it exists, but it works, that&#8217;s kind of the ideal.</p>\n\n\n\n<p>[00:17:45] <strong>Damon Cook:</strong> Yeah, I mean these APIs are in the background, yeah, for developers to explore, and use, and pull in, and integrate. But yeah, at the end of the day, the end user shouldn&#8217;t know about it, have to know about any of this, and just, have a great experience. So yeah, I think that&#8217;s the idea.</p>\n\n\n\n<p>[00:18:00] <strong>Nathan Wrigley:</strong> Where do you learn what you should be working on? So the team of volunteers and seconded people that are working on the Interactivity API, who are you listening to? Where do you get your feedback from? And I know in the open source world, it&#8217;s hard to get that feedback. And you might be just listening to a dozen voices, interested people, or there may be, I don&#8217;t know, hundreds of people talking to you. But to drive it forward, who are you listening to? Where do you get your intuitions as to what should be on the roadmap?</p>\n\n\n\n<p>[00:18:25] <strong>Damon Cook:</strong> There is a Make Slack Group, it&#8217;s Interactivity API I believe, or Core Interactivity API room. But there&#8217;s some great contributors in there, and I&#8217;m probably going to mess up all their names but there&#8217;s Jon Surrell, I believe, and Greg Ziółkowski. I apologise Greg, I tried. But they are very active contributors and I probably feel like the least contributor. But, yeah, they&#8217;ve been doing a great job.</p>\n\n\n\n<p>I think what it comes down to historically, the Frontity team, I&#8217;m not sure if you&#8217;re familiar with that project, but back in the day they kind of got integrated. All these smart folks into Automattic as full-time contributors, and a lot of them have been driving this project daily and contributing towards it, and they&#8217;ve been doing an amazing job. Some other folks, I think from Google, also contribute a lot towards Interactivity API. So that&#8217;s what I follow, they&#8217;re all in that room a lot and very active.</p>\n\n\n\n<p>[00:19:20] <strong>Seth Rubenstein:</strong> That&#8217;s almost everybody. I don&#8217;t know if you mentioned Luis, he&#8217;s kind of my main point of contact. I ping him with questions, or ideas or, hey, we&#8217;re going to try to do this, does this sound crazy to do with the Interactivity API? And he&#8217;s pretty receptive.</p>\n\n\n\n<p>[00:19:32] <strong>Nathan Wrigley:</strong> Would it be fair to say that you could do with some more helpers though? I think in the open source world we could always use some more people flocking around any particular given project. Is that something that you&#8217;d be interested in? I don&#8217;t know, one of the intentions of a podcast like this is to make things like that happen but, yeah, is that a thing?</p>\n\n\n\n<p>[00:19:47] <strong>Seth Rubenstein:</strong> I would like to see a lot more people using an API. You know, we&#8217;re trying to push the limits of the API, and I think it&#8217;s important that we all kind of try to push the limits and see where it needs additional work, or where we might need extra functionality. So I&#8217;d love to see a lot more people using it because I just don&#8217;t think it&#8217;s gotten kind of the critical mass yet.</p>\n\n\n\n<p>[00:20:04] <strong>Nathan Wrigley:</strong> Can you give us some nice examples that I could link to in the show notes of situations where you&#8217;ve seen, specifically the Interactivity API. We mentioned earlier about, you know, general websites and what have you.</p>\n\n\n\n<p>Are there any good examples where you&#8217;ve seen somebody using it, so that if there is a developer looking at this, they can go, oh okay, that&#8217;s the kind of thing we&#8217;re talking about.</p>\n\n\n\n<p>[00:20:21] <strong>Damon Cook:</strong> I certainly can share some links. I have some repos on GitHub where I&#8217;ve built custom blocks and I&#8217;ve done, I believe there&#8217;s a YouTube, at least a recording of a presentation where I&#8217;ve gone step through building, some of these custom blocks and they&#8217;re all in my repo.</p>\n\n\n\n<p>I was going to hand it off to Seth, I guess again, because I know one block that stood out to me that him and his team have created is like a, well, I think you have a poll, but also like a table filtering. I mean, I think those are pretty common experiences that we see on sites, and they&#8217;ve done a great job in creating that seamless experience of filtering.</p>\n\n\n\n<p>[00:20:56] <strong>Seth Rubenstein:</strong> I can just gush for a moment. If you want a good example, www.pewresearch.org, almost everything that you&#8217;re going to see there is using the Interactivity API. Mega Menus, MailChimp newsletter signups, facets, pagination, table of contents. That updates as you scroll through the page, because the chapter blocks report using the Interactivity API to the table of contents block, which is separate, their position. Data tables, charts, quizzes, you name it, pretty much everything that we have on our website is using the Interactivity API at this point.</p>\n\n\n\n<p>There&#8217;s a few plugins that we still have to convert, it&#8217;s actually only two. But almost everything that you see there is using the API, and almost all that code is available for free open source on github.com/pewresearch.</p>\n\n\n\n<p>[00:21:39] <strong>Nathan Wrigley:</strong> Did you do that yourself because you are knee deep in the weeds of this, and so you could understand easily how to do that? Or would it be true to say that the developer documents that you&#8217;ve just mentioned would steer any, air quotes, competent developer to be able to achieve that? Or is it just that you know, you&#8217;ve got the Interactivity API, you also work for this organisation, so the two met.</p>\n\n\n\n<p>[00:21:58] <strong>Seth Rubenstein:</strong> I think it&#8217;s because we wanted to provide learning resources, we wanted to provide a use case of, here&#8217;s what is possible. Obviously I&#8217;m talking about a lot of blocks that are interactive, but one of the things that I could really go into is our concept around the Interactivity API.</p>\n\n\n\n<p>I think a lot of examples that people can point to, it&#8217;s a very specific use case. This block is a collapsible block, you click on it and it expands. We&#8217;ve taken a different approach, something that we call Atomic Interactive Blocks. And so we&#8217;ll make a block and it will have some interactivity instructions and functionality, but the point of that is to be dropped into another block, which has its own interactivity, and instructions, and functionality, and so on and so forth.</p>\n\n\n\n<p>And so what we&#8217;ve really done is made a library of interactive blocks that kind of act like React components, and that you can drop them in other use cases and style them however you want, but what they do is defined maybe higher up.</p>\n\n\n\n<p>Yeah, so I think to me that&#8217;s really the power of the Interactivity API, because what that allows us to do is, as developers, is just maintain a small library of blocks that are programmed to do a lot of things, and interact with a lot of other blocks, but then hand off styling, and content, and all that stuff to designers and other people.</p>\n\n\n\n<p>For me, that&#8217;s been the coolest part about the Interactivity API, is this abstraction out of a block of what it does. We can go into it more, but the interactive stores can communicate with one another, and so you can have block A do a very specific thing, you click on it and it opens. And maybe you put that inside of block B, and block B is aware, well, when block A is set to be open, when its state is set to be open, I need to do this. And so, you know, you can imagine, you can make a button block, and use that in infinite applications.</p>\n\n\n\n<p>The way that we approach it though, that block can dynamically target an interactive store rather than statically being set to just do this one thing in this one interactive store. So all of those GitHub repos will provide examples of how that kind of system works, and how you might approach the same thing for your organisation or website.</p>\n\n\n\n<p>[00:23:48] <strong>Damon Cook:</strong> I think what Seth touched upon is interesting because I think it says a lot kind of to how the API has been built to abstract some of these ideas, and just shared state between components. So like you touched on, a button can be shared, and so many are used in so many contexts, but to be able to abstract that and share state, and the interactivity between these components is, it shows a lot of, the API has been built smartly so that it can be explored and experimented with, which is neat.</p>\n\n\n\n<p>[00:24:19] <strong>Nathan Wrigley:</strong> I think one thing about this topic is that it is possible, probably, to go a bit overboard with being interactive. I&#8217;ve got the API, I know how to use it now, I&#8217;m going to make everything interactive. And I guess there&#8217;s a point where you&#8217;ve got to tell yourself, slow down, not everything needs to be interactive. So let&#8217;s just go into that. Are there any uses which you would say, yeah, you could do that interactively but we probably shouldn&#8217;t? Are there any times where you think, let&#8217;s put the brakes on?</p>\n\n\n\n<p>[00:24:45] <strong>Damon Cook:</strong> I mean, I think any developer will kind of realise when they&#8217;ve maybe over-engineered something. There&#8217;s always going too far and making everything, yeah. You&#8217;ll know I think if you&#8217;re trying to make everything interactive, every paragraph or, you know, it&#8217;s just kind of pointless. But the exciting part is that you can experiment and explore, interact with these APIs and see what you can do. And find the edges of what you can do, and what you should do, or shouldn&#8217;t do, that&#8217;s the fun part.</p>\n\n\n\n<p>[00:25:10] <strong>Seth Rubenstein:</strong> Yeah, I will say that, is it possible that you can do too much? For sure. Technically speaking though, is it possible that you can do too much? I don&#8217;t think so. Like I said, we have a lot of interactivity blocks on a page, and the performance has been great. So I don&#8217;t think there should be a concern of like, oh, I&#8217;m overdoing it with using the Interactivity API in terms of performance. I think the more things you make with the Interactivity API, the better performance you&#8217;re going to get.</p>\n\n\n\n<p>[00:25:33] <strong>Nathan Wrigley:</strong> Let&#8217;s just speak to the performance side of things because you mentioned technically how it&#8217;s achieved a little bit, but could we just develop that a little bit? And you&#8217;ve definitely said performance isn&#8217;t affected, or performance is really great a number of times. What does that actually mean? So if I&#8217;m using this, is it a more performant website because it&#8217;s, I don&#8217;t know, it&#8217;s loading content asynchronously or what have you?</p>\n\n\n\n<p>Has there been any situations where you&#8217;ve had to, I don&#8217;t know, refactor things because the performance took a dip. Performance at the moment is everybody&#8217;s big worry, isn&#8217;t it? Because, you know, Google takes those metrics and ranks you accordingly. So we kind of want to know that if we make this thing interactive, it&#8217;s not going to suddenly impact our score. And I know that Google does take note of these kind of things.</p>\n\n\n\n<p>[00:26:11] <strong>Seth Rubenstein:</strong> Yeah, I think on the performance bit, I mean, to get a little technical, what makes it so performant is kind of that idea of server side hydration, right? You click on something and that element changes, and that can happen client side, but if it needs a new data, that in the past has meant refreshing the page or doing something really kind of complex and technical.</p>\n\n\n\n<p>Now when the data changes and when that element needs to change, that one element re renders on the server, and then it&#8217;s returned back to the client, not the whole page. So that right there is an immediate performance savings because you&#8217;re not having to render a whole page out again, just to get this one little bit of changed information on a page.</p>\n\n\n\n<p>[00:26:45] <strong>Nathan Wrigley:</strong> Let&#8217;s get into probably the final thing for today, and that is the accessibility perspective of things. It&#8217;s become the watch word I think of 2023, 2024, and probably it&#8217;ll carry on, rightly so.</p>\n\n\n\n<p>Has there been any accessibility concerns? Because obviously if you&#8217;re updating content live on the page, is there anything that we need to be concerned about if we&#8217;re developing with the Interactivity API in terms of the accessibility, I don&#8217;t know, screen readers or other assistive technologies.</p>\n\n\n\n<p>[00:27:12] <strong>Damon Cook:</strong> Sure, yeah. I think it&#8217;s always a challenge in building your components, and making sure they&#8217;re interactive. So I think that it&#8217;s really kind of just abstracting things, trying to figure out what your HTML is, what your CSS is, and then layering on the Interactivity API. I know that some of the extensions of pulling in like strings of information that are being updated on the page, like some of the older packages, like the accessibility, or a11y, for the acronym. Some of these packages that have been in Core for a while, they&#8217;re being ported over into the Interactivity API.</p>\n\n\n\n<p>That&#8217;s something that&#8217;s kind of on the roadmap and being explored right now, so that we can have some of these screen reader updates for components, and on the page be integrated with the Interactivity API. So that&#8217;s, yeah, definitely something that&#8217;s being explored.</p>\n\n\n\n<p>But also, yeah, a lot of it is more of just the approach because just the markup and the CSS alone, having the knowledge of how to make that accessible is always a practice, an art form, and something that is always, can be improved.</p>\n\n\n\n<p>[00:28:17] <strong>Nathan Wrigley:</strong> Okay, thank you. Anything, Seth?</p>\n\n\n\n<p>[00:28:19] <strong>Seth Rubenstein:</strong> I think that there&#8217;s actually probably better accessibility that you&#8217;re going to get out of the Interactivity API. You know, I know that screen readers and assistive technologies have come a long way, but if a lot of your website relied on React, and other JavaScript frameworks that render after the page has been rendered, that could pose a problem for accessibility technologies. Here, all that stuff is pre-hydrated and pre-rendered before the page even loads. So your markup&#8217;s ready to go as soon as the page loads, which is actually great.</p>\n\n\n\n<p>[00:28:46] <strong>Nathan Wrigley:</strong> I think probably time has caught up with us. But before we go, we did mention the URLs and where you can find the project. Let&#8217;s just, firstly, go through where we can find you individually. So that might be an email, a Twitter handle, or whatever it might be. So let&#8217;s go to Damon first. Where can people find you if they&#8217;re interested in catching up?</p>\n\n\n\n<p>[00:29:03] <strong>Damon Cook:</strong> I think probably the easiest is X, I still call it Twitter. I am dcook. I&#8217;m always open. Yeah, reach out. I think 99% of my Twitter timeline is sharing WordPress ideas, outreach links. So yeah, you&#8217;ll find me for any WordPress stuff there.</p>\n\n\n\n<p>[00:29:21] <strong>Nathan Wrigley:</strong> Thank you so much. And, Seth?</p>\n\n\n\n<p>[00:29:22] <strong>Seth Rubenstein:</strong> You can also find me on Twitter, which I refuse to call X. Twitter.com/sethrubenstein. And I also share a bunch of Interactivity API and WordPress stuff.</p>\n\n\n\n<p>[00:29:29] <strong>Nathan Wrigley:</strong> Thank you. So this is the bit where I ask, is there anything that we missed? Is there something that you desperately wanted to get across that I failed to ask?</p>\n\n\n\n<p>[00:29:36] <strong>Damon Cook:</strong> To go back just a little bit, he was touching on performance. So one thing actually I wanted to speak to was the idea of the Interactivity API is a standard means for developers to pull in these kind of libraries and do interactivity experiences. And so using this API, you&#8217;re relying on, you know, a simple small bit of source code that is going to be integrated on every page. So that performance impact of not having to pull in an entire library, so it makes it a smaller source code that&#8217;s being pulled in, so that has a huge performance impact as well.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://us.wordcamp.org/2024/speaker/damon-cook/\">Damon Cook</a> and <a href=\"https://us.wordcamp.org/2024/speaker/seth-rubenstein/\">Seth Rubenstein</a>.</p>\n\n\n\n<p>This is the last of the podcasts recorded at WordCamp US 2024, and our focus today is the Interactivity API. You may not be familiar with what this is and why it matters, so Damon and Seth will break it down, and explain how it might transform your WordPress websites in the future.</p>\n\n\n\n<p>Damon starts off by defining what an interactive website is, giving examples such as single-page applications and dynamic elements like tabs and accordions. Seth adds his perspective on how interactivity aids both the end-user and website editors, making for a more compelling user experience and efficient content creation.</p>\n\n\n\n<p>We get into why WordPress needed an Interactivity API, even though the platform already supports libraries like React. The Interactivity API provides a standardised way to create dynamic content, which is essential for modern web expectations.</p>\n\n\n\n<p>We also highlight real-world examples, including faceted searching and filtering, which have been successfully implemented using this API. The conversation also touches on performance improvements brought by the API, emphasising how it can offload server resources by only updating necessary content.</p>\n\n\n\n<p>Towards the end, we explore how the API is already being used in Gutenberg blocks and how it supports both developers and site builders. Damon and Seth also discuss the project&#8217;s development, encouraging more contributions and feedback from the community.</p>\n\n\n\n<p>If you&#8217;re intrigued by improving your WordPress site’s interactivity and performance, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://www.pewresearch.org\">Pew Research Center</a></p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/\">Interactivity API Handbook</a></p>\n\n\n\n<p><a href=\"https://developer.wordpress.org\">WordPress Developer Resources</a></p>\n\n\n\n<p><a href=\"https://frontity.org\">Frontity</a></p>\n\n\n\n<p><a href=\"https://github.com/pewresearch\">Pew Research Center on GitHub</a></p>\n\n\n\n<p><a href=\"https://x.com/dcook/\">Damon&#8217;s X</a></p>\n\n\n\n<p><a href=\"https://x.com/dcook/\">Seth&#8217;s X</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Nov 2024 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"Do The Woo Community: The Future of Distributed Social Media on WordPress with Robert Windisch and Matthias Pfefferle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=86671\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"https://dothewoo.io/the-future-of-distributed-social-media-on-wordpress-with-robert-windisch-and-matthias-pfefferle/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:178:\"In this episode, Abha discusses WordPress\'s potential evolution into a distributed social media platform with Matthias and Robert, emphasizing community engagement and new tools.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Nov 2024 10:23:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: WordCamp Asia and WordCamp Europe Added to Kim Parsell Memorial Scholarship Program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=178985\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wptavern.com/wordcamp-asia-and-wordcamp-europe-added-to-kim-parsell-memorial-scholarship-program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2901:\"<p>As announced at the <a href=\"https://wordpressfoundation.org/news/2024/meeting-minutes/\">2024 WordPress Foundation Meeting</a>, the  <a href=\"https://wordpressfoundation.org/projects/kim-parsell-memorial-scholarship/\">Kim Parsell Memorial Scholarship</a> has been expanded to include WordCamp Europe and WordCamp Asia. Traditionally supporting a woman WordPress contributor to attend WordCamp US, the scholarship now assists women facing financial challenges in attending these three flagship WordCamp events.</p>\n\n\n\n<p>The scholarship honors <a href=\"https://wordpress.org/news/2019/11/people-of-wordpress-kim-parsell/\">Kim Parsell</a>, a cherished member of the WordPress community and regarded as one of the first “women of WordPress”. Known fondly as #wpmom, Kim was a dedicated volunteer who devoted countless hours to the WordPress project and was a strong advocate for women entering the tech industry.</p>\n\n\n\n<p>In 2014, Kim received a travel stipend from the WordPress Foundation, allowing her to attend the WordPress Community Summit held alongside WordCamp San Francisco—a transformative experience she cherished.The WordPress Foundation now offers this scholarship in her memory.</p>\n\n\n\n<p>The<a href=\"https://wordpressfoundation.org/news/2024/kim-parsell-memorial-scholarship-expands-to-wordcamp-asia-and-wordcamp-europe/\"> announcement post</a> states: “ This expansion honors Kim’s legacy and her dedication to inclusivity and diversity within the WordPress community, making it possible for more community members to attend these inspiring events.”</p>\n\n\n\n<p>To qualify, applicants must:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Identify as a woman</li>\n\n\n\n<li>Actively contribute to the WordPress project</li>\n\n\n\n<li>Have never attended WordCamp Asia or WordCamp Europe before</li>\n\n\n\n<li>Require financial assistance to attend WordCamp Asia or WordCamp Europe 2025</li>\n</ul>\n\n\n\n<p><strong>Applications are open until November 30, 2024, for both <a href=\"https://wordcampcentral.survey.fm/wcasia-2025-kim-parsell-scholarship-application\">WordCamp Asia</a> and <a href=\"https://wordcampcentral.survey.fm/wceu-2025-kim-parsell-scholarship-application\">WordCamp Europe</a>, with notifications sent by December 21, 2024. </strong> Applications for WordCamp US will open in the coming months. The scholarship covers travel to the host city, hotel accommodation for the event duration, and a WordCamp ticket. It does not include airport transfers, meals, or other incidental expenses.</p>\n\n\n\n<p>The scholarship’s inaugural recipient in 2015 was <a href=\"https://profiles.wordpress.org/anyssa/\">Anyssa Ferreira</a>, a Brazilian designer, feminist, and WordPress community activist. Last year, it was awarded to <a href=\"https://profiles.wordpress.org/cnormandigital/\">Cynthia Norman</a>, a WordPress developer and Web designer, with a background in training and education.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Nov 2024 04:48:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt: I Voted!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=129655\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2024/11/i-voted/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:485:\"<p>It was a huge pain in the butt, because my mail-in ballot didn&#8217;t register properly, but I found a last-minute flight to Houston and this morning walked over to <a href=\"https://www.emanuelhouston.org/\">Congregation Emanu El</a> and voted. It is our most sacred duty as a citizen. I encourage every American to vote.</p>\n\n\n\n<img width=\"604\" height=\"483\" src=\"https://i0.wp.com/ma.tt/files/2024/11/IMG_9886-1024x819.jpeg?resize=604%2C483&ssl=1\" alt=\"\" class=\"wp-image-129656\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Nov 2024 23:04:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WordPress.org blog: WordPress 6.7 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18056\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2024/11/wordpress-6-7-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8986:\"<p>The third release candidate (RC3) for WordPress 6.7 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC3 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.7 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.7 RC3 in four ways:</p>\n\n\n\n<table><tbody><tr><th>Plugin</th><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><th>Direct Download</th><td>Download the <a href=\"https://wordpress.org/wordpress-6.7-RC3.zip\">RC3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><th>Command Line</th><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br /><code>wp core update --version=6.7-RC3</code></td></tr><tr><th>WordPress Playground</th><td>Use the <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20%5B%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20%5D%20%7D\">6.7 RC3 WordPress Playground instance</a> (available within 35 minutes after the release is ready) to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table>You can test the RC3 version in four ways.\n\n\n\n<p>The current target for the WordPress 6.7 release is <strong>November 12, 2024</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-7/\">6.7 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-7/\">6.7-related posts</a> in the coming weeks for further details.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s in WordPress 6.7 RC3?</h2>\n\n\n\n<p>Get a recap of WordPress 6.7’s highlighted features in the <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-beta-1/\">Beta 1 announcement</a>. For more technical information related to issues addressed since RC2, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.7?since=2024-10-29&until=2024-11-05\">GitHub commits for 6.7</a> since October 29</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=10%2F29%2F2024..11%2F05%2F2024&milestone=6.7&col=id&col=summary&col=milestone&col=owner&col=type&col=priority&order=id\">Closed Trac tickets</a> since October 29</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is critical to ensuring WordPress is performant and stable. It’s also a meaningful way for anyone to contribute. <a href=\"https://make.wordpress.org/test/2024/10/01/help-test-wordpress-6-7/\">This detailed guide</a> will walk you through testing features in WordPress 6.7. For those new to testing, follow <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Search for vulnerabilities</h3>\n\n\n\n<p>From now until the final release of WordPress 6.7 (scheduled for November 12, 2024), the <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.&nbsp;</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.7 beta releases. With RC3, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.7.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? <span lang=\"es\">¿Español?</span> <span lang=\"fr\">Français?</span> <span lang=\"ru\">Русский?</span> <span lang=\"ja\">日本?</span> <span lang=\"hi\">हिन्दी?</span> <span lang=\"bn\">বাংলা?</span> You can <a href=\"https://translate.wordpress.org/projects/wp/dev/\">help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Release the haiku</h2>\n\n\n\n<p><em>RC3 arrives,<br />Final polish, last bugs fall,<br />Six point seven calls.</em></p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post:</em> <em><a href=\"https://profiles.wordpress.org/peterwilsoncc/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>peterwilsoncc</a>, <a href=\"https://profiles.wordpress.org/joedolson/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joedolson</a></em>, <a href=\"https://profiles.wordpress.org/sabernhardt/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sabernhardt</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Nov 2024 17:02:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Baumwald\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Do The Woo Community: Do the Woo WooSesh Recap, Day 2, with Robbie, Marcus and Brian\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=86634\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://dothewoo.io/do-the-woo-woosesh-recap-day-2-with-robbie-marcus-and-brian/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:228:\"The episode covers insights from WooSesh on motion design, e-commerce localization, accessibility, payment security, customer success, and lifetime licenses in plugin development, emphasizing enhancing user experience and trust.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Nov 2024 10:20:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"WordPress Foundation: Kim Parsell Memorial Scholarship Expands to WordCamp Asia and WordCamp Europe!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpressfoundation.org/?p=1194089\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://wordpressfoundation.org/news/2024/kim-parsell-memorial-scholarship-expands-to-wordcamp-asia-and-wordcamp-europe/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2835:\"<p>We are thrilled to announce that following the latest WordPress Foundation Board meeting, the Kim Parsell Memorial Scholarship will now be available for WordCamp Asia and WordCamp Europe, in addition to WordCamp US. This expansion honors Kim’s legacy and her dedication to inclusivity and diversity within the WordPress community, making it possible for more community members to attend these inspiring events.</p>\n\n\n\n<p>The scholarship is designed to support those who are passionate about contributing to WordPress, especially individuals who might otherwise face financial barriers to attending. By extending the scholarship to WordCamp Asia and WordCamp Europe, we aim to further empower community members around the globe to engage with and grow the WordPress community.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Scholarship Requirements and Application</strong></h3>\n\n\n\n<p>The requirements for applying and the application forms for WordCamp Asia and WordCamp Europe are available below.</p>\n\n\n\n<p><strong>Eligibility Information</strong></p>\n\n\n\n<p>There is one scholarship position available to each flagship event (WordCamp Asia, Europe and WordCamp US). To be considered, applicants must meet the following criteria:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Is a woman</li>\n\n\n\n<li>Is an active contributor to the WordPress project</li>\n\n\n\n<li>Has never attended WordCamp Asia/Europe before</li>\n\n\n\n<li>Requires financial assistance to attend WordCamp Asia/Europe 2025</li>\n</ul>\n\n\n\n<p>If you meet the above requirements and would like to be considered, please apply as soon as possible. Applications will be accepted until the closing date of 30 November 2024 for both WordCamp Asia and WordCamp Europe.&nbsp;</p>\n\n\n\n<p>All applicants will receive notification by December 21, 2024.</p>\n\n\n\n<p>For more information, please visit the WordPress Foundation’s page <a href=\"https://wordpressfoundation.org/projects/kim-parsell-memorial-scholarship/\">about the Kim Parsell Memorial Scholarship</a>.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordcampcentral.survey.fm/wcasia-2025-kim-parsell-scholarship-application\">Kim Parsell Memorial Scholarship: WcAsia Application</a></div>\n\n\n\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordcampcentral.survey.fm/wceu-2025-kim-parsell-scholarship-application\">Kim Parsell Memorial Scholarship: WcEU Application</a></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<p>Stay tuned, as applications for the Kim Parsell Memorial Scholarship for WordCamp US will open in the coming months!</p>\n\n\n\n<p>We look forward to welcoming more of you to these incredible WordPress events and celebrating Kim’s legacy together.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Nov 2024 16:43:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Isotta Peira\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Do The Woo Community: Do the Woo WooSesh Recap, Day 1, with Courtney, Jonathan and Brian\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=86621\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/do-the-woo-woosesh-recap-day-1-with-courtney-jonathan-and-brian/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"In this episode, hosts recap WooSesh day one, focusing on WooCommerce\'s rebranding, UI enhancements, community engagement, and enterprise scalability.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Nov 2024 13:40:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Do The Woo Community: WooCommerce Developers, Keep On Top of It\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=86611\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://dothewoo.io/blog/woocommerce-developers-keep-on-top-of-it/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"Keeping on top of Woo as a developer is important. Here are the resources you\'ll find over at WooCommerce and here on Do the Woo.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Nov 2024 09:45:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: WordCamp Europe Seeks New Host City for 2026\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=178830\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wptavern.com/wordcamp-europe-seeks-new-host-city-for-2026\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1858:\"<p>WordCamp Europe is now seeking a host city for its 2026 event. Teams with experience organizing one or more WordCamps in a European city are encouraged to apply. Although hosting the world’s largest WordPress event may seem challenging, applicants will have the support of an experienced core organizing team. The organizing team will work collaboratively for around nine months before the event to ensure all preparations run smoothly.</p>\n\n\n\n<p><strong><a href=\"https://wceurope.survey.fm/wceu-2026-call-for-host-city\">Applications</a> are open until Friday, 15 November 2024. </strong>The final decision on the 2026 host city is expected by Friday, 29 November 2024. Applicants should consider an appropriate venue that can accommodate 1,500 seats in a main auditorium-style layout, with additional spaces for breakout tracks and workshops, as well as around 15 rooms for support functions.</p>\n\n\n\n<p>The Host City Selection Committee is committed to fairness, providing equal assistance to all applicants. Applications will be evaluated based on survey responses, with rankings used to determine the final selection. Preference will be given to countries that have not previously hosted WordCamp Europe, as past events have taken place in the Netherlands, Bulgaria, Spain, Austria, France, Serbia, Germany, Portugal, Greece, Italy, and Switzerland.</p>\n\n\n\n<p>The team from the selected city will be invited to join the organizing team for <a href=\"https://europe.wordcamp.org/2025/\">WordCamp Europe 2025</a> in Basel, where they will gain valuable insights. The current organizing team will provide guidance on processes, offer ongoing support, and ensure a smooth handover for the 2026 event.</p>\n\n\n\n<p>Check out the call for host cities <a href=\"https://europe.wordcamp.org/2025/call-for-host-city-2026/\">announcement</a> for more information.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Nov 2024 03:47:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Matt: Michael Palmisano on Collier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=129612\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://ma.tt/2024/11/michael-palmisano-on-collier/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:698:\"<p>I&#8217;ve been obsessed with Jacob Collier since I first saw his<a href=\"https://www.youtube.com/watch?v=pvKUttYs5ow\"> Don&#8217;t You Worry &#8216;Bout A Thing cover on YouTube</a>, and one of my favorite genres of videos is genius musicians breaking down the incredible musical stuff Jacob is doing. (<a href=\"https://colabs.taylorguitars.com/products/jacob-collier-signature-model-5-string-us\">He even has his own instrument now</a>.) This reaction and breakdown from Michael Palmisano, who is an incredible musician, go through Jacob&#8217;s amazing <a href=\"https://www.youtube.com/watch?v=IQvzX0Z3HE4\">Little Blue video</a> is amazing.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 03 Nov 2024 20:19:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"Gutenberg Times: Inline comments, new Playground blueprints, block bindings and more — Weekend Edition 310\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=30645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://gutenbergtimes.com/inline-comments-new-playground-blueprints-block-bindings-and-more-weekend-edition-310/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20673:\"<p>Howdy, </p>\n\n\n\n<p>This week, I started my <a href=\"https://x.com/bph/status/1851248209890296100\">month-long hiatus from social media</a>. It&#8217;s a completely arbitrary timing of my bi-annual ritual.  Gutenberg Times post will be shared on LinkedIn and Mastodon, automatically posted using the built-in Jetpack feature. I&#8217;ll be back after Thanksgiving Nov 29th for a few weeks before I start my year-end vacation. You might see me posting from <a href=\"https://events.wordpress.org/rome/2024/coredays/\">Core Days in Rome, Italy</a>, though. I am excited to meet contributors there and post one or two selfies. </p>\n\n\n\n<p>Speaking of Rome: it will be my first time there, and I booked a tour of Vatican City at 7am to beat the crowds. I got a few chuckles of disbelieve from hubby and other family members as I am normally not an early riser&#8230; I&#8217;ll let you know how it turns out.</p>\n\n\n\n\n\n<p>Have a splendid weekend ahead!</p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n<p class=\"has-text-align-left\">PS: <strong>Voting for <a href=\"https://thewpweekly.com/awards/\">WP Awards 2024</a></strong><a href=\"https://thewpweekly.com/awards/\"> </a>is now open, produced by <a href=\"https://x.com/idavinder\">Davinder Singh Kainth</a>.  Consider giving your vote to the  &#8220;Gutenberg Times&#8221; in the blog category and to &#8220;Gutenberg Changelog&#8221; in the podcast category, please. 🤗 </p>\n\n\n\n<p>PPS: Reminder: <strong>November 5th at 17:00 UTC</strong>: <strong><a href=\"https://www.youtube.com/watch?v=K6N098ElnYU\">WordPress 6.7 Highlights and Q &amp; A with Jamie Marsland, Nick Diego and Rich Tabor</a> </strong>Live on YouTube. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/inline-comments-new-playground-blueprints-block-bindings-and-more-weekend-edition-310/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/inline-comments-new-playground-blueprints-block-bindings-and-more-weekend-edition-310/#collaborative-editing-inline-comments\">Collaborative Editing: Inline comments</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/inline-comments-new-playground-blueprints-block-bindings-and-more-weekend-edition-310/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/inline-comments-new-playground-blueprints-block-bindings-and-more-weekend-edition-310/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/inline-comments-new-playground-blueprints-block-bindings-and-more-weekend-edition-310/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/inline-comments-new-playground-blueprints-block-bindings-and-more-weekend-edition-310/#this-week-in-wordpress-playground\">This week in WordPress Playground </a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/inline-comments-new-playground-blueprints-block-bindings-and-more-weekend-edition-310/#new-blueprints-in-the-gallery\">New Blueprints in the Gallery</a></li></ol></li></ol>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>Nathan Wrigley</strong> of WP Builds invited me to start a new podcast series called &#8220;At the Core&#8221; and to discuss with him what next for WordPress. The first episode arrived on people&#8217;s podcast app this week: <a href=\"https://wpbuilds.com/2024/10/31/396-new-show-at-the-core-with-birgit-pauli-haack-episode-1/\">At The Core with Birgit Pauli-Haack &#8211; Episode 1</a>. Wrigley is a master moderator and host. It was a great pleasure being on this show with him. We discussed a heap of information: about WordPress 6.7, WordPress Playground, Gutenberg experiments, and the 2025 default theme. And a lot more. Listen in.</p>\n\n\n\n<a href=\"https://wpbuilds.com/2024/10/31/396-new-show-at-the-core-with-birgit-pauli-haack-episode-1/\"><img width=\"652\" height=\"342\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/11/At-the-core-wpbuilds-episode-1-birgit-pauli-haack.jpg?resize=652%2C342&ssl=1\" alt=\"\" class=\"wp-image-30727\" /></a>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"collaborative-editing-inline-comments\">Collaborative Editing: Inline comments</h3>\n\n\n\n<p><strong>Pooja Bhimani</strong>, developer and project manager at <a href=\"https://www.multidots.com/\">Mulidots</a>, together with other core contributors released the <a href=\"https://github.com/WordPress/gutenberg/pull/60622\"><strong>first and experimental version for inline commenting</strong></a> to the block editor. Before you can explore it, you need to enable the experiment &#8220;Block comments&#8221; on the Gutenberg plugin. It will be released with Gutenberg 19.6 next week. You can already take a peak via the <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">Gutenberg Nightly on Playground</a>. </p>\n\n\n\n<p>Once enabled, you see an new menu item on the 3-dot-menu from the block toolbar, that opens a box in the sidebar to add your comment. A new icon appears in the toolbar once a comment is associated with a block. Then you can open, edit, delete or reply to the comment or &#8216;resolve&#8217; the issue. When you click on the canvas, you can view all the comments for this particular post. Using the star on top of the comment sidebar, you can pin the icon to the top of the screen for easy access. You can use comments on pages or posts or any other custom post types. Once the post is published, inline comments are disabled.</p>\n\n\n\n<p>As an MVP (minimally viable product) it works very well, apart from a few tiny quirks. Make sure to share your findings on GitHub or in the #outreach channel. The team also provides a list of what&#8217;s next for the inline commenting in <a href=\"https://github.com/WordPress/gutenberg/issues/66377\">this GitHub tracking issue</a></p>\n\n\n\n<a href=\"https://github.com/WordPress/gutenberg/pull/60622\"><img width=\"652\" height=\"386\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/11/Screenshot-2024-11-02-at-10.09.56.png?resize=652%2C386&ssl=1\" alt=\"\" class=\"wp-image-30736\" /></a>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>🎙️ Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-110-gutenberg-19-5-wordpress-6-7-create-block-theme-plugin/\">Gutenberg Changelog #110 – Gutenberg 19.5, WordPress 6.7, Create Block Theme Plugin and a Thousand Block Themes at the Repository</a> with Joni Halabi </p>\n\n\n\n<img width=\"652\" height=\"184\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/10/Screenshot-2024-10-25-at-17.17.35.png?resize=652%2C184&ssl=1\" alt=\"\" class=\"wp-image-30608\" />\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>On YouTube, <strong>Jamie Marsland</strong>, teaches you in <a href=\"https://www.youtube.com/watch?v=wrizp4PuGDw\"><strong>WordPress Layouts! A Beginner&#8217;s Guide</strong></a>, how to master content widths and page widths for stunning layouts. Discover the 4 essential widths:  Normal width,  Wide content width, Full width and Custom width via Global Styles and learn how your various container blocks adapt to the settings. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>At our friends over at WordPress.com, <strong>Tanya Thibodeau</strong> shared <a href=\"https://wordpress.com/blog/2024/10/31/5-powerful-gutenberg-blocks-for-developers-to-create-custom-layouts/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Five Powerful Gutenberg Blocks for Developers to Create Custom Layouts</strong></a> and explained how best to use the Group, Columns, Cover, Spacer and &#8211; my new favorite &#8211; the Query Loop block. Thibodeau has instructions and demos for each of them.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Justin Tadlock</strong> has updated the free <a href=\"https://wordpress.org/plugins/x3p0-breadcrumbs/\"><strong>X3P0: Breadcrumbs plugin</strong></a> with the option to remove the first breadcrumb. He also added a Markup Style option for selecting between plain HTML, Microdata, and RDFa (default) markup. Developer can also find new hooks that act as extension points.</p>\n\n\n\n<a href=\"https://wordpress.org/plugins/x3p0-breadcrumbs/\"><img width=\"652\" height=\"346\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/11/x3P0-Breadcrumbs.jpg?resize=652%2C346&ssl=1\" alt=\"\" class=\"wp-image-30743\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Rob O’Rourke</strong>, principal engineer at HumanMade, <a href=\"https://humanmade.com/engineering/introducing-lottie-lite-for-wordpress-animations/\"><strong>introduced  Lottie Lite for WordPress animations</strong></a> It&#8217;s a lightweight alternative to the Lottie Files plugin and is  designed to offer a simpler, more efficient solution for WordPress users. O&#8217;Rourke shared in his post the genesis of the project as its key features and how they work. Check out <a href=\"https://github.com/humanmade/lottie-lite\">Lottie Lite over on Human Made&#8217;s GitHub</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Carolina Nymark</strong>, core contributor sponsored by Yoast, and <strong>Juanfra Aldasoro</strong> are the lead developers for this year&#8217;s WordPress default theme, Twenty-Twenty-Five. During this week&#8217;s Developer Hours they gave a behind-the-scenes insight into the making of the theme. The recording is available on WordPress TV: <strong><a href=\"https://wordpress.tv/2024/10/29/developer-hours-exploring-the-twenty-twenty-five-theme/\">Developer Hours: Exploring the Twenty Twenty-Five Theme</a></strong>. </p>\n\n\n\n<p>They also shared links to dive in: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Demo site: <a href=\"https://2025.wordpress.net/\">2025.wordpress.net</a>, </li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfive\">GitHub repo</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/08/15/introducing-twenty-twenty-five/\">Introducing Twenty Twenty-Five</a></li>\n</ul>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n		\n			<div class=\"jetpack-videopress-player__wrapper\"> <div class=\"toolbelt-video-wrapper\"></div></div>\n			\n			\n		\n		</div>\n\n\n<p></p>\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2024&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p>In his tutorial, <a href=\"https://webberzone.com/custom-block-theme-templates-wordpress-plugins/\"><strong>Building Custom Block Theme Templates: A Plugin Developer’s Guide</strong></a>, <strong>Ajay D’Souza</strong>, walks plugin developer through the process to providing templates to block themes. <a href=\"https://developer.wordpress.org/news/2024/08/29/registering-block-templates-via-plugins-in-wordpress-6-7/\">WordPress 6.7 will come with a new API</a> for this use case, though. However what are plugin developers to do when they want to support older WordPress version, too? D&#8217;Souza has you covered. You learn about the nature of block theme templates and how to build a template handler, define your loading methods, and put it all together in an real-life examples. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>ICYMI: The <a href=\"https://make.wordpress.org/core/2024/10/30/recap-hallway-hangout-dataviews-and-dataform-components/\"><strong>Recap: Hallway Hangout DataViews and DataForm Components</strong></a> is now available with the recording, a summary, details, shared resources and a transcript. Riad Benguella, André Maneiro, and I discussed with Nick Diego the evolution and future of DataViews and DataForms in WordPress. The overall focus of the demonstration was to showcase the current capabilities of DataViews and DataForm, as well as the plans for future extensibility and integration with the broader WordPress admin experience. <a href=\"https://youtu.be/wApJVW8uxno\">The recording</a> is available on YouTube</p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In <strong>Justin Tadlock</strong>&#8216;s latest tutorial on the WordPress Developer blog, <a href=\"https://developer.wordpress.org/news/2024/10/29/getting-and-setting-block-binding-values-in-the-editor/\"><strong>Getting and setting Block Binding values in the Editor,</strong></a> he walks you through making the data from your custom binding sources appear in the Editor and also letting users edit that data from the connected blocks.</p>\n\n\n\n<a href=\"https://developer.wordpress.org/news/2024/10/29/getting-and-setting-block-binding-values-in-the-editor/\"><img width=\"609\" height=\"243\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/11/Screenshot-2024-11-02-at-15.08.11.png?resize=609%2C243&ssl=1\" alt=\"\" class=\"wp-image-30747\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"this-week-in-wordpress-playground\">This week in WordPress Playground </h2>\n\n\n\n<p>WordPress Playground is an exciting new platform that is the basis of a few features and tools around WordPress. Recently, it received a new, much more intuitive interface, that looks familiar to site editor users. You can learn more about this change from the new Make Blog of the Playground team. <a href=\"https://make.wordpress.org/playground/2024/09/27/running-multiple-playgrounds-with-wordpress-playground/\"><strong>Running Multiple Playgrounds with WordPress Playground</strong></a> by Brandon Payton.</p>\n\n\n\n<a href=\"https://make.wordpress.org/playground/2024/09/27/running-multiple-playgrounds-with-wordpress-playground/\"><img width=\"652\" height=\"420\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/11/Screenshot-2024-11-01-at-12.54.22.png?resize=652%2C420&ssl=1\" alt=\"screenshot playground instance\" class=\"wp-image-30724\" /></a>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"new-blueprints-in-the-gallery\">New Blueprints in the Gallery</h3>\n\n\n\n<p><strong>Jonathan Bossenger</strong>, developer educator on the WordPress training team,  added a blueprint to load the Create Block Theme plugin automatically to the next Playground instance. That way you can instantly start working on a new theme.  <a href=\"https://playground.wordpress.net/?blueprint-url=https://raw.githubusercontent.com/wordpress/blueprints/trunk/blueprints/create-block-theme/blueprint.json\">Try it out. </a></p>\n\n\n\n<p><strong>Alex Kirk</strong>, web developer from Vienna, added a blueprint to turn Playground into a feed reader with the Friends Plugin. Using it allows you to  read feeds from the web in Playground, and even via ActivityPub.  <a href=\"https://playground.wordpress.net/?blueprint-url=https://raw.githubusercontent.com/wordpress/blueprints/trunk/blueprints/friends-cors/blueprint.json\">Start reading</a> (Add the Gutenberg Times via it&#8217;s feed URL https://gutenbergtimes.com/feed) </p>\n\n\n\n<p><strong>Jason Bahl</strong>, developer of WPGraphQL, didn&#8217;t wait long to add a blueprint that <a href=\"https://playground.wordpress.net/?blueprint-url=https://raw.githubusercontent.com/wordpress/blueprints/trunk/blueprints/wpgraphql/blueprint.json\">loads WordPress with WPGraphQL active and defaults to the WPGraphQL IDE page </a>to allow users to test GraphQL queries and explore the GraphQL Schema.</p>\n\n\n\n<p>There are a few other blueprints for Playground are waiting to be discovered in the Blueprint Gallery. You can <a href=\"https://github.com/WordPress/blueprints/blob/trunk/GALLERY.md\">browse the list on GitHub</a> or on any new Playground instance. </p>\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>An interior decoration of a restaurant by wooden pieces. Malappuram, Kerala, India, by <a href=\"https://profiles.wordpress.org/sitharakp/\">Sithara Koramparambil</a> on WordPress Photos. </p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 02 Nov 2024 15:00:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Automattic and Matt Mullenweg Push for Dismissal of Key Claims in WP Engine Lawsuit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=178749\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wptavern.com/automattic-and-matt-mullenweg-push-for-dismissal-of-key-claims-in-wp-engine-lawsuit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13466:\"<p>Automattic and Matt Mullenweg have filed a response asking the court to dismiss counts 1-6 and 9-11 of&nbsp; WP Engine’s lawsuit. WP Engine had filed a motion on October 18, 2024 for a preliminary <a href=\"https://storage.courtlistener.com/recap/gov.uscourts.cand.437474/gov.uscourts.cand.437474.17.0.pdf\">injunction</a> in a Northern California court, seeking restored access to WordPress.org and a reversion to conditions as of September 20, 2024.&nbsp;</p>\n\n\n\n<p>In response, Automattic has filed three key documents: a Motion to Dismiss WP Engine’s Complaint, a Motion to Strike, and the Opposition to WP Engine’s Preliminary Injunction. </p>\n\n\n\n<p>Automattic also <a href=\"https://x.com/automattic/status/1851869479028023505\">tweeted</a>, &#8220;Today, in order to protect the community from the threat posed by <a href=\"https://x.com/wpengine\">@WPEngine</a>’s conduct, we have filed three documents with the court. These documents respond to WP Engine’s cherry-picked versions of events with critical context not found in their legal filings.&#8221; </p>\n\n\n\n<p>Let&#8217;s take a look at the main points in the documents. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Motion to Dismiss WP Engine’s Complaint&nbsp;</h3>\n\n\n\n<p>The <a href=\"https://automattic.com/wp-content/uploads/2024/10/motion-to-dismiss.pdf\">Motion to Dismiss </a>begins with the introduction, “Contrary to the allegations in WP Engine’s Complaint, the perpetrator responsible for the harms against the WordPress community is not Automattic or Matt Mullenweg (“Matt”). It is WP Engine itself. Despite its own (mis)conduct, WP Engine’s Complaint now asks this Court to compel Matt to provide various resources and support to private equity-backed WP Engine for free, in the absence of any contract, agreement, or promise to do so. The Complaint also seeks to restrict Matt’s ability to express openly his perspective that WP Engine’s practices negatively impact the WordPress software platform and community—a platform and community that has been his life’s work. There is no legal or factual basis for the Court to compel such access or restrict such speech.”</p>\n\n\n\n<p>The motion argues that “WP Engine’s complaint is full of sound and fury, but WP Engine’s allegations ultimately signify nothing. Beneath the Complaint’s tone of indignation lies an utter absence of any factual allegations that do or could plausibly state a claim for relief. The Complaint strains mightily and misleadingly to conflate the WordPress software with Matt’s Website and with the WordPress trademarks, but it is devoid of any facts establishing that Matt has any obligation to provide the resources on the Website to WP Engine.”</p>\n\n\n\n<p>It states that “WP Engine’s misleadingly curated Complaint focuses solely on the events of the last two months, but this story actually begins over two decades ago, when Matt created a new way to build websites.”</p>\n\n\n\n<p>“Contrary to the allegations of the Complaint, Automattic, founded by Matt in 2005, does not own the WordPress software but rather offers three managed WordPress hosting services, WordPress.com for everyday users; Pressable, for agencies and developers; and WordPress VIP, for high-end enterprise sites including WhiteHouse.gov, NASA, Salesforce, and CNN. The WordPress ecosystem is also supported by the WordPress Foundation (“Foundation”)—a 501(c)(3) public benefit corporation dedicated to educating the public about WordPress and open source software. The role of the Foundation is charitable, educational, and scientific.”</p>\n\n\n\n<p>The motion details the significant time and resources that Matt and Automattic contribute to WordPress.org. “Matt is the owner of the WordPress.org domain name. Matt created the Website to support the WordPress community and software. Over time, the content the Website provides has become more robust. It takes significant resources from Matt and others to maintain the Website. For example, Matt and other employees of Automattic contribute over 3,500 hours weekly to support and maintain the Website, including the core software and other features offered through the Website.”</p>\n\n\n\n<p>The motion accuses WP Engine of leveraging WordPress resources for profit while failing to contribute meaningfully back to the community and profiting off the goodwill of the WordPress and WooCommerce trademarks. It alleges that WP Engine’s shift in practices began in 2018 when private equity firm Silver Lake took majority control, leading to intensified trademark use and an increased profit-driven focus.&nbsp;</p>\n\n\n\n<p>Alleging trademark violations since 2021, the motion claims that WP Engine and Silver Lake have attempted to profit from WordPress’s reputation without bearing a share of the responsibilities. Matt had requested that WP Engine either license the WordPress trademarks or dedicate eight percent of its revenue to the further development of the open source WordPress software, but WP Engine declined.</p>\n\n\n\n<p>When it became abundantly clear to Matt that WP Engine had no interest in giving back, Matt was left with two choices: (i) continue to allow WP Engine to unfairly exploit the free resources of the Website, use the WordPress and WooCommerce trademarks without authorization, which would also threaten the very existence of those trademarks, and remain silent on the negative impact of its behavior or (ii) refuse to allow WP Engine to do that and demand publicly that WP Engine do more to support the community.</p>\n\n\n\n<p>The motion also states, “The mere fact that WP Engine made the risky decision to base its growing business on a site to which it has no rights or guarantee of access, without making backup plans, is not enough for it to conjure a claim out of legal thin air. Similarly, WP Engine’s business decision to rely on Matt’s Website does not provide any legal or factual basis for muzzling Matt and preventing him from criticizing WP Engine for acts that he believes are damaging the WordPress community.”&nbsp;</p>\n\n\n\n<p>It continues, “The real unlawful activity here is WP Engine’s infringement of the WordPress and WooCommerce trademarks. This infringement was so egregious that in the days prior to filing this lawsuit, WP Engine scurried to delete various unauthorized uses of the WordPress and WooCommerce trademarks from its website—a tacit acknowledgement of their infringing nature.”</p>\n\n\n\n<p>In short, WP Engine&#8217;s complaint fails to state claims concerning intentional interference with contractual relations, tortious interference with prospective economic advantage, Computer Fraud and Abuse Act violations, attempted extortion, and unfair competition under California Business and Professions Code § 17200.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Motion to Strike&nbsp;</h3>\n\n\n\n<p>Automattic and Matt Mullenweg have moved to<a href=\"https://automattic.com/wp-content/uploads/2024/10/motion-to-strike.pdf\"> strike parts of WP Engine’s complaint</a>, citing California’s anti-SLAPP law. They argue that WP Engine’s  “claims fail as a matter of law and must be struck under California’s anti-SLAPP law because they improperly seek to impose liability for commentary and debate on an issue of public interest—namely, WP Engine’s commitment (or lack thereof) to the WordPress community &#8211; without any valid basis. WP Engine’s attempt to stifle public discussion of those issues via these claims violates California law and should be stopped here.”</p>\n\n\n\n<p>The motion also asserts,&nbsp; “Matt was speaking and writing in his individual capacity as WordPress’s co-founder, and not as CEO of Automattic. There is no basis to impute his statements to the company. For these and other reasons, WP Engine’s ninth, tenth, and eleventh causes of action should be stricken.”</p>\n\n\n\n<p>WP Engine’s defamation claims are based on statements Mullenweg made on public platforms, which his attorneys argue are protected by the First Amendment and California law.&nbsp;</p>\n\n\n\n<p>Mullenweg’s comments about WP Engine’s &#8220;parasitic&#8221; behavior were part of a broader conversation on the tragedy-of-the-commons theory, explaining the critical importance of meaningful, sustained contributions to the WordPress community through the Five for the Future initiative. Besides, WP Engine does not challenge any of Matt’s statements.&nbsp;</p>\n\n\n\n<p>WP Engine’s trade libel claim fails to plausibly allege another required element: WP Engine has not identified any specific third party who was deterred from conducting business with WP Engine as a result of Matt’s Statements.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Opposition to WP Engine’s Preliminary Injunction</h3>\n\n\n\n<p>Automattic and Matt have requested the <a href=\"https://automattic.com/wp-content/uploads/2024/10/opposition-to-preliminary-injunction.pdf\">denial of WP Engine’s motion</a>, arguing that “WP Engine conflates the open source WordPress software with a website located at wordpress.org (“Website”) that is provided by Matt. The Website is distinct from the WordPress open source software platform and both are distinct from Automattic and the WordPress Foundation, a nonprofit public benefit corporation that was organized exclusively for charitable, scientific and educational purposes, not commercial endeavors. WP Engine’s CEO Heather Brunner feigns ignorance and reliance on a false understanding that an educational foundation was responsible for the Website that provides resources for commercial endeavors.”</p>\n\n\n\n<p>WP Engine has always had unrestricted access to the open-source WordPress software and plugins, which do not require login credentials. The only resources it cannot access are certain developer tools on WordPress.org, previously used to manage plugin versions. WP Engine quickly restored its lost functionality by hosting its plugins independently on its own website.</p>\n\n\n\n<p>WP Engine also seeks to limit competition by asking the Court to prevent Matt from criticizing its actions and to restrict Automattic from offering promotional incentives to consumers. Automattic contends that WP Engine’s purported damages, such as customer losses, result from WP Engine’s service quality rather than any actions by the defendants.</p>\n\n\n\n<p>Also “Matt does not and never has had any contracts, agreements, or obligations to provide WP Engine access to the Website. Nor did WP Engine pay any operating costs towards the Website or to access the Website for this convenience.”</p>\n\n\n\n<p>After losing access, WP Engine implemented a solution restoring its workflow by linking its plugins to its own servers. This setup has been operational for over a month, making any claimed harm from access denial either nonexistent or resolved.</p>\n\n\n\n<p>Since ACF plugin has over two million active installs, so any security vulnerability within ACF would threaten a substantial portion of the WordPress community, the WordPress security team forked that plugin, and named that fork SCF. The public was also notified of the developments.</p>\n\n\n\n<p>&#8220;WP Engine experienced a loss of income or capital in that intervening period, these losses are the result of its decision to freeride off the Website and Matt’s extensive efforts to support and maintain the Website, all the while knowing it had no contractual agreement entitling it to the continued receipt of those resources. WP Engine gambled, for the sake of profit, on Matt’s continued maintenance and provision of the Website for free. Having lost that bet, it cannot now come to the Court complaining of the consequences.&#8221;</p>\n\n\n\n<p>If an injunction is considered, the defendants argue that it should only cover access to WordPress software and plugins. WP Engine should also be required to post a bond compensating Matt for any services he might be compelled to provide, as well as Automattic for any lost revenue due to restricted competition. Maintaining WordPress.org involves annual administrative and operational costs estimated at $800,000. If WP Engine is granted ongoing access, a bond of at least $1.6 million should be posted to cover these services for the case’s expected two-year duration.</p>\n\n\n\n<p>Automattic has also issued the following <a href=\"https://automattic.com/2024/10/31/legal-response-to-wp-engine/\">public statement</a> through its blog:</p>\n\n\n\n<p>“After engaging in conduct that undermines the WordPress community, WP Engine and its private equity owner, Silver Lake, have resorted to making unfounded allegations against the founder and vanguard of the open source software.”</p>\n\n\n\n<p>“WordPress open source software remains freely available to all. But WP Engine is not entitled, either legally or morally, to have unfettered access to WordPress.org—a website Matt Mullenweg built for the benefit of a robust community.”</p>\n\n\n\n<p>“Preserving and maintaining the resources made available on WordPress.org requires considerable effort, investment, and a shared sense of mission that the plaintiff does not embrace. WP Engine and Silver Lake should not expect to profit off the back of others without carrying some of the weight, and that is all that Matt is asking.”</p>\n\n\n\n<p>The court will next hold a hearing on November 26, 2024 and WP Engine has until November 4 to respond to Automattic and Mullenweg’s filings. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 02 Nov 2024 03:32:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Disrupt Interview\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=129595\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://ma.tt/2024/11/disrupt-interview/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:517:\"<p>On Wednesday I had a great chat with Connie Loizos, the editor in chief of TechCrunch, you can view the video here:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>Then yesterday Automattic filed its legal responses to the spurious lawfare from WP Engine, Silver Lake, and Quinn Emanuel. <a href=\"https://automattic.com/2024/10/31/legal-response-to-wp-engine/\">It&#8217;s a bit long, but if you have time give it a read, it&#8217;s the first time we&#8217;ve been able to put out our full story</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 02 Nov 2024 00:12:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: GPL Clarification\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=128866\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://ma.tt/2024/11/gpl-clarification/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:915:\"<p>A quick followup on my prior <a href=\"https://www.youtube.com/watch?v=OUJgahHjAKU\">conversation with Theo</a>.</p>\n\n\n\n<p>During that chat, I talked briefly about a trademark infringer that was also distributing nulled plugins. I said “Not illegal. Legal under the GPL. But they weren’t changing the names. They were selling their customers Pro Plugins with the licensing stuff nulled out.”</p>\n\n\n\n<p>I want to be clear that my reference to legality and GPL was solely focused on the copying and modifying of the code. That is one of the key freedoms of open source and GPL: the right to copy and modify GPL code.</p>\n\n\n\n<p>I was <em>not</em> speaking about their right to charge money for nulled plugins. GPLv2 prohibits that because they aren’t providing physical copies or support. This is very different from reputable web hosts, who provide hosting and support for websites and e-commerce stores.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Nov 2024 17:00:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: Friday Shares: This Week’s Must-Reads and Community Highlights, v2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=86475\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://dothewoo.io/blog/friday-shares-this-weeks-must-reads-and-community-highlights/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:170:\"The content highlights recent updates, events, and resources within the WordPress and WooCommerce communities, emphasizing community engagement and upcoming developments.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Nov 2024 10:30:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"Gravatar: Introducing Native Integrations for Gravatar Mobile SDK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2343\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://blog.gravatar.com/2024/10/30/introducing-native-integrations-for-gravatar-mobile-sdk/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4250:\"<p>We&#8217;re excited to announce the release of native integrations for the Gravatar Mobile SDK, now available for both iOS and Android. These SDKs make it easier than ever to integrate Gravatar&#8217;s powerful avatar and profile management features into your mobile applications.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s New?</h2>\n\n\n\n<p>Our platform-specific SDKs leverage native UI frameworks &#8211; Compose for Android and Swift UI for iOS &#8211; to provide seamless integration with your existing mobile applications. Each SDK is carefully crafted to follow platform-specific best practices while maintaining consistent functionality across ecosystems.</p>\n\n\n\n<p>One of the more exciting additions is our new native Avatar Change Flow &#8211; a complete, ready-to-use UI component that can be embedded directly into your app. This feature eliminates the need to build your own avatar management system, saving you valuable development time. Users can easily update their Gravatar image through a polished, platform-native interface that handles all the complexity of image selection, cropping, and uploading.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Key Features</h2>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/slidesz/AGV_vUf0HwSEeJ6Lkgk7Y_aM3eq2zVwuENr6t7zlcQ-jpp_gFVpj6Axtm7VjQ1AqKRiMb7oj596PPAqdhy2lYTZMBgrdRxFo5M6GG3zrRai_8jNuuo0m0vMznXnXpR5pUcRLSLe_4ej_vE-w8CKNx83hFteoQg3nj1o=nw?key=WL-tUAjvcHnxVirOGhmFGA\" alt=\"\" /><em>Gravatar SDK in <a href=\"https://pocketcasts.com\" target=\"_blank\" rel=\"noreferrer noopener\">Pocket Casts</a></em>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Ready-to-Use UI Components</strong>: Display profile views and avatars with pre-built components</li>\n\n\n\n<li><strong>Efficient Avatar Management</strong>: Calculate and download avatar URLs based on email addresses</li>\n\n\n\n<li><strong>Built-in Image Caching</strong>: Optimize performance with automatic image caching</li>\n\n\n\n<li><strong>Profile Integration</strong>: Fetch and display Gravatar profiles directly within your app</li>\n\n\n\n<li><strong>Avatar Upload Support</strong>: Enable users to update their Gravatar images from your app</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Platform-Specific Benefits</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Android SDK</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Built with Kotlin and Jetpack Compose, with easy compatibility with the old view system</li>\n\n\n\n<li>Seamless integration with modern Android development workflows</li>\n\n\n\n<li>Android-specific optimizations for performance</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">iOS SDK</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Written in Swift with native iOS UI frameworks</li>\n\n\n\n<li>Available via CocoaPods and Swift Package Manager</li>\n\n\n\n<li>iOS-specific extensions including UIImageView integration</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Getting Started</h2>\n\n\n\n<p>Visit our GitHub repositories to start integrating Gravatar into your mobile apps:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Android SDK: <a href=\"https://github.com/Automattic/Gravatar-SDK-Android\">github.com/Automattic/Gravatar-SDK-Android</a></li>\n\n\n\n<li>iOS SDK: <a href=\"https://github.com/Automattic/Gravatar-SDK-iOS\">github.com/Automattic/Gravatar-SDK-iOS</a></li>\n</ul>\n\n\n\n<p>For implementation guides and detailed documentation, visit our <a href=\"https://docs.gravatar.com/sdk/\">developer site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security and Privacy</h2>\n\n\n\n<p>Your users&#8217; privacy and security are our top priority. The SDK implements secure data handling via oAuth and gives users full control over their profile visibility. </p>\n\n\n\n<p><a href=\"https://support.gravatar.com/privacy-pledge/\">Visit our privacy pledge here</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Coming Soon</h2>\n\n\n\n<p>We&#8217;re actively working on expanding the SDK&#8217;s capabilities with full profile editing support. This upcoming feature will allow users to manage additional profile fields and user information directly within your app, making it even easier to provide a comprehensive Gravatar integration experience.</p>\n\n\n\n<p>We&#8217;re committed to improving the developer experience and would love to hear your feedback. Try out the new SDKs and let us know what you think!</p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Oct 2024 15:39:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 22 Nov 2024 09:21:59 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:13:\"last-modified\";s:29:\"Fri, 22 Nov 2024 09:15:30 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1732310520;s:23:\"__cache_expiration_time\";i:1732310520;}","off");
INSERT INTO wp_options VALUES("150","_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1732310520","off");
INSERT INTO wp_options VALUES("151","_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1732267320","off");
INSERT INTO wp_options VALUES("152","_transient_timeout_dash_v2_f69de0bbfe7eaa113146875f40c02000","1732310520","off");
INSERT INTO wp_options VALUES("153","_transient_dash_v2_f69de0bbfe7eaa113146875f40c02000","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://ru.wordpress.org/news/2023/12/scam-alert-2023/\'>Предупреждение о мошенниках</a></li><li><a class=\'rsswidget\' href=\'https://ru.wordpress.org/news/2023/09/2023-wordpress-survey/\'>Ежегодный опрос пользователей и участников разработки WordPress 2023</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://ma.tt/2024/11/welcoming-harper/\'>Matt: Welcoming Harper</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/peepso-leaves-wordpress-plugin-repository\'>WPTavern: PeepSo Leaves WordPress Plugin Repository</a></li><li><a class=\'rsswidget\' href=\'https://dothewoo.io/ai-devops-and-accessibility-in-woocommerce-with-anick-akbar/\'>Do The Woo Community: AI, DevOps, and Accessibility in WooCommerce with Anick Akbar</a></li></ul></div>","off");
INSERT INTO wp_options VALUES("157","finished_updating_comment_type","1","auto");
INSERT INTO wp_options VALUES("162","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/ru_RU/wordpress-6.7.1.zip\";s:6:\"locale\";s:5:\"ru_RU\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/ru_RU/wordpress-6.7.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.1\";s:7:\"version\";s:5:\"6.7.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1732268457;s:15:\"version_checked\";s:5:\"6.7.1\";s:12:\"translations\";a:0:{}}","off");
INSERT INTO wp_options VALUES("165","current_theme","JupiterX","auto");
INSERT INTO wp_options VALUES("166","theme_mods_jupiterx","a:3:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1732267933;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_primary\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:17:\"sidebar_secondary\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:23:\"footer_widgets_column_1\";a:0:{}s:23:\"footer_widgets_column_2\";a:0:{}s:23:\"footer_widgets_column_3\";a:0:{}s:23:\"footer_widgets_column_4\";a:0:{}s:23:\"footer_widgets_column_5\";a:0:{}s:23:\"footer_widgets_column_6\";a:0:{}}}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}","on");
INSERT INTO wp_options VALUES("167","theme_switched","","auto");
INSERT INTO wp_options VALUES("168","jupiterx","a:8:{s:7:\"api_key\";s:9:\"activated\";s:13:\"theme_version\";s:5:\"4.4.0\";s:21:\"theme_current_version\";s:5:\"4.4.0\";s:23:\"mods_migrated_from_lite\";b:1;s:28:\"first_installation_after_250\";b:1;s:18:\"has_page_title_bar\";b:1;s:30:\"jupiterx_selected_google_fonts\";a:0:{}s:11:\"svg_support\";i:1;}","auto");
INSERT INTO wp_options VALUES("171","_transient_timeout_jupiterx_sellkit_pro_link","1732289065","off");
INSERT INTO wp_options VALUES("172","_transient_jupiterx_sellkit_pro_link","https://d1rfs5xwxtkv4m.cloudfront.net/updates/1.9.2/1107ea73-3654-471c-96a7-5d3a0bf49998/sellkit-pro.zip?Expires=1732868283&Signature=E4aoYDQPwtSDL0psHx27unrzqgtIvaHDo2Jf7akVFLVMNTnnb6A5Q9dwv3LLoDdFO0i~3sxOjN85UJrG5j0S6fj0yK7iRxLhfwvwcAtw-D9XwUc1wbvlcnCXNuSrb3-rgPo8AgoBHReFvkbzKd~7Wo49ZhsPoEBfCIRDNCt9aruqZnYw6N5aHKN3KeocPd-a9GrvXx0B9yAsk-HoQLxykgrXOXPAvyyndvn1gswPh5gxPIuJCSzHENDAoOAEPRNrvrxHMePXINVhy2AvLKsSiH3k~ybAsAq9958JuEC5y2lNdxrs2UhN8S70j0qJvZbDObhlVDKlPVB0WcAI-Kcxbg__&Key-Pair-Id=K2A7AZRN7F76V9","off");
INSERT INTO wp_options VALUES("183","theme_mods_jupiterx-child","a:2:{s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1732267525;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_primary\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:17:\"sidebar_secondary\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:23:\"footer_widgets_column_1\";a:0:{}s:23:\"footer_widgets_column_2\";a:0:{}s:23:\"footer_widgets_column_3\";a:0:{}s:23:\"footer_widgets_column_4\";a:0:{}s:23:\"footer_widgets_column_5\";a:0:{}s:23:\"footer_widgets_column_6\";a:0:{}}}}","off");
INSERT INTO wp_options VALUES("189","_site_transient_wp_plugin_dependencies_plugin_data","a:0:{}","off");
INSERT INTO wp_options VALUES("190","recently_activated","a:0:{}","off");
INSERT INTO wp_options VALUES("219","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1732268482;s:7:\"checked\";a:2:{s:8:\"jupiterx\";s:5:\"4.4.0\";s:16:\"twentytwentyfive\";s:3:\"1.0\";}s:8:\"response\";a:1:{s:8:\"jupiterx\";a:4:{s:5:\"theme\";s:8:\"jupiterx\";s:7:\"package\";b:0;s:11:\"new_version\";s:5:\"4.8.5\";s:3:\"url\";b:0;}}s:9:\"no_update\";a:1:{s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.0.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}}s:12:\"translations\";a:0:{}}","off");
INSERT INTO wp_options VALUES("226","_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a","1732279105","off");
INSERT INTO wp_options VALUES("227","_site_transient_poptags_40cd750bba9870f18aada2478b24840a","O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:6622;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4855;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2791;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2681;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2090;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1985;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1930;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1777;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1589;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1588;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1558;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1547;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1512;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1503;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1441;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1313;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1188;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1170;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1160;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1151;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1032;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1021;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:991;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:990;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:950;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:939;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:924;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:907;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:900;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:898;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:897;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:896;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:850;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:832;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:818;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:809;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:781;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:779;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:758;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:756;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:753;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:735;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:718;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:703;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:700;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:673;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:662;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:656;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:634;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:634;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:633;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:614;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:612;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:605;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:604;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:602;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:601;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:600;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:599;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:591;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:581;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:579;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:577;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:575;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:574;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:570;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:569;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:556;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:553;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:543;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:541;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:536;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:528;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:523;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:519;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:515;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:503;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:501;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:492;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:491;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:464;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:461;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:456;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:454;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:451;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:449;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:449;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:446;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:445;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:440;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:434;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:431;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:429;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:419;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:418;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:416;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:404;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:398;}s:3:\"map\";a:3:{s:4:\"name\";s:3:\"map\";s:4:\"slug\";s:3:\"map\";s:5:\"count\";i:394;}}","off");
INSERT INTO wp_options VALUES("230","jupiterx_theme_update_modal","dismiss","auto");
INSERT INTO wp_options VALUES("231","widget_jupiterx_social","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("232","widget_jupiterx_posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO wp_options VALUES("233","jet_engine_modules","a:3:{i:0;s:13:\"booking-forms\";i:1;s:18:\"listing-injections\";i:2;s:8:\"calendar\";}","auto");
INSERT INTO wp_options VALUES("237","jet-license-data","a:1:{s:12:\"license-list\";a:0:{}}","auto");
INSERT INTO wp_options VALUES("238","_site_transient_timeout_jet_dashboard_license_expire_check","1732311553","off");
INSERT INTO wp_options VALUES("239","_site_transient_jet_dashboard_license_expire_check","true","off");
INSERT INTO wp_options VALUES("240","_transient_timeout_jupiterx_templates_filters","1732354758","off");
INSERT INTO wp_options VALUES("241","_transient_jupiterx_templates_filters","a:6:{s:8:\"category\";a:16:{s:13:\"blog-magazine\";s:15:\"Blog / Magazine\";s:9:\"corporate\";s:9:\"Corporate\";s:18:\"creative-portfolio\";s:20:\"Creative / Portfolio\";s:9:\"education\";s:9:\"Education\";s:13:\"entertainment\";s:13:\"Entertainment\";s:6:\"events\";s:6:\"Events\";s:4:\"food\";s:4:\"Food\";s:13:\"health-beauty\";s:19:\"Health &amp; Beauty\";s:17:\"listing-directory\";s:19:\"Listing / Directory\";s:4:\"misc\";s:4:\"Misc\";s:10:\"non-profit\";s:10:\"Non Profit\";s:12:\"products-app\";s:14:\"Products / App\";s:7:\"service\";s:7:\"Service\";s:4:\"shop\";s:4:\"Shop\";s:6:\"sports\";s:6:\"Sports\";s:6:\"travel\";s:6:\"Travel\";}s:5:\"style\";a:4:{s:7:\"elegant\";s:7:\"Elegant\";s:4:\"flat\";s:4:\"Flat\";s:7:\"minimal\";s:7:\"Minimal\";s:8:\"parallax\";s:8:\"Parallax\";}s:12:\"content_type\";a:2:{s:10:\"multi_page\";s:10:\"Multi-Page\";s:8:\"one_page\";s:8:\"One Page\";}s:10:\"components\";a:6:{s:4:\"blog\";s:4:\"Blog\";s:12:\"booking_form\";s:13:\"Booking Forms\";s:5:\"popup\";s:5:\"Popup\";s:9:\"portfolio\";s:9:\"Portfolio\";s:4:\"shop\";s:4:\"Shop\";s:9:\"slideshow\";s:9:\"Slideshow\";}s:9:\"menu_type\";a:4:{s:6:\"burger\";s:6:\"Burger\";s:11:\"full_screen\";s:11:\"Full Screen\";s:9:\"mega_menu\";s:9:\"Mega Menu\";s:6:\"normal\";s:6:\"Normal\";}s:11:\"header_type\";a:4:{s:9:\"multi_row\";s:9:\"Multi Row\";s:7:\"regular\";s:7:\"Regular\";s:11:\"transparent\";s:11:\"Transparent\";s:8:\"vertical\";s:8:\"Vertical\";}}","off");
INSERT INTO wp_options VALUES("251","jupiterx_tgmpa_plugins","a:26:{i:0;a:19:{s:2:\"id\";i:37690;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"Jupiter X Core\";s:8:\"headline\";s:0:\"\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:0:\"\";s:4:\"slug\";s:13:\"jupiterx-core\";s:8:\"basename\";s:31:\"jupiterx-core/jupiterx-core.php\";s:7:\"img_url\";s:87:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/jupiterx-cofe-icon.png\";s:4:\"desc\";s:107:\"Enables the customizer settings in Jupiter X. Also, some other theme functionalities depend on this plugin.\";s:6:\"source\";s:100:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/11/jupiterx-core-4.8.5.zip\";s:7:\"version\";s:5:\"4.8.5\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:59:\"https://my.artbees.net/docs/jupiter-x-core-plugin-overview/\";s:11:\"is_callable\";s:13:\"JupiterX_Core\";s:10:\"label_type\";s:0:\"\";s:8:\"releases\";s:0:\"\";}i:1;a:17:{s:2:\"id\";i:37695;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:22:\"Advanced Custom Fields\";s:8:\"headline\";s:0:\"\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:0:\"\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:8:\"basename\";s:30:\"advanced-custom-fields/acf.php\";s:7:\"img_url\";s:90:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-acf-icon.png\";s:4:\"desc\";s:134:\"Adds the page options to Jupiter X so you can override the global settings on each page. Add and edit extra fields to your post types.\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:11:\"is_callable\";s:3:\"ACF\";s:10:\"label_type\";s:0:\"\";s:8:\"releases\";s:0:\"\";}i:2;a:17:{s:2:\"id\";i:37698;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Elementor\";s:8:\"headline\";s:0:\"\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:0:\"\";s:4:\"slug\";s:9:\"elementor\";s:8:\"basename\";s:23:\"elementor/elementor.php\";s:7:\"img_url\";s:96:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-elementor-icon.png\";s:4:\"desc\";s:162:\"The default page builder with Jupiter X. It allows you to edit the pages in a real WYSIWYG editor. Currently known as the most advanced page builder in the world.\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:74:\"https://help.artbees.net/getting-started/plugins/elementor-plugin-overview\";s:11:\"is_callable\";s:16:\"Elementor\\Plugin\";s:10:\"label_type\";s:0:\"\";s:8:\"releases\";s:0:\"\";}i:3;a:19:{s:2:\"id\";i:37586;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:5:\"Raven\";s:8:\"headline\";s:0:\"\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:0:\"\";s:4:\"slug\";s:5:\"raven\";s:8:\"basename\";s:15:\"raven/raven.php\";s:7:\"img_url\";s:92:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-raven-icon.png\";s:4:\"desc\";s:189:\"20+ new elements exclusively developed by Artbees for Elementor. Also, Header, Footer and custom post type templates in the Free version of Elementor will be available by using this plugin.\";s:6:\"source\";s:94:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2020/09/raven-v1.11.0.zip\";s:7:\"version\";s:6:\"1.11.0\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:70:\"https://help.artbees.net/getting-started/plugins/raven-plugin-overview\";s:11:\"is_callable\";s:12:\"Raven\\Plugin\";s:10:\"label_type\";s:0:\"\";s:8:\"releases\";O:8:\"stdClass\":2:{s:6:\"item-0\";O:8:\"stdClass\":2:{s:14:\"_version_label\";s:1:\"I\";s:15:\"_version_number\";s:5:\"1.3.0\";}s:6:\"item-1\";O:8:\"stdClass\":2:{s:14:\"_version_label\";s:2:\"II\";s:15:\"_version_number\";s:5:\"1.3.1\";}}}i:4;a:19:{s:2:\"id\";i:37701;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:12:\"Jet Elements\";s:8:\"headline\";s:26:\"Get More Elementor Widgets\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/edflWQvInNc\";s:15:\"large_thumbnail\";s:83:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Jet-elements-2.jpg\";s:4:\"slug\";s:12:\"jet-elements\";s:8:\"basename\";s:29:\"jet-elements/jet-elements.php\";s:7:\"img_url\";s:99:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-elements-icon.png\";s:4:\"desc\";s:62:\"Adds different Elements and widgets to Elementor page builder.\";s:6:\"source\";s:102:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/11/jet-elements-v2.7.1.1.zip\";s:7:\"version\";s:7:\"2.7.1.1\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://my.artbees.net/docs/jetelements-plugin-overview/\";s:11:\"is_callable\";s:12:\"Jet_Elements\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:5;a:19:{s:2:\"id\";i:37706;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Blog\";s:8:\"headline\";s:18:\"Create Better Blog\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/80LaNrv9fZ8\";s:15:\"large_thumbnail\";s:79:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Jet-Blog-2.jpg\";s:4:\"slug\";s:8:\"jet-blog\";s:8:\"basename\";s:21:\"jet-blog/jet-blog.php\";s:7:\"img_url\";s:95:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-blog-icon.png\";s:4:\"desc\";s:90:\"Adds advanced widgets to Elementor and let you build a powerful blog and magazine website.\";s:6:\"source\";s:96:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/08/jet-blog-v2.4.0.zip\";s:7:\"version\";s:5:\"2.4.0\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:52:\"https://my.artbees.net/docs/jetblog-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Blog\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:6;a:19:{s:2:\"id\";i:37711;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Menu\";s:8:\"headline\";s:21:\"Create Advanced Menus\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/Pndy-eEgGsY\";s:15:\"large_thumbnail\";s:79:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Jet-Menu-2.jpg\";s:4:\"slug\";s:8:\"jet-menu\";s:8:\"basename\";s:21:\"jet-menu/jet-menu.php\";s:7:\"img_url\";s:95:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-menu-icon.png\";s:4:\"desc\";s:52:\"Advanced mega menu addon for Elementor page builder.\";s:6:\"source\";s:96:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/10/jet-menu-v2.4.5.zip\";s:7:\"version\";s:5:\"2.4.5\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:52:\"https://my.artbees.net/docs/jetmenu-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Menu\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:7;a:19:{s:2:\"id\";i:37716;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Jet Popup\";s:8:\"headline\";s:25:\"Create Pop-ups and Modals\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/pgINfIT8hKk\";s:15:\"large_thumbnail\";s:78:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Jet-Popup.jpg\";s:4:\"slug\";s:9:\"jet-popup\";s:8:\"basename\";s:23:\"jet-popup/jet-popup.php\";s:7:\"img_url\";s:96:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-popup-icon.png\";s:4:\"desc\";s:55:\"The advanced plugin for creating popups with Elementor.\";s:6:\"source\";s:97:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/10/jet-popup-v2.0.7.zip\";s:7:\"version\";s:5:\"2.0.7\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:53:\"https://my.artbees.net/docs/jetpopup-plugin-overview/\";s:11:\"is_callable\";s:9:\"Jet_Popup\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:8;a:19:{s:2:\"id\";i:37721;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Tabs\";s:8:\"headline\";s:41:\"Create Tabs with Extended Functionalities\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/WgOJEQrMEFg\";s:15:\"large_thumbnail\";s:79:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Jet-Tabs-2.jpg\";s:4:\"slug\";s:8:\"jet-tabs\";s:8:\"basename\";s:21:\"jet-tabs/jet-tabs.php\";s:7:\"img_url\";s:95:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-tabs-icon.png\";s:4:\"desc\";s:56:\"Advanced Tabs and Accordions for Elementor Page Builder.\";s:6:\"source\";s:96:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/10/jet-tabs-v2.2.5.zip\";s:7:\"version\";s:5:\"2.2.5\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:52:\"https://my.artbees.net/docs/jettabs-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Tabs\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:9;a:19:{s:2:\"id\";i:37726;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"Jet WooBuilder\";s:8:\"headline\";s:23:\"Customize Product Pages\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/vvMrjACSnzo\";s:15:\"large_thumbnail\";s:85:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Jet-woobuilder-2.jpg\";s:4:\"slug\";s:15:\"jet-woo-builder\";s:8:\"basename\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:7:\"img_url\";s:101:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-woobuilder-icon.png\";s:4:\"desc\";s:131:\"Custom shop templates for WooCommerce. Adds some widgets to Elementor that can be used inside and outside of WooCommerce templates.\";s:6:\"source\";s:104:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/09/jet-woo-builder-v2.1.14.zip\";s:7:\"version\";s:6:\"2.1.14\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:58:\"https://my.artbees.net/docs/jetwoobuilder-plugin-overview/\";s:11:\"is_callable\";s:15:\"Jet_Woo_Builder\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:10;a:19:{s:2:\"id\";i:37731;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:10:\"Jet Tricks\";s:8:\"headline\";s:21:\"Create Visual Effects\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/mfGuDEsixFs\";s:15:\"large_thumbnail\";s:81:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Jet-Tricks-2.jpg\";s:4:\"slug\";s:10:\"jet-tricks\";s:8:\"basename\";s:25:\"jet-tricks/jet-tricks.php\";s:7:\"img_url\";s:97:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-tricks-icon.png\";s:4:\"desc\";s:124:\"Use different eye-catching stylish animation effects and let your content become truly alive with outstanding visual tricks.\";s:6:\"source\";s:99:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/10/jet-tricks-v1.4.10.zip\";s:7:\"version\";s:6:\"1.4.10\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:54:\"https://my.artbees.net/docs/jettricks-plugin-overview/\";s:11:\"is_callable\";s:10:\"Jet_Tricks\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:11;a:19:{s:2:\"id\";i:37736;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:10:\"Jet Engine\";s:8:\"headline\";s:31:\"Create Dynamic Fields and Pages\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/aP_jHmX9hd4\";s:15:\"large_thumbnail\";s:81:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Jet-Engine-2.jpg\";s:4:\"slug\";s:10:\"jet-engine\";s:8:\"basename\";s:25:\"jet-engine/jet-engine.php\";s:7:\"img_url\";s:97:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-engine-icon.png\";s:4:\"desc\";s:146:\"Create and manage custom post types, listings and booking forms for them. Completely compatible with Jupiter X Custom Post Type templates feature.\";s:6:\"source\";s:98:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/10/jet-engine-v3.5.7.zip\";s:7:\"version\";s:5:\"3.5.7\";s:8:\"required\";b:0;s:11:\"recommended\";s:4:\"true\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:54:\"https://my.artbees.net/docs/jetengine-plugin-overview/\";s:11:\"is_callable\";s:10:\"Jet_Engine\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:12;a:19:{s:2:\"id\";i:37741;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:16:\"Jet SmartFilters\";s:8:\"headline\";s:32:\"Create Filters For Any Post Type\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/uJ2efTTaxD8\";s:15:\"large_thumbnail\";s:87:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Jet-SmartFilters-2.jpg\";s:4:\"slug\";s:17:\"jet-smart-filters\";s:8:\"basename\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:7:\"img_url\";s:103:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-smartfilters-icon.png\";s:4:\"desc\";s:107:\"Adds easy-to-use AJAX filters and widgets to Elementor so you can easily manage your listings and products.\";s:6:\"source\";s:106:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/10/jet-smart-filters-3.5.7.1.zip\";s:7:\"version\";s:7:\"3.5.7.1\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:60:\"https://my.artbees.net/docs/jetsmartfilters-plugin-overview/\";s:11:\"is_callable\";s:17:\"Jet_Smart_Filters\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:13;a:19:{s:2:\"id\";i:37746;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:40:\"WPBakery Page Builder (Modified Version)\";s:8:\"headline\";s:61:\"Use Another Page Builder to Migrate from Jupiter to Jupiter X\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:77:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/wpbakery.jpg\";s:4:\"slug\";s:17:\"js_composer_theme\";s:8:\"basename\";s:33:\"js_composer_theme/js_composer.php\";s:7:\"img_url\";s:99:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-js_composer_theme.svg\";s:4:\"desc\";s:140:\"Another page builder with Jupiter X. It can work along side Elementor. Best for the websites that want to migrate from Jupiter to Jupiter X.\";s:6:\"source\";s:102:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/08/js_composer_theme.7.9.zip\";s:7:\"version\";s:3:\"7.9\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:0:\"\";s:11:\"is_callable\";s:10:\"Vc_Manager\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:14;a:19:{s:2:\"id\";i:37751;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:13:\"Jupiter Donut\";s:8:\"headline\";s:48:\"Add Jupiter Shortcodes For WPBakery Page Builder\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:75:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/donut2.jpg\";s:4:\"slug\";s:13:\"jupiter-donut\";s:8:\"basename\";s:31:\"jupiter-donut/jupiter-donut.php\";s:7:\"img_url\";s:95:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jupiter-donut.png\";s:4:\"desc\";s:205:\"80+ shortcodes for WPBakery Page Builder. These shortcodes were available in Jupiter and are necessary if you are migrating your theme from Jupiter to Jupiter X and still want to use WPBakery Page Builder.\";s:6:\"source\";s:101:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/03/jupiter-donut-v1.6.1.zip\";s:7:\"version\";s:5:\"1.6.1\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:0:\"\";s:11:\"is_callable\";s:13:\"Jupiter_Donut\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:15;a:17:{s:2:\"id\";i:37759;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:23:\"Menu Icons by ThemeIsle\";s:8:\"headline\";s:17:\"Add Icons to Menu\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:79:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Menu-Icons.jpg\";s:4:\"slug\";s:10:\"menu-icons\";s:8:\"basename\";s:25:\"menu-icons/menu-icons.php\";s:7:\"img_url\";s:92:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-menu-icons.png\";s:4:\"desc\";s:30:\"Adds icons to your menu items.\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:55:\"https://my.artbees.net/docs/menu-icons-plugin-overview/\";s:11:\"is_callable\";s:10:\"Menu_Icons\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:16;a:19:{s:2:\"id\";i:37762;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:17:\"Slider Revolution\";s:8:\"headline\";s:14:\"Create Sliders\";s:5:\"video\";s:43:\"https://www.youtube.com/watch?v=mn5hC07aGvE\";s:15:\"large_thumbnail\";s:80:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/sliderrev-2.jpg\";s:4:\"slug\";s:9:\"revslider\";s:8:\"basename\";s:23:\"revslider/revslider.php\";s:7:\"img_url\";s:91:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/slider-revolution-icon.png\";s:4:\"desc\";s:55:\"One of the most advanced premium sliders for WordPress.\";s:6:\"source\";s:98:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/11/revslider-v6.7.21.zip\";s:7:\"version\";s:6:\"6.7.21\";s:8:\"required\";b:0;s:11:\"recommended\";s:4:\"true\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:62:\"https://my.artbees.net/docs/slider-revolution-plugin-overview/\";s:11:\"is_callable\";s:14:\"RevSliderFront\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:17;a:19:{s:2:\"id\";i:37767;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:13:\"Master Slider\";s:8:\"headline\";s:14:\"Create Sliders\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:82:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/Master-Slider.jpg\";s:4:\"slug\";s:12:\"masterslider\";s:8:\"basename\";s:29:\"masterslider/masterslider.php\";s:7:\"img_url\";s:100:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-master-slider-icon.jpg\";s:4:\"desc\";s:55:\"One of the most advanced premium sliders for WordPress.\";s:6:\"source\";s:100:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/dlm_uploads/2024/08/masterslider-v3.7.8.zip\";s:7:\"version\";s:5:\"3.7.8\";s:8:\"required\";b:0;s:11:\"recommended\";s:4:\"true\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:58:\"https://my.artbees.net/docs/master-slider-plugin-overview/\";s:11:\"is_callable\";s:13:\"Master_Slider\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:18;a:19:{s:2:\"id\";i:37769;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"headline\";s:14:\"Create Sliders\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:85:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/LayerSlider-WP-2.jpg\";s:4:\"slug\";s:11:\"LayerSlider\";s:8:\"basename\";s:27:\"LayerSlider/layerslider.php\";s:7:\"img_url\";s:99:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-layer-slider-icon.png\";s:4:\"desc\";s:108:\"Popular advanced Slider plugin. Build and publish your sliders on your website. License is \"In-Stock Usage\".\";s:6:\"source\";s:89:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2024/11/layersliderwp-7.13.0.zip\";s:7:\"version\";s:6:\"7.13.0\";s:8:\"required\";b:0;s:11:\"recommended\";s:4:\"true\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:57:\"https://my.artbees.net/docs/layer-slider-plugin-overview/\";s:11:\"is_callable\";s:9:\"LS_Config\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:19;a:17:{s:2:\"id\";i:37772;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:11:\"WooCommerce\";s:8:\"headline\";s:23:\"Build eCommerce Website\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:80:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/WooCommerce.jpg\";s:4:\"slug\";s:11:\"woocommerce\";s:8:\"basename\";s:27:\"woocommerce/woocommerce.php\";s:7:\"img_url\";s:98:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-woocommerce-icon.png\";s:4:\"desc\";s:131:\"Create and manage your e-commerce website with this plugin. After activating, the Shop section in the Customizer will be available.\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:56:\"https://my.artbees.net/docs/woocommerce-plugin-overview/\";s:11:\"is_callable\";s:11:\"WooCommerce\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:20;a:17:{s:2:\"id\";i:37774;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:24:\"Customizer Export/Import\";s:8:\"headline\";s:42:\"Add Export and Import Option to Customizer\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:93:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/customizer-import-export.jpg\";s:4:\"slug\";s:24:\"customizer-export-import\";s:8:\"basename\";s:53:\"customizer-export-import/customizer-export-import.php\";s:7:\"img_url\";s:111:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-customizer-export-import-icon.png\";s:4:\"desc\";s:112:\"Adds the Export and import option to the Customizer. Useful for theme migrations and moving to the child themes.\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:69:\"https://my.artbees.net/docs/customizer-export-import-plugin-overview/\";s:11:\"is_callable\";s:8:\"CEI_Core\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:21;a:17:{s:2:\"id\";i:37776;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:16:\"Customizer Reset\";s:8:\"headline\";s:26:\"Reset Theme Customizations\";s:5:\"video\";s:0:\"\";s:15:\"large_thumbnail\";s:85:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/customizer-reset.jpg\";s:4:\"slug\";s:26:\"customizer-reset-by-wpzoom\";s:8:\"basename\";s:47:\"customizer-reset-by-wpzoom/customizer-reset.php\";s:7:\"img_url\";s:103:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-customizer-reset-icon.png\";s:4:\"desc\";s:107:\"Reset theme customizations made via WordPress Customizer. Useful for troubleshooting the customizer issues.\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:61:\"https://my.artbees.net/docs/customizer-reset-plugin-overview/\";s:11:\"is_callable\";s:21:\"ZOOM_Customizer_Reset\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:22;a:17:{s:2:\"id\";i:45885;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"WunderWP\";s:8:\"headline\";s:65:\"Build Pages Quickly With Presets and Reusable Styles or Templates\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/nW4vduTqD64\";s:15:\"large_thumbnail\";s:79:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2020/02/wunderwp-2.jpg\";s:4:\"slug\";s:8:\"wunderwp\";s:8:\"basename\";s:21:\"wunderwp/wunderwp.php\";s:7:\"img_url\";s:89:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2020/02/wunderwp_plugin_icon.png\";s:4:\"desc\";s:151:\"Save and reuse your Elementor styles or templates in the WunderWP Cloud or use readymade styles to quickly beautify your Elementor pages. All for free!\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:21:\"https://wunderwp.com/\";s:11:\"is_callable\";s:8:\"WunderWP\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:23;a:17:{s:2:\"id\";i:74379;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Growmatik\";s:8:\"headline\";s:44:\"All-in-one Personalized Marketing Automation\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/vdk09PMWit4\";s:15:\"large_thumbnail\";s:78:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2020/08/growmatik.jpg\";s:4:\"slug\";s:40:\"marketing-automation-and-personalization\";s:8:\"basename\";s:54:\"marketing-automation-and-personalization/growmatik.php\";s:7:\"img_url\";s:83:\"https://d1rmtpfhfy6afv.cloudfront.net/wp-content/uploads/2020/08/growmatik-logo.png\";s:4:\"desc\";s:150:\"Growmatik automates your marketing and personalizes your customer experience across their journey by highly-personalized web pages, emails and popups.\";s:8:\"required\";b:0;s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:93:\"https://app.growmatik.ai/start/?utm_source=JupiterXSuggestedPlugin&utm_campaign=JupiterXAdmin\";s:11:\"is_callable\";s:9:\"Growmatik\";s:10:\"label_type\";s:8:\"Optional\";s:8:\"releases\";s:0:\"\";}i:24;a:5:{s:2:\"id\";i:99998;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:7:\"Sellkit\";s:4:\"slug\";s:7:\"sellkit\";s:8:\"basename\";s:19:\"sellkit/sellkit.php\";}i:25;a:8:{s:2:\"id\";i:99999;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:11:\"Sellkit Pro\";s:4:\"slug\";s:11:\"sellkit-pro\";s:6:\"source\";s:505:\"https://d1rfs5xwxtkv4m.cloudfront.net/updates/1.9.2/1107ea73-3654-471c-96a7-5d3a0bf49998/sellkit-pro.zip?Expires=1732868283&Signature=E4aoYDQPwtSDL0psHx27unrzqgtIvaHDo2Jf7akVFLVMNTnnb6A5Q9dwv3LLoDdFO0i~3sxOjN85UJrG5j0S6fj0yK7iRxLhfwvwcAtw-D9XwUc1wbvlcnCXNuSrb3-rgPo8AgoBHReFvkbzKd~7Wo49ZhsPoEBfCIRDNCt9aruqZnYw6N5aHKN3KeocPd-a9GrvXx0B9yAsk-HoQLxykgrXOXPAvyyndvn1gswPh5gxPIuJCSzHENDAoOAEPRNrvrxHMePXINVhy2AvLKsSiH3k~ybAsAq9958JuEC5y2lNdxrs2UhN8S70j0qJvZbDObhlVDKlPVB0WcAI-Kcxbg__&Key-Pair-Id=K2A7AZRN7F76V9\";s:11:\"source_type\";s:8:\"external\";s:9:\"file_path\";s:27:\"sellkit-pro/sellkit-pro.php\";s:8:\"basename\";s:27:\"sellkit-pro/sellkit-pro.php\";}}","off");
INSERT INTO wp_options VALUES("280","wp_sellkit-pro-database-updater_batch_f0136b4538cdf19a23f1541a0c","a:1:{i:0;a:2:{s:17:\"callback_function\";s:27:\"check_database_tables_1_0_0\";s:10:\"db_version\";s:5:\"1.0.0\";}}","off");
INSERT INTO wp_options VALUES("282","sellkit","a:1:{s:22:\"pro_current_db_version\";s:5:\"1.0.0\";}","auto");
INSERT INTO wp_options VALUES("297","acf_first_activated_version","6.3.10.2","on");
INSERT INTO wp_options VALUES("298","acf_site_health","{\"version\":\"6.3.10.2\",\"plugin_type\":\"Free\",\"wp_version\":\"6.7.1\",\"mysql_version\":\"5.7.35-38\",\"is_multisite\":false,\"active_theme\":{\"name\":\"JupiterX\",\"version\":\"4.4.0\",\"theme_uri\":\"https:\\/\\/jupiterx.artbees.net\\/\",\"stylesheet\":false},\"active_plugins\":{\"elementor\\/elementor.php\":{\"name\":\"Elementor\",\"version\":\"3.25.9\",\"plugin_uri\":\"https:\\/\\/elementor.com\\/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash\"},\"jet-engine\\/jet-engine.php\":{\"name\":\"JetEngine\",\"version\":\"3.4.4\",\"plugin_uri\":\"https:\\/\\/crocoblock.com\\/plugins\\/jetengine\\/\"},\"jupiterx-core\\/jupiterx-core.php\":{\"name\":\"Jupiter X Core\",\"version\":\"4.4.0\",\"plugin_uri\":\"https:\\/\\/jupiterx.com\"},\"advanced-custom-fields\\/acf.php\":{\"name\":\"Secure Custom Fields\",\"version\":\"6.3.10.2\",\"plugin_uri\":\"http:\\/\\/wordpress.org\\/plugins\\/advanced-custom-fields\\/\"},\"sellkit-pro\\/sellkit-pro.php\":{\"name\":\"Sellkit Pro\",\"version\":\"1.7.8\",\"plugin_uri\":\"https:\\/\\/artbees.net\"}},\"ui_field_groups\":\"0\",\"php_field_groups\":\"0\",\"json_field_groups\":\"0\",\"rest_field_groups\":\"0\",\"number_of_fields_by_type\":{\"select\":3,\"number\":2,\"image\":1,\"jupiterx_template\":4,\"tab\":4,\"message\":5,\"true_false\":5,\"button_group\":17,\"jupiterx-divider\":2,\"widget_area\":2,\"accordion\":2,\"group\":2,\"textarea\":1,\"text\":2},\"number_of_third_party_fields_by_type\":[],\"post_types_enabled\":true,\"ui_post_types\":\"12\",\"json_post_types\":\"0\",\"ui_taxonomies\":\"8\",\"json_taxonomies\":\"0\",\"rest_api_format\":\"light\",\"admin_ui_enabled\":true,\"field_type-modal_enabled\":true,\"field_settings_tabs_enabled\":false,\"shortcode_enabled\":false,\"registered_acf_forms\":\"0\",\"json_save_paths\":1,\"json_load_paths\":1,\"event_first_activated\":1732268487,\"last_updated\":1732268487}","off");
INSERT INTO wp_options VALUES("299","elementor_active_kit","13","auto");
INSERT INTO wp_options VALUES("300","elementor_font_display","swap","auto");
INSERT INTO wp_options VALUES("303","elementor_checklist","{\"last_opened_timestamp\":-1,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"editor_visit_count\":0,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}}}","auto");
INSERT INTO wp_options VALUES("304","elementor_version","3.25.9","auto");
INSERT INTO wp_options VALUES("305","elementor_install_history","a:1:{s:6:\"3.25.9\";i:1732268487;}","auto");
INSERT INTO wp_options VALUES("306","elementor_events_db_version","1.0.0","off");
INSERT INTO wp_options VALUES("307","_elementor_editor_upgrade_notice_dismissed","1763806218","auto");
INSERT INTO wp_options VALUES("309","acf_version","6.3.10.2","auto");
INSERT INTO wp_options VALUES("310","elementor_onboarded","1","auto");
INSERT INTO wp_options VALUES("311","elementor_tracker_notice","1","auto");
INSERT INTO wp_options VALUES("312","_transient_jupiterx_inactive_required_plugins_list","a:0:{}","on");
INSERT INTO wp_options VALUES("313","_elementor_installed_time","1732268489","auto");
INSERT INTO wp_options VALUES("314","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:28:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:11:\"Link in Bio\";i:15;s:9:\"portfolio\";i:16;s:7:\"pricing\";i:17;s:15:\"product archive\";i:18;s:5:\"Quote\";i:19;s:15:\"Service Details\";i:20;s:8:\"services\";i:21;s:11:\"single page\";i:22;s:11:\"single post\";i:23;s:14:\"single product\";i:24;s:5:\"stats\";i:25;s:9:\"subscribe\";i:26;s:4:\"team\";i:27;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:28:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:11:\"Link in Bio\";i:15;s:9:\"portfolio\";i:16;s:7:\"pricing\";i:17;s:15:\"product archive\";i:18;s:5:\"Quote\";i:19;s:15:\"Service Details\";i:20;s:8:\"services\";i:21;s:11:\"single page\";i:22;s:11:\"single post\";i:23;s:14:\"single product\";i:24;s:5:\"stats\";i:25;s:9:\"subscribe\";i:26;s:4:\"team\";i:27;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:19:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:19:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:19:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:19:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:19:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:19:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:19:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:19:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:19:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:19:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:19:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:19:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:19:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:19:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:19:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:19:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:19:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:19:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:19:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:19:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:19:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:19:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:19:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:19:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:19:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:19:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:19:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:19:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:19:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:19:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:19:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:19:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:19:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:19:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:19:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:19:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:19:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:19:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:19:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:19:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:19:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:19:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:19:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:19:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:19:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:19:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:19:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:19:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:19:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:19:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:19:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:19:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:19:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:19:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:19:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:19:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:19:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:19:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:19:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:19:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:19:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:19:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:19:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:19:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:19:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:19:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:19:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:19:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:19:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:19:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:19:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:19:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:19:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:19:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:19:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:19:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:19:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:19:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:19:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:19:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:19:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:19:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:19:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:19:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:19:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:19:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:19:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:19:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:19:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:19:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:19:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:19:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:19:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:19:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:19:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:19:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:19:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:19:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:19:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:19:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:19:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:19:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:19:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:19:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:19:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:19:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:19:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:19:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:19:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:19:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:19:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:19:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:19:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:19:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:19:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:19:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:19:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:19:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:19:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:19:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:19:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:19:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:19:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:19:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:19:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:19:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:19:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:19:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:19:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:19:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:19:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:19:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:19:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:19:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:19:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:19:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:19:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:19:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:19:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:19:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:19:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:19:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:19:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:19:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:19:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:19:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:19:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:19:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:19:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:19:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:19:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:19:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:19:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:19:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:19:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:19:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:19:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:19:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:19:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:19:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:19:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:19:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:19:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:19:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:19:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:19:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:19:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:19:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:19:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:19:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:19:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:19:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:19:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:19:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:19:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:19:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:19:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:19:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:19:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:19:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:19:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:19:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:19:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:19:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:19:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:19:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:19:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:19:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:19:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:19:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:19:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:19:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:19:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:19:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:19:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:19:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:19:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:19:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:19:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:19:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:19:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:19:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:19:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:19:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:19:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:19:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:19:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:19:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:19:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:19:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:19:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:19:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:19:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:19:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:19:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:19:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:19:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:19:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:19:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:19:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:19:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:19:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:19:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:19:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:19:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:19:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:19:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:19:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:19:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:19:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:19:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:19:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:19:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:19:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:19:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:19:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:19:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:19:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:19:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:19:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:19:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:19:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:19:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:19:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s