<?php

namespace JupiterX_Core\Raven\Core\Compatibility\Wpml\Modules;

defined( 'ABSPATH' ) || die();

class Media_Gallery extends \WPML_Elementor_Module_With_Items {
	public function get_items_field() {
		return 'fields';
	}

	public function get_fields() {
		return [
			'category_label',
			'link' => [ 'field' => 'url_link_to' ],
			'link' => [ 'field' => 'youtube_url' ],
			'link' => [ 'field' => 'vimeo_url' ],
			'link' => [ 'field' => 'video_external_url' ],
			'link' => [ 'field' => 'spotify_url' ],
			'link' => [ 'field' => 'soundcloud_url' ],
		];
	}

	protected function get_title( $field ) {
		switch ( $field ) {
			case 'category_label':
				return esc_html__( 'Raven Media Gallery: Category Label', 'jupiterx-core' );

			case 'url_link_to':
				return esc_html__( 'Raven Media Gallery: URL', 'jupiterx-core' );

			case 'youtube_url':
				return esc_html__( 'Raven Media Gallery: YouTube Link', 'jupiterx-core' );

			case 'vimeo_url':
				return esc_html__( 'Raven Media Gallery: Vimeo Link', 'jupiterx-core' );

			case 'video_external_url':
				return esc_html__( 'Raven Media Gallery: Video External URL', 'jupiterx-core' );

			case 'spotify_url':
				return esc_html__( 'Raven Media Gallery: Spotify URL', 'jupiterx-core' );

			case 'soundcloud_url':
				return esc_html__( 'Raven Media Gallery: Soundcloud URL', 'jupiterx-core' );

			default:
				return '';
		}
	}

	protected function get_editor_type( $field ) {
		switch ( $field ) {

			case 'category_label':
				return 'LINE';

			case 'url_link_to':
				return 'LINK';

			case 'youtube_url':
				return 'LINK';

			case 'vimeo_url':
				return 'LINK';

			case 'video_external_url':
				return 'LINK';

			case 'spotify_url':
				return 'LINK';

			case 'soundcloud_url':
				return 'LINK';

			default:
				return '';
		}
	}
}
