<?php

namespace JupiterX_Core\Raven\Core\Compatibility\Wpml\Modules;

defined( 'ABSPATH' ) || die();

class Video_Playlist extends \WPML_Elementor_Module_With_Items {
	public function get_items_field() {
		return 'tabs';
	}

	public function get_fields() {
		return [
			'link' => [ 'field' => 'youtube_url' ],
			'link' => [ 'field' => 'vimeo_url' ],
			'link' => [ 'field' => 'hosted_url' ],
			'title',
			'duration',
			'inner_tab_content_1',
			'inner_tab_content_2',
		];
	}

	protected function get_title( $field ) {
		switch ( $field ) {
			case 'youtube_url':
				return esc_html__( 'Raven Video Playlist: Item YouTube Link', 'jupiterx-core' );

			case 'vimeo_url':
				return esc_html__( 'Raven Video Playlist: Item Vimeo Link', 'jupiterx-core' );

			case 'hosted_url':
				return esc_html__( 'Raven Video Playlist: Item External URL', 'jupiterx-core' );

			case 'title':
				return esc_html__( 'Raven Video Playlist: Item Title', 'jupiterx-core' );

			case 'duration':
				return esc_html__( 'Raven Video Playlist: Item Duration', 'jupiterx-core' );

			case 'inner_tab_content_1':
				return esc_html__( 'Raven Video Playlist: Item Tab 1 Content', 'jupiterx-core' );

			case 'inner_tab_content_2':
				return esc_html__( 'Raven Video Playlist: Item Tab 2 Content', 'jupiterx-core' );

			default:
				return '';
		}
	}

	protected function get_editor_type( $field ) {
		switch ( $field ) {
			case 'youtube_url':
				return 'LINK';

			case 'vimeo_url':
				return 'LINK';

			case 'hosted_url':
				return 'LINK';

			case 'title':
				return 'LINE';

			case 'duration':
				return 'LINE';

			case 'inner_tab_content_1':
				return 'VISUAL';

			case 'inner_tab_content_2':
				return 'VISUAL';

			default:
				return '';
		}
	}
}
